/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.nio.Filess;
import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests18FileChannels;
import de.pfabulist.lindwurm.niotest.tests.topics.Delete;
import de.pfabulist.lindwurm.niotest.tests.topics.HardLink;
import de.pfabulist.lindwurm.niotest.tests.topics.Move;
import de.pfabulist.lindwurm.niotest.tests.topics.SlowTest;
import de.pfabulist.lindwurm.niotest.tests.topics.Writable;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests19HardLinks
extends Tests18FileChannels {
    public Tests19HardLinks(FSDescription capa) {
        super(capa);
    }

    @Test
    @Category(value={HardLink.class, Writable.class})
    public void testHardLinkCreate() throws IOException {
        Files.createLink(this.link(), this.orig());
        Assertions.assertThat((Path)this.link()).exists();
    }

    @Test
    @Category(value={HardLink.class, Writable.class})
    public void testHardLinkChangeOneChangesTheOther() throws IOException {
        Files.createLink(this.link(), this.orig());
        Files.write(this.link(), CONTENT_OTHER, new OpenOption[0]);
        Assertions.assertThat((byte[])Files.readAllBytes(this.orig())).isEqualTo((Object)CONTENT_OTHER);
    }

    @Test
    @Category(value={HardLink.class, Writable.class, Delete.class})
    public void testHardLinkDeleteOrigDoesNotAffectTheOther() throws IOException {
        Files.createLink(this.link(), this.orig());
        Files.delete(this.orig());
        Assertions.assertThat((byte[])Files.readAllBytes(this.link())).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={HardLink.class, Writable.class, Delete.class})
    public void testHardLinkDeleteLinkDoesNotAffectTheOther() throws IOException {
        Files.createLink(this.link(), this.orig());
        Files.delete(this.link());
        Assertions.assertThat((byte[])Files.readAllBytes(this.orig())).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={SlowTest.class, HardLink.class, Writable.class})
    public void testHardLinkModifyOneModifiedDateOfOtherChanged() throws IOException, InterruptedException {
        Files.createLink(this.link(), this.orig());
        FileTime before = Files.getLastModifiedTime(this.orig(), new LinkOption[0]);
        this.waitForAttribute();
        Files.write(this.link(), CONTENT_OTHER, new OpenOption[0]);
        Assertions.assertThat((Comparable)Files.getLastModifiedTime(this.orig(), new LinkOption[0])).isGreaterThan((Comparable)before);
    }

    @Test
    @Category(value={HardLink.class, Writable.class})
    public void testHardLinkToExistingFileThrows() throws IOException, InterruptedException {
        Assertions.assertThatThrownBy(() -> Files.createLink(this.fileTB(), this.orig())).isInstanceOf(FileAlreadyExistsException.class);
    }

    @Test
    @Category(value={HardLink.class, Writable.class})
    public void testHardLinkToOtherProviderThrows() throws IOException {
        Assertions.assertThatThrownBy(() -> Files.createLink(this.link(), this.otherProviderFileA())).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    @Category(value={HardLink.class, Writable.class})
    public void testHardLinkToDirThrows() throws IOException {
        Files.createLink(this.link(), this.orig());
        Assertions.assertThat((Path)this.link()).exists();
    }

    @Test
    @Category(value={HardLink.class, Writable.class})
    public void testHardLinkToHardLink() throws IOException {
        Files.createLink(this.link(), this.orig());
        Files.createLink(this.link2(), this.link());
        Assertions.assertThat((Path)this.link2()).exists();
    }

    @Test
    @Category(value={HardLink.class, Writable.class})
    public void test2ndHardLink() throws IOException {
        Files.createLink(this.link(), this.fileTA());
        Files.createLink(this.link2(), this.fileTA());
        Assertions.assertThat((Path)this.link2()).exists();
    }

    @Test
    @Category(value={HardLink.class})
    public void testIsSameFileWithHardLink() throws IOException {
        Files.createLink(this.link(), this.orig());
        Assertions.assertThat((boolean)Files.isSameFile(this.link(), this.orig())).isTrue();
    }

    @Test
    @Category(value={HardLink.class})
    public void testHardLinkHasSameFileKey() throws IOException {
        Files.createLink(this.link(), this.orig());
        Object fk1 = Files.readAttributes(this.orig(), BasicFileAttributes.class, new LinkOption[0]).fileKey();
        Object fk2 = Files.readAttributes(this.link(), BasicFileAttributes.class, new LinkOption[0]).fileKey();
        Assertions.assertThat((Object)fk1).isEqualTo(fk2);
    }

    @Test
    @Category(value={HardLink.class, Writable.class})
    public void testHardLinkToRelative() throws IOException {
        Files.createLink(this.link(), this.relativize(this.orig()));
        Assertions.assertThat((boolean)Files.isSameFile(this.link(), this.orig())).isEqualTo(true);
    }

    @Test
    @Category(value={HardLink.class, Writable.class, Move.class})
    public void testMoveHardLinkToRelDoesNotMoveTarget() throws IOException {
        Files.createLink(this.link(), this.relativize(this.orig()));
        Files.move(this.link(), this.dirTB().resolve(this.nameC()), new CopyOption[0]);
        Assertions.assertThat((boolean)Files.isSameFile(this.dirTB().resolve(this.nameC()), this.orig())).isEqualTo(true);
    }

    protected Path orig() {
        Path ret = this.dirTA().resolve("orig");
        if (!Files.exists(ret, new LinkOption[0])) {
            Filess.write((Path)ret, (byte[])CONTENT, (OpenOption[])new OpenOption[0]);
        }
        return ret;
    }

    protected Path link() {
        return this.dirTB().resolve("link");
    }

    protected Path link2() {
        return this.dirTB().resolve("link2");
    }
}

