/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.collection.Sets;
import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests17Windows;
import de.pfabulist.lindwurm.niotest.tests.topics.FileChannelT;
import de.pfabulist.lindwurm.niotest.tests.topics.Scatter;
import de.pfabulist.lindwurm.niotest.tests.topics.Writable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests18FileChannels
extends Tests17Windows {
    public Tests18FileChannels(FSDescription capa) {
        super(capa);
    }

    @Test
    @Category(value={FileChannelT.class})
    public void testOpenFilChannel() throws IOException {
        try {
            FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.READ}), new FileAttribute[0]);
            Throwable throwable = null;
            if (fch != null) {
                if (throwable != null) {
                    try {
                        fch.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    fch.close();
                }
            }
        }
        catch (Exception e) {
            Fail.fail((String)"channels should be supported");
        }
    }

    @Test
    @Category(value={FileChannelT.class})
    public void testTransferFromOfClosedFileChannelThrows() throws IOException {
        try (SeekableByteChannel ch = Files.newByteChannel(this.fileTB(), new OpenOption[0]);
             FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.READ}), new FileAttribute[0]);){
            fch.close();
            Assertions.assertThatThrownBy(() -> fch.transferFrom(ch, 0L, 2L)).isInstanceOf(ClosedChannelException.class);
        }
    }

    @Test
    @Category(value={FileChannelT.class, Writable.class})
    public void testTransferToClosedFileChannelThrows() throws IOException {
        try (SeekableByteChannel ch = Files.newByteChannel(this.fileTB(), new OpenOption[0]);
             FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.READ}), new FileAttribute[0]);){
            fch.close();
            Assertions.assertThatThrownBy(() -> fch.transferTo(0L, 2L, ch)).isInstanceOf(ClosedChannelException.class);
        }
    }

    @Test
    @Category(value={FileChannelT.class, Writable.class})
    public void testTransferFromWrites() throws IOException {
        Files.write(this.absTB(), CONTENT_OTHER, new OpenOption[0]);
        try (SeekableByteChannel ch = Files.newByteChannel(this.absTB(), new OpenOption[0]);
             FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.READ}), new FileAttribute[0]);){
            fch.transferFrom(ch, 0L, CONTENT_OTHER.length);
        }
        Assertions.assertThat((byte[])Files.readAllBytes(this.absTA())).isEqualTo((Object)CONTENT_OTHER);
    }

    @Test
    @Category(value={FileChannelT.class, Writable.class})
    public void testTransferFromLeavesPositionUnchanged() throws IOException {
        Files.write(this.absTB(), CONTENT_OTHER, new OpenOption[0]);
        try (SeekableByteChannel ch = Files.newByteChannel(this.absTB(), new OpenOption[0]);
             FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.READ}), new FileAttribute[0]);){
            fch.transferFrom(ch, 1L, CONTENT_OTHER.length);
            Assertions.assertThat((long)fch.position()).isEqualTo(0L);
        }
    }

    @Test
    @Category(value={FileChannelT.class, Writable.class})
    public void testTransferFromWritesFromPosition() throws IOException {
        Files.write(this.absTB(), CONTENT_OTHER, new OpenOption[0]);
        try (SeekableByteChannel ch = Files.newByteChannel(this.absTB(), new OpenOption[0]);
             FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.READ}), new FileAttribute[0]);){
            fch.transferFrom(ch, 1L, CONTENT_OTHER.length);
        }
        Assertions.assertThat((byte)Files.readAllBytes(this.absTA())[1]).isEqualTo(CONTENT_OTHER[0]);
        Assertions.assertThat((byte)Files.readAllBytes(this.absTA())[5]).isEqualTo(CONTENT_OTHER[4]);
    }

    @Test
    @Category(value={FileChannelT.class})
    public void testTransferFromOnReadonlyChannelThrows() throws IOException {
        Files.write(this.absTB(), CONTENT_OTHER, new OpenOption[0]);
        try (SeekableByteChannel ch = Files.newByteChannel(this.absTB(), new OpenOption[0]);
             FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);){
            Assertions.assertThatThrownBy(() -> fch.transferFrom(ch, 0L, CONTENT_OTHER.length)).isInstanceOf(NonWritableChannelException.class);
        }
    }

    @Test
    @Category(value={FileChannelT.class, Writable.class})
    public void testTransferFromWithNegativePositionThrows() throws IOException {
        Files.write(this.absTB(), CONTENT_OTHER, new OpenOption[0]);
        try (SeekableByteChannel ch = Files.newByteChannel(this.absTB(), new OpenOption[0]);
             FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.READ}), new FileAttribute[0]);){
            Assertions.assertThatThrownBy(() -> fch.transferFrom(ch, -1L, CONTENT_OTHER.length)).isInstanceOf(IllegalArgumentException.class);
        }
    }

    @Test
    @Category(value={FileChannelT.class, Writable.class})
    public void testTransferFromWithNegativeLengthThrows() throws IOException {
        Files.write(this.absTB(), CONTENT_OTHER, new OpenOption[0]);
        try (SeekableByteChannel ch = Files.newByteChannel(this.absTB(), new OpenOption[0]);
             FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.READ}), new FileAttribute[0]);){
            Assertions.assertThatThrownBy(() -> fch.transferFrom(ch, 0L, -1L)).isInstanceOf(IllegalArgumentException.class);
        }
    }

    @Test
    @Category(value={FileChannelT.class, Writable.class})
    public void testTransferFromPositionBeyondFileSizeDoesNothing() throws IOException {
        Files.write(this.absTB(), CONTENT_OTHER, new OpenOption[0]);
        try (SeekableByteChannel ch = Files.newByteChannel(this.absTB(), new OpenOption[0]);
             FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.READ}), new FileAttribute[0]);){
            fch.transferFrom(ch, CONTENT.length * 2, CONTENT_OTHER.length);
        }
        Assertions.assertThat((byte[])Files.readAllBytes(this.absTA())).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={FileChannelT.class, Writable.class})
    public void testTransferFromWithSourceChannelPositionNotZero() throws IOException {
        Files.write(this.absTB(), CONTENT_OTHER, new OpenOption[0]);
        try (SeekableByteChannel ch = Files.newByteChannel(this.absTB(), new OpenOption[0]);
             FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.READ}), new FileAttribute[0]);){
            ch.position(1L);
            fch.transferFrom(ch, 0L, CONTENT_OTHER.length - 1);
            Assertions.assertThat((long)ch.position()).isEqualTo((long)CONTENT_OTHER.length);
        }
        Assertions.assertThat((byte)Files.readAllBytes(this.absTA())[0]).isEqualTo(CONTENT_OTHER[1]);
        Assertions.assertThat((byte)Files.readAllBytes(this.absTA())[5]).isEqualTo(CONTENT_OTHER[6]);
    }

    @Test
    @Category(value={FileChannelT.class, Writable.class})
    public void testTransferFromFromNonReadableChannelThrows() throws IOException {
        Files.write(this.absTB(), CONTENT_OTHER, new OpenOption[0]);
        SeekableByteChannel ch = Files.newByteChannel(this.absTB(), StandardOpenOption.WRITE);
        try (FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE}), new FileAttribute[0]);){
            Assertions.assertThatThrownBy(() -> fch.transferFrom(ch, 0L, CONTENT_OTHER.length)).isInstanceOf(NonReadableChannelException.class);
        }
    }

    @Test
    @Category(value={FileChannelT.class, Writable.class})
    public void testTransferFromSourceWithLessThanRequestedBytesGetsWhatsThere() throws IOException {
        Files.write(this.absTB(), CONTENT_OTHER, new OpenOption[0]);
        SeekableByteChannel ch = Files.newByteChannel(this.absTB(), new OpenOption[0]);
        try (FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE}), new FileAttribute[0]);){
            long count = fch.transferFrom(ch, 0L, CONTENT_OTHER.length * 2);
            Assertions.assertThat((long)count).isEqualTo((long)CONTENT_OTHER.length);
        }
        Assertions.assertThat((byte[])Files.readAllBytes(this.absTA())).isEqualTo((Object)CONTENT_OTHER);
    }

    @Test
    @Category(value={FileChannelT.class})
    public void testTransferToWritesToChannel() throws IOException {
        try (SeekableByteChannel ch = Files.newByteChannel(this.absTB(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
             FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);){
            fch.transferTo(0L, CONTENT.length, ch);
        }
        Assertions.assertThat((byte[])Files.readAllBytes(this.absTB())).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={FileChannelT.class})
    public void testTransferToDoesNotModifyPosition() throws IOException {
        try (SeekableByteChannel ch = Files.newByteChannel(this.absTB(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
             FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);){
            fch.position(3L);
            fch.transferTo(0L, CONTENT.length - 3, ch);
            Assertions.assertThat((long)fch.position()).isEqualTo(3L);
        }
    }

    @Test
    @Category(value={FileChannelT.class, Writable.class})
    public void testTransferToFromWriteOnlyThrows() throws IOException {
        try (SeekableByteChannel ch = Files.newByteChannel(this.absTB(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
             FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE}), new FileAttribute[0]);){
            Assertions.assertThatThrownBy(() -> fch.transferTo(0L, CONTENT.length, ch)).isInstanceOf(NonReadableChannelException.class);
        }
    }

    @Test
    @Category(value={FileChannelT.class, Writable.class})
    public void testTransferToFromNegativePosition() throws IOException {
        try (SeekableByteChannel ch = Files.newByteChannel(this.absTB(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
             FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);){
            Assertions.assertThatThrownBy(() -> fch.transferTo(-1L, CONTENT.length, ch)).isInstanceOf(IllegalArgumentException.class);
        }
    }

    @Test
    @Category(value={FileChannelT.class, Writable.class})
    public void testTransferToNegativeContentLengthThrows() throws IOException {
        try (SeekableByteChannel ch = Files.newByteChannel(this.absTB(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
             FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);){
            Assertions.assertThatThrownBy(() -> fch.transferTo(0L, -5L, ch)).isInstanceOf(IllegalArgumentException.class);
        }
    }

    @Test
    @Category(value={FileChannelT.class, Writable.class})
    public void testTransferToNonWritableChannelThrows() throws IOException {
        try (SeekableByteChannel ch = Files.newByteChannel(this.fileTB(), StandardOpenOption.READ);
             FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);){
            Assertions.assertThatThrownBy(() -> fch.transferTo(0L, 3L, ch)).isInstanceOf(NonWritableChannelException.class);
        }
    }

    @Test
    @Category(value={FileChannelT.class, Writable.class})
    public void testTransferToTransfersOnlyWhatsThere() throws IOException {
        try (SeekableByteChannel ch = Files.newByteChannel(this.absTB(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
             FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);){
            long count = fch.transferTo(0L, CONTENT.length * 2, ch);
            Assertions.assertThat((long)count).isEqualTo((long)CONTENT.length);
        }
        Assertions.assertThat((byte[])Files.readAllBytes(this.absTB())).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={FileChannelT.class, Writable.class})
    public void testTransferToFromPosition() throws IOException {
        try (SeekableByteChannel ch = Files.newByteChannel(this.absTB(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
             FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);){
            fch.transferTo(3L, CONTENT.length - 3, ch);
        }
        Assertions.assertThat((byte)Files.readAllBytes(this.absTB())[0]).isEqualTo(CONTENT[3]);
        Assertions.assertThat((byte)Files.readAllBytes(this.absTB())[2]).isEqualTo(CONTENT[5]);
    }

    @Test
    @Category(value={FileChannelT.class, Writable.class})
    public void testFileChannelRead() throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(CONTENT.length);
        try (FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);){
            fch.read(bb);
        }
        Assertions.assertThat((byte[])bb.array()).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={FileChannelT.class, Writable.class, Scatter.class})
    public void testFileChannelScatteredRead() throws IOException {
        ByteBuffer bb1 = ByteBuffer.allocate(5);
        ByteBuffer bb2 = ByteBuffer.allocate(CONTENT.length - 5);
        try (FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);){
            fch.read(new ByteBuffer[]{bb1, bb2});
        }
        Assertions.assertThat((byte)bb1.array()[4]).isEqualTo(CONTENT[4]);
        Assertions.assertThat((byte)bb2.array()[0]).isEqualTo(CONTENT[5]);
    }

    @Test
    @Category(value={FileChannelT.class})
    public void testForce() throws IOException {
        try (SeekableByteChannel ch = Files.newByteChannel(this.absTB(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
             FileChannel fch = FileChannel.open(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);){
            fch.transferTo(0L, CONTENT.length, ch);
            fch.force(true);
            Assertions.assertThat((byte[])Files.readAllBytes(this.absTB())).isEqualTo((Object)CONTENT);
        }
    }
}

