/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.nio.PathIKWID;
import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests16Unix;
import de.pfabulist.lindwurm.niotest.tests.topics.DosAttributesT;
import de.pfabulist.lindwurm.niotest.tests.topics.RootComponent;
import de.pfabulist.lindwurm.niotest.tests.topics.UNC;
import de.pfabulist.lindwurm.niotest.tests.topics.Windows;
import de.pfabulist.lindwurm.niotest.tests.topics.Writable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.DosFileAttributeView;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests17Windows
extends Tests16Unix {
    public Tests17Windows(FSDescription capa) {
        super(capa);
    }

    @Test
    @Category(value={Windows.class})
    public void testCaseIgnorantPathsAreEqual() {
        Assertions.assertThat((Path)this.absD().resolve(this.nameB())).isEqualTo((Object)this.mixCase(this.absD().resolve(this.nameB())));
    }

    @Test
    @Category(value={Windows.class})
    public void testCaseIgnorantPathHaveSameHashCode() throws IOException {
        Assertions.assertThat((int)this.absD().resolve(this.nameB()).hashCode()).isEqualTo(this.mixCase(this.absD().resolve(this.nameB())).hashCode());
    }

    @Test
    @Category(value={Windows.class})
    public void testCaseIgnorantPathCompareTo0() throws IOException {
        Assertions.assertThat((int)this.absD().resolve(this.nameB()).compareTo(this.mixCase(this.absD().resolve(this.nameB())))).isEqualTo(0);
    }

    @Test
    @Category(value={Windows.class})
    public void testCaseIgnorantPathKeepCompareSaneGreater() throws IOException {
        Assertions.assertThat((int)this.absABC().compareTo(this.mixCase(this.absAB()))).isGreaterThan(0);
    }

    @Test
    @Category(value={Windows.class})
    public void testCaseIgnorantPathKeepCompareSaneSmaller() throws IOException {
        Assertions.assertThat((int)this.absAB().compareTo(this.mixCase(this.absABC()))).isLessThan(0);
    }

    @Test
    @Category(value={Windows.class})
    public void testCaseRemembering() throws IOException {
        Path file = this.dirTA().resolve(this.nameD());
        Files.write(this.mixCase(file), CONTENT, new OpenOption[0]);
        try (DirectoryStream<Path> dstr = Files.newDirectoryStream(PathIKWID.childGetParent((Path)file));){
            Path kid = dstr.iterator().next();
            Assertions.assertThat((Path)kid).isEqualTo((Object)file);
            Assertions.assertThat((String)kid.toString()).isNotEqualTo((Object)file.toString());
        }
    }

    @Test
    @Category(value={Windows.class})
    public void testWindowsBase() {
        Assertions.assertThat((boolean)this.FS.getPath("C:\\", new String[0]).isAbsolute()).isTrue();
    }

    @Test
    @Category(value={Windows.class, RootComponent.class})
    public void testWindowsJustRootComponentIsRelative() {
        Assertions.assertThat((boolean)this.FS.getPath("C:", new String[0]).isAbsolute()).isFalse();
    }

    @Test
    @Category(value={Windows.class, RootComponent.class})
    public void testWindowsRelativeWithRootComponent() {
        Assertions.assertThat((boolean)this.FS.getPath("C:foo", new String[0]).isAbsolute()).isFalse();
    }

    @Test
    @Category(value={Windows.class, RootComponent.class})
    public void testWindowsFilenameOfPathWithRootComponentHasNoRootComponent() {
        Assertions.assertThat((Path)this.FS.getPath("C:\\foo\\duh", new String[0]).getFileName()).isEqualTo((Object)this.FS.getPath("duh", new String[0]));
    }

    @Test
    @Category(value={Windows.class, RootComponent.class})
    public void testWindowsToAbsoluteWithoutRootComponent() {
        Assertions.assertThat((Path)this.FS.getPath("C:\\foo\\duh", new String[0]).getFileName()).isEqualTo((Object)this.FS.getPath("duh", new String[0]));
    }

    @Test
    @Category(value={Windows.class, RootComponent.class})
    public void testWindowsDifferentRootComponentResolvesToArgument() {
        Assertions.assertThat((Path)this.FS.getPath("C:\\foo", new String[0]).resolve("D:duh")).isEqualTo((Object)this.FS.getPath("D:duh", new String[0]));
    }

    @Test
    @Category(value={Windows.class, RootComponent.class})
    public void testWindowsSameRootComponentResolves() {
        Assertions.assertThat((Path)this.FS.getPath("C:\\foo", new String[0]).resolve("C:duh")).isEqualTo((Object)this.FS.getPath("C:\\foo\\duh", new String[0]));
    }

    @Test
    @Category(value={Windows.class, RootComponent.class})
    public void testWindowsImpliedRootComponentResolvesNot() {
        Assertions.assertThat((Path)this.FS.getPath("\\foo", new String[0]).resolve("C:duh")).isEqualTo((Object)this.FS.getPath("C:duh", new String[0]));
    }

    @Test
    @Category(value={Windows.class, RootComponent.class})
    public void testWindowsNoRootComponentResolves() {
        Assertions.assertThat((Path)this.FS.getPath("C:\\foo", new String[0]).resolve("duh")).isEqualTo((Object)this.FS.getPath("C:\\foo\\duh", new String[0]));
    }

    @Test
    @Category(value={Windows.class})
    public void testWindowsCaseDrive() {
        Assertions.assertThat((Path)this.FS.getPath("X:\\foo", new String[0])).isEqualTo((Object)this.FS.getPath("x:\\foo", new String[0]));
    }

    @Test
    @Category(value={Windows.class, RootComponent.class})
    public void testWindowsGetFileNameHasNoRootComponent() {
        Assertions.assertThat((boolean)this.FS.getPath("C:\\foo", new String[0]).getFileName().toString().startsWith("C:")).isFalse();
    }

    @Test
    @Category(value={Windows.class, RootComponent.class})
    public void testWindowsNoRootComponentGetRootHasNoRootComponent() {
        Assertions.assertThat((Path)this.FS.getPath("\\foo", new String[0]).getRoot()).isEqualTo((Object)this.FS.getPath("\\", new String[0]));
    }

    @Test
    @Category(value={Windows.class, DosAttributesT.class, Writable.class})
    public void testWindowsIsHidden() throws IOException {
        Assertions.assertThat((boolean)Files.isHidden(this.fileTA())).isFalse();
        Files.getFileAttributeView(this.absTA(), DosFileAttributeView.class, new LinkOption[0]).setHidden(true);
        Assertions.assertThat((boolean)Files.isHidden(this.fileTA())).isTrue();
        Files.setAttribute(this.absTA(), "dos:hidden", false, new LinkOption[0]);
        Assertions.assertThat((boolean)Files.isHidden(this.fileTA())).isFalse();
    }

    @Test
    @Category(value={Windows.class, UNC.class})
    public void testWindowsUNC1() throws IOException {
        Assertions.assertThat((int)this.FS.getPath("\\\\mach\\foo\\ho", new String[0]).getNameCount()).isEqualTo(1);
    }

    @Test
    @Category(value={Windows.class})
    public void testWindowsUNCNoHostName() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.getPath("\\\\", new String[0])).isInstanceOf(InvalidPathException.class);
    }

    @Test
    @Category(value={Windows.class})
    public void testWindowsdUNCNoShareName() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.getPath("\\\\localhost", new String[0])).isInstanceOf(InvalidPathException.class);
    }

    @Test
    @Category(value={Windows.class, UNC.class})
    public void testWindowsdUNCPlenty() throws IOException {
        try {
            this.FS.getPath("\\//////\\\\localhost\\////foo", new String[0]);
        }
        catch (InvalidPathException e) {
            Fail.fail((String)"UNC paths are valid in Windows");
        }
    }

    @Test
    @Category(value={Windows.class, UNC.class})
    public void testWindowsUNCSlash() throws IOException {
        Assertions.assertThat((int)this.FS.getPath("//mach/foo/ho", new String[0]).getNameCount()).isEqualTo(1);
    }

    @Test
    @Category(value={Windows.class, UNC.class})
    public void testWindowsUNCAbsolute() throws IOException {
        Assertions.assertThat((boolean)this.FS.getPath("\\\\mach\\foo", new String[0]).isAbsolute()).isTrue();
    }

    @Test
    @Category(value={Windows.class, UNC.class})
    public void testWindowsUNCAbsolute2() throws IOException {
        Assertions.assertThat((boolean)this.FS.getPath("\\\\mach\\C$", new String[0]).isAbsolute()).isTrue();
    }

    @Test
    @Category(value={Windows.class, UNC.class})
    public void testWindowsUNCRoot() throws IOException {
        Assertions.assertThat((Path)this.FS.getPath("\\\\mach\\C$", new String[0]).getRoot()).isEqualTo((Object)this.FS.getPath("\\\\mach\\C$\\", new String[0]));
    }
}

