/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.nio.PathIKWID;
import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests11Watcher;
import de.pfabulist.lindwurm.niotest.tests.topics.Copy;
import de.pfabulist.lindwurm.niotest.tests.topics.SecondFileSystem;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.FileAttribute;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests12DifferentFS
extends Tests11Watcher {
    public Tests12DifferentFS(FSDescription capa) {
        super(capa);
    }

    @Test
    @Category(value={SecondFileSystem.class, Copy.class})
    public void testCopyToDifferentFS() throws IOException {
        Path src = this.fileTA();
        this.FS.provider().copy(src, this.otherFSabsTA(), new CopyOption[0]);
        Assertions.assertThat((Path)this.otherFSabsTA()).exists();
    }

    @Test
    @Category(value={SecondFileSystem.class, Copy.class})
    public void testMoveToDifferentFS() throws IOException {
        Path src = this.fileTA();
        this.FS.provider().move(src, this.otherFSabsTA(), new CopyOption[0]);
        Assertions.assertThat((Path)this.otherFSabsTA()).exists();
        Assertions.assertThat((Path)this.absTA()).doesNotExist();
    }

    @Test
    @Category(value={SecondFileSystem.class})
    public void testIsSameFileDifferentFSIsFalse() throws IOException {
        Assertions.assertThat((boolean)this.FS.provider().isSameFile(this.absAB(), this.otherFSFileTA())).isFalse();
    }

    @Test
    @Category(value={SecondFileSystem.class})
    public void testCompareToDifferentFSPathSameToStringButDifferent() throws IOException {
        Assertions.assertThat((int)this.absAB().toString().compareTo(this.otherFSAbsAB().toString())).isEqualTo(0);
        Assertions.assertThat((int)this.absAB().compareTo(this.otherFSAbsAB())).isNotEqualTo(0);
    }

    @Test
    @Category(value={SecondFileSystem.class})
    public void testStartsWithDifferentFSIsFalse() throws IOException {
        Assertions.assertThat((boolean)this.absAB().startsWith(this.otherFSAbsAB())).isFalse();
    }

    @Test
    @Category(value={SecondFileSystem.class})
    public void testEndsWithDifferentFSIsFalse() throws IOException {
        Assertions.assertThat((boolean)this.absAB().endsWith(this.otherFSAbsAB())).isFalse();
    }

    @Override
    @Test
    @Category(value={SecondFileSystem.class})
    public void testRelativize() {
        Assertions.assertThatThrownBy(() -> this.absAB().relativize(this.otherFSAbsA())).isInstanceOf(ProviderMismatchException.class);
    }

    public Path otherFSAbsA() throws IOException {
        FileSystem fs = this.description.get(Path.class, "playground2").getFileSystem();
        return PathIKWID.absoluteGetRoot((Path)fs.getPath("", new String[0]).toAbsolutePath()).resolve(this.nameA());
    }

    public Path otherFSAbsAB() throws IOException {
        return this.otherFSAbsA().resolve(this.nameB());
    }

    public Path otherFSabsTA() throws IOException {
        Path dir = this.description.get(Path.class, "playground2").resolve(this.testMethodName.getMethodName());
        Files.createDirectories(dir, new FileAttribute[0]);
        return dir.resolve(this.nameA());
    }

    public Path otherFSFileTA() throws IOException {
        Path ret = this.otherFSabsTA();
        if (!Files.exists(ret, new LinkOption[0])) {
            Files.write(ret, CONTENT, standardOpen);
        }
        return ret;
    }
}

