/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.collection.Ref;
import de.pfabulist.kleinod.collection.Sets;
import de.pfabulist.kleinod.nio.PathIKWID;
import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests10PathWithContent;
import de.pfabulist.lindwurm.niotest.tests.topics.Closable;
import de.pfabulist.lindwurm.niotest.tests.topics.Delete;
import de.pfabulist.lindwurm.niotest.tests.topics.SlowTest;
import de.pfabulist.lindwurm.niotest.tests.topics.Watchable;
import de.pfabulist.lindwurm.niotest.tests.topics.Writable;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests11Watcher
extends Tests10PathWithContent {
    public static final String WATCH_DELAY = "watchDelay";
    @Nullable
    private WatchService watchService;

    public Tests11Watcher(FSDescription capa) {
        super(capa);
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class, Writable.class, Delete.class})
    public void testWatchADelete() throws Exception {
        Path toBeDeleted = this.watchedFileA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_DELETE);
        Files.delete(toBeDeleted);
        Thread.sleep(4000L);
        AssertionsForInterfaceTypes.assertThat((boolean)Tests11Watcher.correctKey(this.watchServicePoll(), toBeDeleted, StandardWatchEventKinds.ENTRY_DELETE)).isTrue();
    }

    @Test(timeout=20000L)
    @Category(value={SlowTest.class, Watchable.class, Writable.class, Delete.class})
    public void testWatchADeleteTake() throws Exception {
        Path toBeDeleted = this.watchedFileA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_DELETE);
        Files.delete(toBeDeleted);
        AssertionsForInterfaceTypes.assertThat((boolean)Tests11Watcher.correctKey(this.getWatchService().take(), toBeDeleted, StandardWatchEventKinds.ENTRY_DELETE)).isTrue();
    }

    @Test(timeout=30000L)
    @Category(value={SlowTest.class, Watchable.class, Writable.class, Delete.class})
    public void testWatchADeletePollWithTimeOut() throws Exception {
        Path toBeDeleted = this.watchedFileA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_DELETE);
        Files.delete(toBeDeleted);
        AssertionsForInterfaceTypes.assertThat((boolean)Tests11Watcher.correctKey(this.waitForWatchService().poll(1000L, TimeUnit.MILLISECONDS), toBeDeleted, StandardWatchEventKinds.ENTRY_DELETE)).isTrue();
    }

    @Test(timeout=30000L)
    @Category(value={SlowTest.class, Watchable.class, Writable.class})
    public void testWatchPollWithTimeoutTimesOut() throws Exception {
        this.watcherSetup(StandardWatchEventKinds.ENTRY_DELETE);
        this.getWatchService().poll(1000L, TimeUnit.MILLISECONDS);
        AssertionsForInterfaceTypes.assertThat((String)"did we reach that?").isNotNull();
    }

    @Test(expected=ClosedWatchServiceException.class)
    @Category(value={Watchable.class, Writable.class})
    public void testRegisterOnClosedWatchService() throws IOException {
        WatchService watcher = this.FS.newWatchService();
        watcher.close();
        this.dirTAB().register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
    }

    @Test(expected=ClosedWatchServiceException.class)
    @Category(value={Watchable.class, Writable.class, Closable.class})
    public void testRegisterWatchServiceOfClosedFS() throws Exception {
        this.getClosedDirB().register(this.getClosedFSWatchService(), StandardWatchEventKinds.ENTRY_DELETE);
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class, Writable.class})
    public void testWatchADeleteFromAMove() throws Exception {
        Path toBeMoved = this.watchedFileA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_DELETE);
        Files.move(toBeMoved, this.absTA(), new CopyOption[0]);
        AssertionsForInterfaceTypes.assertThat((boolean)Tests11Watcher.correctKey(this.watchServicePoll(), toBeMoved, StandardWatchEventKinds.ENTRY_DELETE)).isTrue();
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class, Writable.class})
    public void testWatchAModify() throws Exception {
        Path toBeModified = this.watchedFileA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_MODIFY);
        Files.write(toBeModified, CONTENT_OTHER, new OpenOption[0]);
        AssertionsForInterfaceTypes.assertThat((boolean)Tests11Watcher.correctKey(this.watchServicePoll(), toBeModified, StandardWatchEventKinds.ENTRY_MODIFY)).isTrue();
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class, Writable.class})
    public void testWatchReadIsNotModify() throws Exception {
        Path toBeModified = this.watchedFileA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_MODIFY);
        Files.readAllBytes(toBeModified);
        AssertionsForInterfaceTypes.assertThat((Object)this.watchServicePoll()).isNull();
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class, Writable.class})
    public void testWatchForOtherEventCatchesNothing() throws Exception {
        Path toBeModified = this.watchedFileA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        Files.write(toBeModified, CONTENT_OTHER, new OpenOption[0]);
        AssertionsForInterfaceTypes.assertThat((Object)this.watchServicePoll()).isNull();
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class})
    public void testWatchInOtherDirCatchesNothing() throws Exception {
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        this.fileTAB();
        AssertionsForInterfaceTypes.assertThat((Object)this.watchServicePoll()).isNull();
    }

    @Test(timeout=30000L)
    @Category(value={SlowTest.class, Watchable.class, Writable.class})
    public void testNotResetWatchKeyDoesNotQue() throws Exception {
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        this.watchedFileA();
        WatchKey key = this.waitForWatchService().take();
        key.pollEvents();
        Files.write(this.watchedAbsB(), CONTENT, new OpenOption[0]);
        AssertionsForInterfaceTypes.assertThat((Object)this.watchServicePoll()).isNull();
    }

    @Test(timeout=30000L)
    @Category(value={SlowTest.class, Watchable.class, Writable.class})
    public void testResetWatchKeyDoesQue() throws Exception {
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        this.watchedFileA();
        WatchKey key = this.waitForWatchService().take();
        key.pollEvents();
        key.reset();
        Path file = Files.write(this.watchedAbsB(), CONTENT, new OpenOption[0]);
        AssertionsForInterfaceTypes.assertThat((boolean)Tests11Watcher.correctKey(this.getWatchService().take(), file, StandardWatchEventKinds.ENTRY_CREATE)).isTrue();
    }

    @Test(timeout=20000L)
    @Category(value={SlowTest.class, Watchable.class, Writable.class})
    public void testWatchACreateBy2WatchServies() throws Exception {
        Path toBeCreated = this.watchedAbsA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        WatchService watchService2 = this.FS.newWatchService();
        this.watchedDir().register(watchService2, StandardWatchEventKinds.ENTRY_CREATE);
        Files.write(toBeCreated, CONTENT, new OpenOption[0]);
        AssertionsForInterfaceTypes.assertThat((boolean)Tests11Watcher.correctKey(this.getWatchService().take(), toBeCreated, StandardWatchEventKinds.ENTRY_CREATE)).isTrue();
        AssertionsForInterfaceTypes.assertThat((boolean)Tests11Watcher.correctKey(watchService2.take(), toBeCreated, StandardWatchEventKinds.ENTRY_CREATE)).isTrue();
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class, Writable.class})
    public void testWatchACreate() throws Exception {
        Path toBeCreated = this.watchedAbsA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        Files.write(toBeCreated, CONTENT, new OpenOption[0]);
        AssertionsForInterfaceTypes.assertThat((boolean)Tests11Watcher.correctKey(this.watchServicePoll(), toBeCreated, StandardWatchEventKinds.ENTRY_CREATE)).isTrue();
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class, Writable.class, Writable.class})
    public void testWatchACreateDir() throws Exception {
        Path toBeCreated = this.watchedAbsA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        Files.createDirectory(toBeCreated, new FileAttribute[0]);
        AssertionsForInterfaceTypes.assertThat((boolean)Tests11Watcher.correctKey(this.watchServicePoll(), toBeCreated, StandardWatchEventKinds.ENTRY_CREATE)).isTrue();
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class, Writable.class, Writable.class})
    public void testWatchACreateFromCopy() throws Exception {
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        Files.copy(this.fileTB(), this.watchedAbsA(), new CopyOption[0]);
        AssertionsForInterfaceTypes.assertThat((boolean)Tests11Watcher.correctKey(this.watchServicePoll(), this.watchedAbsA(), StandardWatchEventKinds.ENTRY_CREATE)).isTrue();
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class, Writable.class, Writable.class})
    public void testWatchACreateFromMove() throws Exception {
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        Files.move(this.fileTAB(), this.watchedAbsA(), new CopyOption[0]);
        AssertionsForInterfaceTypes.assertThat((boolean)Tests11Watcher.correctKey(this.watchServicePoll(), this.watchedAbsA(), StandardWatchEventKinds.ENTRY_CREATE)).isTrue();
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class, Writable.class})
    public void testCanceledWatchKeyDoesNotWatch() throws Exception {
        WatchKey key = this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        key.cancel();
        this.watchedFileA();
        AssertionsForInterfaceTypes.assertThat((Object)this.watchServicePoll()).isNull();
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class, Writable.class})
    public void testWatchATruncate() throws Exception {
        Path file = this.watchedFileA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_MODIFY);
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE}), new FileAttribute[0]);){
            channel.truncate(2L);
        }
        AssertionsForInterfaceTypes.assertThat((boolean)Tests11Watcher.correctKey(this.watchServicePoll(), file, StandardWatchEventKinds.ENTRY_MODIFY)).isTrue();
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class, Writable.class})
    public void testWatchServiceTakeBlocks() throws Exception {
        Path dir = this.dirTA();
        WatchService watcher = dir.getFileSystem().newWatchService();
        dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        Ref interrupted = Ref.valueOf((Object)false);
        new Thread(() -> {
            try {
                watcher.take();
            }
            catch (InterruptedException | ClosedWatchServiceException exception) {
            }
            finally {
                interrupted.set((Object)true);
            }
        }).start();
        Thread.sleep(1000L);
        AssertionsForInterfaceTypes.assertThat((Boolean)((Boolean)interrupted.get())).isFalse();
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class, Writable.class})
    public void testCloseAWatchServiceReleasesBlockedTreads() throws Exception {
        Path dir = this.dirTB();
        WatchService watcher = dir.getFileSystem().newWatchService();
        dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        Ref interrupted = Ref.valueOf((Object)false);
        new Thread(() -> {
            try {
                watcher.take();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ClosedWatchServiceException e) {
                interrupted.set((Object)true);
            }
        }).start();
        Thread.sleep(1000L);
        watcher.close();
        Thread.sleep(100L);
        AssertionsForInterfaceTypes.assertThat((Boolean)((Boolean)interrupted.get())).isTrue();
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class, Writable.class})
    public void testCloseAWatchServiceCancelsKeys() throws Exception {
        Path dir = this.dirTA();
        WatchService watcher = dir.getFileSystem().newWatchService();
        WatchKey key = dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        watcher.close();
        this.waitForWatchService();
        AssertionsForInterfaceTypes.assertThat((boolean)key.isValid()).isFalse();
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class, Writable.class})
    public void testPollAnEmptyWatchServiceReturnsNull() throws Exception {
        Path dir = this.dirTA();
        WatchService watcher = dir.getFileSystem().newWatchService();
        dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        AssertionsForInterfaceTypes.assertThat((Object)watcher.poll()).isNull();
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class, Writable.class})
    public void testWatchKeyPollEventsEmptiesQue() throws Exception {
        Path dir = this.dirTA();
        Path toBeDeleted = this.dirTAB();
        WatchService watcher = dir.getFileSystem().newWatchService();
        dir.register(watcher, StandardWatchEventKinds.ENTRY_DELETE);
        Thread.sleep(1000L);
        Files.delete(toBeDeleted);
        this.waitForWatchService();
        WatchKey watchKey = watcher.poll();
        watchKey.pollEvents();
        AssertionsForInterfaceTypes.assertThat(watchKey.pollEvents()).isEmpty();
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class, Writable.class})
    public void testDeleteWatchedDirCancelsKeys() throws Exception {
        WatchKey key = this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        Files.delete(this.watchedDir());
        this.watchServicePoll();
        AssertionsForInterfaceTypes.assertThat((boolean)key.isValid()).isFalse();
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class, Writable.class})
    public void testMovedWatchedDirCancelsKeys() throws Exception {
        Path dir = this.dirTA();
        WatchService watcher = this.FS.newWatchService();
        WatchKey key = dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        Files.move(dir, this.absTB(), new CopyOption[0]);
        this.waitForWatchService();
        AssertionsForInterfaceTypes.assertThat((boolean)key.isValid()).isFalse();
    }

    public Path watchedFileA() throws IOException {
        Path ret = this.watchedAbsA();
        Files.write(ret, CONTENT, standardOpen);
        return ret;
    }

    public Path watchedAbsA() throws IOException {
        return this.watchedDir().resolve(this.nameA());
    }

    public Path watchedAbsB() throws IOException {
        return this.watchedDir().resolve(this.nameB());
    }

    public Path watchedDir() throws IOException {
        Path ret = this.absT().resolve("watched");
        Files.createDirectories(ret, new FileAttribute[0]);
        return ret;
    }

    public WatchService getWatchService() {
        return this.watchService;
    }

    public WatchService waitForWatchService() throws InterruptedException {
        Thread.sleep(this.getDelay());
        return this.watchService;
    }

    private int getDelay() {
        int delay = this.description.getInt(WATCH_DELAY);
        if (delay < 10) {
            return 2000;
        }
        return delay;
    }

    public WatchKey watchServicePoll() throws InterruptedException {
        return this.watchService.poll(this.getDelay(), TimeUnit.MILLISECONDS);
    }

    WatchKey watcherSetup(WatchEvent.Kind<Path> ... kinds) throws IOException {
        this.watchService = this.FS.newWatchService();
        return this.watchedDir().register(this.watchService, kinds);
    }

    public static boolean correctKey(WatchKey key, Path file, WatchEvent.Kind<Path> kind) {
        if (key == null) {
            return false;
        }
        if (!key.isValid()) {
            return false;
        }
        if (!PathIKWID.childGetParent((Path)file).equals(key.watchable())) {
            return false;
        }
        List<WatchEvent<?>> events = key.pollEvents();
        return events.stream().filter(ev -> {
            if (!PathIKWID.namedGetFilename((Path)file).equals(ev.context())) {
                return false;
            }
            return ev.kind().equals(kind);
        }).findAny().isPresent();
    }
}

