/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.nio.Filess;
import de.pfabulist.kleinod.nio.PathIKWID;
import de.pfabulist.kleinod.nio.Pathss;
import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests08ThreadSafe;
import de.pfabulist.lindwurm.niotest.tests.topics.AsynchronousFileChannel;
import de.pfabulist.lindwurm.niotest.tests.topics.Copy;
import de.pfabulist.lindwurm.niotest.tests.topics.Delete;
import de.pfabulist.lindwurm.niotest.tests.topics.FileChannelT;
import de.pfabulist.lindwurm.niotest.tests.topics.HardLink;
import de.pfabulist.lindwurm.niotest.tests.topics.Move;
import de.pfabulist.lindwurm.niotest.tests.topics.SymLink;
import de.pfabulist.lindwurm.niotest.tests.topics.Writable;
import java.io.IOException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests09WrongProvider
extends Tests08ThreadSafe {
    public static final String OTHER_PROVIDER_PLAYGROUND = "otherProviderPlayground";

    public Tests09WrongProvider(FSDescription capa) {
        super(capa);
    }

    @Test
    public void testNewByteChannelOtherProvider() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().newByteChannel(this.otherProviderAbsA(), Collections.emptySet(), new FileAttribute[0])).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    public void testGetBasicFileAttributeViewProvider() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().getFileAttributeView(this.otherProviderAbsA(), BasicFileAttributeView.class, new LinkOption[0])).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    @Category(value={Writable.class})
    public void testCreateDirectoryOtherProvider() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().createDirectory(this.otherProviderAbsA(), new FileAttribute[0])).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    @Category(value={FileChannelT.class})
    public void testNewFileChannelOtherProvider() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().newFileChannel(this.otherProviderAbsA(), Collections.emptySet(), new FileAttribute[0])).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    public void testCheckAccessOtherProvider() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().checkAccess(this.otherProviderAbsA(), new AccessMode[0])).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    @Category(value={Copy.class, Writable.class})
    public void testCopyOtherProviderFrom() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().copy(this.otherProviderAbsA(), this.absTA(), new CopyOption[0])).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    @Category(value={Copy.class, Writable.class})
    public void testCopyOtherProviderTo() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().copy(this.fileTA(), this.otherProviderAbsA(), new CopyOption[0])).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    @Category(value={Move.class, Writable.class})
    public void testMoveOtherProviderFrom() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().move(this.otherProviderAbsA(), this.absTA(), new CopyOption[0])).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    @Category(value={Copy.class, Writable.class})
    public void testMoveOtherProviderTo() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().move(this.fileTAB(), this.otherProviderAbsA(), new CopyOption[0])).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    @Category(value={HardLink.class, Writable.class})
    public void testHardLinkOfDifferentProvider() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().createLink(this.otherProviderAbsA(), this.fileTA())).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    @Category(value={Writable.class, SymLink.class})
    public void testCreateSymLinkFromOtherProviderPath() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().createSymbolicLink(this.otherProviderAbsA(), this.fileTA(), new FileAttribute[0])).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    @Category(value={Writable.class, SymLink.class})
    public void testCreateSymLinkToPathFromOtherProvider() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().createSymbolicLink(this.dirTA().resolve("link"), this.otherProviderAbsA(), new FileAttribute[0])).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    @Category(value={Delete.class, Writable.class})
    public void testDeleteOtherProvider() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().delete(this.otherProviderAbsA())).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    @Category(value={Delete.class, Writable.class})
    public void testDeleteIfExistsOtherProvider() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().deleteIfExists(this.otherProviderAbsA())).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    public void testGetFileStoreOtherProvider() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().getFileStore(this.otherProviderAbsA())).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    public void testGetPathOtherURI() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().getPath(this.otherProviderAbsA().toUri())).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testIsHiddenOtherProvider() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().isHidden(this.otherProviderAbsA())).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    @Category(value={FileChannelT.class, AsynchronousFileChannel.class})
    public void testNewAsynchronousFileChannelOtherProvider() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().newAsynchronousFileChannel(this.otherProviderAbsA(), Collections.emptySet(), null, new FileAttribute[0])).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    @Category(value={Writable.class})
    public void testNewOutputStreamOtherProvider() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().newOutputStream(this.otherProviderAbsA(), new OpenOption[0])).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    public void testNewDirectoryStreamOtherProvider() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().newDirectoryStream(this.otherProviderAbsA(), null)).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    public void testReadAttributesOtherProvider() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().readAttributes(this.otherProviderAbsA(), BasicFileAttributes.class, new LinkOption[0])).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    public void testReadAttributesStringOtherProvider() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().readAttributes(this.otherProviderAbsA(), "*", new LinkOption[0])).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    @Category(value={SymLink.class})
    public void testReadSymLinkOtherProvider() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().readSymbolicLink(this.otherProviderAbsA())).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    public void testResolveWithPathFromOtherProviderThrows() throws IOException {
        Assertions.assertThatThrownBy(() -> this.absD().resolve(this.otherProviderAbsA())).isInstanceOf(ProviderMismatchException.class);
    }

    @Test
    public void testIsSameFileOtherProvider() throws IOException {
        Assertions.assertThat((boolean)this.FS.provider().isSameFile(this.otherProviderAbsA(), this.getFile())).isFalse();
    }

    @Test
    public void testIsSameFileOtherProvider2() throws IOException {
        Assertions.assertThat((boolean)this.FS.provider().isSameFile(this.getFile(), this.otherProviderAbsA())).isFalse();
    }

    @Test
    public void testResolveSiblingOtherProviderThrows() {
        Assertions.assertThatThrownBy(() -> this.absD().resolveSibling(this.otherProviderAbsA())).isInstanceOf(ProviderMismatchException.class);
    }

    protected Path otherProviderAbsA() {
        return this.getOtherProviderPlayground().resolve(this.nameA());
    }

    protected Path getOtherProviderPlayground() {
        if (this.description.otherProviderPlayground == null) {
            Path other = (Path)this.description.get(OTHER_PROVIDER_PLAYGROUND);
            if (other != null) {
                this.description.otherProviderPlayground = other;
            } else {
                if (this.FS.equals(FileSystems.getDefault())) {
                    throw new IllegalStateException();
                }
                this.description.otherProviderPlayground = Pathss.getTmpDir((String)"other");
            }
        }
        return this.description.otherProviderPlayground;
    }

    protected Path otherProviderFileA() {
        Path ret = this.otherProviderAbsA();
        if (!Files.exists(ret, new LinkOption[0])) {
            Filess.createDirectories((Path)PathIKWID.childGetParent((Path)ret), (FileAttribute[])new FileAttribute[0]);
            Filess.write((Path)ret, (byte[])CONTENT, (OpenOption[])new OpenOption[0]);
        }
        return ret;
    }
}

