/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.nio.PathIKWID;
import de.pfabulist.kleinod.text.Strings;
import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests04Copy;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public abstract class Tests05URI
extends Tests04Copy {
    public Tests05URI(FSDescription capa) {
        super(capa);
    }

    @Test
    public void testFileSystemOfAPathIsTheConstructingOne() {
        Assertions.assertThat((Object)this.FS).isEqualTo((Object)this.FS.getPath("", new String[0]).getFileSystem());
    }

    @Test
    public void testSeparatorIsNotEmpty() {
        Assertions.assertThat((boolean)this.FS.getSeparator().isEmpty()).isFalse();
    }

    @Test
    public void testSchemeIsNotEmpty() {
        Assertions.assertThat((boolean)this.FS.provider().getScheme().isEmpty()).isFalse();
    }

    @Test
    public void testProviderGetFileSystemWithWrongSchemeFails() {
        Assertions.assertThatThrownBy(() -> this.FS.provider().getFileSystem(URI.create(this.FS.provider().getScheme() + "N:"))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testWrongUriAtProviderNewFails() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().newFileSystem(URI.create(this.FS.provider().getScheme() + "N:"), Collections.EMPTY_MAP)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testToUriOfRelativePathIsTheUriOfTheAbsolute() throws Exception {
        Assertions.assertThat((URI)this.pathDefault().toAbsolutePath().toUri()).isEqualTo((Object)this.pathDefault().toUri());
    }

    @Test
    public void testGetExistingFileSystem() throws IOException {
        FileSystem fs = this.FS.provider().getFileSystem(this.toURI(this.FS));
        Assertions.assertThat((Object)fs).isEqualTo((Object)this.FS);
    }

    @Test
    public void testNewFileSystemOfExistingThrows() throws IOException {
        Assertions.assertThatThrownBy(() -> this.FS.provider().newFileSystem(this.toURI(this.FS), this.getEnv())).isInstanceOf(FileSystemAlreadyExistsException.class);
    }

    @Test
    public void testPathToUriAndBackIsSame() {
        Path path = this.getNonExistingPath();
        URI uri = path.toUri();
        Assertions.assertThat((URI)uri).isNotNull();
        Path back = Paths.get(uri);
        Assertions.assertThat((Path)back).isEqualTo((Object)path);
    }

    @Test
    public void testPathWithWitespaceToUri() {
        Path path = this.getEmptyDir().resolve("z z");
        URI uri = path.toUri();
        Assertions.assertThat((URI)uri).isNotNull();
    }

    @Test
    public void testPathWithWitespaceToUriAndBack() {
        Path path = this.getEmptyDir().resolve("z z");
        URI uri = path.toUri();
        Assertions.assertThat((URI)uri).isNotNull();
        Path back = Paths.get(uri);
        Assertions.assertThat((Path)back).isEqualTo((Object)path);
    }

    public URI toURI(FileSystem fs) {
        Function toURI = (Function)this.description.props.get("fsToUri");
        if (toURI == null) {
            return Tests05URI.toURIWithRoot(fs);
        }
        return (URI)toURI.apply(fs);
    }

    public Map<String, ?> getEnv() {
        Map env = (Map)this.description.props.get("env");
        if (env == null) {
            return Collections.EMPTY_MAP;
        }
        return env;
    }

    public static URI toURIWithRoot(FileSystem fs) {
        return PathIKWID.absoluteGetRoot((Path)fs.getPath("", new String[0]).toAbsolutePath()).toUri();
    }

    public static URI toURIWithoutPath(FileSystem fs) {
        Path root = PathIKWID.absoluteGetRoot((Path)fs.getPath("", new String[0]).toAbsolutePath());
        return URI.create(Strings.withoutSuffix((String)root.toUri().toString(), (String)root.toString().replace('\\', '/')));
    }
}

