/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.collection.Sets;
import de.pfabulist.kleinod.nio.Filess;
import de.pfabulist.kleinod.nio.PathIKWID;
import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests03File;
import de.pfabulist.lindwurm.niotest.tests.topics.Attributes;
import de.pfabulist.lindwurm.niotest.tests.topics.Copy;
import de.pfabulist.lindwurm.niotest.tests.topics.CreationTime;
import de.pfabulist.lindwurm.niotest.tests.topics.Delete;
import de.pfabulist.lindwurm.niotest.tests.topics.LastModifiedTime;
import de.pfabulist.lindwurm.niotest.tests.topics.Move;
import de.pfabulist.lindwurm.niotest.tests.topics.MoveWhile;
import de.pfabulist.lindwurm.niotest.tests.topics.SlowTest;
import de.pfabulist.lindwurm.niotest.tests.topics.Writable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests04Copy
extends Tests03File {
    @Test
    @Category(value={Writable.class, Copy.class})
    public void testCopyDuplicatesTheContent() throws IOException {
        Files.copy(this.srcFile(), this.tgt(), new CopyOption[0]);
        Assertions.assertThat((byte[])Files.readAllBytes(this.tgt())).isEqualTo((Object)CONTENT);
        Assertions.assertThat((byte[])Files.readAllBytes(this.srcFile())).isEqualTo((Object)CONTENT);
    }

    @Test(expected=FileAlreadyExistsException.class)
    @Category(value={Writable.class, Copy.class})
    public void testCopyAlreadyThereWithoutOptionThrows() throws IOException {
        Files.write(this.tgt(), CONTENT, standardOpen);
        Files.copy(this.srcFile(), this.tgt(), new CopyOption[0]);
    }

    @Test
    @Category(value={Writable.class, Copy.class})
    public void testCopyAlreadyThereOverwrite() throws IOException {
        Files.write(this.tgt(), CONTENT_OTHER, new OpenOption[0]);
        Files.copy(this.srcFile(), this.tgt(), StandardCopyOption.REPLACE_EXISTING);
        Assertions.assertThat((byte[])Files.readAllBytes(this.tgt())).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={Writable.class, Copy.class})
    public void testCopyViaProvider() throws IOException {
        this.srcFile().getFileSystem().provider().copy(this.srcFile(), this.tgt(), new CopyOption[0]);
        Assertions.assertThat((byte[])Files.readAllBytes(this.tgt())).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={Writable.class, Copy.class, SlowTest.class, Attributes.class, CreationTime.class})
    public void testCopyResultHasCreationTime() throws Exception {
        FileTime before = Files.getLastModifiedTime(this.srcFile(), new LinkOption[0]);
        this.waitForAttribute();
        Files.copy(this.srcFile(), this.tgt(), new CopyOption[0]);
        FileTime created = Files.readAttributes(this.tgt(), BasicFileAttributes.class, new LinkOption[0]).creationTime();
        Assertions.assertThat((Comparable)created).isGreaterThan((Comparable)before);
    }

    @Test
    @Category(value={Writable.class, Copy.class, SlowTest.class, Attributes.class})
    public void testCopyAttributesCheckModifiedTime() throws Exception {
        BasicFileAttributes srcAttis = Files.readAttributes(this.srcFile(), BasicFileAttributes.class, new LinkOption[0]);
        this.waitForAttribute();
        Files.copy(this.srcFile(), this.tgt(), StandardCopyOption.COPY_ATTRIBUTES);
        BasicFileAttributes tgtAttis = Files.readAttributes(this.tgt(), BasicFileAttributes.class, new LinkOption[0]);
        Assertions.assertThat((Comparable)tgtAttis.lastModifiedTime()).isEqualTo((Object)srcAttis.lastModifiedTime());
    }

    @Test
    @Category(value={Writable.class, Copy.class, SlowTest.class, Attributes.class})
    public void testCopyDoesNotModifyOriginal() throws Exception {
        FileTime beforeCopy = Files.getLastModifiedTime(this.srcFile(), new LinkOption[0]);
        this.waitForAttribute();
        Files.copy(this.srcFile(), this.tgt(), new CopyOption[0]);
        Assertions.assertThat((Path)this.srcFile()).exists();
        Assertions.assertThat((Comparable)Files.getLastModifiedTime(this.srcFile(), new LinkOption[0])).isEqualTo((Object)beforeCopy);
    }

    @Test
    @Category(value={Writable.class, Copy.class})
    public void testModifyOriginalAfterCopyDoesNotChangeTarget() throws Exception {
        Files.copy(this.srcFile(), this.tgt(), new CopyOption[0]);
        Files.write(this.srcFile(), CONTENT_OTHER, new OpenOption[0]);
        Assertions.assertThat((byte[])Files.readAllBytes(this.tgt())).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={Writable.class, Move.class})
    public void testMoveCreatesNewFileDeletesOriginal() throws IOException {
        Files.move(this.srcFile(), this.tgt(), new CopyOption[0]);
        Assertions.assertThat((Path)this.src()).doesNotExist();
    }

    @Test(expected=FileAlreadyExistsException.class)
    @Category(value={Writable.class, Move.class})
    public void testMoveAlreadyThereThrows() throws IOException {
        Files.write(this.tgt(), CONTENT_OTHER, standardOpen);
        Files.move(this.srcFile(), this.tgt(), new CopyOption[0]);
    }

    @Test
    @Category(value={Writable.class, Move.class})
    public void testFailedMoveLeavesOriginal() throws Exception {
        Files.write(this.tgt(), CONTENT, standardOpen);
        try {
            Files.move(this.srcFile(), this.tgt(), new CopyOption[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        Assertions.assertThat((Path)this.src()).exists();
    }

    @Test
    @Category(value={Writable.class, Move.class})
    public void testMoveAlreadyThereOverwrite() throws Exception {
        Files.write(this.tgt(), CONTENT_OTHER, standardOpen);
        Files.move(this.srcFile(), this.tgt(), StandardCopyOption.REPLACE_EXISTING);
        Assertions.assertThat((byte[])Files.readAllBytes(this.tgt())).isEqualTo((Object)CONTENT);
        Assertions.assertThat((Path)this.src()).doesNotExist();
    }

    @Test(expected=FileAlreadyExistsException.class)
    @Category(value={Writable.class, Move.class})
    public void testMoveAlreadyThereDirectory() throws Exception {
        Files.createDirectory(this.tgt(), new FileAttribute[0]);
        Files.move(this.srcFile(), this.tgt(), new CopyOption[0]);
    }

    @Test
    @Category(value={Writable.class, Move.class})
    public void testMoveAlreadyThereDirectoryOverwrite() throws Exception {
        Files.createDirectory(this.tgt(), new FileAttribute[0]);
        Files.move(this.srcFile(), this.tgt(), StandardCopyOption.REPLACE_EXISTING);
        Assertions.assertThat((byte[])Files.readAllBytes(this.tgt())).isEqualTo((Object)CONTENT);
        Assertions.assertThat((Path)this.src()).doesNotExist();
    }

    @Test(expected=DirectoryNotEmptyException.class)
    @Category(value={Writable.class, Move.class})
    public void testMoveAlreadyThereNonEmptyDirectoryOverwrite() throws Exception {
        Files.createDirectory(this.tgt(), new FileAttribute[0]);
        Files.write(this.tgt().resolve(this.nameB()), CONTENT, new OpenOption[0]);
        Files.move(this.srcFile(), this.tgt(), StandardCopyOption.REPLACE_EXISTING);
    }

    @Test
    @Category(value={Writable.class, Move.class})
    public void testMoveViaProvider() throws IOException {
        this.srcFile().getFileSystem().provider().move(this.src(), this.tgt(), new CopyOption[0]);
        Assertions.assertThat((Path)this.src()).doesNotExist();
    }

    @Test
    @Category(value={Writable.class, Move.class})
    public void testMoveEmptyDir() throws IOException {
        Files.move(this.srcDir(), this.tgt(), new CopyOption[0]);
        Assertions.assertThat((Path)this.tgt()).isDirectory();
    }

    @Test
    @Category(value={Writable.class, Move.class})
    public void testMoveNonEmptyDir() throws IOException {
        Files.write(this.srcDir().resolve(this.nameB()), CONTENT, new OpenOption[0]);
        Files.write(this.src().resolve(this.nameC()), CONTENT, new OpenOption[0]);
        Files.createDirectory(this.src().resolve(this.nameA()), new FileAttribute[0]);
        Files.write(this.src().resolve(this.nameA()).resolve(this.nameA()), CONTENT, new OpenOption[0]);
        Files.move(this.src(), this.tgt(), new CopyOption[0]);
        Assertions.assertThat((Path)this.tgt().resolve(this.nameA()).resolve(this.nameA())).exists();
    }

    @Test(expected=IOException.class)
    @Category(value={Writable.class, Move.class})
    public void testMoveIntoItself() throws IOException {
        Files.move(this.srcDir(), this.srcDir().resolve("tgt"), new CopyOption[0]);
    }

    @Test
    @Category(value={Writable.class, Move.class})
    public void testMoveRoot() throws IOException {
        Assertions.assertThatThrownBy(() -> Files.move(this.defaultRoot(), this.tgt(), new CopyOption[0])).isInstanceOf(FileSystemException.class);
    }

    @Test
    @Category(value={Writable.class, Move.class})
    public void testMoveToRootThrows() throws IOException {
        Assertions.assertThatThrownBy(() -> Files.move(this.fileTA(), this.defaultRoot(), StandardCopyOption.REPLACE_EXISTING)).isInstanceOf(FileSystemException.class);
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Move.class, Attributes.class})
    public void testMoveKeepsLastModifiedTime() throws IOException, InterruptedException {
        FileTime modi = Files.getLastModifiedTime(this.srcFile(), new LinkOption[0]);
        this.waitForAttribute();
        Files.move(this.src(), this.tgt(), new CopyOption[0]);
        Assertions.assertThat((Comparable)Files.getLastModifiedTime(this.tgt(), new LinkOption[0])).isEqualTo((Object)modi);
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Move.class, Attributes.class, LastModifiedTime.class})
    public void testMoveChangesModifiedTimeOfParent() throws IOException, InterruptedException {
        FileTime modi = Files.getLastModifiedTime(PathIKWID.childGetParent((Path)this.srcFile()), new LinkOption[0]);
        this.waitForAttribute();
        Files.move(this.src(), this.tgt(), new CopyOption[0]);
        Assertions.assertThat((Comparable)Files.getLastModifiedTime(PathIKWID.childGetParent((Path)this.src()), new LinkOption[0])).isGreaterThan((Comparable)modi);
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Move.class, Attributes.class, LastModifiedTime.class})
    public void testMoveChangesModifiedTimeOfTargetsParent() throws IOException, InterruptedException {
        FileTime modi = Files.getLastModifiedTime(PathIKWID.childGetParent((Path)this.tgt()), new LinkOption[0]);
        this.waitForAttribute();
        Files.move(this.srcFile(), this.tgt(), new CopyOption[0]);
        Assertions.assertThat((Comparable)Files.getLastModifiedTime(PathIKWID.childGetParent((Path)this.tgt()), new LinkOption[0])).isGreaterThan((Comparable)modi);
    }

    @Test
    @Category(value={Writable.class, Move.class})
    public void testMoveNonExistantThrows() throws IOException, InterruptedException {
        Assertions.assertThatThrownBy(() -> Files.move(this.absAB(), this.tgt(), new CopyOption[0])).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    @Category(value={Writable.class, Copy.class})
    public void testCopyDirCreatesADirWithTheTargetName() throws Exception {
        Files.copy(this.srcDir(), this.tgt(), new CopyOption[0]);
        Assertions.assertThat((Path)this.tgt()).exists();
    }

    @Test
    @Category(value={Writable.class, Copy.class})
    public void testCopyNonEmptyDirDoesNotCopyKids() throws Exception {
        Files.write(this.srcDir().resolve(this.nameB()), CONTENT, new OpenOption[0]);
        Files.copy(this.src(), this.tgt(), new CopyOption[0]);
        Assertions.assertThat(Files.list(this.tgt()).findAny()).isEmpty();
    }

    @Test
    @Category(value={Writable.class, Copy.class})
    public void testCopyDirReplaceExistingOverwritesFile() throws Exception {
        Files.write(this.tgt(), CONTENT, standardOpen);
        Files.copy(this.srcDir(), this.tgt(), StandardCopyOption.REPLACE_EXISTING);
        Assertions.assertThat((Path)this.tgt()).isDirectory();
    }

    @Test(expected=DirectoryNotEmptyException.class)
    @Category(value={Writable.class, Copy.class})
    public void testCopyFileReplaceExistingDoesNotOverwriteExistingNonEmptyDir() throws Exception {
        Path targetKid = this.tgt().resolve("targetKid");
        Files.createDirectories(this.tgt(), new FileAttribute[0]);
        Files.write(targetKid, CONTENT, new OpenOption[0]);
        Files.copy(this.srcFile(), this.tgt(), StandardCopyOption.REPLACE_EXISTING);
    }

    @Test
    @Category(value={Writable.class, Copy.class})
    public void testCopyFileReplaceExistingOverwritesExistingDir() throws Exception {
        Files.createDirectories(this.tgt(), new FileAttribute[0]);
        Files.copy(this.srcFile(), this.tgt(), StandardCopyOption.REPLACE_EXISTING);
        Assertions.assertThat((byte[])Files.readAllBytes(this.tgt())).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={Writable.class, Copy.class})
    public void testCopyIntoItself() throws IOException {
        Path tgt = this.srcDir().resolve("tgt");
        Files.copy(PathIKWID.childGetParent((Path)tgt), tgt, new CopyOption[0]);
        Assertions.assertThat((Path)tgt).exists();
    }

    @Test
    @Category(value={Writable.class, Delete.class})
    public void testDeleteDeletes() throws Exception {
        Files.delete(this.fileTA());
        Assertions.assertThat((Path)this.absTA()).doesNotExist();
    }

    @Test
    @Category(value={Writable.class, Delete.class})
    public void testDeleteDirRemovesItFromParentsKids() throws IOException, InterruptedException {
        Path dir = this.dirTB();
        Files.delete(dir);
        Assertions.assertThat((boolean)Tests04Copy.isKid(dir.getParent(), dir)).isFalse();
    }

    protected static boolean isKid(Path dir, Path kid) {
        return Filess.list((Path)dir).filter(k -> k.equals(kid)).findAny().isPresent();
    }

    @Test
    @Category(value={Writable.class, Delete.class})
    public void testDeleteFileRemovesItFromParentsKids() throws IOException, InterruptedException {
        Path file = this.fileTAB();
        Files.delete(file);
        Assertions.assertThat((boolean)Tests04Copy.isKid(file.getParent(), file)).isFalse();
    }

    @Test
    @Category(value={Writable.class, Delete.class})
    public void testDeleteNonEmptyDirectoryThrows() throws IOException {
        Assertions.assertThatThrownBy(() -> Files.delete(PathIKWID.childGetParent((Path)this.fileTAB()))).isInstanceOf(DirectoryNotEmptyException.class);
    }

    @Test
    @Category(value={Writable.class, Delete.class})
    public void testDeleteEmptyDir() throws IOException {
        Files.delete(this.dirTA());
        Assertions.assertThat((Path)this.absTA()).doesNotExist();
    }

    @Test
    @Category(value={Writable.class, Delete.class})
    public void testDeleteEmptiedDir() throws IOException {
        Path file = this.fileTAB();
        Files.delete(file);
        Files.delete(PathIKWID.childGetParent((Path)file));
        Assertions.assertThat((Path)PathIKWID.childGetParent((Path)file)).doesNotExist();
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Delete.class, Attributes.class, LastModifiedTime.class})
    public void testDeleteFileChangesParentsModificationTime() throws IOException, InterruptedException {
        FileTime modified = Files.getLastModifiedTime(PathIKWID.childGetParent((Path)this.fileTAB()), new LinkOption[0]);
        this.waitForAttribute();
        Files.delete(this.fileTAB());
        Assertions.assertThat((Comparable)Files.getLastModifiedTime(this.absTA(), new LinkOption[0])).isGreaterThan((Comparable)modified);
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Delete.class, Attributes.class, CreationTime.class})
    public void testDeleteFileDoesNotChangeParentCreationTime() throws IOException, InterruptedException {
        Path file = this.fileTAB();
        Path parent = PathIKWID.childGetParent((Path)file);
        FileTime created = Files.readAttributes(parent, BasicFileAttributes.class, new LinkOption[0]).creationTime();
        this.waitForAttribute();
        Files.delete(file);
        Assertions.assertThat((Comparable)Files.readAttributes(parent, BasicFileAttributes.class, new LinkOption[0]).creationTime()).isEqualTo((Object)created);
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Delete.class, Attributes.class, LastModifiedTime.class})
    public void testDeleteDirChangesParentsModificationTime() throws IOException, InterruptedException {
        FileTime modified = Files.getLastModifiedTime(PathIKWID.childGetParent((Path)this.dirTAB()), new LinkOption[0]);
        this.waitForAttribute();
        Files.delete(this.absTAB());
        Assertions.assertThat((Comparable)Files.getLastModifiedTime(this.absTA(), new LinkOption[0])).isGreaterThan((Comparable)modified);
    }

    @Test(expected=NoSuchFileException.class)
    @Category(value={Writable.class, Delete.class})
    public void testDeleteNonExistingFileThrows() throws IOException {
        Files.delete(this.absTA());
    }

    @Test(expected=Exception.class)
    @Category(value={Writable.class, Delete.class})
    public void testDeleteRootThrows() throws IOException {
        Files.delete(this.defaultRoot());
    }

    @Test
    @Category(value={Writable.class, Delete.class})
    public void testDeleteRecreate() throws IOException {
        Files.delete(this.fileTAB());
        Files.write(this.absTAB(), CONTENT, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        Assertions.assertThat((byte[])Files.readAllBytes(this.absTAB())).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={Writable.class, Delete.class})
    public void testDeleteIfExistsRecreate() throws IOException {
        Files.deleteIfExists(this.fileTAB());
        Files.write(this.absTAB(), CONTENT, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        Assertions.assertThat((byte[])Files.readAllBytes(this.absTAB())).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={Writable.class, Move.class})
    public void testRenamingAFileRemovesNameFromParentsDirStream() throws IOException {
        Path file = this.srcFile();
        Files.move(file, PathIKWID.childGetParent((Path)file).resolve("tgt"), new CopyOption[0]);
        Assertions.assertThat((boolean)Tests04Copy.isKid(PathIKWID.childGetParent((Path)file), file)).isFalse();
    }

    @Test
    @Category(value={Writable.class, Move.class})
    public void testRenamingAFileAddsNameToParentsDirStream() throws IOException {
        Path tgt = PathIKWID.childGetParent((Path)this.src()).resolve("tgt");
        Files.move(this.srcFile(), tgt, new CopyOption[0]);
        Assertions.assertThat((boolean)Tests04Copy.isKid(this.src().getParent(), tgt)).isTrue();
    }

    @Test(expected=NoSuchFileException.class)
    @Category(value={Writable.class, Move.class})
    public void testMoveToFileWithNonExistingParentThrows() throws IOException {
        Files.move(this.srcFile(), this.absTAB(), new CopyOption[0]);
    }

    @Test
    @Category(value={Writable.class, Delete.class, MoveWhile.class})
    public void testDeleteWhileReading() throws IOException {
        Path file = this.fileTA();
        try (SeekableByteChannel ch = Files.newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);){
            Files.delete(file);
            Assertions.assertThat((Path)file).doesNotExist();
            int i = ch.read(ByteBuffer.allocate(2));
            Assertions.assertThat((int)i).isEqualTo(2);
        }
        Assertions.assertThat((Path)file).doesNotExist();
    }

    @Test
    @Category(value={Writable.class, Delete.class, MoveWhile.class})
    public void testDeleteWhileWriting() throws IOException {
        Path file = this.fileTA();
        try (SeekableByteChannel ch = Files.newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE}), new FileAttribute[0]);){
            Files.delete(file);
            Assertions.assertThat((Path)file).doesNotExist();
            ch.write(ByteBuffer.wrap(CONTENT_OTHER));
        }
        Assertions.assertThat((Path)file).doesNotExist();
    }

    @Test
    @Category(value={Writable.class, Delete.class, MoveWhile.class})
    public void testMoveWhileWriting() throws IOException {
        Path file = this.fileTA();
        try (SeekableByteChannel ch = Files.newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE}), new FileAttribute[0]);){
            Files.move(file, this.absTB(), new CopyOption[0]);
            Assertions.assertThat((Path)file).doesNotExist();
            ByteBuffer bb = ByteBuffer.wrap(CONTENT_OTHER);
            ch.write(bb);
        }
        Assertions.assertThat((byte[])Files.readAllBytes(this.absTB())).isEqualTo((Object)CONTENT_OTHER);
    }

    public Tests04Copy(FSDescription capa) {
        super(capa);
    }

    protected Path src() {
        return this.absT().resolve("src");
    }

    protected Path srcFile() {
        if (Files.exists(this.src(), new LinkOption[0])) {
            return this.src();
        }
        Filess.write((Path)this.src(), (byte[])CONTENT, (OpenOption[])new OpenOption[0]);
        return this.src();
    }

    protected Path srcDir() {
        Path ret = this.src();
        if (Files.exists(ret, new LinkOption[0])) {
            return ret;
        }
        Filess.createDirectory((Path)ret, (FileAttribute[])new FileAttribute[0]);
        return ret;
    }

    protected Path tgt() {
        Path ret = this.absT().resolve("tgt");
        return ret;
    }
}

