/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.nio.Filess;
import de.pfabulist.kleinod.nio.PathIKWID;
import de.pfabulist.kleinod.text.Strings;
import de.pfabulist.lindwurm.niotest.Utils;
import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests01NoContent;
import de.pfabulist.lindwurm.niotest.tests.topics.Attributes;
import de.pfabulist.lindwurm.niotest.tests.topics.CreationTime;
import de.pfabulist.lindwurm.niotest.tests.topics.LastAccessTime;
import de.pfabulist.lindwurm.niotest.tests.topics.LastModifiedTime;
import de.pfabulist.lindwurm.niotest.tests.topics.SlowTest;
import de.pfabulist.lindwurm.niotest.tests.topics.WorkingDirectoryInPlaygroundTree;
import de.pfabulist.lindwurm.niotest.tests.topics.Writable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests02Dir
extends Tests01NoContent {
    @SuppressFBWarnings
    protected static byte[] CONTENT;
    @SuppressFBWarnings
    protected static byte[] CONTENT_OTHER;
    @SuppressFBWarnings
    protected static byte[] CONTENT_BIG;
    @SuppressFBWarnings
    protected static byte[] CONTENT50;

    public Tests02Dir(FSDescription capa) {
        super(capa);
    }

    @Test
    public void testDefaultIsDir() throws Exception {
        Assertions.assertThat((Path)this.pathDefault()).isDirectory();
    }

    @Test
    public void testContentOfNonEmptyDir() throws IOException {
        Assertions.assertThat(Files.list(this.getNonEmptyDir()).findAny()).isPresent();
    }

    @Test
    public void testIteratorCanOnlyBeCalledOnceOnDirStream() throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.getNonEmptyDir());){
            stream.iterator();
            Assertions.assertThatThrownBy(stream::iterator).isInstanceOf(IllegalStateException.class);
        }
    }

    @Test
    public void testDirStreamIteratorHasNoRemove() throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.getNonEmptyDir());){
            Assertions.assertThatThrownBy(() -> stream.iterator().remove()).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @Test
    public void testContentOfNonEmptyDirFiltered() throws IOException {
        int unfilteredSize;
        Path dir = this.getNonEmptyDir();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            unfilteredSize = Utils.getSize(stream);
        }
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){
            boolean first = true;

            @Override
            public boolean accept(Path entry) throws IOException {
                if (this.first) {
                    this.first = false;
                    return false;
                }
                return true;
            }
        };
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, (DirectoryStream.Filter<? super Path>)filter);){
            Assertions.assertThat((int)Utils.getSize(stream)).isEqualTo(unfilteredSize - 1);
        }
    }

    @Test
    @Category(value={Writable.class})
    public void testNewDirIsInParentsDirStream() throws IOException {
        Path dir = this.dirTA().resolve(this.nameB());
        Files.createDirectory(dir, new FileAttribute[0]);
        Assertions.assertThat(Files.list(PathIKWID.childGetParent((Path)dir)).filter(c -> c.equals(dir)).findAny()).isPresent();
    }

    @Test
    @Category(value={Writable.class})
    public void testNewDirectoryExists() throws IOException {
        Files.createDirectory(this.absTA(), new FileAttribute[0]);
        Assertions.assertThat((Path)this.absTA()).exists();
    }

    @Test
    @Category(value={Writable.class, WorkingDirectoryInPlaygroundTree.class})
    public void testNewRelDirectoryExists() throws IOException {
        Files.createDirectory(this.relTA(), new FileAttribute[0]);
        Assertions.assertThat((Path)this.relTA()).exists();
    }

    @Test
    @Category(value={Writable.class})
    public void testCreateDirectoryTwiceThrows() throws IOException {
        Path newDir = this.absTA();
        Files.createDirectory(newDir, new FileAttribute[0]);
        Assertions.assertThatThrownBy(() -> Files.createDirectory(newDir, new FileAttribute[0])).isInstanceOf(FileAlreadyExistsException.class);
    }

    @Test(expected=NoSuchFileException.class)
    @Category(value={Writable.class})
    public void testCreateDirectoryWithoutExistingParentFails() throws IOException {
        Files.createDirectory(this.absTAB(), new FileAttribute[0]);
    }

    @Test(expected=FileSystemException.class)
    @Category(value={Writable.class})
    public void testCreateDirectoryWithInFileFails() throws IOException {
        Files.createDirectory(this.fileTA().resolve(this.nameC()), new FileAttribute[0]);
    }

    @Test
    public void testRootisADir() throws IOException {
        Assertions.assertThat((Path)this.defaultRoot()).isDirectory();
    }

    @Test
    public void testDefaultExists() throws Exception {
        Assertions.assertThat((Path)this.pathDefault()).exists();
    }

    @Test
    public void testNonExistingAbsolutePathIsNotADirectory() throws IOException {
        Assertions.assertThat((boolean)Files.isDirectory(this.getNonExistingPath(), new LinkOption[0])).isFalse();
    }

    @Test
    public void testNonExistingAbsolutePathIsNotADirectoryEvenIfParent() throws IOException {
        Assertions.assertThat((boolean)Files.isDirectory(PathIKWID.childGetParent((Path)this.getNonExistingPath().resolve("child")), new LinkOption[0])).isFalse();
    }

    @Test
    public void testNonExistingRelativePathIsNotADirectory() throws IOException {
        Assertions.assertThat((boolean)Files.isDirectory(this.getNonExistingPath(), new LinkOption[0])).isFalse();
    }

    @Test(expected=FileAlreadyExistsException.class)
    @Category(value={Writable.class})
    public void testCreateDirWithSamePathAsExistingFileFails() throws Exception {
        Files.createDirectory(this.fileTA(), new FileAttribute[0]);
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Attributes.class, LastModifiedTime.class})
    public void testCreateDirSetsModifiedTimeOfParent() throws IOException, InterruptedException {
        Path dir = this.dirTA();
        FileTime created = Files.getLastModifiedTime(dir, new LinkOption[0]);
        this.waitForAttribute();
        Files.createDirectory(dir.resolve(this.nameB()), new FileAttribute[0]);
        Assertions.assertThat((Comparable)Files.getLastModifiedTime(dir, new LinkOption[0])).isGreaterThan((Comparable)created);
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Attributes.class, LastAccessTime.class})
    public void testCreateDirSetsLastAccessTimeOfParent() throws IOException, InterruptedException {
        Path dir = this.dirTA();
        FileTime before = Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        this.waitForAttribute();
        Files.createDirectory(dir.resolve(this.nameB()), new FileAttribute[0]);
        Assertions.assertThat((Comparable)Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime()).isGreaterThan((Comparable)before);
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, CreationTime.class})
    public void testCreateDirSetsCreationTime() throws IOException, InterruptedException {
        Path dir = this.absTA();
        FileTime before = Files.getLastModifiedTime(PathIKWID.childGetParent((Path)dir), new LinkOption[0]);
        this.waitForAttribute();
        Files.createDirectory(dir, new FileAttribute[0]);
        BasicFileAttributes atti = Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]);
        Assertions.assertThat((Comparable)atti.creationTime()).isGreaterThan((Comparable)before);
    }

    @Test
    public void testKidsOfAbsoluteDirAreAbsolute() throws Exception {
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(this.getNonEmptyDir());){
            for (Path kid : kids) {
                Assertions.assertThat((Path)kid).isAbsolute();
            }
        }
    }

    @Test
    @Category(value={WorkingDirectoryInPlaygroundTree.class})
    public void testKidsOfRelativeDirAreRelative() throws Exception {
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(PathIKWID.childGetParent((Path)this.relativize(this.getNonEmptyDir())));){
            for (Path kid : kids) {
                Assertions.assertThat((Path)kid).isRelative();
            }
        }
    }

    @Test
    public void testKidsOfRelDirAreLikeTheResultOfResolve() throws Exception {
        Path dir = this.getNonEmptyDir();
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(dir);){
            for (Path kid : kids) {
                Assertions.assertThat((Path)kid).isEqualTo((Object)dir.resolve(kid.getFileName()));
            }
        }
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Attributes.class, LastAccessTime.class})
    public void testReadDirStreamSetsLastAccessTime() throws Exception {
        Path dir = PathIKWID.childGetParent((Path)this.fileTAB());
        FileTime before = Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        this.waitForAttribute();
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(dir);){
            for (Path path : kids) {
            }
        }
        Assertions.assertThat((Comparable)Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime()).isGreaterThan((Comparable)before);
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Attributes.class, LastAccessTime.class})
    public void testReadEmptyDirStreamSetsLastAccessTime() throws Exception {
        Path dir = this.dirTA();
        FileTime before = Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        this.waitForAttribute();
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(dir);){
            for (Path path : kids) {
            }
        }
        Assertions.assertThat((Comparable)Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime()).isGreaterThan((Comparable)before);
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Attributes.class})
    public void testReadDirStreamDoesNotSetParentsLastAccessTime() throws Exception {
        Path dir = this.dirTA();
        FileTime before = Files.readAttributes(PathIKWID.childGetParent((Path)dir), BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        this.waitForAttribute();
        Files.list(dir).forEach(p -> {});
        Assertions.assertThat((Comparable)Files.readAttributes(PathIKWID.childGetParent((Path)dir), BasicFileAttributes.class, new LinkOption[0]).lastAccessTime()).isEqualTo((Object)before);
    }

    @Test
    public void testCloseDirStreamInTheMiddleOfIteration() throws Exception {
        int size;
        Path dir = this.getNonEmptyDir();
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(dir);){
            size = Utils.getSize(kids);
        }
        kids = Files.newDirectoryStream(dir);
        var4_3 = null;
        try {
            int count = 0;
            for (Path kid : kids) {
                if (++count != 1) continue;
                kids.close();
            }
            Assertions.assertThat((int)count).isLessThan(size);
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (kids != null) {
                if (var4_3 != null) {
                    try {
                        kids.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    kids.close();
                }
            }
        }
    }

    @Test
    public void testReadBytesFromDirectoryThrows() throws IOException {
        Assertions.assertThatThrownBy(() -> Files.readAllBytes(this.dirTA())).isInstanceOf(Exception.class);
    }

    @Test
    public void testNewDirectoryStreamFromNonExistingDirThrows() throws IOException {
        Assertions.assertThatThrownBy(() -> {
            DirectoryStream<Path> kids = Files.newDirectoryStream(this.getNonExistingPath());
            Throwable throwable = null;
            if (kids != null) {
                if (throwable != null) {
                    try {
                        kids.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    kids.close();
                }
            }
        }).isInstanceOf(NoSuchFileException.class);
    }

    @BeforeClass
    @SuppressFBWarnings
    public static void beforeDir() {
        int i;
        CONTENT = Strings.getBytes((String)"hi there");
        CONTENT_OTHER = Strings.getBytes((String)"what's up, huh, huh");
        String str = new String(Character.toChars(66560));
        for (i = 0; i < 12; ++i) {
            str = str + str;
        }
        CONTENT_BIG = Strings.getBytes((String)(str + "abcde"));
        CONTENT50 = new byte[50];
        for (i = 0; i < 50; ++i) {
            Tests02Dir.CONTENT50[i] = (byte)i;
        }
    }

    public Path absT() {
        Path ret = this.description.get(Path.class, "playground").resolve(this.testMethodName.getMethodName());
        Filess.createDirectories((Path)ret, (FileAttribute[])new FileAttribute[0]);
        return ret;
    }

    public Path absTA() {
        return this.absT().resolve(this.nameA());
    }

    public Path absTB() {
        return this.absT().resolve(this.nameB());
    }

    public Path absTC() {
        return this.absT().resolve(this.nameC());
    }

    public Path relTA() {
        Path abs = this.absTA();
        return this.pathDefault().toAbsolutePath().relativize(abs);
    }

    public Path absTAB() {
        return this.absTA().resolve(this.nameB());
    }

    public Path absTAC() {
        return this.absTA().resolve(this.nameC());
    }

    public Path dirTA() {
        Path ret = this.absTA();
        Filess.createDirectories((Path)ret, (FileAttribute[])new FileAttribute[0]);
        return ret;
    }

    public Path dirTAB() {
        Path ret = this.absTAB();
        Filess.createDirectories((Path)ret, (FileAttribute[])new FileAttribute[0]);
        return ret;
    }

    public Path dirTBB() {
        Path ret = this.absTB().resolve(this.nameB());
        Filess.createDirectories((Path)ret, (FileAttribute[])new FileAttribute[0]);
        return ret;
    }

    public Path dirTB() {
        Path ret = this.absTB();
        Filess.createDirectories((Path)ret, (FileAttribute[])new FileAttribute[0]);
        return ret;
    }

    public Path fileTA() {
        Path ret = this.absTA();
        if (!Files.exists(ret, new LinkOption[0])) {
            Filess.write((Path)ret, (byte[])CONTENT, (OpenOption[])new OpenOption[0]);
        }
        return ret;
    }

    public Path fileTB() {
        Path ret = this.absTB();
        if (!Files.exists(ret, new LinkOption[0])) {
            Filess.write((Path)ret, (byte[])CONTENT, (OpenOption[])new OpenOption[0]);
        }
        return ret;
    }

    public Path fileTAB() {
        Path ret = this.dirTA().resolve(this.nameB());
        if (!Files.exists(ret, new LinkOption[0])) {
            Filess.write((Path)ret, (byte[])CONTENT, (OpenOption[])new OpenOption[0]);
        }
        return ret;
    }

    public Path relativize(Path path) {
        return this.pathDefault().toAbsolutePath().relativize(path);
    }

    public Path fileTAC() {
        Path ret = this.dirTA().resolve(this.nameC());
        if (!Files.exists(ret, new LinkOption[0])) {
            Filess.write((Path)ret, (byte[])CONTENT, (OpenOption[])new OpenOption[0]);
        }
        return ret;
    }

    public Path fileTAD() {
        Path ret = this.dirTA().resolve(this.nameD());
        if (!Files.exists(ret, new LinkOption[0])) {
            Filess.write((Path)ret, (byte[])CONTENT, (OpenOption[])new OpenOption[0]);
        }
        return ret;
    }

    public void waitForAttribute() {
        try {
            Object del = this.description.props.get("attributeDelay");
            if (del != null) {
                Thread.sleep(((Integer)del).intValue());
            } else {
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Path getNonEmptyDir() {
        if (!this.description.provides(Writable.class)) {
            return this.description.get(Path.class, "nonemptyDir");
        }
        Path dir = this.dirTBB();
        Filess.write((Path)dir.resolve("one"), (byte[])CONTENT, (OpenOption[])new OpenOption[0]);
        Filess.write((Path)dir.resolve("two"), (byte[])CONTENT, (OpenOption[])new OpenOption[0]);
        return dir;
    }

    public Path getEmptyDir() {
        if (!this.description.provides(Writable.class)) {
            return this.description.get(Path.class, "emptyDir");
        }
        return this.dirTA();
    }

    public Path getNonExistingPath() {
        if (!this.description.provides(Writable.class)) {
            return this.description.get(Path.class, "nonexisting");
        }
        return this.absTA().resolve("notthere");
    }
}

