/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.nio.PathIKWID;
import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests00Setup;
import de.pfabulist.lindwurm.niotest.tests.topics.Basic;
import de.pfabulist.lindwurm.niotest.tests.topics.NotDefaultFileSystem;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Basic.class})
public abstract class Tests01NoContent
extends Tests00Setup {
    protected String[] name = new String[]{"aaa", "bbbb", "cccc", "ddddd", "eeeeee"};

    public Tests01NoContent(FSDescription capa) {
        super(capa);
    }

    @Test
    public void testGetNameSimple() {
        Assertions.assertThat((Path)this.relAB().getName(0)).isEqualTo((Object)this.relA());
        Assertions.assertThat((Path)this.relAB().getName(1)).isEqualTo((Object)this.relB());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRootHasNoName() {
        this.defaultRoot().getName(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetNameWithNegativeIndex() {
        this.relAB().getName(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetNameWithTooLargeIndex() {
        this.relAB().getName(5);
    }

    @Test
    public void testGetNameOfDefaultPathIsItself() {
        Assertions.assertThat((Path)this.pathDefault().getName(0)).isEqualTo((Object)this.pathDefault());
    }

    @Test
    public void testResultOfGetNameIsRelative() {
        Assertions.assertThat((Path)this.relAB().getName(0)).isRelative();
    }

    @Test
    public void testNameDoesNotIncludeSeparator() throws Exception {
        Assertions.assertThat((String)this.relAB().getName(1).toString()).doesNotContain((CharSequence)this.FS.getSeparator());
    }

    @Test
    public void testNameCountOfNameIs1() throws Exception {
        Assertions.assertThat((int)this.relABC().getName(2).getNameCount()).isEqualTo(1);
    }

    @Test
    public void testGetNameCountSimple() {
        Assertions.assertThat((int)this.relAB().getNameCount()).isEqualTo(2);
    }

    @Test
    public void testGetNameIsIdempontent() {
        Assertions.assertThat((Path)this.relA().getName(0)).isEqualTo((Object)this.relA());
    }

    @Test
    public void testRootNameCountIs0() {
        Assertions.assertThat((int)this.defaultRoot().getNameCount()).isEqualTo(0);
    }

    @Test
    public void testDefaultHasNameCount1() {
        Assertions.assertThat((int)this.pathDefault().getNameCount()).isEqualTo(1);
    }

    @Test
    public void testEndsWithSimple() {
        Assertions.assertThat((boolean)this.relABC().endsWith(this.relBC())).isTrue();
        Assertions.assertThat((boolean)this.relABC().endsWith(this.relAB())).isFalse();
    }

    @Test
    public void testEndsWithStringSimple() {
        Path abc = this.relABC();
        String bcStr = this.relBC().toString();
        String abStr = this.relAB().toString();
        Assertions.assertThat((boolean)abc.endsWith(bcStr)).isTrue();
        Assertions.assertThat((boolean)abc.endsWith(abStr)).isFalse();
    }

    @Test
    public void testStartsWithSimple() {
        Path abc = this.relABC();
        Path bc = this.relBC();
        Path ab = this.relAB();
        Assertions.assertThat((boolean)abc.startsWith(bc)).isFalse();
        Assertions.assertThat((boolean)abc.startsWith(ab)).isTrue();
    }

    @Test
    public void testAbsolutePathDoesNotStartsWithARelativePath() {
        Path abcAbso = this.absABC();
        Path abRel = this.relAB();
        Assertions.assertThat((boolean)abcAbso.startsWith(abRel)).isFalse();
    }

    @Test
    public void testAbsolutePathDoesStartsWithAnAbsolutePath() {
        Path abcAbso = this.absABC();
        Path abAbso = this.absAB();
        Assertions.assertThat((boolean)abcAbso.startsWith(abAbso)).isTrue();
    }

    @Test
    public void testAbsolutePathDoesStartsWithRoot() {
        Assertions.assertThat((boolean)this.absABC().startsWith(this.defaultRoot())).isTrue();
    }

    @Test
    public void testNoNonEmptyPathStartsWithDefault() {
        Assertions.assertThat((boolean)this.relABC().startsWith(this.pathDefault())).isFalse();
    }

    @Test
    public void testStartsWithStringSimple() {
        Path abc = this.relABC();
        String bcStr = this.relBC().toString();
        String abStr = this.relAB().toString();
        Assertions.assertThat((boolean)abc.startsWith(bcStr)).isFalse();
        Assertions.assertThat((boolean)abc.startsWith(abStr)).isTrue();
    }

    @Test
    public void testSubPathSimple() throws Exception {
        Assertions.assertThat((Path)this.relBC()).isEqualTo((Object)this.relABC().subpath(1, 3));
    }

    @Test
    public void testSubPathIsRelative() throws Exception {
        Assertions.assertThat((Path)this.relABC().subpath(1, 3)).isRelative();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubPathNegativeStart() throws Exception {
        this.relABC().subpath(-1, 2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubPathStartTooLarge() throws Exception {
        this.relAB().subpath(7, 9);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubPathEndBeforeStart() throws Exception {
        this.relABC().subpath(1, 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubPathEndTooLarge() throws Exception {
        this.relABC().subpath(1, 12);
    }

    @Test
    public void testFileNameHasNameCountOf1() {
        Assertions.assertThat((int)this.absAB().getFileName().getNameCount()).isEqualTo(1);
    }

    @Test
    public void testGetFileNameIsIdempotent() throws Exception {
        Path fileName = PathIKWID.namedGetFilename((Path)this.relAB());
        Assertions.assertThat((Path)fileName.getFileName()).isEqualTo((Object)fileName);
    }

    @Test
    public void testFileNameIsRelative() throws Exception {
        Assertions.assertThat((Path)this.absAB().getFileName()).isRelative();
    }

    @Test
    public void testRootHasNoFileName() throws Exception {
        Assertions.assertThat((Path)this.defaultRoot().getFileName()).isNull();
    }

    @Test
    public void testFileNameStringIsPathPartString() {
        Assertions.assertThat((String)this.relA().getFileName().toString()).isEqualTo((Object)this.nameA());
    }

    @Test
    public void testFileNameIsLastName() throws Exception {
        Assertions.assertThat((Path)this.relABC().getFileName()).isEqualTo((Object)this.relABC().getName(2));
    }

    @Test
    public void testDefaultHasANameAndItsItself() throws Exception {
        Assertions.assertThat((Path)this.pathDefault()).isEqualTo((Object)this.pathDefault().getFileName());
    }

    @Test
    public void testResolveOfNameStrEndsWithThatName() {
        Path rel = this.pathDefault();
        Path res = rel.resolve(this.nameA());
        Assertions.assertThat((boolean)res.endsWith(this.nameA())).isTrue();
    }

    @Test
    public void testResolveOfARelativePathIsRelative() throws Exception {
        Assertions.assertThat((Path)this.pathDefault().resolve(this.nameA())).isRelative();
    }

    @Test
    public void testResolveOfAbsoluteIsAbsolute() throws Exception {
        Assertions.assertThat((Path)this.absAB().resolve(this.nameA())).isAbsolute();
    }

    @Test
    public void testResolveWithDefaultIsNop() {
        Assertions.assertThat((Path)this.relABC()).isEqualTo((Object)this.relABC().resolve(this.pathDefault()));
    }

    @Test
    public void testResolveWithNameIsSameAsStr() throws Exception {
        Assertions.assertThat((Path)this.relAB().resolve(this.nameD())).isEqualTo((Object)this.relAB().resolve(this.relD()));
    }

    @Test
    public void testResolveWorksLikeGetPathOnStringsWithSeparator() throws Exception {
        String str = this.nameA() + this.FS.getSeparator() + this.nameB();
        Assertions.assertThat((Path)this.pathDefault().resolve(str)).isEqualTo((Object)this.FS.getPath(str, new String[0]));
    }

    @Test
    public void testResolveWithStringWithSeparatorsSameAsWithPath() throws Exception {
        String str = this.nameA() + this.FS.getSeparator() + this.nameB();
        Path asPath = this.FS.getPath(this.nameA() + this.FS.getSeparator() + this.nameB(), new String[0]);
        Assertions.assertThat((Path)this.pathDefault().resolve(str)).isEqualTo((Object)this.pathDefault().resolve(asPath));
    }

    @Test
    public void testResolveIterative() throws Exception {
        Path two = this.relA().resolve(this.relB());
        Assertions.assertThat((Path)this.relA().resolve(two)).isEqualTo((Object)this.relA().resolve(this.relA().resolve(this.relB())));
    }

    @Test
    public void testResolveWithAbsoluteArgReturnArg() throws Exception {
        Assertions.assertThat((Path)this.absAB()).isEqualTo((Object)this.relA().resolve(this.absAB()));
    }

    @Test
    public void testResolveSiblingIsGetParentResolve() {
        Assertions.assertThat((Path)this.relABC().resolveSibling(this.relA())).isEqualTo((Object)this.relAB().resolve(this.relA()));
    }

    @Test
    public void testResolveSiblingWithAbsoluteArgIsThatArg() throws Exception {
        Assertions.assertThat((Path)this.relA().resolveSibling(this.absAB())).isEqualTo((Object)this.absAB());
    }

    @Test
    public void testResolveSiblingOnRootReturnsArg() throws Exception {
        Assertions.assertThat((Path)this.defaultRoot().resolveSibling(this.relAB())).isEqualTo((Object)this.relAB());
    }

    @Test
    public void testResolveSiblingOnDefaultReturnsArg() throws Exception {
        Assertions.assertThat((Path)this.pathDefault().resolveSibling(this.relAB())).isEqualTo((Object)this.relAB());
    }

    @Test
    public void testResolveSiblingOnNameReturnsArg() throws Exception {
        Assertions.assertThat((Path)this.relA().resolveSibling(this.relAB())).isEqualTo((Object)this.relAB());
    }

    @Test
    public void testResolveSiblingWorksWithStringAndPath() throws Exception {
        Assertions.assertThat((Path)this.relAB().resolveSibling(this.relB())).isEqualTo((Object)this.relAB().resolveSibling(this.nameB()));
    }

    @Test
    public void testResolveSiblingOnRootWithEmptyIsEmpty() throws Exception {
        Assertions.assertThat((Path)this.defaultRoot().resolveSibling(this.pathDefault())).isEqualTo((Object)this.pathDefault());
    }

    @Test
    public void testResolveSiblingOnEmptyWithEmptyIsEmpty() throws Exception {
        Assertions.assertThat((Path)this.pathDefault().resolveSibling(this.pathDefault())).isEqualTo((Object)this.pathDefault());
    }

    @Test
    public void testResolveSiblingOnChildWithEmptyIsParent() throws Exception {
        Assertions.assertThat((Path)this.absABC().resolveSibling(this.pathDefault())).isEqualTo((Object)this.absAB());
    }

    @Test
    public void testGetPathIgnoresEmptyStringAsFirstParameter() throws Exception {
        Assertions.assertThat((Path)this.FS.getPath(this.nameA(), new String[0])).isEqualTo((Object)this.FS.getPath("", this.nameA()));
    }

    @Test
    public void testGetPathIgnoresEmptyStringInAnyParameter() throws Exception {
        Assertions.assertThat((Path)this.FS.getPath(this.nameA(), new String[0])).isEqualTo((Object)this.FS.getPath("", "", this.nameA(), "", ""));
    }

    @Test
    public void testGetPathWithSeveralNamesIsSameAsWithOneStringWithSeparators() throws Exception {
        Assertions.assertThat((Path)this.FS.getPath(this.nameA(), this.nameB(), this.nameC())).isEqualTo((Object)this.FS.getPath(this.nameA() + this.FS.getSeparator() + this.nameB() + this.FS.getSeparator() + this.nameC(), new String[0]));
    }

    @Test
    public void testpathAllowsMixedArguments() throws Exception {
        Assertions.assertThat((Path)this.FS.getPath(this.nameA() + this.FS.getSeparator() + this.nameB(), this.nameC())).isEqualTo((Object)this.FS.getPath(this.nameA(), this.nameB() + this.FS.getSeparator() + this.nameC()));
    }

    @Test
    public void testpathAndToStringAreOpposites() throws Exception {
        Assertions.assertThat((Path)this.FS.getPath(this.relABC().toString(), new String[0])).isEqualTo((Object)this.relABC());
        String str = this.nameC() + this.FS.getSeparator() + this.nameD();
        Assertions.assertThat((String)this.FS.getPath(str, new String[0]).toString()).isEqualTo((Object)str);
    }

    @Test
    public void testGetPathNotStartingWithRootStringIsRelative() throws Exception {
        Assertions.assertThat((Path)this.FS.getPath(this.nameC(), new String[0])).isRelative();
    }

    @Test
    public void testRelativize() {
        Path shrt = this.FS.getPath(this.nameA(), new String[0]);
        Path lng = this.FS.getPath(this.nameA(), this.nameB(), this.nameC());
        Assertions.assertThat((Path)lng).isEqualTo((Object)shrt.resolve(shrt.relativize(lng)));
    }

    @Test
    public void testRelativizeAbsolute() {
        Path root = this.defaultRoot();
        Path lng = root.resolve(this.nameA()).resolve(this.nameB()).resolve(this.nameC());
        Path lngRel = this.FS.getPath(this.nameA(), this.nameB(), this.nameC());
        Assertions.assertThat((Path)lngRel).isEqualTo((Object)root.relativize(lng));
    }

    @Test
    public void testRelativizeFromDefaultAbsoluteIsInverseOfToAbsoluteNormalize() {
        Path abs = this.absABC();
        Path defAbs = this.pathDefault().toAbsolutePath();
        Assertions.assertThat((Path)defAbs.relativize(abs).toAbsolutePath().normalize()).isEqualTo((Object)abs);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRelativizeAbsToRel() {
        Path shrt = this.FS.getPath(this.nameA(), new String[0]);
        Path lng = this.FS.getPath(this.nameA(), this.nameB(), this.nameC()).toAbsolutePath();
        shrt.relativize(lng);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRelativizeRelToAbs() {
        Path shrt = this.FS.getPath(this.nameA(), new String[0]).toAbsolutePath();
        Path lng = this.FS.getPath(this.nameA(), this.nameB(), this.nameC());
        shrt.relativize(lng);
    }

    @Test
    public void testRelativizePathWithOtherRootFails() {
        for (Path root : this.FS.getRootDirectories()) {
            if (root.equals(this.defaultRoot())) continue;
            Assertions.assertThatThrownBy(() -> root.relativize(this.defaultRoot())).isInstanceOf(IllegalArgumentException.class);
        }
    }

    @Test
    public void testGetParent() {
        Path rel = this.FS.getPath(this.nameA(), new String[0]);
        Assertions.assertThat((Path)rel.getParent()).isNull();
        Path abs = this.FS.getPath(this.nameA(), this.nameC()).toAbsolutePath();
        Assertions.assertThat((Path)abs).isEqualTo((Object)abs.resolve(this.nameA()).getParent());
    }

    @Test
    public void testGetParentOfRootIsNull() throws Exception {
        Assertions.assertThat((Path)this.defaultRoot().getParent()).isNull();
    }

    @Test
    public void testGetParentOfNameIsNull() throws Exception {
        Assertions.assertThat((Path)this.relA().getParent()).isNull();
    }

    @Test
    public void testGetParentOfDefaultIsNull() throws Exception {
        Assertions.assertThat((Path)this.pathDefault().getParent()).isNull();
    }

    @Test
    public void testGetParentOfLongerRelativeNameIsNotNull() throws Exception {
        Assertions.assertThat((Path)this.relAB().getParent()).isNotNull();
    }

    @Test
    public void testGetParentIsInverseOfResolve() throws Exception {
        Assertions.assertThat((Path)this.relA()).isEqualTo((Object)PathIKWID.childGetParent((Path)this.relA().resolve(this.relB())));
        Assertions.assertThat((Path)this.relAB()).isEqualTo((Object)PathIKWID.childGetParent((Path)this.relAB()).resolve(this.relB()));
    }

    @Test
    public void testGetParentOfRelativeIsRelative() throws Exception {
        Assertions.assertThat((Path)PathIKWID.childGetParent((Path)this.relAB())).isRelative();
    }

    @Test
    public void testgetParentOfAbsoluteIsAbsolute() throws Exception {
        Assertions.assertThat((Path)PathIKWID.childGetParent((Path)this.absAB())).isAbsolute();
    }

    @Test
    public void testNormalizeWildAbsPaths() {
        Path abs = this.absAB();
        Assertions.assertThat((Path)abs.resolve(".." + this.FS.getSeparator() + "bb" + this.FS.getSeparator() + ".." + this.FS.getSeparator() + ".").normalize()).isEqualTo((Object)PathIKWID.childGetParent((Path)abs));
        Assertions.assertThat((String)this.relA().resolve("..").normalize().toString()).isEqualTo((Object)"");
    }

    @Test
    public void testNormalizeWildRelPaths() {
        Assertions.assertThat((String)this.relA().resolve("..").normalize().toString()).isEqualTo((Object)"");
    }

    @Test
    public void testNormalize1Dot() {
        Path path1 = this.relAB();
        Path path2 = path1.resolve(".");
        Assertions.assertThat((Path)path1).isNotEqualTo((Object)path2);
        Assertions.assertThat((Path)path1).isEqualTo((Object)path2.normalize());
    }

    @Test
    public void testNormalize2Dots() {
        Path path1 = this.relAB();
        Path path2 = path1.resolve(this.nameD()).resolve("..");
        Assertions.assertThat((Path)path1).isNotEqualTo((Object)path2);
        Assertions.assertThat((Path)path1).isEqualTo((Object)path2.normalize());
    }

    @Test
    public void testNormalizeIsIdempotent() throws Exception {
        Path path = this.relABC().resolve("..").resolve(this.nameC());
        Assertions.assertThat((Path)path.normalize().normalize()).isEqualTo((Object)path.normalize());
    }

    @Test
    public void testNormlizeParentOfRoot() {
        Assertions.assertThat((Path)this.defaultRoot().resolve("..").normalize()).isEqualTo((Object)this.defaultRoot());
    }

    @Test
    public void testNormalizeRelativePath() {
        Path rel = this.FS.getPath("..", new String[0]).resolve(this.nameA());
        Assertions.assertThat((Path)rel.normalize()).isEqualTo((Object)rel);
    }

    @Test
    public void testNormalizeRelativePathEmptyHm() {
        Path rel = this.FS.getPath(this.nameA(), new String[0]).resolve("..");
        Assertions.assertThat((Path)rel.normalize()).isEqualTo((Object)this.pathDefault());
    }

    @Test
    public void testPathIterator() {
        int i = 0;
        for (Path kid : this.relABC()) {
            switch (i) {
                case 0: {
                    Assertions.assertThat((Path)kid).isEqualTo((Object)this.relA());
                    break;
                }
                case 1: {
                    Assertions.assertThat((Path)kid).isEqualTo((Object)this.relB());
                    break;
                }
                case 2: {
                    Assertions.assertThat((Path)kid).isEqualTo((Object)this.relC());
                    break;
                }
            }
            ++i;
        }
        Assertions.assertThat((int)i).isEqualTo(3);
    }

    @Test
    public void testRootOfRelativeIsNull() {
        Assertions.assertThat((Path)this.relABC().getRoot()).isNull();
    }

    @Test
    public void testRootIsOneOfTheRoots() {
        Assertions.assertThat((Path)this.defaultRoot()).isIn(this.FS.getRootDirectories());
    }

    @Test
    public void testRootOfAbsolutePathIsAbsolute() throws Exception {
        Assertions.assertThat((Path)this.absAB().getRoot()).isAbsolute();
    }

    @Test
    public void testdefaultRootIsIdempotent() throws Exception {
        Assertions.assertThat((Path)this.defaultRoot()).isEqualTo((Object)this.defaultRoot().getRoot());
    }

    @Test
    public void testToAbsoluteProducesAnAbsolutePath() throws Exception {
        Assertions.assertThat((Path)this.relABC().toAbsolutePath()).isAbsolute();
    }

    @Test
    public void testToAbsoluteIsIdempotent() throws Exception {
        Assertions.assertThat((Path)this.absAB()).isEqualTo((Object)this.absAB().toAbsolutePath());
    }

    @Test
    public void testDefaultIsRelative() throws Exception {
        Assertions.assertThat((Path)this.pathDefault()).isRelative();
    }

    @Test
    public void testRelativePathToStringDoesNotStartWithSeparator() throws Exception {
        Assertions.assertThat((boolean)this.relAB().toString().startsWith(this.FS.getSeparator())).isFalse();
    }

    @Test
    public void testPathWith2NamesHasSeparatorInToString() throws Exception {
        Assertions.assertThat((boolean)this.relAB().toString().contains(this.FS.getSeparator())).isTrue();
    }

    @Test
    @Category(value={NotDefaultFileSystem.class})
    public void testPathsWithSamePathElementsButDifferentProviderAreDifferent() throws Exception {
        Path myABC = this.FS.getPath(this.nameA(), this.nameB(), this.nameC());
        Path otherABC = FileSystems.getDefault().getPath(this.nameA(), this.nameB(), this.nameC());
        Assertions.assertThat((Path)myABC).isNotEqualTo((Object)otherABC);
    }

    @Test(expected=UnsupportedOperationException.class)
    @Category(value={NotDefaultFileSystem.class})
    public void testToFileOnNonDefaultFSThrows() throws Exception {
        this.absAB().toFile();
    }

    @Test
    public void testPathMatcherKnowsGlob() {
        Assertions.assertThat((Object)this.FS.getPathMatcher("glob:*")).isNotNull();
    }

    @Test
    public void testPathMatcherKnowsRegex() {
        Assertions.assertThat((Object)this.FS.getPathMatcher("regex:.*")).isNotNull();
    }

    @Test
    public void testPathMatcherThrowsOnUnknownSyntax() {
        Assertions.assertThatThrownBy(() -> this.FS.getPathMatcher("thisisarellysillysyntax:*")).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    public void testPathMatherRegex() throws Exception {
        PathMatcher pm = this.FS.getPathMatcher("regex:.*" + this.nameC() + ".*");
        Assertions.assertThat((boolean)pm.matches(this.FS.getPath(this.nameC(), new String[0]).toAbsolutePath())).isTrue();
        Assertions.assertThat((boolean)pm.matches(this.FS.getPath(this.nameC(), new String[0]))).isTrue();
        Assertions.assertThat((boolean)pm.matches(this.FS.getPath(this.nameC(), "da"))).isTrue();
        Assertions.assertThat((boolean)pm.matches(this.FS.getPath("du", this.nameC(), "da"))).isTrue();
        Assertions.assertThat((boolean)pm.matches(this.FS.getPath("du", this.nameC() + this.nameA(), "da"))).isTrue();
    }

    @Test
    public void testPathMatherGlob() throws Exception {
        PathMatcher pm = this.FS.getPathMatcher("glob:*.{" + this.nameC() + "," + this.nameD() + "}");
        Assertions.assertThat((boolean)pm.matches(this.FS.getPath(this.nameE() + "." + this.nameD(), new String[0]))).isTrue();
        Assertions.assertThat((boolean)pm.matches(this.FS.getPath(this.nameE() + "." + this.nameC(), new String[0]))).isTrue();
        Assertions.assertThat((boolean)pm.matches(this.FS.getPath(this.nameE() + this.nameC(), new String[0]))).isFalse();
    }

    @Test
    @Category(value={NotDefaultFileSystem.class})
    public void testCompareToDifferentProviderThrows() throws Exception {
        Assertions.assertThatThrownBy(() -> this.relABC().compareTo(FileSystems.getDefault().getPath(this.nameA(), new String[0]))).isInstanceOf(ClassCastException.class);
    }

    @Test
    public void testCompareToOfEqualPathsIs0() throws Exception {
        Assertions.assertThat((int)this.relABC().compareTo(this.relABC())).isEqualTo(0);
    }

    @Test
    public void testCompareToShortPathIsPositive() throws Exception {
        Assertions.assertThat((this.relABC().compareTo(this.relAB()) > 0 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testCompareToLongerPathIsNegative() throws Exception {
        Assertions.assertThat((this.relAB().compareTo(this.relABC()) < 0 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testRelativePathIsNotEqualtoAbsoluteWithSamePathElements() throws Exception {
        Assertions.assertThat((int)this.relAB().compareTo(this.absAB())).isNotEqualTo(0);
    }

    private int restrictTo1(int in) {
        return in < 0 ? -1 : 1;
    }

    @Test
    public void testRelativePathsAreInDifferentSpaceThanAbsolutes() throws Exception {
        int diff = this.restrictTo1(this.relABC().compareTo(this.absABC()));
        Assertions.assertThat((int)this.restrictTo1(this.relAB().compareTo(this.absABC()))).isEqualTo(diff);
        Assertions.assertThat((int)this.restrictTo1(this.relABC().compareTo(this.absAB()))).isEqualTo(diff);
        Assertions.assertThat((int)this.restrictTo1(this.relABC().compareTo(this.absD()))).isEqualTo(diff);
    }

    @Test
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
    public void testPathIsImmutableToToAbsolute() throws Exception {
        Path rel = this.relAB();
        rel.toAbsolutePath();
        Assertions.assertThat((Path)rel).isRelative();
    }

    @Test
    public void testPathIsImmutableToNormalize() throws Exception {
        Path unnom = this.relAB().resolve("..");
        Assertions.assertThat((boolean)unnom.toString().contains("..")).isTrue();
    }

    @Test
    public void testNonExistingAbsolutePathIsNotAFile() throws IOException {
        Assertions.assertThat((boolean)Files.isRegularFile(this.relAB(), new LinkOption[0])).isFalse();
    }

    @Test
    public void testNonExistingRelativePathIsNotAFile() throws IOException {
        Assertions.assertThat((boolean)Files.isRegularFile(this.relA(), new LinkOption[0])).isFalse();
    }

    @Test
    public void testSeparatorIsNoFileName() {
        Path path = this.FS.getPath(this.nameD() + this.FS.getSeparator() + this.nameA(), new String[0]);
        for (Path elem : path) {
            Assertions.assertThat((String)elem.toString()).doesNotContain((CharSequence)this.FS.getSeparator());
        }
    }

    @Test
    public void testResolveNull() throws IOException {
        Assertions.assertThatThrownBy(() -> this.relAB().resolve((String)null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    public void testNullPath() {
        Assertions.assertThatThrownBy(() -> this.FS.getPath(null, new String[0])).isInstanceOf(NullPointerException.class);
    }

    public Path pathDefault() {
        return this.FS.getPath("", new String[0]);
    }

    public Path defaultRoot() {
        return PathIKWID.absoluteGetRoot((Path)this.FS.getPath("", new String[0]).toAbsolutePath());
    }

    public Path relA() {
        return this.FS.getPath(this.nameA(), new String[0]);
    }

    public Path relB() {
        return this.FS.getPath(this.nameB(), new String[0]);
    }

    public Path relC() {
        return this.FS.getPath(this.nameC(), new String[0]);
    }

    public Path relD() {
        return this.FS.getPath(this.nameD(), new String[0]);
    }

    public Path relAB() {
        return this.FS.getPath(this.nameA(), this.nameB());
    }

    public Path relBC() {
        return this.FS.getPath(this.nameB(), this.nameC());
    }

    public Path relABC() {
        return this.FS.getPath(this.nameA(), this.nameB(), this.nameC());
    }

    public String nameA() {
        return this.name[0];
    }

    public String nameB() {
        return this.name[1];
    }

    public String nameC() {
        return this.name[2];
    }

    public String nameD() {
        return this.name[3];
    }

    public String nameE() {
        return this.name[4];
    }

    public Path absAB() {
        return this.defaultRoot().resolve(this.nameA()).resolve(this.nameB());
    }

    public Path absABC() {
        return this.defaultRoot().resolve(this.nameA()).resolve(this.nameB()).resolve(this.nameC());
    }

    public Path absD() {
        return this.defaultRoot().resolve(this.nameD());
    }
}

