/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.tests.attributes.AttributeDescription;
import de.pfabulist.lindwurm.niotest.tests.attributes.AttributeDescriptionBuilder;
import de.pfabulist.lindwurm.niotest.tests.topics.Basic;
import de.pfabulist.lindwurm.niotest.tests.topics.Topic;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.junit.rules.TestName;

public class FSDescription {
    private final List<Class<? extends Topic>> notProvidedTopics = new ArrayList<Class<? extends Topic>>();
    public final Map<String, Object> props = new HashMap<String, Object>();
    private final Set<String> bugs = new HashSet<String>();
    private final Set<String> bugSchemes = new HashSet<String>();
    @Nullable
    public ClosedFSVars closedFSVars;
    @Nullable
    public Path otherProviderPlayground;
    private final Set<String> usedBugs = new HashSet<String>();
    private final Set<String> usedSchemes = new HashSet<String>();
    public final Map<String, AttributeDescription> attributeDescriptions = new HashMap<String, AttributeDescription>();
    protected final Map<Integer, Path> longPaths = new HashMap<Integer, Path>();
    protected final Map<Object, Object> rem = new HashMap<Object, Object>();

    public FSDescription() {
        this.attributeDescriptions.put("basic", AttributeDescriptionBuilder.attributeBuilding(Basic.class, "basic", BasicFileAttributeView.class, BasicFileAttributes.class).addAttribute("lastModifiedTime", BasicFileAttributes::lastModifiedTime).addAttribute("creationTime", BasicFileAttributes::creationTime).addAttribute("size", BasicFileAttributes::size).addAttribute("lastAccessTime", BasicFileAttributes::lastAccessTime).addAttribute("isDirectory", BasicFileAttributes::isDirectory).addAttribute("isSymbolicLink", BasicFileAttributes::isSymbolicLink).addAttribute("isOther", BasicFileAttributes::isOther).build());
    }

    public <T> T get(Class<T> klass, String key) {
        Object val = this.props.get(key);
        if (val == null) {
            throw new IllegalStateException("niotest error: no value for " + key);
        }
        if (val.getClass().isAssignableFrom(klass)) {
            throw new IllegalStateException("niotest error: wrong class for: " + key + " expected: " + klass + " got: " + val.getClass());
        }
        return klass.cast(val);
    }

    public int getInt(String key) {
        Object ret = this.props.get(key);
        if (ret == null) {
            return 0;
        }
        return (Integer)ret;
    }

    public FSDescription addTopic(Class<? extends Topic> clazz) {
        this.notProvidedTopics.remove(clazz);
        return this;
    }

    public FSDescription removeTopic(Class<? extends Topic> clazz) {
        this.notProvidedTopics.add(clazz);
        return this;
    }

    public boolean provides(Class<?> clazz) {
        return !this.notProvidedTopics.contains(clazz);
    }

    @Nullable
    public Object get(String key) {
        return this.props.get(key);
    }

    public boolean isBug(TestName testMethodName) {
        return this.bugs.contains(testMethodName.getMethodName()) || this.bugSchemes.stream().anyMatch(scheme -> testMethodName.getMethodName().contains((CharSequence)scheme));
    }

    public void addBug(String name) {
        this.bugs.add(name);
    }

    public void addBugScheme(String scheme) {
        this.bugSchemes.add(scheme);
    }

    public void markHits(TestName testMethodName) {
        Optional<String> found = this.bugs.stream().filter(name -> name.equals(testMethodName.getMethodName())).findFirst();
        if (found.isPresent()) {
            this.usedBugs.add(found.get());
            return;
        }
        Optional<String> usedScheme = this.bugSchemes.stream().filter(scheme -> testMethodName.getMethodName().contains((CharSequence)scheme)).findFirst();
        if (usedScheme.isPresent()) {
            this.usedSchemes.add(usedScheme.get());
        }
    }

    public void printUnused() {
        for (String bug : this.bugs) {
            if (this.usedBugs.contains(bug)) continue;
            System.out.println("not found method called " + bug);
        }
        for (String scheme : this.bugSchemes) {
            if (this.usedSchemes.contains(scheme)) continue;
            System.out.println("bug scheme did not apply :  " + scheme);
        }
    }

    public Stream<AttributeDescription> getAttributeDescriptions() {
        return this.attributeDescriptions.values().stream().filter(ad -> !this.notProvidedTopics.contains(ad.getTopic()));
    }

    public static class ClosedFSVars {
        @Nullable
        public FileSystem fs;
        public Path play;
        @Nullable
        public Path fileA;
        @Nullable
        public Path dirB;
        @Nullable
        public SeekableByteChannel readChannel;
        @Nullable
        public URI uri;
        @Nullable
        public DirectoryStream<Path> dirStream;
        @Nullable
        public WatchService watchService;
        @Nullable
        public FileSystemProvider provider;

        public ClosedFSVars(Path play) {
            this.play = play;
        }
    }
}

