/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests.descriptionbuilders;

import de.pfabulist.kleinod.os.OS;
import de.pfabulist.kleinod.os.PathLimits;
import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.attributes.AttributeDescriptionBuilder;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.DescriptionBuilder;
import de.pfabulist.lindwurm.niotest.tests.topics.DosAttributesT;
import de.pfabulist.lindwurm.niotest.tests.topics.FileKeyT;
import de.pfabulist.lindwurm.niotest.tests.topics.MoveWhile;
import de.pfabulist.lindwurm.niotest.tests.topics.NonCasePreserving;
import de.pfabulist.lindwurm.niotest.tests.topics.Posix;
import de.pfabulist.lindwurm.niotest.tests.topics.RootComponent;
import de.pfabulist.lindwurm.niotest.tests.topics.UNC;
import de.pfabulist.lindwurm.niotest.tests.topics.Unix;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;

public class WindowsBuilder<T>
extends DescriptionBuilder<T> {
    public WindowsBuilder(FSDescription descr, T t) {
        super(descr, t);
        descr.removeTopic(Unix.class);
        PathLimits pathLimits = new PathLimits(OS.WINDOWS);
        descr.props.put("oneCharCount", pathLimits.getBigChar());
        descr.props.put("getMaxFilenameLength", pathLimits.getMaxFilenameLength());
        descr.props.put("maxPathLength", pathLimits.getMaxPathLength());
        descr.props.put("filenameLenth", arg_0 -> ((PathLimits)pathLimits).filenameCount(arg_0));
        descr.props.put("pathLength", arg_0 -> ((PathLimits)pathLimits).pathCount(arg_0));
        descr.removeTopic(Posix.class);
        descr.removeTopic(MoveWhile.class);
        descr.removeTopic(NonCasePreserving.class);
        descr.removeTopic(FileKeyT.class);
        descr.attributeDescriptions.put("dos", AttributeDescriptionBuilder.attributeBuilding(DosAttributesT.class, "dos", DosFileAttributeView.class, DosFileAttributes.class).addAttribute("hidden", DosFileAttributes::isHidden).addAttribute("archive", DosFileAttributes::isArchive).addAttribute("system", DosFileAttributes::isSystem).addAttribute("readonly", DosFileAttributes::isReadOnly).build());
    }

    public WindowsBuilder<T> noUNC() {
        this.descr.removeTopic(UNC.class);
        return this;
    }

    public WindowsBuilder<T> noRootComponents() {
        this.descr.removeTopic(RootComponent.class);
        return this;
    }

    public WindowsBuilder<T> fat() {
        this.descr.addTopic(NonCasePreserving.class);
        this.descr.props.put("getMaxFilenameLength", 12);
        this.descr.props.put("maxPathLength", 255);
        return this;
    }
}

