/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests.descriptionbuilders;

import de.pfabulist.kleinod.os.OS;
import de.pfabulist.kleinod.os.PathLimits;
import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.attributes.AttributeDescriptionBuilder;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.DescriptionBuilder;
import de.pfabulist.lindwurm.niotest.tests.topics.CaseInsensitive;
import de.pfabulist.lindwurm.niotest.tests.topics.DosAttributesT;
import de.pfabulist.lindwurm.niotest.tests.topics.HiddenDotFiles;
import de.pfabulist.lindwurm.niotest.tests.topics.NonCasePreserving;
import de.pfabulist.lindwurm.niotest.tests.topics.NotOSX;
import de.pfabulist.lindwurm.niotest.tests.topics.PermissionChecks;
import de.pfabulist.lindwurm.niotest.tests.topics.Posix;
import de.pfabulist.lindwurm.niotest.tests.topics.Windows;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;

public class UnixBuilder<T>
extends DescriptionBuilder<T> {
    public UnixBuilder(FSDescription descr, T t) {
        super(descr, t);
        PathLimits pathLimits = new PathLimits(OS.UNIX);
        descr.props.put("oneCharCount", pathLimits.getBigChar());
        descr.props.put("getMaxFilenameLength", pathLimits.getMaxFilenameLength());
        descr.props.put("maxPathLength", pathLimits.getMaxPathLength());
        descr.props.put("filenameLenth", arg_0 -> ((PathLimits)pathLimits).filenameCount(arg_0));
        descr.props.put("pathLength", arg_0 -> ((PathLimits)pathLimits).pathCount(arg_0));
        descr.removeTopic(Windows.class);
        descr.removeTopic(DosAttributesT.class);
        descr.removeTopic(CaseInsensitive.class);
        descr.removeTopic(NonCasePreserving.class);
        descr.attributeDescriptions.put("posix", AttributeDescriptionBuilder.attributeBuilding(Posix.class, "posix", PosixFileAttributeView.class, PosixFileAttributes.class).addAttribute("owner", PosixFileAttributes::owner).addAttribute("permissions", PosixFileAttributes::permissions).addAttribute("group", PosixFileAttributes::group).build());
    }

    public UnixBuilder<T> noPosix() {
        this.descr.removeTopic(Posix.class);
        return this;
    }

    public UnixBuilder<T> noPermissionChecks() {
        this.descr.removeTopic(PermissionChecks.class);
        return this;
    }

    public UnixBuilder<T> otherUser() {
        this.descr.removeTopic(PermissionChecks.class);
        return this;
    }

    public UnixBuilder<T> hfsPlus() {
        PathLimits pathLimits = new PathLimits(OS.OSX);
        this.descr.props.put("oneCharCount", pathLimits.getBigChar());
        this.descr.props.put("getMaxFilenameLength", pathLimits.getMaxFilenameLength());
        this.descr.props.put("maxPathLength", pathLimits.getMaxPathLength());
        this.descr.props.put("filenameLenth", arg_0 -> ((PathLimits)pathLimits).filenameCount(arg_0));
        this.descr.props.put("pathLength", arg_0 -> ((PathLimits)pathLimits).pathCount(arg_0));
        this.descr.addTopic(CaseInsensitive.class);
        this.descr.removeTopic(NotOSX.class);
        return this;
    }

    public UnixBuilder<T> osx() {
        return this.hfsPlus();
    }

    public UnixBuilder<T> noHiddenDotFiles() {
        this.descr.removeTopic(HiddenDotFiles.class);
        return this;
    }
}

