/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests.descriptionbuilders;

import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.DescriptionBuilder;
import de.pfabulist.lindwurm.niotest.tests.topics.WorkingDirectoryInPlaygroundTree;
import de.pfabulist.lindwurm.niotest.tests.topics.Writable;
import java.nio.file.Path;

public class ReadonlyPlayground<T>
extends DescriptionBuilder<T> {
    public ReadonlyPlayground(FSDescription descr, T t) {
        super(descr, t);
    }

    public ReadonlyPlayground<T> set(Path root) {
        this.descr.removeTopic(Writable.class);
        this.descr.props.put("playground", root);
        if (!root.getRoot().equals(root.getFileSystem().getPath("", new String[0]).toAbsolutePath().getRoot())) {
            this.descr.removeTopic(WorkingDirectoryInPlaygroundTree.class);
        }
        return this;
    }

    public ReadonlyPlayground<T> nonEmptyDir(Path dir) {
        this.descr.props.put("nonemptyDir", dir);
        return this;
    }

    public ReadonlyPlayground<T> emptyDir(Path dir) {
        this.descr.props.put("emptyDir", dir);
        return this;
    }

    public ReadonlyPlayground<T> nonExisting(Path path) {
        this.descr.props.put("nonexisting", path);
        return this;
    }

    public ReadonlyPlayground<T> file(Path path) {
        this.descr.props.put("file", path);
        return this;
    }
}

