/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests.descriptionbuilders;

import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.DescriptionBuilder;
import de.pfabulist.lindwurm.niotest.tests.topics.LimitedPath;
import de.pfabulist.lindwurm.niotest.tests.topics.MaxFilename;
import de.pfabulist.lindwurm.niotest.tests.topics.MaxPath;

public class PathConstraints<T>
extends DescriptionBuilder<T> {
    public PathConstraints(FSDescription descr, T t) {
        super(descr, t);
    }

    public PathConstraints<T> noMaxFilenameLength() {
        this.descr.removeTopic(MaxFilename.class);
        return this;
    }

    public PathConstraints<T> noMaxPathLength() {
        this.descr.removeTopic(MaxPath.class);
        return this;
    }

    public PathConstraints<T> unlimitedPathLength() {
        this.descr.props.put("maxPathLength", 45000);
        this.descr.removeTopic(LimitedPath.class);
        return this;
    }

    public PathConstraints<T> pathLength(int len) {
        this.descr.props.put("maxPathLength", len);
        return this;
    }

    public PathConstraints<T> filenameLength(int len) {
        this.descr.props.put("getMaxFilenameLength", len);
        return this;
    }

    public PathConstraints<T> unlimitedFilenameLength() {
        this.descr.props.put("getMaxFilenameLength", 42000);
        return this;
    }
}

