/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests.descriptionbuilders;

import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.AttributeBuilder;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.BasicAttributesBuilder;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.ClosablePlayground;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.FSCreation;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.FileChannelBuilder;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.FileStoreBuilder;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.HardLinksBuilder;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.OtherProviderPlayground;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.PathConstraints;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.Playground;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.ReadonlyPlayground;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.SymlinkBuilder;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.SyncBuilder;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.TestEnvironmentBuilder;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.UnixBuilder;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.WatchBuilder;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.WindowsBuilder;
import de.pfabulist.lindwurm.niotest.tests.topics.Principals;
import de.pfabulist.lindwurm.niotest.tests.topics.SlowTest;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class CombinedBuilder {
    private final FSDescription descr;

    public CombinedBuilder(FSDescription descr) {
        this.descr = descr;
    }

    public static CombinedBuilder build() {
        return new CombinedBuilder(new FSDescription());
    }

    public FSDescription done() {
        return this.descr;
    }

    public CombinedBuilder bug(String name, boolean actually) {
        if (actually) {
            this.descr.addBug(name);
        }
        return this;
    }

    public CombinedBuilder bug(String name) {
        return this.bug(name, true);
    }

    public CombinedBuilder nitpick(String name, String comment) {
        return this.bug(name, true);
    }

    public CombinedBuilder nitpickScheme(String scheme, String comment) {
        return this.bugScheme(scheme, true);
    }

    public CombinedBuilder bugScheme(String scheme, boolean val) {
        if (val) {
            this.descr.addBugScheme(scheme);
        }
        return this;
    }

    public CombinedBuilder waitForFile(Path path) {
        while (!Files.exists(path, new LinkOption[0])) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this;
    }

    public CombinedBuilder fastOnly() {
        this.descr.removeTopic(SlowTest.class);
        return this;
    }

    public CombinedBuilder noPrincipals() {
        this.descr.removeTopic(Principals.class);
        return this;
    }

    public ClosablePlayground<CombinedBuilder> closable() {
        return new ClosablePlayground<CombinedBuilder>(this.descr, this);
    }

    public Playground<CombinedBuilder> playground() {
        return new Playground<CombinedBuilder>(this.descr, this);
    }

    public ReadonlyPlayground<CombinedBuilder> readonlyPlayground() {
        return new ReadonlyPlayground<CombinedBuilder>(this.descr, this);
    }

    public OtherProviderPlayground<CombinedBuilder> otherProviderplayground() {
        return new OtherProviderPlayground<CombinedBuilder>(this.descr, this);
    }

    public WatchBuilder<CombinedBuilder> watchable() {
        return new WatchBuilder<CombinedBuilder>(this.descr, this);
    }

    public BasicAttributesBuilder<CombinedBuilder> time() {
        return new BasicAttributesBuilder<CombinedBuilder>(this.descr, this);
    }

    public BasicAttributesBuilder<CombinedBuilder> basicAttributes() {
        return new BasicAttributesBuilder<CombinedBuilder>(this.descr, this);
    }

    public PathConstraints<CombinedBuilder> pathConstraints() {
        return new PathConstraints<CombinedBuilder>(this.descr, this);
    }

    public UnixBuilder<CombinedBuilder> unix() {
        return new UnixBuilder<CombinedBuilder>(this.descr, this);
    }

    public WindowsBuilder<CombinedBuilder> windows() {
        return new WindowsBuilder<CombinedBuilder>(this.descr, this);
    }

    public SymlinkBuilder<CombinedBuilder> symlinks() {
        return new SymlinkBuilder<CombinedBuilder>(this.descr, this);
    }

    public HardLinksBuilder<CombinedBuilder> hardlinks() {
        return new HardLinksBuilder<CombinedBuilder>(this.descr, this);
    }

    public FSCreation<CombinedBuilder> fsCreation() {
        return new FSCreation<CombinedBuilder>(this.descr, this);
    }

    public FileStoreBuilder<CombinedBuilder> fileStores() {
        return new FileStoreBuilder<CombinedBuilder>(this.descr, this);
    }

    public FileChannelBuilder<CombinedBuilder> fileChannel() {
        return new FileChannelBuilder<CombinedBuilder>(this.descr, this);
    }

    public AttributeBuilder<CombinedBuilder> attributes() {
        return new AttributeBuilder<CombinedBuilder>(this.descr, this);
    }

    public TestEnvironmentBuilder<CombinedBuilder> testEnv() {
        return new TestEnvironmentBuilder<CombinedBuilder>(this.descr, this);
    }

    public SyncBuilder<CombinedBuilder> sync() {
        return new SyncBuilder<CombinedBuilder>(this.descr, this);
    }
}

