/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests19HardLinks;
import de.pfabulist.lindwurm.niotest.tests.topics.Attributes;
import de.pfabulist.lindwurm.niotest.tests.topics.Copy;
import de.pfabulist.lindwurm.niotest.tests.topics.Delete;
import de.pfabulist.lindwurm.niotest.tests.topics.DirSymLink;
import de.pfabulist.lindwurm.niotest.tests.topics.FileStores;
import de.pfabulist.lindwurm.niotest.tests.topics.HardLink;
import de.pfabulist.lindwurm.niotest.tests.topics.Move;
import de.pfabulist.lindwurm.niotest.tests.topics.SlowTest;
import de.pfabulist.lindwurm.niotest.tests.topics.SymLink;
import de.pfabulist.lindwurm.niotest.tests.topics.Writable;
import de.pfabulist.unchecked.Filess;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotLinkException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests20SymLinks
extends Tests19HardLinks {
    public Tests20SymLinks(FSDescription capa) {
        super(capa);
    }

    @Test
    @Category(value={SymLink.class, Writable.class})
    public void testCreateSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Assertions.assertThat((Path)this.symLink()).exists();
    }

    @Test(expected=FileAlreadyExistsException.class)
    @Category(value={SymLink.class, Writable.class})
    public void testCreateSymLinkWhereLinkExistsThrows() throws IOException {
        Files.write(this.symLink(), CONTENT, new OpenOption[0]);
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
    }

    @Test
    @Category(value={SymLink.class, Writable.class})
    public void testCreateSymLinkToNonExisting() throws IOException {
        Files.createSymbolicLink(this.link(), this.absTA(), new FileAttribute[0]);
        Assertions.assertThat((Path)this.link()).existsNoFollowLinks();
    }

    @Test
    @Category(value={SymLink.class})
    public void testSymLinkAttributeNonLink() throws IOException {
        Assertions.assertThat((boolean)Files.isSymbolicLink(this.targetFile())).isFalse();
    }

    @Test
    @Category(value={SymLink.class})
    public void testSymLinkAttributeLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Assertions.assertThat((Path)this.symLink()).isSymbolicLink();
    }

    @Test
    @Category(value={SymLink.class})
    public void testReadFromSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Assertions.assertThat((byte[])Files.readAllBytes(this.symLink())).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={SymLink.class})
    public void testReadFromSymLinkToSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.createSymbolicLink(this.symLink2(), this.symLink(), new FileAttribute[0]);
        Assertions.assertThat((byte[])Files.readAllBytes(this.symLink2())).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={SymLink.class, Writable.class})
    public void testWriteToSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.write(this.symLink(), CONTENT_OTHER, new OpenOption[0]);
        Assertions.assertThat((byte[])Files.readAllBytes(this.targetFile())).isEqualTo((Object)CONTENT_OTHER);
    }

    @Test
    @Category(value={SymLink.class, DirSymLink.class})
    public void testDirSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Assertions.assertThat((Path)this.symLink()).isDirectory();
    }

    @Test
    @Category(value={SymLink.class, DirSymLink.class})
    public void testStreamFromDirSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.symLink());){
            for (Path kid : stream) {
                Assertions.assertThat((Path)kid.getParent()).isSymbolicLink();
                Assertions.assertThat((boolean)Files.isSameFile(kid, this.targetDirKid())).isTrue();
            }
        }
    }

    @Test
    @Category(value={SymLink.class, DirSymLink.class})
    public void testCreateFileInDirSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.write(this.linkKid(), CONTENT, new OpenOption[0]);
        Assertions.assertThat((Path)this.linkKid()).exists();
    }

    @Test
    @Category(value={SymLink.class, DirSymLink.class})
    public void testFileInDirSymLinkIsNotSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.write(this.linkKid(), CONTENT, new OpenOption[0]);
        Assertions.assertThat((boolean)Files.isSymbolicLink(this.linkKid())).isFalse();
    }

    @Test
    @Category(value={SymLink.class, DirSymLink.class})
    public void testCreateDirInDirSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.createDirectory(this.linkKid(), new FileAttribute[0]);
        Assertions.assertThat((Path)this.linkKid()).isDirectory();
    }

    @Test
    @Category(value={SymLink.class, Writable.class, Delete.class})
    public void testDeleteSymLinkDoesNotDeleteTarget() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.delete(this.symLink());
        Assertions.assertThat((Path)this.targetFile()).exists();
        Assertions.assertThat((Path)this.symLink()).doesNotExist();
    }

    @Test
    @Category(value={SymLink.class})
    public void testDeleteSymLinkDoesNotDeleteTargetNonEmptyDirCase() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.write(this.symLink().resolve("kid"), CONTENT, new OpenOption[0]);
        Files.delete(this.symLink());
        Assertions.assertThat((Path)this.symLink()).doesNotExist();
    }

    @Test
    @Category(value={SymLink.class, Writable.class, Copy.class})
    public void testCopyFromSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.copy(this.symLink(), this.tgt(), new CopyOption[0]);
        Assertions.assertThat((byte[])Files.readAllBytes(this.tgt())).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={SymLink.class, DirSymLink.class, Writable.class, Copy.class})
    public void testCopyFromDeeperSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.write(this.linkKid(), CONTENT, new OpenOption[0]);
        Files.copy(this.linkKid(), this.tgt(), new CopyOption[0]);
        Assertions.assertThat((byte[])Files.readAllBytes(this.tgt())).isEqualTo((Object)CONTENT);
    }

    @Test(expected=FileAlreadyExistsException.class)
    @Category(value={SymLink.class})
    public void testCopyToBrokenSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.absTA(), new FileAttribute[0]);
        Files.copy(this.fileTAB(), this.symLink(), new CopyOption[0]);
    }

    @Test
    @Category(value={SymLink.class, Copy.class, Writable.class})
    public void testCopyBrokenSymLinkToItself() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.absTA(), new FileAttribute[0]);
        Files.copy(this.symLink(), this.symLink(), new CopyOption[0]);
        Assertions.assertThat((String)"still here").isEqualTo((Object)"still here");
    }

    @Test
    @Category(value={SymLink.class, Copy.class, Writable.class})
    public void testCopySymLinkToItself() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.copy(this.symLink(), this.symLink(), new CopyOption[0]);
        Assertions.assertThat((byte[])Files.readAllBytes(this.symLink())).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={SymLink.class, Copy.class, Writable.class})
    public void testCopyToSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.copy(this.fileTAB(), this.symLink(), StandardCopyOption.REPLACE_EXISTING);
        Assertions.assertThat((boolean)Files.isSymbolicLink(this.symLink())).isFalse();
    }

    @Test
    @Category(value={SymLink.class, DirSymLink.class, Copy.class, Writable.class})
    public void testCopyToDeepSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.copy(this.fileTAB(), this.linkKid(), new CopyOption[0]);
        Assertions.assertThat((byte[])Files.readAllBytes(this.linkKid())).isEqualTo((Object)CONTENT);
        Assertions.assertThat((byte[])Files.readAllBytes(this.linkKid().toRealPath(new LinkOption[0]))).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={SymLink.class, HardLink.class, Writable.class})
    public void testHardLinkToSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.createLink(this.hardLink(), this.symLink());
        Assertions.assertThat((byte[])Files.readAllBytes(this.hardLink())).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={SymLink.class, HardLink.class, Delete.class, Writable.class})
    public void testHardLinkToSymLinkDeleteSymLeavesHardLinkUntouched() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.createLink(this.hardLink(), this.symLink());
        Files.delete(this.symLink());
        Assertions.assertThat((byte[])Files.readAllBytes(this.hardLink())).isEqualTo((Object)CONTENT);
    }

    @Test(expected=NoSuchFileException.class)
    @Category(value={SymLink.class})
    public void testBrokenSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.delete(this.targetFile());
        Files.readAllBytes(this.symLink());
    }

    @Test
    @Category(value={SymLink.class})
    public void testBrokenSymLinkNotExists() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.absTA(), new FileAttribute[0]);
        Assertions.assertThat((boolean)Files.exists(this.symLink(), new LinkOption[0])).isFalse();
    }

    @Test
    @Category(value={SymLink.class})
    public void testBrokenSymLinkNoFollowLinkExists() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.absTA(), new FileAttribute[0]);
        Assertions.assertThat((Path)this.symLink()).existsNoFollowLinks();
    }

    @Test
    @Category(value={SymLink.class})
    public void testBrokenSymLinkThrowsOnIsSymlink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.absTA(), new FileAttribute[0]);
        Assertions.assertThat((Path)this.symLink()).isSymbolicLink();
    }

    @Test
    @Category(value={SymLink.class})
    public void testBrokenSymLinkGetAttisNoFollowLinkDoesWorks() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.absTA(), new FileAttribute[0]);
        BasicFileAttributes aa = Files.readAttributes(this.symLink(), BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        Assertions.assertThat((boolean)aa.isSymbolicLink()).isTrue();
    }

    @Test(expected=NoSuchFileException.class)
    @Category(value={SymLink.class})
    public void testBrokenSymLinkDoesNotTestForSymlinkAttribute() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.absTA(), new FileAttribute[0]);
        Files.readAttributes(this.symLink(), BasicFileAttributes.class, new LinkOption[0]);
    }

    @Test
    @Category(value={SymLink.class})
    public void testDeleteBrokenSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.absTA(), new FileAttribute[0]);
        Files.delete(this.symLink());
        Assertions.assertThat((boolean)Files.exists(this.symLink(), LinkOption.NOFOLLOW_LINKS)).isFalse();
    }

    @Test
    @Category(value={SymLink.class})
    public void testGetSymLinkTarget() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Assertions.assertThat((Path)Files.readSymbolicLink(this.symLink())).isEqualTo((Object)this.targetFile());
    }

    @Test(expected=NotLinkException.class)
    @Category(value={SymLink.class})
    public void testGetSymLinkOfNonLinkThrows() throws IOException {
        Files.readSymbolicLink(this.targetFile());
    }

    @Test
    @Category(value={SymLink.class})
    public void testReadAttributesFromSymLinkNoFollowLinks() throws IOException, InterruptedException {
        this.targetFile();
        Thread.sleep(2000L);
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        FileTime orig = Files.readAttributes(this.symLink(), BasicFileAttributes.class, new LinkOption[0]).creationTime();
        FileTime linkTime = Files.readAttributes(this.symLink(), BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS).creationTime();
        Assertions.assertThat((Comparable)linkTime).isGreaterThan((Comparable)orig);
    }

    @Test
    @Category(value={SymLink.class})
    public void testAttributesFromSymLinkWithFollowLinkShowNoLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        BasicFileAttributes bfa = Files.readAttributes(this.symLink(), BasicFileAttributes.class, new LinkOption[0]);
        Assertions.assertThat((boolean)bfa.isSymbolicLink()).isFalse();
    }

    @Test
    @Category(value={SymLink.class})
    public void testAttributesFromSymLinkWithFollowLinkShowNoLink_View() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        BasicFileAttributeView bfav = Files.getFileAttributeView(this.symLink(), BasicFileAttributeView.class, new LinkOption[0]);
        Assertions.assertThat((boolean)bfav.readAttributes().isSymbolicLink()).isFalse();
    }

    @Test
    @Category(value={SymLink.class})
    public void testMoveSymLinkFileTestContent() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.move(this.symLink(), this.absTA(), new CopyOption[0]);
        Assertions.assertThat((byte[])Files.readAllBytes(this.absTA())).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={SymLink.class})
    public void testMoveSymLinkMovesLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.move(this.symLink(), this.absTC(), new CopyOption[0]);
        Assertions.assertThat((Path)this.symLink()).doesNotExist();
    }

    @Test
    @Category(value={SymLink.class, Writable.class, Move.class})
    public void testMoveSymLinkLeavesTarget() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.move(this.symLink(), this.absTC(), new CopyOption[0]);
        Assertions.assertThat((Path)this.targetFile()).exists();
    }

    @Test
    @Category(value={SymLink.class, Writable.class, Move.class})
    public void testMoveSymLinkFileKeepsSymLinkStatus() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.move(this.symLink(), this.tgt(), new CopyOption[0]);
        Assertions.assertThat((Path)this.tgt()).isSymbolicLink();
    }

    @Test
    @Category(value={SymLink.class, FileStores.class})
    public void testFileStoreOfSymLinkIsTargets() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Assertions.assertThat((Object)Files.getFileStore(this.symLink())).isEqualTo((Object)Files.getFileStore(this.targetFile()));
    }

    @Test
    @Category(value={SymLink.class})
    public void testSymLinkAndTargetAreSameFile() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Assertions.assertThat((boolean)Files.isSameFile(this.symLink(), this.targetFile())).isTrue();
    }

    @Test
    @Category(value={SymLink.class, DirSymLink.class})
    public void testDeepSymLinkIsSameFile() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.write(this.linkKid(), CONTENT, new OpenOption[0]);
        Assertions.assertThat((boolean)Files.isSameFile(this.linkKid(), this.targetDir().resolve(this.linkKid().getFileName()))).isTrue();
    }

    @Test
    @Category(value={SymLink.class})
    public void testDoubleSymLinkExists() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.createSymbolicLink(this.linkKid(), this.fileTAB(), new FileAttribute[0]);
        Assertions.assertThat((Path)this.linkKid()).exists();
    }

    @Test
    @Category(value={SymLink.class, DirSymLink.class})
    public void testDoubleSymLinkSameFile() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.createSymbolicLink(this.linkKid(), this.fileTAB(), new FileAttribute[0]);
        Assertions.assertThat((boolean)Files.isSameFile(this.linkKid(), this.fileTAB())).isTrue();
    }

    @Test
    @Category(value={SymLink.class, DirSymLink.class, Attributes.class, SlowTest.class})
    public void testDoubleSymLinkReadAttributes() throws IOException, InterruptedException {
        this.fileTAB();
        Thread.sleep(1100L);
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.createSymbolicLink(this.linkKid(), this.fileTAB(), new FileAttribute[0]);
        Assertions.assertThat((Object)Files.readAttributes(this.linkKid(), "basic:lastModifiedTime", new LinkOption[0]).get("lastModifiedTime")).isEqualTo(Files.readAttributes(this.fileTAB(), "basic:lastModifiedTime", new LinkOption[0]).get("lastModifiedTime"));
    }

    @Test
    @Category(value={SymLink.class})
    public void testDeepSymLinkMove() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.write(this.linkKid(), CONTENT, new OpenOption[0]);
        Files.move(this.linkKid(), this.tgt(), new CopyOption[0]);
        Assertions.assertThat((byte[])Files.readAllBytes(this.tgt())).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={SymLink.class, DirSymLink.class, Writable.class, Move.class})
    public void testMoveToDeepSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.move(this.fileTAB(), this.linkKid(), new CopyOption[0]);
        Assertions.assertThat((byte[])Files.readAllBytes(this.linkKid())).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={SymLink.class, DirSymLink.class, Attributes.class, SlowTest.class})
    public void testDoubleSymLinkReadAttributesNoFollowLink() throws IOException, InterruptedException {
        this.fileTAB();
        Thread.sleep(1100L);
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.createSymbolicLink(this.linkKid(), this.fileTAB(), new FileAttribute[0]);
        Assertions.assertThat((Comparable)((FileTime)Files.readAttributes(this.linkKid(), "basic:lastModifiedTime", LinkOption.NOFOLLOW_LINKS).get("lastModifiedTime"))).isGreaterThan((Comparable)((FileTime)Files.readAttributes(this.fileTAB(), "basic:lastModifiedTime", new LinkOption[0]).get("lastModifiedTime")));
    }

    @Test
    @Category(value={SymLink.class})
    public void testSymLinkChanges() throws IOException {
        Path target = this.targetFile();
        Files.createSymbolicLink(this.symLink(), target, new FileAttribute[0]);
        Files.delete(target);
        Files.createDirectory(target, new FileAttribute[0]);
        Assertions.assertThat((Path)this.symLink()).isDirectory();
    }

    @Test
    @Category(value={SymLink.class})
    public void testRelSymLinkIsRelativeToLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.FS.getPath("..", new String[0]).resolve(this.nameA()), new FileAttribute[0]);
        Files.write(this.symLink().getParent().getParent().resolve(this.nameA()), CONTENT_OTHER, new OpenOption[0]);
        Assertions.assertThat((byte[])Files.readAllBytes(this.symLink())).isEqualTo((Object)CONTENT_OTHER);
    }

    @Test
    @Category(value={SymLink.class})
    public void testMoveARelSymLink2() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.FS.getPath("..", new String[0]).resolve(this.nameA()), new FileAttribute[0]);
        Path to = this.dirTB().resolve(this.nameB());
        Files.move(this.symLink(), to, new CopyOption[0]);
        Files.write(to, CONTENT, new OpenOption[0]);
        Assertions.assertThat((boolean)Files.isSameFile(to, this.absTA())).isTrue();
    }

    @Test
    @Category(value={SymLink.class, SlowTest.class, Attributes.class})
    public void testMoveSymLinkDoesNotChangeLastModifiedTime() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.fileTA(), new FileAttribute[0]);
        FileTime before = Files.getLastModifiedTime(this.symLink(), LinkOption.NOFOLLOW_LINKS);
        this.waitForAttribute();
        Files.move(this.symLink(), this.absTB(), new CopyOption[0]);
        Assertions.assertThat((Comparable)Files.getLastModifiedTime(this.absTB(), LinkOption.NOFOLLOW_LINKS)).isEqualTo((Object)before);
    }

    @Test
    @Category(value={SymLink.class})
    public void testMoveARelSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.relA(), new FileAttribute[0]);
        Files.move(this.symLink(), this.absTB(), new CopyOption[0]);
        Files.write(this.absTB(), CONTENT, new OpenOption[0]);
        Assertions.assertThat((boolean)Files.isSameFile(this.absTB(), this.absTA())).isTrue();
    }

    @Test
    @Category(value={SymLink.class})
    public void testMoveReplaceExistingToSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.move(this.fileTA(), this.symLink(), StandardCopyOption.REPLACE_EXISTING);
        Assertions.assertThat((boolean)Files.isSymbolicLink(this.symLink())).isFalse();
    }

    @Test
    @Category(value={SymLink.class, DirSymLink.class})
    public void testUnnormalizedDeepSymLinkFollowsLinkBeforeNormalization() throws IOException {
        Path sym = this.dirTA().resolve("link");
        Files.createSymbolicLink(sym, this.dirTBB(), new FileAttribute[0]);
        Files.write(this.dirTA().resolve(this.nameC()), CONTENT, new OpenOption[0]);
        Files.write(this.dirTB().resolve(this.nameC()), CONTENT_OTHER, new OpenOption[0]);
        Assertions.assertThat((boolean)Files.isSameFile(sym.resolve("..").resolve(this.nameC()), this.dirTB().resolve(this.nameC()))).isTrue();
    }

    @Test
    @Category(value={SymLink.class})
    public void testSymLinkToUnnormalizedRelPath() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.FS.getPath(this.nameA(), new String[0]).resolve(".."), new FileAttribute[0]);
        Files.createSymbolicLink(this.symLink().getParent().resolve(this.nameA()), this.targetFile(), new FileAttribute[0]);
        Assertions.assertThat((boolean)Files.isSameFile(this.symLink(), this.targetFile().getParent())).isTrue();
    }

    @Test
    @Category(value={SymLink.class, FileStores.class})
    public void testGetFileStoreOfSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Assertions.assertThat((Object)Files.getFileStore(this.symLink())).isEqualTo((Object)Files.getFileStore(this.targetFile()));
    }

    @Test(expected=NoSuchFileException.class)
    @Category(value={SymLink.class})
    public void testGetFileStoreOfBrokenSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.absTA(), new FileAttribute[0]);
        Files.getFileStore(this.symLink());
    }

    @Test(expected=FileAlreadyExistsException.class)
    @Category(value={SymLink.class})
    public void testCreateDirAtSymLinkThrows() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.absTA(), new FileAttribute[0]);
        Files.createDirectory(this.symLink(), new FileAttribute[0]);
    }

    @Test(expected=FileAlreadyExistsException.class)
    @Category(value={SymLink.class, HardLink.class})
    public void testCreateHardLinkAtSymLinkThrows() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.absTA(), new FileAttribute[0]);
        Files.createLink(this.symLink(), this.targetFile());
    }

    private Path targetFile() {
        Path target = this.absT().resolve("targetSpace").resolve("target");
        if (Files.exists(target, new LinkOption[0])) {
            return target;
        }
        Filess.createDirectories((Path)target.getParent());
        Filess.write((Path)target, (byte[])CONTENT, (OpenOption[])new OpenOption[0]);
        return target;
    }

    protected Path otherProviderTargetFile() {
        Path target = this.otherProviderAbsA().resolve(this.nameB());
        if (!Files.exists(target, new LinkOption[0])) {
            Filess.createDirectories((Path)target.getParent());
            Filess.write((Path)target, (byte[])CONTENT, (OpenOption[])new OpenOption[0]);
        }
        return target;
    }

    protected Path otherProviderTargetDir() {
        Path target = this.otherProviderAbsA().resolve("target");
        if (!Files.exists(target, new LinkOption[0])) {
            Filess.createDirectories((Path)target);
            Filess.write((Path)this.otherProviderTargetDirKid(), (byte[])CONTENT, (OpenOption[])new OpenOption[0]);
        }
        return target;
    }

    protected Path otherProviderTargetDirKid() {
        return this.otherProviderAbsA().resolve("target").resolve("kid");
    }

    private Path targetDir() {
        Path target = this.targetDirKid().getParent();
        if (!Files.exists(target, new LinkOption[0])) {
            Filess.createDirectories((Path)target);
            Filess.write((Path)this.targetDirKid(), (byte[])CONTENT, (OpenOption[])new OpenOption[0]);
        }
        return target;
    }

    private Path targetDirKid() {
        return this.absT().resolve("targetSpace").resolve("targetDir").resolve("targetKid");
    }

    protected Path symLinkSpace() {
        Path ret = this.absT().resolve("forsyml");
        Filess.createDirectories((Path)ret);
        return ret;
    }

    protected Path symLink() {
        return this.symLinkSpace().resolve("link");
    }

    protected Path symLink2() {
        return this.symLinkSpace().resolve("link2");
    }

    protected Path hardLink() {
        return this.symLinkSpace().resolve("hardLink");
    }

    private Path linkKid() {
        return this.symLink().resolve("linkKid");
    }
}

