/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests16Unix;
import de.pfabulist.lindwurm.niotest.tests.topics.DosAttributesT;
import de.pfabulist.lindwurm.niotest.tests.topics.RootComponent;
import de.pfabulist.lindwurm.niotest.tests.topics.UNC;
import de.pfabulist.lindwurm.niotest.tests.topics.Windows;
import de.pfabulist.lindwurm.niotest.tests.topics.Writable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.DosFileAttributeView;
import org.assertj.core.api.Fail;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests17Windows
extends Tests16Unix {
    public Tests17Windows(FSDescription capa) {
        super(capa);
    }

    @Test
    @Category(value={Windows.class})
    public void testCaseIgnorantPathsAreEqual() {
        MatcherAssert.assertThat((Object)this.absD().resolve(this.nameB()), (Matcher)Is.is((Object)this.mixCase(this.absD().resolve(this.nameB()))));
    }

    @Test
    @Category(value={Windows.class})
    public void testCaseIgnorantPathHaveSameHashCode() throws IOException {
        MatcherAssert.assertThat((Object)this.absD().resolve(this.nameB()).hashCode(), (Matcher)Is.is((Object)this.mixCase(this.absD().resolve(this.nameB())).hashCode()));
    }

    @Test
    @Category(value={Windows.class})
    public void testCaseRemembering() throws IOException {
        Path file = this.dirTA().resolve(this.nameD());
        Files.write(this.mixCase(file), CONTENT, new OpenOption[0]);
        try (DirectoryStream<Path> dstr = Files.newDirectoryStream(file.getParent());){
            Path kid = dstr.iterator().next();
            MatcherAssert.assertThat((Object)kid, (Matcher)Is.is((Object)file));
            MatcherAssert.assertThat((Object)kid.toString(), (Matcher)IsNot.not((Matcher)Is.is((Object)file.toString())));
        }
    }

    @Test
    @Category(value={Windows.class})
    public void testWindowsBase() {
        MatcherAssert.assertThat((Object)this.FS.getPath("C:\\", new String[0]).isAbsolute(), (Matcher)Is.is((Object)true));
    }

    @Test
    @Category(value={Windows.class, RootComponent.class})
    public void testWindowsJustRootComponentIsRelative() {
        MatcherAssert.assertThat((Object)this.FS.getPath("C:", new String[0]).isAbsolute(), (Matcher)Is.is((Object)false));
    }

    @Test
    @Category(value={Windows.class, RootComponent.class})
    public void testWindowsRelativeWithRootComponent() {
        MatcherAssert.assertThat((Object)this.FS.getPath("C:foo", new String[0]).isAbsolute(), (Matcher)Is.is((Object)false));
    }

    @Test
    @Category(value={Windows.class, RootComponent.class})
    public void testWindowsFilenameOfPathWithRootComponentHasNoRootComponent() {
        MatcherAssert.assertThat((Object)this.FS.getPath("C:\\foo\\duh", new String[0]).getFileName(), (Matcher)Is.is((Object)this.FS.getPath("duh", new String[0])));
    }

    @Test
    @Category(value={Windows.class, RootComponent.class})
    public void testWindowsToAbsoluteWithoutRootComponent() {
        MatcherAssert.assertThat((Object)this.FS.getPath("C:\\foo\\duh", new String[0]).getFileName(), (Matcher)Is.is((Object)this.FS.getPath("duh", new String[0])));
    }

    @Test
    @Category(value={Windows.class, RootComponent.class})
    public void testWindowsDifferentRootComponentResolvesToArgument() {
        MatcherAssert.assertThat((Object)this.FS.getPath("C:\\foo", new String[0]).resolve("D:duh"), (Matcher)Is.is((Object)this.FS.getPath("D:duh", new String[0])));
    }

    @Test
    @Category(value={Windows.class, RootComponent.class})
    public void testWindowsSameRootComponentResolves() {
        MatcherAssert.assertThat((Object)this.FS.getPath("C:\\foo", new String[0]).resolve("C:duh"), (Matcher)Is.is((Object)this.FS.getPath("C:\\foo\\duh", new String[0])));
    }

    @Test
    @Category(value={Windows.class, RootComponent.class})
    public void testWindowsImpliedRootComponentResolvesNot() {
        MatcherAssert.assertThat((Object)this.FS.getPath("\\foo", new String[0]).resolve("C:duh"), (Matcher)Is.is((Object)this.FS.getPath("C:duh", new String[0])));
    }

    @Test
    @Category(value={Windows.class, RootComponent.class})
    public void testWindowsNoRootComponentResolves() {
        MatcherAssert.assertThat((Object)this.FS.getPath("C:\\foo", new String[0]).resolve("duh"), (Matcher)Is.is((Object)this.FS.getPath("C:\\foo\\duh", new String[0])));
    }

    @Test
    @Category(value={Windows.class})
    public void testWindowsCaseDrive() {
        MatcherAssert.assertThat((Object)this.FS.getPath("X:\\foo", new String[0]), (Matcher)Is.is((Object)this.FS.getPath("x:\\foo", new String[0])));
    }

    @Test
    @Category(value={Windows.class, RootComponent.class})
    public void testWindowsGetFileNameHasNoRootComponent() {
        MatcherAssert.assertThat((Object)this.FS.getPath("C:\\foo", new String[0]).getFileName().toString().startsWith("C:"), (Matcher)Is.is((Object)false));
    }

    @Test
    @Category(value={Windows.class, RootComponent.class})
    public void testWindowsNoRootComponentGetRootHasNoRootComponent() {
        MatcherAssert.assertThat((Object)this.FS.getPath("\\foo", new String[0]).getRoot(), (Matcher)Is.is((Object)this.FS.getPath("\\", new String[0])));
    }

    @Test
    @Category(value={Windows.class, DosAttributesT.class, Writable.class})
    public void testWindowsIsHidden() throws IOException {
        MatcherAssert.assertThat((Object)Files.isHidden(this.fileTA()), (Matcher)Is.is((Object)false));
        Files.getFileAttributeView(this.absTA(), DosFileAttributeView.class, new LinkOption[0]).setHidden(true);
        MatcherAssert.assertThat((Object)Files.isHidden(this.fileTA()), (Matcher)Is.is((Object)true));
        Files.setAttribute(this.absTA(), "dos:hidden", false, new LinkOption[0]);
        MatcherAssert.assertThat((Object)Files.isHidden(this.fileTA()), (Matcher)Is.is((Object)false));
    }

    @Test
    @Category(value={Windows.class, UNC.class})
    public void testWindowsUNC1() throws IOException {
        MatcherAssert.assertThat((Object)this.FS.getPath("\\\\mach\\foo\\ho", new String[0]).getNameCount(), (Matcher)Is.is((Object)1));
    }

    @Test(expected=InvalidPathException.class)
    @Category(value={Windows.class})
    public void testWindowsUNCNoHostName() throws IOException {
        this.FS.getPath("\\\\", new String[0]);
    }

    @Test(expected=InvalidPathException.class)
    @Category(value={Windows.class})
    public void testWindowsdUNCNoShareName() throws IOException {
        this.FS.getPath("\\\\localhost", new String[0]);
    }

    @Test
    @Category(value={Windows.class, UNC.class})
    public void testWindowsdUNCPlenty() throws IOException {
        try {
            this.FS.getPath("\\//////\\\\localhost\\////foo", new String[0]);
        }
        catch (InvalidPathException e) {
            Fail.fail((String)"UNC paths are valid in Windows");
        }
    }

    @Test
    @Category(value={Windows.class, UNC.class})
    public void testWindowsUNCSlash() throws IOException {
        MatcherAssert.assertThat((Object)this.FS.getPath("//mach/foo/ho", new String[0]).getNameCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    @Category(value={Windows.class, UNC.class})
    public void testWindowsUNCAbsolute() throws IOException {
        MatcherAssert.assertThat((Object)this.FS.getPath("\\\\mach\\foo", new String[0]).isAbsolute(), (Matcher)Is.is((Object)true));
    }

    @Test
    @Category(value={Windows.class, UNC.class})
    public void testWindowsUNCAbsolute2() throws IOException {
        MatcherAssert.assertThat((Object)this.FS.getPath("\\\\mach\\C$", new String[0]).isAbsolute(), (Matcher)Is.is((Object)true));
    }

    @Test
    @Category(value={Windows.class, UNC.class})
    public void testWindowsUNCRoot() throws IOException {
        MatcherAssert.assertThat((Object)this.FS.getPath("\\\\mach\\C$", new String[0]).getRoot(), (Matcher)Is.is((Object)this.FS.getPath("\\\\mach\\C$\\", new String[0])));
    }
}

