/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.os.OS;
import de.pfabulist.kleinod.os.PathLimits;
import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests13FileStore;
import de.pfabulist.lindwurm.niotest.tests.topics.Attributes;
import de.pfabulist.lindwurm.niotest.tests.topics.FileOwnerView;
import de.pfabulist.lindwurm.niotest.tests.topics.HiddenDotFiles;
import de.pfabulist.lindwurm.niotest.tests.topics.MaxFilename;
import de.pfabulist.lindwurm.niotest.tests.topics.NotOSX;
import de.pfabulist.lindwurm.niotest.tests.topics.OwnerView;
import de.pfabulist.lindwurm.niotest.tests.topics.PermissionChecks;
import de.pfabulist.lindwurm.niotest.tests.topics.Posix;
import de.pfabulist.lindwurm.niotest.tests.topics.Principals;
import de.pfabulist.lindwurm.niotest.tests.topics.Unix;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests16Unix
extends Tests13FileStore {
    public Tests16Unix(FSDescription capa) {
        super(capa);
    }

    @Test
    @Category(value={Attributes.class, Posix.class, Unix.class})
    public void testPosixGetAttributeView() throws IOException {
        Assertions.assertThat((Object)Files.readAttributes(this.getFile(), PosixFileAttributes.class, new LinkOption[0])).isNotNull();
    }

    @Test
    @Category(value={Unix.class})
    public void testUnixSeparatorIsSlash() {
        Assertions.assertThat((String)this.FS.getSeparator()).isEqualTo((Object)"/");
    }

    @Test
    @Category(value={Unix.class, HiddenDotFiles.class})
    public void testDotFilesAreHidden() throws IOException {
        Assertions.assertThat((boolean)Files.isHidden(this.getFile().resolve(".dot"))).isTrue();
    }

    @Test
    @Category(value={Attributes.class, Posix.class, OwnerView.class})
    public void testOwnerByTwoMethods() throws IOException {
        Assertions.assertThat((Object)Files.getOwner(this.pathDefault(), new LinkOption[0])).isEqualTo((Object)Files.readAttributes(this.pathDefault(), PosixFileAttributes.class, new LinkOption[0]).owner());
    }

    @Test
    @Category(value={Principals.class, Posix.class, Unix.class, PermissionChecks.class})
    public void testDifferentOwnerCantWrite() throws IOException {
        UserPrincipal none = this.FS.getUserPrincipalLookupService().lookupPrincipalByName("root");
        Files.setOwner(this.fileTA(), none);
        Assertions.assertThatThrownBy(() -> Files.write(this.absTA(), CONTENT_OTHER, new OpenOption[0])).isInstanceOf(AccessDeniedException.class);
    }

    @Test
    @Category(value={Posix.class, Unix.class, Principals.class})
    public void testFilesHaveOwners() throws IOException {
        Assertions.assertThat((Object)Files.getOwner(this.getFile(), new LinkOption[0])).isNotNull();
    }

    @Test
    @Category(value={Principals.class})
    public void testGetPrincipalsLookupServiceDoesNotThrow() throws IOException {
        Assertions.assertThat((Object)this.FS.getUserPrincipalLookupService()).isNotNull();
    }

    @Test
    @Category(value={Principals.class, Attributes.class, FileOwnerView.class})
    public void testFindOwner() throws IOException {
        UserPrincipalLookupService lookupService = this.FS.getUserPrincipalLookupService();
        UserPrincipal owner = Files.getOwner(this.FS.getPath("", new String[0]).toAbsolutePath(), new LinkOption[0]);
        Assertions.assertThat((Object)lookupService.lookupPrincipalByName(owner.getName())).isEqualTo((Object)owner);
    }

    @Test
    @Category(value={Unix.class, NotOSX.class, MaxFilename.class})
    public void testFilenameTooLongBecauseUnicode() throws IOException {
        String str = new String(Character.toChars(66560));
        PathLimits limits = new PathLimits(OS.UNIX);
        String fname = this.longFileName(limits.getMaxPathLength() - str.length(), str);
        Assertions.assertThat((int)fname.length()).isLessThan(limits.filenameCount(fname));
        Assertions.assertThatThrownBy(() -> Files.write(this.absT().resolve(fname), CONTENT, new OpenOption[0])).isInstanceOf(FileSystemException.class);
    }
}

