/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests12DifferentFS;
import de.pfabulist.lindwurm.niotest.tests.topics.Exclusive;
import de.pfabulist.lindwurm.niotest.tests.topics.FileStores;
import de.pfabulist.lindwurm.niotest.tests.topics.SizeLimit;
import de.pfabulist.lindwurm.niotest.tests.topics.Writable;
import de.pfabulist.unchecked.Filess;
import de.pfabulist.unchecked.Unchecked;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyIterable;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests13FileStore
extends Tests12DifferentFS {
    public Tests13FileStore(FSDescription capa) {
        super(capa);
    }

    @Test
    @Category(value={FileStores.class})
    public void testFileStoreIterable() {
        MatcherAssert.assertThat(this.FS.getFileStores(), (Matcher)Matchers.not((Matcher)IsEmptyIterable.emptyIterable()));
    }

    @Test(expected=NoSuchFileException.class)
    @Category(value={FileStores.class})
    public void testGetFileStoreOfNonExistent() throws IOException {
        Files.getFileStore(this.getNonExistingPath());
    }

    @Test
    @Category(value={FileStores.class})
    public void testFileStoresHaveAName() {
        for (FileStore store : this.FS.getFileStores()) {
            MatcherAssert.assertThat((Object)store.name(), (Matcher)Matchers.notNullValue());
        }
    }

    @Test
    @Category(value={FileStores.class})
    public void testFileStoresHaveAType() {
        for (FileStore store : this.FS.getFileStores()) {
            MatcherAssert.assertThat((Object)store.type(), (Matcher)Matchers.notNullValue());
        }
    }

    @Test
    @Category(value={FileStores.class})
    public void testFileStoreTotalSpaceIsNonNegative() throws IOException {
        for (FileStore store : this.FS.getFileStores()) {
            MatcherAssert.assertThat((Object)store.getTotalSpace(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
        }
    }

    @Test
    @Category(value={FileStores.class})
    public void testFileStoreUsableSpaceIsSmallerThanTotal() throws IOException {
        for (FileStore store : this.FS.getFileStores()) {
            MatcherAssert.assertThat((Object)store.getTotalSpace(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(store.getUsableSpace())));
        }
    }

    @Test
    @Category(value={FileStores.class})
    public void testFileStoreUnallocatedSpaceIsSmallerUsableSpace() throws IOException {
        for (FileStore store : this.FS.getFileStores()) {
            MatcherAssert.assertThat((Object)store.getUnallocatedSpace(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(store.getUsableSpace())));
        }
    }

    @Test
    @Category(value={FileStores.class, Exclusive.class, Writable.class})
    public void testPathFileStoreGrowingFileLowersUnallocatedSpace() throws IOException {
        Path file = this.fileTA();
        FileStore store = this.FS.provider().getFileStore(file);
        long before = store.getUnallocatedSpace();
        Files.write(file, CONTENT50, new OpenOption[0]);
        MatcherAssert.assertThat((Object)store.getUnallocatedSpace(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(before)));
    }

    @Test
    @Category(value={FileStores.class, Exclusive.class, Writable.class})
    public void testPathFileStoreGrowingFileLowersUsableSpace() throws IOException {
        Path file = this.fileTA();
        FileStore store = this.FS.provider().getFileStore(file);
        long before = store.getUnallocatedSpace();
        for (int i = 0; i < 10; ++i) {
            Files.write(file, CONTENT_BIG, StandardOpenOption.APPEND);
        }
        MatcherAssert.assertThat((Object)store.getUsableSpace(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(before)));
    }

    @Test
    @Category(value={FileStores.class})
    public void testFileStoreShowsThatBasicFileAttributeViewIsSupported() throws IOException {
        FileStore store = this.FS.provider().getFileStore(this.FS.getPath("", new String[0]).toAbsolutePath());
        MatcherAssert.assertThat((Object)store.supportsFileAttributeView(BasicFileAttributeView.class), (Matcher)Is.is((Object)true));
    }

    @Test
    @Category(value={FileStores.class, SizeLimit.class, Exclusive.class})
    public void testFileStoreLimitPreventsFileCreation() throws IOException {
        FileStore store = this.sizeLimitedRoot().getFileSystem().provider().getFileStore(this.sizeLimitedRoot());
        while (store.getUsableSpace() > 20000L) {
            Files.write(this.sizeLimitedRoot().resolve(UUID.randomUUID().toString()), CONTENT_BIG, new OpenOption[0]);
        }
        Assertions.assertThatThrownBy(() -> Files.write(this.sizeLimitedRoot().resolve(UUID.randomUUID().toString()), CONTENT_BIG, new OpenOption[0])).isInstanceOf(IOException.class);
    }

    @Test
    @Category(value={FileStores.class, SizeLimit.class, Exclusive.class})
    public void testFileStoreLimitPreventsFileModification() throws IOException {
        FileStore store = this.sizeLimitedRoot().getFileSystem().provider().getFileStore(this.sizeLimitedRoot());
        while (store.getUsableSpace() > 20000L) {
            Files.write(this.sizeLimitedRoot().resolve(UUID.randomUUID().toString()), CONTENT_BIG, new OpenOption[0]);
        }
        Assertions.assertThatThrownBy(() -> Files.write(this.fileInLimitedPlayground(), CONTENT_BIG, StandardOpenOption.APPEND)).isInstanceOf(IOException.class);
    }

    @Test
    @Category(value={FileStores.class, SizeLimit.class, Exclusive.class})
    public void testFileStoreLimitPreventsCopy() throws IOException {
        FileStore store = this.sizeLimitedRoot().getFileSystem().provider().getFileStore(this.sizeLimitedRoot());
        while (store.getUsableSpace() > 20000L) {
            Files.write(this.sizeLimitedRoot().resolve(UUID.randomUUID().toString()), CONTENT_BIG, new OpenOption[0]);
        }
        Path target = this.sizeLimitedRoot().resolve("target");
        Assertions.assertThatThrownBy(() -> Files.copy(this.fileInLimitedPlayground(), target, new CopyOption[0])).isInstanceOf(IOException.class);
    }

    @Test
    @Category(value={FileStores.class, SizeLimit.class, Exclusive.class})
    public void testCanCreateFileWithinLimits() throws IOException {
        FileStore store = this.sizeLimitedRoot().getFileSystem().provider().getFileStore(this.sizeLimitedRoot());
        MatcherAssert.assertThat((Object)store.getUsableSpace(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(CONTENT.length)));
        Path file = this.sizeLimitedRoot().resolve(UUID.randomUUID().toString());
        Files.write(file, CONTENT, new OpenOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(file), (Matcher)Is.is((Object)CONTENT));
    }

    public Path sizeLimitedRoot() {
        Path ret = this.description.get(Path.class, "sizeLimitedPlayground").resolve(this.testMethodName.getMethodName());
        Filess.createDirectories((Path)ret);
        this.fileInLimitedPlayground();
        return ret;
    }

    public Path fileInLimitedPlayground() {
        Path ret = this.description.get(Path.class, "sizeLimitedPlayground").resolve("bigggg");
        if (!Files.exists(ret, new LinkOption[0])) {
            try {
                Files.write(ret, CONTENT_BIG, new OpenOption[0]);
            }
            catch (IOException e) {
                throw Unchecked.u((Throwable)e);
            }
        }
        return ret;
    }
}

