/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.collection.P;
import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests09WrongProvider;
import de.pfabulist.lindwurm.niotest.tests.topics.CaseInsensitive;
import de.pfabulist.lindwurm.niotest.tests.topics.CasePreserving;
import de.pfabulist.lindwurm.niotest.tests.topics.Copy;
import de.pfabulist.lindwurm.niotest.tests.topics.Delete;
import de.pfabulist.lindwurm.niotest.tests.topics.FileStores;
import de.pfabulist.lindwurm.niotest.tests.topics.HardLink;
import de.pfabulist.lindwurm.niotest.tests.topics.LimitedPath;
import de.pfabulist.lindwurm.niotest.tests.topics.MaxFilename;
import de.pfabulist.lindwurm.niotest.tests.topics.MaxPath;
import de.pfabulist.lindwurm.niotest.tests.topics.Move;
import de.pfabulist.lindwurm.niotest.tests.topics.NonCasePreserving;
import de.pfabulist.lindwurm.niotest.tests.topics.WorkingDirectoryInPlaygroundTree;
import de.pfabulist.lindwurm.niotest.tests.topics.Writable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests10PathWithContent
extends Tests09WrongProvider {
    public static final String MAX_FILENAME_LENGTH = "getMaxFilenameLength";
    public static final String MAX_PATH_LENGTH = "maxPathLength";
    public static final String ONE_CHAR_COUNT = "oneCharCount";
    public static final String GET_FILENAME_LENGTH = "filenameLenth";
    public static final String GET_PATH_LENGTH = "pathLength";

    public Tests10PathWithContent(FSDescription capa) {
        super(capa);
    }

    @Test
    public void testIsSameFileOnEqualPath() throws IOException {
        Path file = this.getNonExistingPath();
        Assertions.assertThat((boolean)Files.isSameFile(file, file)).isTrue();
    }

    @Test
    public void testIsSameFileWithUnnormalizedPath() throws IOException {
        Assertions.assertThat((boolean)this.FS.provider().isSameFile(this.getFile(), this.unnormalize(this.getFile()))).isTrue();
    }

    @Test
    @Category(value={WorkingDirectoryInPlaygroundTree.class})
    public void testIsSameFileWithRelativePath() throws IOException {
        Assertions.assertThat((boolean)this.FS.provider().isSameFile(this.getFile(), this.relativize(this.getFile()))).isTrue();
    }

    @Test
    public void testIsSameFileOfSameContentDifferentPathIsNot() throws IOException {
        Assertions.assertThat((boolean)this.FS.provider().isSameFile(this.fileTA(), this.fileTB())).isFalse();
    }

    @Test
    public void testIsSameFileOfDifferentPathNonExistingFileIsNot() throws IOException {
        Assertions.assertThat((boolean)this.FS.provider().isSameFile(this.getFile(), this.getNonExistingPath())).isFalse();
    }

    @Test
    @Category(value={Writable.class})
    public void testWriteUnnormalized() throws IOException {
        Files.write(this.unnormalize(this.absTA()), CONTENT, standardOpen);
        Assertions.assertThat((byte[])Files.readAllBytes(this.absTA())).isEqualTo((Object)CONTENT);
    }

    @Test
    public void testReadAttributesFromUnnormalizedPath() throws IOException {
        Path file = this.getFile();
        long size = Files.size(file);
        Assertions.assertThat((long)Files.size(this.unnormalize(file))).isEqualTo(size);
    }

    @Test
    public void testCheckAccessUnnormalizedPath() throws IOException {
        try {
            this.FS.provider().checkAccess(this.unnormalize(this.getFile()), new AccessMode[0]);
        }
        catch (Exception e) {
            Assert.fail((String)"checkAccess fails to normalize");
        }
    }

    @Test
    @Category(value={WorkingDirectoryInPlaygroundTree.class})
    public void testCheckAccessRelativePath() throws IOException {
        try {
            this.FS.provider().checkAccess(this.relativize(this.getFile()), new AccessMode[0]);
        }
        catch (IOException e) {
            Assert.fail((String)"checkAccess does not work with relative paths");
        }
    }

    @Test
    public void testCheckAccessSupportesRead() throws IOException {
        try {
            this.FS.provider().checkAccess(this.getFile(), AccessMode.READ);
        }
        catch (AccessDeniedException accessDeniedException) {
        }
        catch (UnsupportedOperationException e) {
            Assert.fail((String)"checkAccess must support READ");
        }
    }

    @Test
    @Category(value={Writable.class})
    public void testCheckAccessSupportesWrite() throws IOException {
        try {
            this.FS.provider().checkAccess(this.fileTAB(), AccessMode.WRITE);
        }
        catch (AccessDeniedException accessDeniedException) {
        }
        catch (UnsupportedOperationException e) {
            Assert.fail((String)"checkAccess must support WRITE");
        }
    }

    @Test
    public void testCheckAccessSupportesExecute() throws IOException {
        try {
            this.FS.provider().checkAccess(this.getFile(), AccessMode.EXECUTE);
        }
        catch (AccessDeniedException accessDeniedException) {
        }
        catch (UnsupportedOperationException e) {
            Assert.fail((String)"checkAccess must support EXECUTE");
        }
    }

    @Test(expected=NoSuchFileException.class)
    public void testCheckAccessNonExistingFile() throws IOException {
        this.FS.provider().checkAccess(this.getNonExistingPath(), new AccessMode[0]);
    }

    @Test
    @Category(value={Copy.class, Writable.class})
    public void testCopyUnnormalizedPath() throws IOException {
        this.FS.provider().copy(this.unnormalize(this.srcFile()), this.tgt(), new CopyOption[0]);
        Assertions.assertThat((byte[])Files.readAllBytes(this.tgt())).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={Move.class, Writable.class})
    public void testMoveUnnormalizedPath() throws IOException {
        this.FS.provider().move(this.unnormalize(this.srcFile()), this.tgt(), new CopyOption[0]);
        Assertions.assertThat((byte[])Files.readAllBytes(this.tgt())).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={Copy.class, Writable.class})
    public void testCopyToUnnormalizedPath() throws IOException {
        this.FS.provider().copy(this.srcFile(), this.unnormalize(this.tgt()), new CopyOption[0]);
        Assertions.assertThat((byte[])Files.readAllBytes(this.tgt())).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={Move.class, Writable.class})
    public void testMoveToUnnormalizedPath() throws IOException {
        this.FS.provider().move(this.srcFile(), this.unnormalize(this.tgt()), new CopyOption[0]);
        Assertions.assertThat((byte[])Files.readAllBytes(this.tgt())).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={Writable.class})
    public void testCreateDirectoryUnnormalizedPath() throws IOException {
        this.FS.provider().createDirectory(this.unnormalize(this.absTA()), new FileAttribute[0]);
        Assertions.assertThat((Path)this.absTA()).exists();
    }

    @Test
    @Category(value={Writable.class, WorkingDirectoryInPlaygroundTree.class})
    public void testCreateDirectoryWithRelativePath() throws IOException {
        Files.createDirectory(this.relTA(), new FileAttribute[0]);
        Assertions.assertThat((Path)this.relTA()).exists();
    }

    @Test
    @Category(value={Delete.class, Writable.class})
    public void testDeleteUnnormalizedPath() throws IOException {
        this.FS.provider().delete(this.unnormalize(this.fileTAC()));
        Assertions.assertThat((Path)this.absTAC()).doesNotExist();
    }

    @Test
    @Category(value={Delete.class, Writable.class})
    public void testDeleteIfExistsUnnormalizedPath() throws IOException {
        this.FS.provider().deleteIfExists(this.unnormalize(this.fileTAC()));
        Assertions.assertThat((Path)this.absTAC()).doesNotExist();
    }

    @Test
    @Category(value={FileStores.class})
    public void testGetFileStoreUnnormalizedPath() throws IOException {
        try {
            this.FS.provider().getFileStore(this.unnormalize(this.getFile()));
        }
        catch (Exception e) {
            Assert.fail((String)"getFileStore should accept unnormalized paths");
        }
    }

    @Test
    public void testIsHiddenUnnormalizedPath() throws IOException {
        try {
            this.FS.provider().isHidden(this.unnormalize(this.getFile()));
        }
        catch (Exception e) {
            Assert.fail((String)"isHidden should accept unnormalized paths");
        }
    }

    @Test
    @Category(value={WorkingDirectoryInPlaygroundTree.class})
    public void testToRealPathReturnsAnAbsolutePath() throws Exception {
        Assertions.assertThat((Path)this.relativize(this.getFile()).toRealPath(new LinkOption[0])).isAbsolute();
    }

    @Test
    public void testToRealPathOfUnnormalizedResturnsAnNormalizedPath() throws Exception {
        Path real = this.unnormalize(this.getFile()).toRealPath(new LinkOption[0]);
        Assertions.assertThat((Path)real.normalize()).isEqualTo((Object)real);
    }

    @Test
    public void testToRealPathOfUnnormalizedIsSamePath() throws Exception {
        Path file = this.getFile();
        Assertions.assertThat((boolean)this.FS.provider().isSameFile(this.unnormalize(file).toRealPath(new LinkOption[0]), file)).isTrue();
    }

    @Test(expected=NoSuchFileException.class)
    public void testToRealPathOfNonExistingFileThrows() throws Exception {
        this.getNonExistingPath().toRealPath(new LinkOption[0]);
    }

    @Test
    @Category(value={MaxFilename.class})
    public void testTooLongFilenameHasNoEffectOnPathConstruction() throws IOException {
        try {
            this.getEmptyDir().resolve(this.tooLongFileName());
        }
        catch (Exception e) {
            Assert.fail((String)"too long paths should be buildable");
        }
    }

    @Test
    @Category(value={MaxPath.class, Writable.class})
    public void testTooLongPathHasNoEffectOnPathConstruction() throws IOException {
        try {
            this.absTTooLongPath();
        }
        catch (Exception e) {
            Assert.fail((String)"too long paths should be buildable");
        }
    }

    @Test
    @Category(value={Writable.class, MaxFilename.class})
    public void testWriteToMaxFilenameWorks() throws IOException {
        Path loong = this.absTLongFilename();
        Files.createDirectories(loong.getParent(), new FileAttribute[0]);
        Files.write(loong, CONTENT, new OpenOption[0]);
        Assertions.assertThat((byte[])Files.readAllBytes(loong)).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={Writable.class, MaxPath.class})
    public void testWriteToMaxPathWorks() throws IOException {
        Path loong = this.absTLongPath();
        Files.createDirectories(loong.getParent(), new FileAttribute[0]);
        Files.write(loong, CONTENT, new OpenOption[0]);
        Assertions.assertThat((byte[])Files.readAllBytes(loong)).isEqualTo((Object)CONTENT);
    }

    @Test
    @Category(value={Writable.class, MaxFilename.class})
    public void testMaxFilenameWriteTooLongThrows() throws IOException {
        Path loong = this.absTTooLongFilename();
        Files.createDirectories(loong.getParent(), new FileAttribute[0]);
        Assertions.assertThatThrownBy(() -> Files.write(loong, CONTENT, new OpenOption[0])).isInstanceOf(FileSystemException.class);
    }

    @Test
    @Category(value={Writable.class, MaxPath.class, LimitedPath.class})
    public void testCreateDirWithTooLongPathThrows() throws IOException {
        Path loong = this.absTTooLongPath();
        Files.createDirectories(loong.getParent(), new FileAttribute[0]);
        Assertions.assertThatThrownBy(() -> Files.write(loong, CONTENT, new OpenOption[0])).isInstanceOf(IOException.class);
    }

    @Test
    @Category(value={Writable.class, MaxFilename.class})
    public void testCreateDirWithMaxFilenameWorks() throws IOException {
        Path loong = this.absTLongFilename();
        Files.createDirectories(loong, new FileAttribute[0]);
        Assertions.assertThat((Path)loong).exists();
    }

    @Test
    @Category(value={Writable.class, MaxPath.class})
    public void testCreateDirOfMaxPathWorks() throws IOException {
        Path loong = this.absTLongPath();
        Files.createDirectories(loong, new FileAttribute[0]);
        Assertions.assertThat((Path)loong).exists();
    }

    @Test(expected=FileSystemException.class)
    @Category(value={Writable.class, MaxFilename.class})
    public void testMaxFilenameDirTooLongThrows() throws IOException {
        Path loong = this.absTTooLongFilename();
        Files.createDirectories(loong, new FileAttribute[0]);
    }

    @Test
    @Category(value={Writable.class, MaxPath.class, LimitedPath.class})
    public void testMaxPathDirTooLongThrows() throws IOException {
        Path loong = this.absTTooLongPath();
        Files.createDirectories(loong.getParent(), new FileAttribute[0]);
        Assertions.assertThatThrownBy(() -> Files.createDirectory(loong, new FileAttribute[0])).isInstanceOf(IOException.class);
    }

    @Test
    @Category(value={Writable.class, Copy.class, MaxFilename.class})
    public void testMaxFilenameCopyWorks() throws IOException {
        Path loong = this.absTLongFilename();
        Files.createDirectories(loong.getParent(), new FileAttribute[0]);
        Files.copy(this.fileTAB(), loong, new CopyOption[0]);
        Assertions.assertThat((Path)loong).exists();
    }

    @Test
    @Category(value={Writable.class, Copy.class, MaxPath.class})
    public void testMaxPathCopyWorks() throws IOException {
        Path loong = this.absTLongPath();
        Files.createDirectories(loong.getParent(), new FileAttribute[0]);
        Files.copy(this.fileTAB(), loong, new CopyOption[0]);
        Assertions.assertThat((Path)loong).exists();
    }

    @Test(expected=FileSystemException.class)
    @Category(value={Writable.class, Copy.class, MaxFilename.class})
    public void testMaxFilenameCopyTooLongThrows() throws IOException {
        Path loong = this.absTTooLongFilename();
        Files.copy(this.fileTAB(), loong, new CopyOption[0]);
    }

    @Test
    @Category(value={Writable.class, Copy.class, MaxPath.class, LimitedPath.class})
    public void testMaxPathCopyTooLongThrows() throws IOException {
        Path loong = this.absTTooLongPath();
        Files.createDirectories(loong.getParent(), new FileAttribute[0]);
        Assertions.assertThatThrownBy(() -> Files.copy(this.fileTAB(), loong, new CopyOption[0])).isInstanceOf(IOException.class);
    }

    @Test
    @Category(value={Writable.class, HardLink.class, MaxFilename.class})
    public void testMaxFilenameHardLinkWorks() throws IOException {
        Path loong = this.absTLongFilename();
        Files.createLink(loong, this.fileTAB());
        Assertions.assertThat((Path)loong).exists();
    }

    @Test
    @Category(value={Writable.class, HardLink.class, MaxPath.class})
    public void testMaxPathHardLinkWorks() throws IOException {
        Path loong = this.absTLongPath();
        Files.createDirectories(loong.getParent(), new FileAttribute[0]);
        Files.createLink(loong, this.fileTAB());
        Assertions.assertThat((Path)loong).exists();
    }

    @Test(expected=FileSystemException.class)
    @Category(value={HardLink.class, Writable.class, MaxFilename.class})
    public void testMaxFilenameHardLinkTooLongThrows() throws IOException {
        Path loong = this.absTTooLongFilename();
        Files.createLink(loong, this.fileTAB());
    }

    @Test
    @Category(value={HardLink.class, Writable.class, MaxPath.class, LimitedPath.class})
    public void testMaxPathHardLinkTooLongThrows() throws IOException {
        Path loong = this.absTTooLongPath();
        Files.createDirectories(loong.getParent(), new FileAttribute[0]);
        Assertions.assertThatThrownBy(() -> Files.createLink(loong, this.fileTAB())).isInstanceOf(FileSystemException.class);
    }

    @Test
    @Category(value={Move.class, Writable.class, MaxFilename.class})
    public void testMaxFilenameMoveWorks() throws IOException {
        Path loong = this.absTLongFilename();
        Files.move(this.fileTAB(), loong, new CopyOption[0]);
        Assertions.assertThat((Path)loong).exists();
    }

    @Test
    @Category(value={Move.class, Writable.class, MaxPath.class})
    public void testMaxPathMoveWorks() throws IOException {
        Path loong = this.absTLongPath();
        Files.createDirectories(loong.getParent(), new FileAttribute[0]);
        Files.move(this.fileTAB(), loong, new CopyOption[0]);
        Assertions.assertThat((Path)loong).exists();
    }

    @Test(expected=FileSystemException.class)
    @Category(value={Writable.class, Move.class, MaxFilename.class})
    public void testMaxFilenameMoveTooLongThrows() throws IOException {
        Path loong = this.absTTooLongFilename();
        Files.move(this.fileTAB(), loong, new CopyOption[0]);
    }

    @Test
    @Category(value={Writable.class, Move.class, MaxPath.class, LimitedPath.class})
    public void testMaxPathMoveTooLongThrows() throws IOException {
        Path loong = this.absTTooLongPath();
        Files.createDirectories(loong.getParent(), new FileAttribute[0]);
        Assertions.assertThatThrownBy(() -> Files.move(this.fileTAB(), loong, new CopyOption[0])).isInstanceOf(IOException.class);
    }

    @Test
    @Category(value={CaseInsensitive.class, Writable.class})
    public void testCaseInsensitiveWriting() throws IOException {
        Files.write(this.absTA(), CONTENT, new OpenOption[0]);
        Files.write(this.mixCase(this.absTA()), CONTENT_OTHER, new OpenOption[0]);
        Assertions.assertThat((byte[])Files.readAllBytes(this.absTA())).isEqualTo((Object)CONTENT_OTHER);
    }

    @Test
    @Category(value={CaseInsensitive.class, Writable.class})
    public void testCaseInsensitivePathsPointToSameFile() throws IOException {
        Path file = this.dirTA().resolve(this.nameD());
        Files.write(this.mixCase(file), CONTENT, new OpenOption[0]);
        Assertions.assertThat((boolean)Files.isSameFile(file, this.mixCase(file))).isTrue();
    }

    @Test
    @Category(value={CasePreserving.class, CaseInsensitive.class, Writable.class})
    public void testCasePreserving() throws IOException {
        Path file = this.dirTA().resolve(this.nameD());
        Path mixed = this.dirTA().resolve(this.mixCase(this.nameD()));
        Files.write(mixed, CONTENT, new OpenOption[0]);
        try (DirectoryStream<Path> dir = Files.newDirectoryStream(file.getParent());){
            for (Path kid : dir) {
                Assertions.assertThat((String)kid.toString()).isEqualTo((Object)mixed.toString());
                Assertions.assertThat((String)kid.toString()).isNotEqualTo((Object)file.toString());
                Assertions.assertThat((String)kid.toString()).isNotEqualTo((Object)file.toString().toUpperCase());
            }
        }
    }

    @Test
    @Category(value={CasePreserving.class, CaseInsensitive.class, Writable.class})
    public void testCaseRememberingOverwriteDoesNotOverwriteRememberedName() throws IOException {
        Path file = this.dirTA().resolve(this.nameD());
        Files.write(this.mixCase(file), CONTENT, new OpenOption[0]);
        Files.write(file, CONTENT, new OpenOption[0]);
        try (DirectoryStream<Path> dstr = Files.newDirectoryStream(file.getParent());){
            Path kid = dstr.iterator().next();
            Assertions.assertThat((String)kid.toString().toLowerCase()).isEqualTo((Object)file.toString().toLowerCase());
            Assertions.assertThat((String)kid.toString()).isNotEqualTo((Object)file.toString());
        }
    }

    @Test
    @Category(value={NonCasePreserving.class})
    public void testNonCasePreserving() throws IOException {
        Path file = this.dirTA().resolve(this.nameD());
        Files.write(this.mixCase(file), CONTENT, new OpenOption[0]);
        try (DirectoryStream<Path> dir = Files.newDirectoryStream(file.getParent());){
            for (Path kid : dir) {
                Assertions.assertThat((String)kid.toString()).isNotEqualTo((Object)this.mixCase(file).toString());
                Assertions.assertThat((String)kid.toString()).isNotEqualTo((Object)file.toString());
                Assertions.assertThat((String)kid.toString()).isEqualTo((Object)file.toString().toUpperCase());
            }
        }
    }

    public Path unnormalize(Path path) {
        return path.getParent().resolve("..").resolve(path.getParent().getFileName()).resolve(path.getFileName());
    }

    public Path absTLongFilename() {
        return this.absT().resolve(this.maxFileName());
    }

    public Path absTTooLongFilename() {
        return this.absT().resolve(this.tooLongFileName());
    }

    public String tooLongFileName() {
        return this.maxFileName() + this.description.get(ONE_CHAR_COUNT);
    }

    public String maxFileName() {
        return this.longFileName(this.getMaxFilenameLength());
    }

    public String longFileName(int len) {
        return this.longFileName(len, (String)this.description.get(ONE_CHAR_COUNT));
    }

    @SuppressFBWarnings
    public String longFileName(int len, String one) {
        String ret = (String)this.description.rem.get(P.of((Object)len, (Object)one));
        if (ret != null) {
            return ret;
        }
        ret = "";
        for (int i = 0; i < len; ++i) {
            ret = ret + one;
        }
        this.description.rem.put(P.of((Object)len, (Object)one), ret);
        return ret;
    }

    public Path maxPath() {
        return this.maxPath(this.getMaxPathLength());
    }

    @SuppressFBWarnings
    public Path maxPath(int len) {
        Path ret = this.description.longPaths.get(len);
        if (ret != null) {
            try {
                Files.deleteIfExists(ret);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return ret;
        }
        ret = this.getCommon();
        Function counting = (Function)this.description.get(GET_PATH_LENGTH);
        int max = len - (Integer)counting.apply(ret.toString()) - 1;
        int maxFN = this.getMaxFilenameLength();
        String fname = this.longFileName(maxFN / 8);
        String str = "";
        while ((Integer)counting.apply(str) < max - maxFN - 1) {
            str = str + (str.isEmpty() ? "" : this.FS.getSeparator()) + fname;
        }
        String foo = this.longFileName(max - (Integer)counting.apply(str) - 1, "b");
        if (foo.length() > 0) {
            str = str + this.FS.getSeparator() + foo;
        }
        ret = ret.resolve(str);
        this.description.longPaths.put(len, ret);
        return ret;
    }

    private int getMaxFilenameLength() {
        int maxFilenameLength = this.description.getInt(MAX_FILENAME_LENGTH);
        if (maxFilenameLength < 2) {
            throw new IllegalStateException("set max filename length");
        }
        return maxFilenameLength;
    }

    public Path absTLongPath() {
        return this.maxPath();
    }

    public Path absTTooLongPath() {
        return this.maxPath(this.getMaxPathLength() + 1);
    }

    private int getMaxPathLength() {
        int maxPathLength = this.description.getInt(MAX_PATH_LENGTH);
        if (maxPathLength < 2) {
            throw new IllegalStateException("set max path length");
        }
        return maxPathLength;
    }

    public Path mixCase(Path in) {
        return in.getFileSystem().getPath(this.mixCase(in.toString()), new String[0]);
    }

    @SuppressFBWarnings
    public String mixCase(String inStr) {
        String mix = "";
        for (int i = 0; i < inStr.length(); ++i) {
            mix = i % 2 == 0 ? mix + inStr.substring(i, i + 1).toUpperCase() : mix + inStr.substring(i, i + 1).toLowerCase();
        }
        return mix;
    }
}

