/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.matcher.ExceptionMatcher;
import de.pfabulist.lindwurm.niotest.matcher.FileTimeMatcher;
import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests05URI;
import de.pfabulist.lindwurm.niotest.tests.topics.Attributes;
import de.pfabulist.lindwurm.niotest.tests.topics.CreationTime;
import de.pfabulist.lindwurm.niotest.tests.topics.FileKeyT;
import de.pfabulist.lindwurm.niotest.tests.topics.LastAccessTime;
import de.pfabulist.lindwurm.niotest.tests.topics.LastModifiedTime;
import de.pfabulist.lindwurm.niotest.tests.topics.Move;
import de.pfabulist.lindwurm.niotest.tests.topics.SlowTest;
import de.pfabulist.lindwurm.niotest.tests.topics.WorkingDirectoryInPlaygroundTree;
import de.pfabulist.lindwurm.niotest.tests.topics.Writable;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests06Attributes
extends Tests05URI {
    public Tests06Attributes(FSDescription capa) {
        super(capa);
    }

    @Test
    @Category(value={Attributes.class})
    public void testGetLastModifiedTimeDoesNotThrow() throws IOException {
        try {
            Files.readAttributes(this.pathDefault(), BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime();
        }
        catch (Exception e) {
            Assert.fail((String)"last modified time should be supported attribute");
        }
    }

    @Test
    @Category(value={Attributes.class, Writable.class})
    public void testGetCreationTimeIsRecent() throws IOException {
        FileTime created = Files.readAttributes(this.fileTA(), BasicFileAttributes.class, new LinkOption[0]).creationTime();
        Assert.assertThat((Object)created, FileTimeMatcher.isCloseTo(FileTime.fromMillis(System.currentTimeMillis())));
    }

    @Test(expected=UnsupportedOperationException.class)
    @Category(value={Attributes.class})
    public void testReadAttributesAskingForUnknownAttributesThrows() throws Exception {
        Files.readAttributes(this.pathDefault(), SomeFileAttributes.class, new LinkOption[0]);
    }

    @Test
    @Category(value={Attributes.class})
    public void testSizeOfDirDoesNotThrow() throws IOException {
        try {
            Files.size(this.pathDefault());
        }
        catch (IOException e) {
            Assert.fail((String)"size of dir should not throw");
        }
    }

    @Test
    @Category(value={Attributes.class})
    public void testRootIsNotASymbolicLink() {
        Assert.assertThat((String)"root is a symbolic link", (Object)Files.isSymbolicLink(this.defaultRoot()), (Matcher)CoreMatchers.not((Object)true));
    }

    @Test
    @Category(value={Attributes.class})
    public void testBasicIsASupportedFileAttributeView() {
        Assert.assertThat(this.FS.supportedFileAttributeViews(), (Matcher)CoreMatchers.hasItem((Object)"basic"));
    }

    @Test
    @Category(value={Attributes.class})
    public void testGetLastModifiedAllMethodsDeliverSame() throws IOException {
        Path path = this.getFile();
        FileTime last0 = Files.getLastModifiedTime(path, new LinkOption[0]);
        FileTime last1 = this.FS.provider().readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime();
        FileTime last2 = (FileTime)this.FS.provider().readAttributes(path, "basic:lastModifiedTime", new LinkOption[0]).get("lastModifiedTime");
        FileTime last3 = this.FS.provider().getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]).readAttributes().lastModifiedTime();
        Assert.assertThat((Object)last0, (Matcher)CoreMatchers.is((Object)last1));
        Assert.assertThat((Object)last1, (Matcher)CoreMatchers.is((Object)last2));
        Assert.assertThat((Object)last2, (Matcher)CoreMatchers.is((Object)last3));
        Assert.assertThat((Object)last3, (Matcher)CoreMatchers.is((Object)last0));
    }

    @Test
    @Category(value={Attributes.class})
    public void testAllGetAttributeMethodsDeliverSame() throws IOException {
        this.description.getAttributeDescriptions().forEach(ad -> {
            try {
                Path path = this.getFile();
                for (String key : ad.getAttributeNames()) {
                    Object val1 = ad.get(this.FS.provider().readAttributes(path, ad.getReadType(), new LinkOption[0]), key);
                    Object val2 = this.FS.provider().readAttributes(path, ad.getName() + ":" + key, new LinkOption[0]).get(key);
                    Object val3 = ad.get(this.FS.provider().getFileAttributeView(path, ad.getViewType(), new LinkOption[0]).readAttributes(), key);
                    Assert.assertThat((String)("get attribute " + ad.getName() + ":" + key), (Object)val1, (Matcher)CoreMatchers.is((Object)val2));
                    Assert.assertThat((String)("get attribute " + ad.getName() + ":" + key), (Object)val2, (Matcher)CoreMatchers.is((Object)val3));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    @Test
    @Category(value={Attributes.class, WorkingDirectoryInPlaygroundTree.class})
    public void testGetLastModifiedViaStringOfRelativePath() throws IOException {
        Path path = this.getFile();
        Assert.assertThat((Object)this.FS.provider().readAttributes(this.pathDefault().toAbsolutePath().relativize(path), "basic:lastModifiedTime", new LinkOption[0]).get("lastModifiedTime"), (Matcher)CoreMatchers.is((Object)this.FS.provider().readAttributes(path, "basic:lastModifiedTime", new LinkOption[0]).get("lastModifiedTime")));
    }

    @Test
    @Category(value={Attributes.class})
    public void testGetAllBasicAttributes() throws IOException {
        Map<String, Object> attis = this.FS.provider().readAttributes(this.getFile(), "basic:*", new LinkOption[0]);
        Assert.assertThat(attis.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"size", "creationTime", "lastAccessTime", "lastModifiedTime", "fileKey", "isDirectory", "isRegularFile", "isSymbolicLink", "isOther"}));
    }

    @Test
    @Category(value={Attributes.class})
    public void testGetAllFooAttributes() {
        this.description.getAttributeDescriptions().forEach(ad -> {
            try {
                Map<String, Object> attis = this.FS.provider().readAttributes(this.getFile(), ad.getName() + ":*", new LinkOption[0]);
                for (String key : ad.getAttributeNames()) {
                    Assert.assertThat((String)(ad.getName() + ":" + key), (Object)attis.containsKey(key), (Matcher)CoreMatchers.is((Object)true));
                }
            }
            catch (IOException e) {
                Assert.assertThat((Object)"failed", (Matcher)CoreMatchers.is((Object)"not thrown"));
            }
        });
    }

    @Test
    @Category(value={Attributes.class})
    public void testUnsupportedAttributeViewReturnsNull() {
        Assert.assertThat((Object)this.FS.provider().getFileAttributeView(this.pathDefault(), UnsiView.class, new LinkOption[0]), (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=UnsupportedOperationException.class)
    @Category(value={Attributes.class})
    public void testUnsupportedAttributesThrows() throws IOException {
        this.FS.provider().readAttributes(this.pathDefault(), UnsiAttris.class, new LinkOption[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    @Category(value={Attributes.class})
    public void testReadUnsupportedAttributeThrows() throws IOException {
        this.FS.provider().readAttributes(this.pathDefault(), "thisissuchasillyattributesname:duda", new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    @Category(value={Attributes.class})
    public void testReadAttributesUnknownAttributeThrows() throws IOException {
        this.FS.provider().readAttributes(this.pathDefault(), "basic:duda", new LinkOption[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    @Category(value={Attributes.class})
    public void testSetUnsupportedAttributeThrows() throws IOException {
        this.FS.provider().setAttribute(this.fileTA(), "whoaa:freeze", true, new LinkOption[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    @Category(value={Attributes.class})
    public void testGetUnsupportedAttributeThrows() throws IOException {
        Files.getAttribute(this.fileTA(), "whoaa:freeze", new LinkOption[0]);
    }

    @Test
    @Category(value={Attributes.class})
    public void testGetUnsupportedAttributeThrows2() throws IOException {
        this.description.getAttributeDescriptions().forEach(ad -> Assert.assertThat((String)("attribute view " + ad.getName()), () -> Files.getAttribute(this.getFile(), ad.getName() + ":areallystupidname", new LinkOption[0]), ExceptionMatcher.throwsException(IllegalArgumentException.class)));
    }

    @Test(expected=IllegalArgumentException.class)
    @Category(value={Attributes.class})
    public void testReadAttributesOneUnknownAttributeThrows() throws IOException {
        this.FS.provider().readAttributes(this.pathDefault(), "basic:lastModifiedTime,duda", new LinkOption[0]);
    }

    @Test
    @Category(value={Attributes.class, Writable.class, LastModifiedTime.class})
    public void testSetLastModifiedTimeViaString() throws IOException {
        FileTime past = FileTime.fromMillis(System.currentTimeMillis() - 100000L);
        Path file = this.getFile();
        this.FS.provider().setAttribute(file, "basic:lastModifiedTime", past, new LinkOption[0]);
        Assert.assertThat((Object)Files.getLastModifiedTime(file, new LinkOption[0]), FileTimeMatcher.isCloseTo(past));
    }

    @Test
    @Category(value={Attributes.class, Writable.class, LastModifiedTime.class})
    public void testSetLastModifiedTimeViaFiles() throws IOException {
        FileTime past = FileTime.fromMillis(System.currentTimeMillis() - 100000L);
        Path file = this.fileTA();
        Files.setLastModifiedTime(file, past);
        Assert.assertThat((Object)Files.getLastModifiedTime(file, new LinkOption[0]), FileTimeMatcher.isCloseTo(past));
    }

    @Test
    @Category(value={Attributes.class, Writable.class, LastModifiedTime.class})
    public void testSetLastModifiedTimeViaView() throws IOException {
        FileTime past = FileTime.fromMillis(System.currentTimeMillis() - 100000L);
        Path file = this.getFile();
        this.FS.provider().getFileAttributeView(file, BasicFileAttributeView.class, new LinkOption[0]).setTimes(past, null, null);
        Assert.assertThat((Object)Files.getLastModifiedTime(file, new LinkOption[0]), FileTimeMatcher.isCloseTo(past));
    }

    @Test(expected=IllegalArgumentException.class)
    @Category(value={Attributes.class, Writable.class})
    public void testSetSizeThrows() throws IOException {
        this.FS.provider().setAttribute(this.fileTA(), "basic:size", 7, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    @Category(value={Attributes.class, Writable.class})
    public void testSetIsLinkThrows() throws IOException {
        this.FS.provider().setAttribute(this.fileTA(), "basic:isSymbolicLink", true, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    @Category(value={Attributes.class, Writable.class})
    public void testSetIsDirectoryThrows() throws IOException {
        this.FS.provider().setAttribute(this.fileTA(), "basic:isDirectory", true, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    @Category(value={Attributes.class, Writable.class})
    public void testSetIsRegularFileThrows() throws IOException {
        this.FS.provider().setAttribute(this.fileTA(), "basic:isRegularFile", true, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    @Category(value={Attributes.class, Writable.class})
    public void testSetFileKeyThrows() throws IOException {
        this.FS.provider().setAttribute(this.fileTA(), "basic:fileKey", true, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    @Category(value={Attributes.class, Writable.class})
    public void testSetIsOtherThrows() throws IOException {
        this.FS.provider().setAttribute(this.fileTA(), "basic:isOther", true, new LinkOption[0]);
    }

    @Test
    @Category(value={Attributes.class, Writable.class, Attributes.class, CreationTime.class})
    public void testSetCreationTimeViaString() throws IOException {
        FileTime past = FileTime.fromMillis(System.currentTimeMillis() - 100000L);
        Path file = this.fileTA();
        this.FS.provider().setAttribute(file, "basic:creationTime", past, new LinkOption[0]);
        Assert.assertThat((Object)Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).creationTime(), FileTimeMatcher.isCloseTo(past));
    }

    @Test
    @Category(value={Attributes.class, SlowTest.class, Writable.class})
    public void testSetCreationTimeDoesNotChangeLastAccessTime() throws IOException, InterruptedException {
        Path file = this.fileTA();
        FileTime before = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        this.waitForAttribute();
        this.FS.provider().setAttribute(file, "basic:creationTime", FileTime.fromMillis(System.currentTimeMillis() - 100000L), new LinkOption[0]);
        Assert.assertThat((Object)Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), (Matcher)CoreMatchers.is((Object)before));
    }

    @Test
    @Category(value={Attributes.class, Writable.class, Attributes.class, CreationTime.class})
    public void testSetCreationTimeViaView() throws IOException {
        FileTime past = FileTime.fromMillis(System.currentTimeMillis() - 100000L);
        Path file = this.fileTA();
        this.FS.provider().getFileAttributeView(file, BasicFileAttributeView.class, new LinkOption[0]).setTimes(null, null, past);
        Assert.assertThat((Object)Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).creationTime(), FileTimeMatcher.isCloseTo(past));
    }

    @Test
    @Category(value={Attributes.class, Writable.class, LastAccessTime.class})
    public void testSetLastAccessTimeViaString() throws IOException {
        FileTime past = FileTime.fromMillis(System.currentTimeMillis() - 100000L);
        Path file = this.fileTA();
        this.FS.provider().setAttribute(file, "basic:lastAccessTime", past, new LinkOption[0]);
        Assert.assertThat((Object)Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), FileTimeMatcher.isCloseTo(past));
    }

    @Test
    @Category(value={Attributes.class, Writable.class, LastAccessTime.class})
    public void testSetLastAccessTimeViaView() throws IOException {
        FileTime past = FileTime.fromMillis(System.currentTimeMillis() - 100000L);
        Path file = this.fileTA();
        this.FS.provider().getFileAttributeView(file, BasicFileAttributeView.class, new LinkOption[0]).setTimes(null, past, null);
        Assert.assertThat((Object)Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), FileTimeMatcher.isCloseTo(past));
    }

    @Test(expected=NoSuchFileException.class)
    @Category(value={Attributes.class})
    public void testGetAttributeFromNonExistingFile() throws IOException {
        Files.getLastModifiedTime(this.getNonExistingPath(), new LinkOption[0]);
    }

    @Test(expected=NoSuchFileException.class)
    @Category(value={Attributes.class})
    public void testReadAttributesByStringFromNonExistingFile() throws IOException {
        Files.readAttributes(this.getNonExistingPath(), "basic:size", new LinkOption[0]);
    }

    @Test
    @Category(value={Attributes.class})
    public void testReadAttributesViewFromNonExistingFile() throws IOException {
        Assert.assertThat((Object)this.FS.provider().getFileAttributeView(this.getNonExistingPath(), BasicFileAttributeView.class, new LinkOption[0]), (Matcher)CoreMatchers.notNullValue());
    }

    @Test(expected=NoSuchFileException.class)
    @Category(value={Attributes.class})
    public void testReadAttributesViewAndReadFromNonExistingFile() throws IOException {
        BasicFileAttributeView view = this.FS.provider().getFileAttributeView(this.getNonExistingPath(), BasicFileAttributeView.class, new LinkOption[0]);
        view.readAttributes();
    }

    @Test
    @Category(value={Attributes.class, Writable.class})
    public void testReadAttributesViewFutureExistingFile() throws IOException {
        BasicFileAttributeView view = this.FS.provider().getFileAttributeView(this.absTA(), BasicFileAttributeView.class, new LinkOption[0]);
        this.fileTA();
        try {
            view.readAttributes();
        }
        catch (Exception e) {
            Assert.fail((String)"future files have a view");
        }
    }

    @Test(expected=NoSuchFileException.class)
    @Category(value={Attributes.class})
    public void testReadAttributesFromNonExistingFile() throws IOException {
        Files.readAttributes(this.getNonExistingPath(), BasicFileAttributes.class, new LinkOption[0]);
    }

    @Test
    @Category(value={Attributes.class, FileKeyT.class})
    public void testFileKeyIsId() throws IOException {
        Assert.assertThat(Files.readAttributes(this.getFile(), "basic:fileKey", new LinkOption[0]), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not(Files.readAttributes(this.getNonEmptyDir(), "basic:fileKey", new LinkOption[0]))));
    }

    @Test
    @Category(value={Attributes.class, FileKeyT.class, Move.class, Writable.class})
    public void testFileKeyIsKeptInMove() throws IOException {
        Path src = this.fileTAB();
        Path tgt = this.absTC();
        Map<String, Object> key = Files.readAttributes(src, "basic:fileKey", new LinkOption[0]);
        Files.move(src, tgt, new CopyOption[0]);
        Map<String, Object> key2 = Files.readAttributes(tgt, "basic:fileKey", new LinkOption[0]);
        Assert.assertThat(key2, (Matcher)CoreMatchers.is(key));
    }

    @Test
    @Category(value={Attributes.class})
    public void testUserDefinedAttributes() {
        try {
            Files.getFileAttributeView(this.getFile(), UserDefinedFileAttributeView.class, new LinkOption[0]);
        }
        catch (Exception e) {
            Assert.fail((String)"UserDefinedAttributeView must be supported");
        }
    }

    public static interface UnsiAttris
    extends BasicFileAttributes {
    }

    public static interface UnsiView
    extends BasicFileAttributeView {
    }

    public static class SomeFileAttributes
    implements BasicFileAttributes {
        @Override
        public FileTime lastModifiedTime() {
            return null;
        }

        @Override
        public FileTime lastAccessTime() {
            return null;
        }

        @Override
        public FileTime creationTime() {
            return null;
        }

        @Override
        public boolean isRegularFile() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public boolean isSymbolicLink() {
            return false;
        }

        @Override
        public boolean isOther() {
            return false;
        }

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public Object fileKey() {
            return null;
        }
    }
}

