/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.collection.Sets;
import de.pfabulist.kleinod.text.Strings;
import de.pfabulist.lindwurm.niotest.matcher.ExceptionMatcher;
import de.pfabulist.lindwurm.niotest.matcher.FileTimeMatcher;
import de.pfabulist.lindwurm.niotest.matcher.IteratorMatcher;
import de.pfabulist.lindwurm.niotest.matcher.PathExists;
import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests02Dir;
import de.pfabulist.lindwurm.niotest.tests.topics.AllwaysSync;
import de.pfabulist.lindwurm.niotest.tests.topics.Attributes;
import de.pfabulist.lindwurm.niotest.tests.topics.Basic;
import de.pfabulist.lindwurm.niotest.tests.topics.CreationTime;
import de.pfabulist.lindwurm.niotest.tests.topics.LastAccessTime;
import de.pfabulist.lindwurm.niotest.tests.topics.LastModifiedTime;
import de.pfabulist.lindwurm.niotest.tests.topics.SlowTest;
import de.pfabulist.lindwurm.niotest.tests.topics.Synced;
import de.pfabulist.lindwurm.niotest.tests.topics.Unix;
import de.pfabulist.lindwurm.niotest.tests.topics.Windows;
import de.pfabulist.lindwurm.niotest.tests.topics.Writable;
import de.pfabulist.unchecked.Filess;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Clock;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.number.OrderingComparison;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests03File
extends Tests02Dir {
    @SuppressFBWarnings
    protected static OpenOption[] standardOpen = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};

    @Test(expected=NoSuchFileException.class)
    public void testReadCreateNonExistingFileThrows() throws IOException {
        Files.newByteChannel(this.getNonExistingPath(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ, StandardOpenOption.CREATE_NEW, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.DELETE_ON_CLOSE, StandardOpenOption.DSYNC, StandardOpenOption.CREATE}), new FileAttribute[0]);
    }

    @Test(expected=NoSuchFileException.class)
    @Category(value={Writable.class})
    public void testWriteFileWithoutExistingParentThrows() throws IOException {
        Files.write(this.absTAB(), CONTENT, StandardOpenOption.CREATE, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
    }

    @Test
    @Category(value={Writable.class})
    public void testWriteWithoutOptionsCreatesTheFile() throws IOException {
        Path target = this.absTA();
        Files.write(target, CONTENT, new OpenOption[0]);
        Assert.assertThat((Object)target, PathExists.exists());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChannelSetNegativePositionThrows() throws IOException {
        try (SeekableByteChannel channel = Files.newByteChannel(this.getFile(), StandardOpenOption.READ);){
            channel.position(-1L);
        }
    }

    @Test
    public void testChannelGetSize() throws IOException {
        Path target = this.getFile();
        try (SeekableByteChannel channel = Files.newByteChannel(target, StandardOpenOption.READ);){
            Assert.assertThat((Object)channel.size(), (Matcher)Is.is((Object)Files.size(target)));
        }
    }

    @Test
    @Category(value={Writable.class})
    public void testWriteWithoutOptionsOverwritesExisting() throws IOException {
        Path target = this.fileTA();
        Files.write(target, CONTENT_OTHER, new OpenOption[0]);
        Assert.assertThat((Object)Files.readAllBytes(target), (Matcher)Is.is((Object)CONTENT_OTHER));
    }

    @Test
    @Category(value={Writable.class, Basic.class})
    public void testRWBytes() throws IOException {
        Path target = this.absTA();
        Files.write(target, CONTENT, standardOpen);
        byte[] out = Files.readAllBytes(target);
        Assert.assertThat((Object)out, (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    @Category(value={Writable.class, Basic.class})
    public void testNewFileIsInDirStream() throws IOException {
        Path file = this.absTA();
        Files.write(file, CONTENT, standardOpen);
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(file.getParent());){
            Assert.assertThat((Object)file, IteratorMatcher.isIn(kids));
        }
    }

    @Test
    @Category(value={Writable.class, Basic.class})
    public void testRWBytes20k() throws IOException {
        Path target = this.absTA();
        Files.write(target, CONTENT_BIG, standardOpen);
        byte[] out = Files.readAllBytes(target);
        Assert.assertThat((Object)out, (Matcher)Is.is((Object)CONTENT_BIG));
    }

    @Test
    public void testReadSmallChunks() throws IOException {
        Path target = this.getFile();
        long size = Files.size(target);
        Assume.assumeThat((Object)size, (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(3L)));
        byte[] out = new byte[(int)(size * 2L)];
        int sum = 0;
        try (SeekableByteChannel readChannel = Files.newByteChannel(target, StandardOpenOption.READ);){
            ByteBuffer bb;
            int count;
            while ((count = readChannel.read(bb = ByteBuffer.wrap(out, sum, 3))) >= 0) {
                Assert.assertThat((Object)(sum += count), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf((int)size + 20)));
            }
        }
        Assert.assertThat((Object)sum, (Matcher)Is.is((Object)((int)size)));
        Assert.assertThat((Object)Arrays.copyOfRange(out, 0, sum), (Matcher)Is.is((Object)Files.readAllBytes(target)));
    }

    @Test
    @Category(value={Writable.class})
    public void testWriteSmallChunks() {
        Path target = this.absTA();
        Filess.write((Path)target, (byte[])Arrays.copyOfRange(CONTENT, 0, 3), (OpenOption[])new OpenOption[0]);
        Filess.write((Path)target, (byte[])Arrays.copyOfRange(CONTENT, 3, CONTENT.length), (OpenOption[])new OpenOption[]{StandardOpenOption.APPEND});
        Assert.assertThat((Object)Filess.readAllBytes((Path)target), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testClosedChannelIsClosed() throws IOException {
        try (SeekableByteChannel read = Files.newByteChannel(this.getFile(), new OpenOption[0]);){
            read.close();
            Assert.assertThat((Object)read.isOpen(), (Matcher)Is.is((Object)false));
        }
    }

    @Test
    public void testReadFromClosedChannelThrows() throws IOException {
        try (SeekableByteChannel read = Files.newByteChannel(this.getFile(), new OpenOption[0]);){
            read.close();
            Assert.assertThat(() -> read.read(ByteBuffer.allocate(30)), ExceptionMatcher.throwsException(ClosedChannelException.class));
        }
    }

    @Test
    @Category(value={Writable.class})
    public void testWriteToClosedChannelThrows() throws IOException {
        try (SeekableByteChannel write = Files.newByteChannel(this.fileTA(), StandardOpenOption.WRITE);){
            write.close();
            Assert.assertThat(() -> write.write(ByteBuffer.allocate(30)), ExceptionMatcher.throwsException(ClosedChannelException.class));
        }
    }

    @Test
    @Category(value={Writable.class, Attributes.class})
    public void testWriteFileAndSize() throws IOException {
        Path target = this.absTA();
        Files.write(target, CONTENT, standardOpen);
        Assert.assertThat((Object)Files.readAttributes(target, BasicFileAttributes.class, new LinkOption[0]).size(), (Matcher)Is.is((Object)CONTENT.length));
    }

    @Test
    @Category(value={Writable.class, Attributes.class})
    public void testFileAttributesAreImmutable() throws IOException {
        Path file = this.absTA();
        Files.write(file, CONTENT, standardOpen);
        BasicFileAttributes atti = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
        long oldSize = atti.size();
        Files.write(file, CONTENT_OTHER, StandardOpenOption.APPEND);
        Assert.assertThat((Object)atti.size(), (Matcher)Is.is((Object)oldSize));
    }

    @Test(expected=NoSuchFileException.class)
    @Category(value={Writable.class})
    public void testWriteNonExistent() throws IOException {
        SeekableByteChannel ch = this.FS.provider().newByteChannel(this.absTA(), Collections.singleton(StandardOpenOption.WRITE), new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
    }

    @Test
    @Category(value={Writable.class})
    public void testWriteNothingOverExistingFileDoesNotChangeIt() throws IOException {
        Path there = this.fileTA();
        SeekableByteChannel ch = this.FS.provider().newByteChannel(there, Collections.singleton(StandardOpenOption.WRITE), new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
        Assert.assertThat((Object)Files.size(there), (Matcher)Is.is((Object)CONTENT.length));
    }

    @Test
    @Category(value={Writable.class})
    public void testWriteAndCreateNonExistentCreatesIt() throws IOException {
        SeekableByteChannel ch = this.FS.provider().newByteChannel(this.absTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE}), new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
        Assert.assertThat((Object)this.absTA(), PathExists.exists());
    }

    @Test
    @Category(value={Writable.class})
    public void testWriteAndCreateExistent() throws IOException {
        Path there = this.fileTA();
        SeekableByteChannel ch = this.FS.provider().newByteChannel(there, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE}), new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
        Assert.assertThat((Object)there, PathExists.exists());
    }

    @Test
    @Category(value={Writable.class})
    public void testAppend() throws IOException {
        Path there = this.fileTA();
        Files.write(there, CONTENT, StandardOpenOption.APPEND);
        Assert.assertThat((Object)Files.size(there), (Matcher)Is.is((Object)((long)CONTENT.length * 2L)));
        byte[] out = Files.readAllBytes(there);
        Assert.assertThat((Object)Arrays.copyOfRange(out, 0, CONTENT.length), (Matcher)Is.is((Object)CONTENT));
        Assert.assertThat((Object)Arrays.copyOfRange(out, CONTENT.length, 2 * CONTENT.length), (Matcher)Is.is((Object)CONTENT));
    }

    @Test(expected=IllegalArgumentException.class)
    @Category(value={Writable.class})
    public void testAppendAndReadThrows() throws IOException {
        SeekableByteChannel ch = this.FS.provider().newByteChannel(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.READ}), new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    @Category(value={Writable.class})
    public void testAppendAndTruncateExistingThrows() throws IOException {
        SeekableByteChannel ch = this.FS.provider().newByteChannel(this.fileTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.TRUNCATE_EXISTING}), new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
    }

    @Test(expected=NoSuchFileException.class)
    @Category(value={Writable.class})
    public void testAppendDoesNotCreateNewFile() throws IOException {
        Files.write(this.absTA(), CONTENT, StandardOpenOption.APPEND);
    }

    @Test
    @Category(value={Writable.class})
    public void testWriteAndCreateNewNonExistent() throws IOException {
        Path notthere = this.absTA();
        SeekableByteChannel ch = this.FS.provider().newByteChannel(notthere, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW}), new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
        Assert.assertThat((Object)notthere, PathExists.exists());
    }

    @Test(expected=FileAlreadyExistsException.class)
    @Category(value={Writable.class})
    public void testWriteOnlyNew() throws IOException {
        Path there = this.fileTA();
        SeekableByteChannel ch = this.FS.provider().newByteChannel(there, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW}), new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
    }

    @Test(expected=FileAlreadyExistsException.class)
    @Category(value={Writable.class})
    public void testWriteOnlyNewIfCreateIsThereToo() throws IOException {
        Path there = this.fileTA();
        SeekableByteChannel ch = this.FS.provider().newByteChannel(there, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW, StandardOpenOption.CREATE}), new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
    }

    @Test
    @Category(value={Writable.class})
    public void testOverwriteTruncateExisting() throws IOException {
        Path there = this.fileTA();
        SeekableByteChannel ch = this.FS.provider().newByteChannel(there, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING}), new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
        Assert.assertThat((Object)there, PathExists.exists());
        Assert.assertThat((Object)Files.size(there), (Matcher)Is.is((Object)0L));
    }

    @Test
    @Category(value={Writable.class, Attributes.class, CreationTime.class})
    public void testOverwriteTruncateExistingDoesNotChangeCreationTime() throws IOException {
        Path there = this.fileTA();
        FileTime created = Files.readAttributes(there, BasicFileAttributes.class, new LinkOption[0]).creationTime();
        SeekableByteChannel ch = this.FS.provider().newByteChannel(there, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING}), new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
        Assert.assertThat((Object)Files.readAttributes(there, BasicFileAttributes.class, new LinkOption[0]).creationTime(), (Matcher)Is.is((Object)created));
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Attributes.class, LastAccessTime.class})
    public void testOverwriteSetLastAccessTime() throws IOException, InterruptedException {
        Path there = this.fileTA();
        FileTime before = Files.readAttributes(there, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        this.waitForAttribute();
        Set options = Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING});
        SeekableByteChannel ch = this.FS.provider().newByteChannel(there, options, new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
        Assert.assertThat((Object)Files.readAttributes(there, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), (Matcher)OrderingComparison.greaterThan((Comparable)before));
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Attributes.class})
    public void testOverwriteDoesNotSetLastAccessTimeOfParent() throws IOException, InterruptedException {
        Path there = this.fileTA();
        FileTime before = Files.readAttributes(there.getParent(), BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        this.waitForAttribute();
        Set options = Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING});
        SeekableByteChannel ch = this.FS.provider().newByteChannel(there, options, new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
        Assert.assertThat((Object)Files.readAttributes(there.getParent(), BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), (Matcher)Is.is((Object)before));
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Attributes.class, LastModifiedTime.class})
    public void testCreateFileSetsModifiedTimeOfParent() throws IOException, InterruptedException {
        Path file = this.absTA();
        FileTime created = Files.getLastModifiedTime(file.getParent(), new LinkOption[0]);
        this.waitForAttribute();
        Files.write(file, CONTENT, standardOpen);
        FileTime modified = Files.getLastModifiedTime(file.getParent(), new LinkOption[0]);
        Assert.assertThat((String)"created after modified", (Object)modified, (Matcher)OrderingComparison.greaterThan((Comparable)created));
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Attributes.class})
    public void testCreateFileSetsLastAccessTime() throws IOException, InterruptedException {
        Path file = this.fileTA();
        BasicFileAttributes bfa = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
        Assert.assertThat((Object)bfa.lastAccessTime(), FileTimeMatcher.isCloseTo(bfa.creationTime()));
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Attributes.class, LastAccessTime.class})
    public void testCreateFileSetsLastAccessTimeOfParent() throws IOException, InterruptedException {
        Path dir = this.dirTA();
        FileTime before = Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        this.waitForAttribute();
        this.fileTAB();
        Assert.assertThat((Object)Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), (Matcher)OrderingComparison.greaterThan((Comparable)before));
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Attributes.class, LastModifiedTime.class})
    public void testCreateFileSetModifiedTime() throws Exception {
        Path file = this.absTA();
        FileTime parentCreated = Files.getLastModifiedTime(file.getParent(), new LinkOption[0]);
        this.waitForAttribute();
        this.fileTA();
        Assert.assertThat((Object)Files.getLastModifiedTime(file, new LinkOption[0]), (Matcher)OrderingComparison.greaterThan((Comparable)parentCreated));
    }

    @Test
    @Category(value={Writable.class, Attributes.class, LastModifiedTime.class})
    public void testModifiedDateIsCloseToCurrentTime() throws Exception {
        Path file = this.fileTA();
        FileTime before = FileTime.from(Clock.systemUTC().instant());
        Assert.assertThat((Object)Files.getLastModifiedTime(file, new LinkOption[0]), FileTimeMatcher.isCloseTo(before));
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Attributes.class, LastAccessTime.class})
    public void testReadFileSetsLastAccessTime() throws Exception {
        Path file = this.fileTA();
        FileTime before = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        this.waitForAttribute();
        Files.readAllBytes(file);
        Assert.assertThat((Object)Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), (Matcher)OrderingComparison.greaterThan((Comparable)before));
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Attributes.class, LastAccessTime.class})
    public void testReadFileDoesNotSetParentsLastAccessTime() throws Exception {
        Path file = this.fileTA();
        FileTime before = Files.readAttributes(file.getParent(), BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        this.waitForAttribute();
        Files.readAllBytes(file);
        Assert.assertThat((Object)Files.readAttributes(file.getParent(), BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), (Matcher)Is.is((Object)before));
    }

    @Test
    public void testReadFromExhausted() throws IOException {
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(this.getFile(), Collections.singleton(StandardOpenOption.READ), new FileAttribute[0]);){
            channel.read(ByteBuffer.allocate(CONTENT.length * 2));
            ByteBuffer bb = ByteBuffer.allocate(CONTENT.length * 2);
            int ret = channel.read(bb);
            Assert.assertThat((Object)ret, (Matcher)Is.is((Object)-1));
            Assert.assertThat((Object)bb.position(), (Matcher)Is.is((Object)0));
        }
    }

    @Test
    public void testChannelSetPositionSetsPosition() throws IOException {
        Path file = this.getFile();
        try (SeekableByteChannel out = this.FS.provider().newByteChannel(file, Collections.singleton(StandardOpenOption.READ), new FileAttribute[0]);){
            out.position(1L);
            Assert.assertThat((Object)out.position(), (Matcher)Is.is((Object)1L));
        }
    }

    @Test
    @Category(value={Writable.class})
    public void testRandomWrite() throws IOException {
        Path file = this.fileTA();
        byte[] over = Strings.getBytes((String)"waa");
        byte[] expected = new byte[CONTENT.length];
        System.arraycopy(CONTENT, 0, expected, 0, CONTENT.length);
        System.arraycopy(over, 0, expected, 1, over.length);
        try (SeekableByteChannel out = this.FS.provider().newByteChannel(file, Collections.singleton(StandardOpenOption.WRITE), new FileAttribute[0]);){
            out.position(1L);
            out.write(ByteBuffer.wrap(over));
        }
        Assert.assertThat((Object)Files.readAllBytes(file), (Matcher)Is.is((Object)expected));
    }

    @Test
    @Category(value={Writable.class})
    public void testWriteBeyondFileSize() throws IOException {
        Path file = this.fileTA();
        try (SeekableByteChannel out = this.FS.provider().newByteChannel(file, Collections.singleton(StandardOpenOption.WRITE), new FileAttribute[0]);){
            out.position(100L);
            out.write(ByteBuffer.wrap("ha".getBytes("UTF-8")));
        }
        Assert.assertThat((Object)Files.size(file), (Matcher)Is.is((Object)102L));
    }

    @Test
    public void testRandomRead() throws IOException {
        Path file = this.getFile();
        byte[] content = Files.readAllBytes(file);
        Assume.assumeThat((Object)content.length, (Matcher)OrderingComparison.greaterThan((Comparable)Integer.valueOf(3)));
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Collections.singleton(StandardOpenOption.READ), new FileAttribute[0]);){
            channel.position(1L);
            ByteBuffer buffer = ByteBuffer.allocate(2);
            channel.read(buffer);
            Assert.assertThat((Object)buffer.array(), (Matcher)Is.is((Object)Arrays.copyOfRange(content, 1, 3)));
        }
    }

    @Test
    public void testRandomReadPosition() throws IOException {
        Path file = this.getFile();
        Assume.assumeThat((Object)Files.size(file), (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(4L)));
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Collections.singleton(StandardOpenOption.READ), new FileAttribute[0]);){
            channel.position(1L);
            ByteBuffer buffer = ByteBuffer.allocate(2);
            channel.read(buffer);
            Assert.assertThat((Object)channel.position(), (Matcher)Is.is((Object)3L));
        }
    }

    @Test
    @Category(value={Writable.class, Synced.class, AllwaysSync.class})
    public void testReadAndWrite() throws IOException {
        Path file = this.fileTA();
        try (SeekableByteChannel inout = this.FS.provider().newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.READ}), new FileAttribute[0]);){
            inout.position(1L);
            inout.write(ByteBuffer.wrap("waa".getBytes("UTF-8")));
            Assert.assertThat((Object)new String(Files.readAllBytes(file), "UTF-8"), (Matcher)Is.is((Object)"hwaahere"));
            inout.position(2L);
            ByteBuffer buffer = ByteBuffer.allocate(2);
            inout.read(buffer);
            Assert.assertThat((Object)buffer.array()[0], (Matcher)Is.is((Object)Strings.getBytes((String)"a")[0]));
        }
    }

    @Test(expected=NonReadableChannelException.class)
    @Category(value={Writable.class})
    public void testReadFromWriteOnlyChannelThrows() throws IOException {
        Path file = this.fileTA();
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE}), new FileAttribute[0]);){
            channel.read(ByteBuffer.allocate(2));
        }
    }

    @Test(expected=NonWritableChannelException.class)
    public void testWriteToReadOnlyChannelThrows() throws IOException {
        Path file = this.getFile();
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);){
            channel.write(ByteBuffer.allocate(2));
        }
    }

    @Test
    @Category(value={Writable.class})
    public void testTruncate() throws Exception {
        Path file = this.fileTA();
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE}), new FileAttribute[0]);){
            channel.truncate(2L);
        }
        Assert.assertThat((Object)Files.size(file), (Matcher)Is.is((Object)2L));
    }

    @Test(expected=NonWritableChannelException.class)
    @Category(value={Writable.class})
    public void testTruncateOnReadChannelThrows() throws Exception {
        Path file = this.fileTA();
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);){
            channel.truncate(2L);
        }
    }

    @Test(expected=ClosedChannelException.class)
    @Category(value={Writable.class})
    public void testTruncateOnClosedChannelThrows() throws Exception {
        Path file = this.fileTA();
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE}), new FileAttribute[0]);){
            channel.close();
            channel.truncate(2L);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    @Category(value={Writable.class})
    public void testTruncateToNegativeSizeThrows() throws Exception {
        Path file = this.fileTA();
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE}), new FileAttribute[0]);){
            channel.truncate(-7L);
        }
    }

    @Test(expected=FileSystemException.class)
    @Category(value={Writable.class})
    public void testWriteChannelOfDir() throws IOException {
        SeekableByteChannel channel = this.FS.provider().newByteChannel(this.dirTA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE}), new FileAttribute[0]);
        Throwable throwable = null;
        if (channel != null) {
            if (throwable != null) {
                try {
                    channel.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                channel.close();
            }
        }
    }

    @Test(expected=FileSystemException.class)
    @Category(value={Windows.class})
    public void testReadChannelOfDirThrows() throws IOException {
        SeekableByteChannel channel = this.FS.provider().newByteChannel(this.getNonEmptyDir(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);
        Throwable throwable = null;
        if (channel != null) {
            if (throwable != null) {
                try {
                    channel.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                channel.close();
            }
        }
    }

    @Test
    @Category(value={Unix.class})
    public void testReadChannelOfDirDoesNotThrow() throws IOException {
        try {
            SeekableByteChannel channel = this.FS.provider().newByteChannel(this.getNonEmptyDir(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);
            Throwable throwable = null;
            if (channel != null) {
                if (throwable != null) {
                    try {
                        channel.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    channel.close();
                }
            }
        }
        catch (FileSystemException exp) {
            Assert.fail((String)"unix system should allow read of dir");
        }
    }

    @Test
    @Category(value={SlowTest.class, Attributes.class, Writable.class, LastModifiedTime.class})
    public void testEveryChannelWriteUpdatesLastModifiedTime() throws IOException, InterruptedException {
        Path file = this.fileTA();
        FileTime before = Files.getLastModifiedTime(file, new LinkOption[0]);
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE}), new FileAttribute[0]);){
            for (int i = 0; i < 3; ++i) {
                this.waitForAttribute();
                ByteBuffer bb = ByteBuffer.allocate(20);
                bb.array()[5] = (byte)i;
                channel.write(bb);
                FileTime after = Files.getLastModifiedTime(file, new LinkOption[0]);
                Assert.assertThat((Object)after, (Matcher)OrderingComparison.greaterThan((Comparable)before));
                before = after;
            }
        }
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Attributes.class, LastAccessTime.class})
    public void testEveryChannelReadUpdatesLastAccessTime() throws IOException, InterruptedException {
        Path file = this.fileTA();
        FileTime before = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);){
            for (int i = 0; i < 3; ++i) {
                this.waitForAttribute();
                ByteBuffer bb = ByteBuffer.allocate(3);
                channel.read(bb);
                FileTime after = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
                Assert.assertThat((Object)after, (Matcher)OrderingComparison.greaterThan((Comparable)before));
                before = after;
            }
        }
    }

    @Test(expected=FileSystemException.class)
    @Category(value={Writable.class})
    public void testCreateFileInFileThrows() throws IOException {
        Files.write(this.fileTA().resolve("foo"), CONTENT, new OpenOption[0]);
    }

    @Test(expected=FileSystemException.class)
    @Category(value={Writable.class})
    public void testTruncateOnAppendChannelThrows() throws Exception {
        Path file = this.fileTA();
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.APPEND}), new FileAttribute[0]);){
            channel.truncate(2L);
        }
    }

    public Tests03File(FSDescription capa) {
        super(capa);
    }

    public Path getFile() {
        if (!this.description.provides(Writable.class)) {
            return this.description.get(Path.class, "file");
        }
        return this.fileTA();
    }
}

