/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.matcher.ExceptionMatcher;
import de.pfabulist.lindwurm.niotest.matcher.IteratorMatcher;
import de.pfabulist.lindwurm.niotest.matcher.PathAbsolute;
import de.pfabulist.lindwurm.niotest.matcher.PathEndsWith;
import de.pfabulist.lindwurm.niotest.matcher.PathStartsWith;
import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests00Setup;
import de.pfabulist.lindwurm.niotest.tests.topics.Basic;
import de.pfabulist.lindwurm.niotest.tests.topics.NotDefaultFileSystem;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Basic.class})
public abstract class Tests01NoContent
extends Tests00Setup {
    protected String[] name = new String[]{"aaa", "bbbb", "cccc", "ddddd", "eeeeee"};

    public Tests01NoContent(FSDescription capa) {
        super(capa);
    }

    @Test
    public void testGetNameSimple() {
        Assert.assertThat((Object)this.relAB().getName(0), (Matcher)Is.is((Object)this.relA()));
        Assert.assertThat((Object)this.relAB().getName(1), (Matcher)Is.is((Object)this.relB()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRootHasNoName() {
        this.defaultRoot().getName(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetNameWithNegativeIndex() {
        this.relAB().getName(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetNameWithTooLargeIndex() {
        this.relAB().getName(5);
    }

    @Test
    public void testGetNameOfDefaultPathIsItself() {
        Assert.assertThat((Object)this.pathDefault().getName(0), (Matcher)Is.is((Object)this.pathDefault()));
    }

    @Test
    public void testResultOfGetNameIsRelative() {
        Assert.assertThat((Object)this.relAB().getName(0), PathAbsolute.relative());
    }

    @Test
    public void testNameDoesNotIncludeSeparator() throws Exception {
        Assert.assertThat((Object)this.relAB().getName(1).toString().contains(this.FS.getSeparator()), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testNameCountOfNameIs1() throws Exception {
        Assert.assertThat((Object)this.relABC().getName(2).getNameCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testGetNameCountSimple() {
        Assert.assertThat((Object)this.relAB().getNameCount(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void testGetNameIsIdempontent() {
        Assert.assertThat((Object)this.relA().getName(0), (Matcher)Is.is((Object)this.relA()));
    }

    @Test
    public void testRootNameCountIs0() {
        Assert.assertThat((Object)this.defaultRoot().getNameCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void testDefaultHasNameCount1() {
        Assert.assertThat((Object)this.pathDefault().getNameCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testEndsWithSimple() {
        Assert.assertThat((Object)this.relABC(), PathEndsWith.endsWith(this.relBC()));
        Assert.assertThat((Object)this.relABC(), (Matcher)CoreMatchers.not(PathEndsWith.endsWith(this.relAB())));
    }

    @Test
    public void testEndsWithStringSimple() {
        Path abc = this.relABC();
        String bcStr = this.relBC().toString();
        String abStr = this.relAB().toString();
        Assert.assertThat((Object)abc, PathEndsWith.endsWith(bcStr));
        Assert.assertThat((Object)abc, (Matcher)CoreMatchers.not(PathEndsWith.endsWith(abStr)));
    }

    @Test
    public void testStartsWithSimple() {
        Path abc = this.relABC();
        Path bc = this.relBC();
        Path ab = this.relAB();
        Assert.assertThat((Object)abc, (Matcher)CoreMatchers.not(PathStartsWith.startsWith(bc)));
        Assert.assertThat((Object)abc, PathStartsWith.startsWith(ab));
    }

    @Test
    public void testAbsolutePathDoesNotStartsWithARelativePath() {
        Path abcAbso = this.absABC();
        Path abRel = this.relAB();
        Assert.assertThat((Object)abcAbso, (Matcher)CoreMatchers.not(PathStartsWith.startsWith(abRel)));
    }

    @Test
    public void testAbsolutePathDoesStartsWithAnAbsolutePath() {
        Path abcAbso = this.absABC();
        Path abAbso = this.absAB();
        Assert.assertThat((Object)abcAbso.startsWith(abAbso), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testAbsolutePathDoesStartsWithRoot() {
        Assert.assertThat((Object)this.absABC(), PathStartsWith.startsWith(this.defaultRoot()));
    }

    @Test
    public void testNoNonEmptyPathStartsWithDefault() {
        Assert.assertThat((Object)this.relABC(), (Matcher)CoreMatchers.not(PathStartsWith.startsWith(this.pathDefault())));
    }

    @Test
    public void testStartsWithStringSimple() {
        Path abc = this.relABC();
        String bcStr = this.relBC().toString();
        String abStr = this.relAB().toString();
        Assert.assertThat((Object)abc, (Matcher)CoreMatchers.not(PathStartsWith.startsWith(bcStr)));
        Assert.assertThat((Object)abc.startsWith(abStr), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testSubPathSimple() throws Exception {
        Assert.assertEquals((Object)this.relBC(), (Object)this.relABC().subpath(1, 3));
    }

    @Test
    public void testSubPathIsRelative() throws Exception {
        Assert.assertThat((Object)this.relABC().subpath(1, 3), PathAbsolute.relative());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubPathNegativeStart() throws Exception {
        this.relABC().subpath(-1, 2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubPathStartTooLarge() throws Exception {
        this.relAB().subpath(7, 9);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubPathEndBeforeStart() throws Exception {
        this.relABC().subpath(1, 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubPathEndTooLarge() throws Exception {
        this.relABC().subpath(1, 12);
    }

    @Test
    public void testFileNameHasNameCountOf1() {
        Assert.assertThat((Object)this.absAB().getFileName().getNameCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testGetFileNameIsIdempotent() throws Exception {
        Path fileName = this.relAB().getFileName();
        Assert.assertThat((Object)fileName.getFileName(), (Matcher)Is.is((Object)fileName));
    }

    @Test
    public void testFileNameIsRelative() throws Exception {
        Assert.assertThat((Object)this.absAB().getFileName(), PathAbsolute.relative());
    }

    @Test
    public void testRootHasNoFileName() throws Exception {
        Assert.assertThat((Object)this.defaultRoot().getFileName(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testFileNameStringIsPathPartString() {
        Assert.assertThat((Object)this.relA().getFileName().toString(), (Matcher)Is.is((Object)this.nameA()));
    }

    @Test
    public void testFileNameIsLastName() throws Exception {
        Assert.assertThat((Object)this.relABC().getFileName(), (Matcher)Is.is((Object)this.relABC().getName(2)));
    }

    @Test
    public void testDefaultHasANameAndItsItself() throws Exception {
        Assert.assertEquals((Object)this.pathDefault(), (Object)this.pathDefault().getFileName());
    }

    @Test
    public void testResolveOfNameStrEndsWithThatName() {
        Path rel = this.pathDefault();
        Path res = rel.resolve(this.nameA());
        Assert.assertThat((Object)res, PathEndsWith.endsWith(this.nameA()));
    }

    @Test
    public void testResolveOfARelativePathIsRelative() throws Exception {
        Assert.assertThat((Object)this.pathDefault().resolve(this.nameA()), PathAbsolute.relative());
    }

    @Test
    public void testResolveOfAbsoluteIsAbsolute() throws Exception {
        Assert.assertThat((Object)this.absAB().resolve(this.nameA()), PathAbsolute.absolute());
    }

    @Test
    public void testResolveWithDefaultIsNop() {
        Assert.assertEquals((Object)this.relABC(), (Object)this.relABC().resolve(this.pathDefault()));
    }

    @Test
    public void testResolveWithNameIsSameAsStr() throws Exception {
        Assert.assertEquals((Object)this.relAB().resolve(this.nameD()), (Object)this.relAB().resolve(this.relD()));
    }

    @Test
    public void testResolveWorksLikeGetPathOnStringsWithSeparator() throws Exception {
        String str = this.nameA() + this.FS.getSeparator() + this.nameB();
        Assert.assertEquals((Object)this.pathDefault().resolve(str), (Object)this.FS.getPath(str, new String[0]));
    }

    @Test
    public void testResolveWithStringWithSeparatorsSameAsWithPath() throws Exception {
        String str = this.nameA() + this.FS.getSeparator() + this.nameB();
        Path asPath = this.FS.getPath(this.nameA() + this.FS.getSeparator() + this.nameB(), new String[0]);
        Assert.assertEquals((Object)this.pathDefault().resolve(str), (Object)this.pathDefault().resolve(asPath));
    }

    @Test
    public void testResolveIterative() throws Exception {
        Path two = this.relA().resolve(this.relB());
        Assert.assertEquals((Object)this.relA().resolve(two), (Object)this.relA().resolve(this.relA().resolve(this.relB())));
    }

    @Test
    public void testResolveWithAbsoluteArgReturnArg() throws Exception {
        Assert.assertEquals((Object)this.absAB(), (Object)this.relA().resolve(this.absAB()));
    }

    @Test
    public void testResolveSiblingIsGetParentResolve() throws Exception {
        Assert.assertEquals((Object)this.relAB().resolve(this.relA()), (Object)this.relABC().resolveSibling(this.relA()));
    }

    @Test
    public void testResolveSiblingWithAbsoluteArgIsThatArg() throws Exception {
        Assert.assertEquals((Object)this.absAB(), (Object)this.relA().resolveSibling(this.absAB()));
    }

    @Test
    public void testResolveSiblingOnRootReturnsArg() throws Exception {
        Assert.assertEquals((Object)this.relAB(), (Object)this.defaultRoot().resolveSibling(this.relAB()));
    }

    @Test
    public void testResolveSiblingOnDefaultReturnsArg() throws Exception {
        Assert.assertEquals((Object)this.relAB(), (Object)this.pathDefault().resolveSibling(this.relAB()));
    }

    @Test
    public void testResolveSiblingOnNameReturnsArg() throws Exception {
        Assert.assertEquals((Object)this.relAB(), (Object)this.relA().resolveSibling(this.relAB()));
    }

    @Test
    public void testResolveSiblingWorksWithStringAndPath() throws Exception {
        Assert.assertEquals((Object)this.relAB().resolveSibling(this.relB()), (Object)this.relAB().resolveSibling(this.nameB()));
    }

    @Test
    public void testGetPathIgnoresEmptyStringAsFirstParameter() throws Exception {
        Assert.assertEquals((Object)this.FS.getPath(this.nameA(), new String[0]), (Object)this.FS.getPath("", this.nameA()));
    }

    @Test
    public void testGetPathIgnoresEmptyStringInAnyParameter() throws Exception {
        Assert.assertEquals((Object)this.FS.getPath(this.nameA(), new String[0]), (Object)this.FS.getPath("", "", this.nameA(), "", ""));
    }

    @Test
    public void testGetPathWithSeveralNamesIsSameAsWithOneStringWithSeparators() throws Exception {
        Assert.assertEquals((Object)this.FS.getPath(this.nameA(), this.nameB(), this.nameC()), (Object)this.FS.getPath(this.nameA() + this.FS.getSeparator() + this.nameB() + this.FS.getSeparator() + this.nameC(), new String[0]));
    }

    @Test
    public void testpathAllowsMixedArguments() throws Exception {
        Assert.assertEquals((Object)this.FS.getPath(this.nameA() + this.FS.getSeparator() + this.nameB(), this.nameC()), (Object)this.FS.getPath(this.nameA(), this.nameB() + this.FS.getSeparator() + this.nameC()));
    }

    @Test
    public void testpathAndToStringAreOpposites() throws Exception {
        Assert.assertThat((Object)this.FS.getPath(this.relABC().toString(), new String[0]), (Matcher)Is.is((Object)this.relABC()));
        String str = this.nameC() + this.FS.getSeparator() + this.nameD();
        Assert.assertThat((Object)this.FS.getPath(str, new String[0]).toString(), (Matcher)Is.is((Object)str));
    }

    @Test
    public void testGetPathNotStartingWithRootStringIsRelative() throws Exception {
        Assert.assertThat((Object)this.FS.getPath(this.nameC(), new String[0]), PathAbsolute.relative());
    }

    @Test
    public void testRelativize() {
        Path shrt = this.FS.getPath(this.nameA(), new String[0]);
        Path lng = this.FS.getPath(this.nameA(), this.nameB(), this.nameC());
        Assert.assertEquals((Object)lng, (Object)shrt.resolve(shrt.relativize(lng)));
    }

    @Test
    public void testRelativizeAbsolute() {
        Path root = this.defaultRoot();
        Path lng = root.resolve(this.nameA()).resolve(this.nameB()).resolve(this.nameC());
        Path lngRel = this.FS.getPath(this.nameA(), this.nameB(), this.nameC());
        Assert.assertEquals((Object)lngRel, (Object)root.relativize(lng));
    }

    @Test
    public void testRelativizeFromDefaultAbsoluteIsInverseOfToAbsoluteNormalize() {
        Path abs = this.absABC();
        Path defAbs = this.pathDefault().toAbsolutePath();
        Assert.assertThat((Object)defAbs.relativize(abs).toAbsolutePath().normalize(), (Matcher)Is.is((Object)abs));
    }

    @Test
    public void testUnnormalizedBasedOnFile() {
        Assert.assertThat((Object)this.absABC().resolve("..").resolve(this.nameC()).normalize(), (Matcher)Is.is((Object)this.absABC()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRelativizeAbsToRel() {
        Path shrt = this.FS.getPath(this.nameA(), new String[0]);
        Path lng = this.FS.getPath(this.nameA(), this.nameB(), this.nameC()).toAbsolutePath();
        shrt.relativize(lng);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRelativizeRelToAbs() {
        Path shrt = this.FS.getPath(this.nameA(), new String[0]).toAbsolutePath();
        Path lng = this.FS.getPath(this.nameA(), this.nameB(), this.nameC());
        shrt.relativize(lng);
    }

    @Test
    public void testRelativizePathWithOtherRootFails() {
        for (Path root : this.FS.getRootDirectories()) {
            if (root.equals(this.defaultRoot())) continue;
            Assert.assertThat(() -> root.relativize(this.defaultRoot()), ExceptionMatcher.throwsException(IllegalArgumentException.class));
        }
    }

    @Test
    public void testGetParent() {
        Path rel = this.FS.getPath(this.nameA(), new String[0]);
        Assert.assertThat((Object)rel.getParent(), (Matcher)CoreMatchers.nullValue());
        Path abs = this.FS.getPath(this.nameA(), this.nameC()).toAbsolutePath();
        Assert.assertEquals((Object)abs, (Object)abs.resolve(this.nameA()).getParent());
    }

    @Test
    public void testGetParentOfRootIsNull() throws Exception {
        Assert.assertThat((Object)this.defaultRoot().getParent(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testGetParentOfNameIsNull() throws Exception {
        Assert.assertThat((Object)this.relA().getParent(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testGetParentOfDefaultIsNull() throws Exception {
        Assert.assertThat((Object)this.pathDefault().getParent(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testGetParentOfLongerRelativeNameIsNotNull() throws Exception {
        Assert.assertThat((Object)this.relAB().getParent(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetParentIsInverseOfResolve() throws Exception {
        Assert.assertEquals((Object)this.relA(), (Object)this.relA().resolve(this.relB()).getParent());
        Assert.assertEquals((Object)this.relAB(), (Object)this.relAB().getParent().resolve(this.relB()));
    }

    @Test
    public void testGetParentOfRelativeIsRelative() throws Exception {
        Assert.assertThat((Object)this.relAB().getParent(), PathAbsolute.relative());
    }

    @Test
    public void testgetParentOfAbsoluteIsAbsolute() throws Exception {
        Assert.assertThat((Object)this.absAB().getParent(), PathAbsolute.absolute());
    }

    @Test
    public void testNormalizeWildAbsPaths() {
        Path abs = this.absAB();
        Assert.assertThat((Object)abs.resolve(".." + this.FS.getSeparator() + "bb" + this.FS.getSeparator() + ".." + this.FS.getSeparator() + ".").normalize(), (Matcher)Is.is((Object)abs.getParent()));
        Assert.assertEquals((Object)"", (Object)this.relA().resolve("..").normalize().toString());
    }

    @Test
    public void testNormalizeWildRelPaths() {
        Assert.assertEquals((Object)"", (Object)this.relA().resolve("..").normalize().toString());
    }

    @Test
    public void testNormalize1Dot() {
        Path path1 = this.relAB();
        Path path2 = path1.resolve(".");
        Assert.assertThat((Object)path1, (Matcher)CoreMatchers.not((Matcher)Is.is((Object)path2)));
        Assert.assertThat((Object)path1, (Matcher)Is.is((Object)path2.normalize()));
    }

    @Test
    public void testNormalize2Dots() {
        Path path1 = this.relAB();
        Path path2 = path1.resolve(this.nameD()).resolve("..");
        Assert.assertThat((Object)path1, (Matcher)CoreMatchers.not((Matcher)Is.is((Object)path2)));
        Assert.assertThat((Object)path1, (Matcher)Is.is((Object)path2.normalize()));
    }

    @Test
    public void testNormalizeIsIdempotent() throws Exception {
        Path path = this.relABC().resolve("..").resolve(this.nameC());
        Assert.assertThat((Object)path.normalize().normalize(), (Matcher)Is.is((Object)path.normalize()));
    }

    @Test
    public void testNormlizeParentOfRoot() {
        Assert.assertThat((Object)this.defaultRoot().resolve("..").normalize(), (Matcher)Is.is((Object)this.defaultRoot()));
    }

    @Test
    public void testNormalizeRelativePath() {
        Path rel = this.FS.getPath("..", new String[0]).resolve(this.nameA());
        Assert.assertThat((Object)rel.normalize(), (Matcher)Is.is((Object)rel));
    }

    @Test
    public void testNormalizeRelativePathEmptyHm() {
        Path rel = this.FS.getPath(this.nameA(), new String[0]).resolve("..");
        Assert.assertThat((Object)rel.normalize(), (Matcher)Is.is((Object)this.pathDefault()));
    }

    @Test
    public void testPathIterator() {
        int i = 0;
        for (Path kid : this.relABC()) {
            switch (i) {
                case 0: {
                    Assert.assertThat((Object)kid, (Matcher)Is.is((Object)this.relA()));
                    break;
                }
                case 1: {
                    Assert.assertThat((Object)kid, (Matcher)Is.is((Object)this.relB()));
                    break;
                }
                case 2: {
                    Assert.assertThat((Object)kid, (Matcher)Is.is((Object)this.relC()));
                    break;
                }
            }
            ++i;
        }
        Assert.assertEquals((long)3L, (long)i);
    }

    @Test
    public void testRootOfRelativeIsNull() {
        Assert.assertThat((Object)this.relABC().getRoot(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testRootIsOneOfTheRoots() {
        Assert.assertThat((Object)this.defaultRoot(), IteratorMatcher.isIn(this.FS.getRootDirectories()));
    }

    @Test
    public void testRootOfAbsolutePathIsAbsolute() throws Exception {
        Assert.assertThat((Object)this.absAB().getRoot(), PathAbsolute.absolute());
    }

    @Test
    public void testdefaultRootIsIdempotent() throws Exception {
        Assert.assertEquals((Object)this.defaultRoot(), (Object)this.defaultRoot().getRoot());
    }

    @Test
    public void testToAbsoluteProducesAnAbsolutePath() throws Exception {
        Assert.assertThat((Object)this.relABC().toAbsolutePath(), PathAbsolute.absolute());
    }

    @Test
    public void testToAbsoluteIsIdempotent() throws Exception {
        Assert.assertThat((Object)this.absAB(), (Matcher)Is.is((Object)this.absAB().toAbsolutePath()));
    }

    @Test
    public void testDefaultIsRelative() throws Exception {
        Assert.assertThat((Object)this.pathDefault(), PathAbsolute.relative());
    }

    @Test
    public void testRelativePathToStringDoesNotStartWithSeparator() throws Exception {
        Assert.assertThat((Object)this.relAB().toString().startsWith(this.FS.getSeparator()), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testPathWith2NamesHasSeparatorInToString() throws Exception {
        Assert.assertThat((Object)this.relAB().toString().contains(this.FS.getSeparator()), (Matcher)Is.is((Object)true));
    }

    @Test
    @Category(value={NotDefaultFileSystem.class})
    public void testPathsWithSamePathElementsButDifferentProviderAreDifferent() throws Exception {
        Path myABC = this.FS.getPath(this.nameA(), this.nameB(), this.nameC());
        Path otherABC = FileSystems.getDefault().getPath(this.nameA(), this.nameB(), this.nameC());
        Assert.assertThat((Object)myABC, (Matcher)CoreMatchers.not((Matcher)Is.is((Object)otherABC)));
    }

    @Test(expected=UnsupportedOperationException.class)
    @Category(value={NotDefaultFileSystem.class})
    public void testToFileOnNonDefaultFSThrows() throws Exception {
        this.absAB().toFile();
    }

    @Test
    public void testPathMatcherKnowsGlob() {
        try {
            this.FS.getPathMatcher("glob:*");
        }
        catch (UnsupportedOperationException exp) {
            Assert.fail((String)"glob should be supported");
        }
    }

    @Test
    public void testPathMatcherKnowsRegex() {
        try {
            this.FS.getPathMatcher("regex:.*");
        }
        catch (UnsupportedOperationException exp) {
            Assert.fail((String)"glob should be supported");
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPathMatcherThrowsOnUnknownSyntax() {
        this.FS.getPathMatcher("thisisarellysillysyntax:.*");
    }

    @Test
    public void testPathMatherRegex() throws Exception {
        PathMatcher pm = this.FS.getPathMatcher("regex:.*" + this.nameC() + ".*");
        Assert.assertThat((Object)pm.matches(this.FS.getPath(this.nameC(), new String[0]).toAbsolutePath()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)pm.matches(this.FS.getPath(this.nameC(), new String[0])), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)pm.matches(this.FS.getPath(this.nameC(), "da")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)pm.matches(this.FS.getPath("du", this.nameC(), "da")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)pm.matches(this.FS.getPath("du", this.nameC() + this.nameA(), "da")), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testPathMatherGlob() throws Exception {
        PathMatcher pm = this.FS.getPathMatcher("glob:*.{" + this.nameC() + "," + this.nameD() + "}");
        Assert.assertThat((Object)pm.matches(this.FS.getPath(this.nameE() + "." + this.nameD(), new String[0])), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)pm.matches(this.FS.getPath(this.nameE() + "." + this.nameC(), new String[0])), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)pm.matches(this.FS.getPath(this.nameE() + this.nameC(), new String[0])), (Matcher)Is.is((Object)false));
    }

    @Test(expected=ClassCastException.class)
    @Category(value={NotDefaultFileSystem.class})
    public void testCompareToDifferentProviderThrows() throws Exception {
        this.relABC().compareTo(FileSystems.getDefault().getPath(this.nameA(), new String[0]));
    }

    @Test
    public void testCompareToOfEqualPathsIs0() throws Exception {
        Assert.assertEquals((long)0L, (long)this.relABC().compareTo(this.relABC()));
    }

    @Test
    public void testCompareToShortPathIsPositive() throws Exception {
        Assert.assertTrue((this.relABC().compareTo(this.relAB()) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToLongetPathIsNegative() throws Exception {
        Assert.assertTrue((this.relAB().compareTo(this.relABC()) < 0 ? 1 : 0) != 0);
    }

    @Test
    @SuppressFBWarnings
    public void testPathIsImmutableToToAbsolute() throws Exception {
        Path rel = this.relAB();
        rel.toAbsolutePath();
        Assert.assertThat((Object)rel, PathAbsolute.relative());
    }

    @Test
    public void testPathIsImmutableToNormalize() throws Exception {
        Path unnom = this.relAB().resolve("..");
        Assert.assertTrue((boolean)unnom.toString().contains(".."));
    }

    @Test
    public void testNonExistingAbsolutePathIsNotAFile() throws IOException {
        Assert.assertThat((Object)Files.isRegularFile(this.relAB(), new LinkOption[0]), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testNonExistingRelativePathIsNotAFile() throws IOException {
        Assert.assertThat((Object)Files.isRegularFile(this.relA(), new LinkOption[0]), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testSeparatorIsNoFileName() {
        Path path = this.FS.getPath(this.nameD() + this.FS.getSeparator() + this.nameA(), new String[0]);
        for (Path elem : path) {
            Assert.assertThat((Object)elem.toString(), (Matcher)CoreMatchers.not((Matcher)Matchers.containsString((String)this.FS.getSeparator())));
        }
    }

    @Test(expected=NullPointerException.class)
    public void testResolveNull() throws IOException {
        this.relAB().resolve((String)null);
    }

    @Test(expected=NullPointerException.class)
    public void testNullPath() {
        this.FS.getPath(null, new String[0]);
    }

    public Path pathDefault() {
        return this.FS.getPath("", new String[0]);
    }

    public Path defaultRoot() {
        return this.FS.getPath("", new String[0]).toAbsolutePath().getRoot();
    }

    public Path relA() {
        return this.FS.getPath(this.nameA(), new String[0]);
    }

    public Path relB() {
        return this.FS.getPath(this.nameB(), new String[0]);
    }

    public Path relC() {
        return this.FS.getPath(this.nameC(), new String[0]);
    }

    public Path relD() {
        return this.FS.getPath(this.nameD(), new String[0]);
    }

    public Path relAB() {
        return this.FS.getPath(this.nameA(), this.nameB());
    }

    public Path relBC() {
        return this.FS.getPath(this.nameB(), this.nameC());
    }

    public Path relABC() {
        return this.FS.getPath(this.nameA(), this.nameB(), this.nameC());
    }

    public String nameA() {
        return this.name[0];
    }

    public String nameB() {
        return this.name[1];
    }

    public String nameC() {
        return this.name[2];
    }

    public String nameD() {
        return this.name[3];
    }

    public String nameE() {
        return this.name[4];
    }

    public Path absAB() {
        return this.defaultRoot().resolve(this.nameA()).resolve(this.nameB());
    }

    public Path absABC() {
        return this.defaultRoot().resolve(this.nameA()).resolve(this.nameB()).resolve(this.nameC());
    }

    public Path absD() {
        return this.defaultRoot().resolve(this.nameD());
    }
}

