/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.TestAnnotated;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class Tests00Setup {
    public final FSDescription description;
    protected final FileSystem FS;
    @Rule
    public TestAnnotated annotated = new TestAnnotated();
    @Rule
    public TestName testMethodName = new TestName();

    protected Tests00Setup(FSDescription description) {
        this.description = description;
        this.FS = description.get(Path.class, "playground").getFileSystem();
    }

    @Before
    public void setup() {
        this.description.markHits(this.testMethodName);
        String name = this.testMethodName.getMethodName();
        if (null != this.annotated.getCats()) {
            for (int i = 0; i < this.annotated.getCats().value().length; ++i) {
                Class top = this.annotated.getCats().value()[i];
                Assume.assumeThat((String)("test: " + name + " not run because FS is/has  not: " + top.getSimpleName()), (Object)this.description.provides(top), (Matcher)CoreMatchers.is((Object)true));
            }
        }
        Assume.assumeThat((String)("known bug: " + name), (Object)this.description.isBug(this.testMethodName), (Matcher)CoreMatchers.is((Object)false));
    }

    public Path getCommon() {
        return this.description.get(Path.class, "playground").resolve("niotestCommon");
    }
}

