/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.matcher;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class PathIsDirectory
extends TypeSafeMatcher<Path> {
    private final boolean is;

    public PathIsDirectory(boolean is) {
        this.is = is;
    }

    public boolean matchesSafely(Path path) {
        return this.is == Files.isDirectory(path, new LinkOption[0]);
    }

    public void describeTo(Description description) {
        description.appendText("path is a directory");
    }

    @Factory
    public static Matcher<Path> isDirectory() {
        return new PathIsDirectory(true);
    }

    @Factory
    public static Matcher<Path> isNotDirectory() {
        return new PathIsDirectory(false);
    }
}

