/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests20SymLinks;
import de.pfabulist.lindwurm.niotest.tests.topics.Readonly;
import de.pfabulist.lindwurm.niotest.tests.topics.SymLink;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests21Readonly
extends Tests20SymLinks {
    public Tests21Readonly(FSDescription capa) {
        super(capa);
    }

    @Test(expected=ReadOnlyFileSystemException.class)
    @Category(value={Readonly.class})
    public void testCanNotWriteToReadonlyFile() throws IOException {
        Files.write(this.getFile(), CONTENT, new OpenOption[0]);
    }

    @Test
    @Category(value={Readonly.class})
    public void testReadonyFileInReadonlyFS() throws IOException {
        MatcherAssert.assertThat((Object)this.getFile().getFileSystem().isReadOnly(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @Category(value={Readonly.class})
    public void testReadFromReadonly() throws IOException {
        Files.readAllBytes(this.getFile());
    }

    @Test
    @Category(value={Readonly.class})
    public void testReadAttributefromReadonly() throws IOException {
        Files.getLastModifiedTime(this.getFile(), new LinkOption[0]);
    }

    @Test(expected=ReadOnlyFileSystemException.class)
    @Category(value={Readonly.class})
    public void testSetAttributeToReadonlyThrows() throws IOException {
        Files.setLastModifiedTime(this.getFile(), FileTime.fromMillis(500L));
    }

    @Test
    @Category(value={Readonly.class})
    public void testReadDirFromReadonly() throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.getNonEmptyDir());){
            for (Path path : stream) {
            }
        }
    }

    @Test(expected=ReadOnlyFileSystemException.class)
    @Category(value={Readonly.class})
    public void testWriteNewFileToReadonly() throws IOException {
        Files.write(this.getNonEmptyDir().resolve("newfile"), CONTENT, new OpenOption[0]);
    }

    @Test(expected=ReadOnlyFileSystemException.class)
    @Category(value={Readonly.class})
    public void testMoveFileInReadonly() throws IOException {
        Files.move(this.getFile(), this.getNonEmptyDir().resolve("newfile"), new CopyOption[0]);
    }

    @Test(expected=ReadOnlyFileSystemException.class)
    @Category(value={Readonly.class})
    public void testCopyFileInReadonly() throws IOException {
        Files.copy(this.getFile(), this.getNonEmptyDir().resolve("newfile"), new CopyOption[0]);
    }

    @Test(expected=ReadOnlyFileSystemException.class)
    @Category(value={Readonly.class})
    public void testDeleteFileInReadonly() throws IOException {
        Files.delete(this.getFile());
    }

    @Test(expected=ReadOnlyFileSystemException.class)
    @Category(value={Readonly.class})
    public void testDeleteDirInReadonly() throws IOException {
        Files.delete(this.getEmptyDir());
    }

    @Test(expected=ReadOnlyFileSystemException.class)
    @Category(value={Readonly.class})
    public void testCreateHardLinkInReadonly() throws IOException {
        Files.createLink(this.getNonEmptyDir().resolve("newLink"), this.getFile());
    }

    @Test(expected=ReadOnlyFileSystemException.class)
    @Category(value={Readonly.class, SymLink.class})
    public void testCreateSymLinkInReadonly() throws IOException {
        Files.createSymbolicLink(this.getNonEmptyDir().resolve("newLink"), this.getFile(), new FileAttribute[0]);
    }

    @Test(expected=AccessDeniedException.class)
    @Category(value={Readonly.class})
    public void testCheckAccessDoesNotSupportesWrite() throws IOException {
        this.FS.provider().checkAccess(this.getFile(), AccessMode.WRITE);
    }
}

