/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.matcher.PathAbsolute;
import de.pfabulist.lindwurm.niotest.matcher.PathExists;
import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests09WrongProvider;
import de.pfabulist.lindwurm.niotest.tests.topics.Copy;
import de.pfabulist.lindwurm.niotest.tests.topics.Delete;
import de.pfabulist.lindwurm.niotest.tests.topics.FileStores;
import de.pfabulist.lindwurm.niotest.tests.topics.HardLink;
import de.pfabulist.lindwurm.niotest.tests.topics.MaxFilename;
import de.pfabulist.lindwurm.niotest.tests.topics.Move;
import de.pfabulist.lindwurm.niotest.tests.topics.Writable;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests10PathWithContent
extends Tests09WrongProvider {
    public static final String MAX_FILENAME_LENGTH = "maxFilenameLength";
    public static final String MAX_PATH_LENGTH = "maxPathLength";

    public Tests10PathWithContent(FSDescription capa) {
        super(capa);
    }

    @Test
    public void testIsSameFileOnEqualPath() throws IOException {
        Path file = this.getNonExistingPath();
        Assert.assertThat((Object)Files.isSameFile(file, file), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsSameFileWithUnnormalizedPath() throws IOException {
        Assert.assertThat((Object)this.FS.provider().isSameFile(this.getFile(), this.unnormalize(this.getFile())), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsSameFileWithRelativePath() throws IOException {
        Assert.assertThat((Object)this.FS.provider().isSameFile(this.getFile(), this.relativize(this.getFile())), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsSameFileOfSameContentDifferentPathIsNot() throws IOException {
        Assert.assertThat((Object)this.FS.provider().isSameFile(this.fileTA(), this.fileTB()), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testIsSameFileOfDifferentPathNonExistingFileIsNot() throws IOException {
        Assert.assertThat((Object)this.FS.provider().isSameFile(this.getFile(), this.getNonExistingPath()), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @Category(value={Writable.class})
    public void testWriteUnnormalized() throws IOException {
        Files.write(this.unnormalize(this.absTA()), CONTENT, standardOpen);
        Assert.assertThat((Object)Files.readAllBytes(this.absTA()), (Matcher)CoreMatchers.is((Object)CONTENT));
    }

    @Test
    public void testReadAttributesFromUnnormalizedPath() throws IOException {
        Path file = this.getFile();
        long size = Files.size(file);
        Assert.assertThat((Object)Files.size(this.unnormalize(file)), (Matcher)CoreMatchers.is((Object)size));
    }

    @Test
    public void testCheckAccessUnnormalizedPath() throws IOException {
        this.FS.provider().checkAccess(this.unnormalize(this.getFile()), new AccessMode[0]);
    }

    @Test
    public void testCheckAccessRelativePath() throws IOException {
        this.FS.provider().checkAccess(this.relativize(this.getFile()), new AccessMode[0]);
    }

    @Test
    public void testCheckAccessSupportesRead() throws IOException {
        try {
            this.FS.provider().checkAccess(this.getFile(), AccessMode.READ);
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    @Test
    @Category(value={Writable.class})
    public void testCheckAccessSupportesWrite() throws IOException {
        try {
            this.FS.provider().checkAccess(this.fileTAB(), AccessMode.WRITE);
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    @Test
    public void testCheckAccessSupportesExecute() throws IOException {
        try {
            this.FS.provider().checkAccess(this.getFile(), AccessMode.EXECUTE);
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    @Test(expected=NoSuchFileException.class)
    public void testCheckAccessNonExistingFile() throws IOException {
        this.FS.provider().checkAccess(this.getNonExistingPath(), new AccessMode[0]);
    }

    @Test
    @Category(value={Copy.class, Writable.class})
    public void testCopyUnnormalizedPath() throws IOException {
        this.FS.provider().copy(this.unnormalize(this.srcFile()), this.tgt(), new CopyOption[0]);
        Assert.assertThat((Object)Files.readAllBytes(this.tgt()), (Matcher)CoreMatchers.is((Object)CONTENT));
    }

    @Test
    @Category(value={Move.class, Writable.class})
    public void testMoveUnnormalizedPath() throws IOException {
        this.FS.provider().move(this.unnormalize(this.srcFile()), this.tgt(), new CopyOption[0]);
        Assert.assertThat((Object)Files.readAllBytes(this.tgt()), (Matcher)CoreMatchers.is((Object)CONTENT));
    }

    @Test
    @Category(value={Copy.class, Writable.class})
    public void testCopyToUnnormalizedPath() throws IOException {
        this.FS.provider().copy(this.srcFile(), this.unnormalize(this.tgt()), new CopyOption[0]);
        Assert.assertThat((Object)Files.readAllBytes(this.tgt()), (Matcher)CoreMatchers.is((Object)CONTENT));
    }

    @Test
    @Category(value={Move.class, Writable.class})
    public void testMoveToUnnormalizedPath() throws IOException {
        this.FS.provider().move(this.srcFile(), this.unnormalize(this.tgt()), new CopyOption[0]);
        Assert.assertThat((Object)Files.readAllBytes(this.tgt()), (Matcher)CoreMatchers.is((Object)CONTENT));
    }

    @Test
    @Category(value={Writable.class})
    public void testCreateDirectoryUnnormalizedPath() throws IOException {
        this.FS.provider().createDirectory(this.unnormalize(this.absTA()), new FileAttribute[0]);
        Assert.assertThat((Object)this.absTA(), PathExists.exists());
    }

    @Test
    @Category(value={Writable.class})
    public void testCreateDirectoryWithRelativePath() throws IOException {
        Files.createDirectory(this.relTA(), new FileAttribute[0]);
        Assert.assertThat((Object)this.relTA(), PathExists.exists());
    }

    @Test
    @Category(value={Delete.class, Writable.class})
    public void testDeleteUnnormalizedPath() throws IOException {
        this.FS.provider().delete(this.unnormalize(this.fileTAC()));
        Assert.assertThat((Object)this.absTAC(), (Matcher)CoreMatchers.not(PathExists.exists()));
    }

    @Test
    @Category(value={Delete.class, Writable.class})
    public void testDeleteIfExistsUnnormalizedPath() throws IOException {
        this.FS.provider().deleteIfExists(this.unnormalize(this.fileTAC()));
        Assert.assertThat((Object)this.absTAC(), (Matcher)CoreMatchers.not(PathExists.exists()));
    }

    @Test
    @Category(value={FileStores.class})
    public void testGetFileStoreUnnormalizedPath() throws IOException {
        this.FS.provider().getFileStore(this.unnormalize(this.getFile()));
    }

    @Test
    public void testIsHiddenUnnormalizedPath() throws IOException {
        this.FS.provider().isHidden(this.unnormalize(this.getFile()));
    }

    @Test
    public void testToRealPathReturnsAnAbsolutePath() throws Exception {
        Assert.assertThat((Object)this.relativize(this.getFile()).toRealPath(new LinkOption[0]), PathAbsolute.absolute());
    }

    @Test
    public void testToRealPathOfUnnormalizedResturnsAnNormalizedPath() throws Exception {
        Path real = this.unnormalize(this.getFile()).toRealPath(new LinkOption[0]);
        Assert.assertThat((Object)real.normalize(), (Matcher)CoreMatchers.is((Object)real));
    }

    @Test
    public void testToRealPathOfUnnormalizedIsSamePath() throws Exception {
        Path file = this.getFile();
        Assert.assertThat((Object)this.FS.provider().isSameFile(this.unnormalize(file).toRealPath(new LinkOption[0]), file), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test(expected=NoSuchFileException.class)
    public void testToRealPathOfNonExistingFileThrows() throws Exception {
        this.getNonExistingPath().toRealPath(new LinkOption[0]);
    }

    @Test
    @Category(value={MaxFilename.class})
    public void testMaxFilenameHasNoEffectOnPathConstruction() throws IOException {
        this.getNonEmptyDir().resolve(this.tooLongFileName());
    }

    @Test
    @Category(value={Writable.class, MaxFilename.class})
    public void testMaxFilenameWorks() throws IOException {
        Path loong = this.absTLongFilename();
        Files.createDirectories(loong.getParent(), new FileAttribute[0]);
        Files.write(loong, CONTENT, new OpenOption[0]);
    }

    @Test(expected=FileSystemException.class)
    @Category(value={Writable.class, MaxFilename.class})
    public void testMaxFilenameWriteTooLongThrows() throws IOException {
        Path loong = this.absTTooLongFilename();
        Files.createDirectories(loong.getParent(), new FileAttribute[0]);
        Files.write(loong, CONTENT, new OpenOption[0]);
    }

    @Test
    @Category(value={Writable.class, MaxFilename.class})
    public void testMaxFilenameDirOfLongWorks() throws IOException {
        Path loong = this.absTLongFilename();
        Files.createDirectories(loong, new FileAttribute[0]);
    }

    @Test(expected=FileSystemException.class)
    @Category(value={Writable.class, MaxFilename.class})
    public void testMaxFilenameDirTooLongThrows() throws IOException {
        Path loong = this.absTTooLongFilename();
        Files.createDirectories(loong, new FileAttribute[0]);
    }

    @Test
    @Category(value={Writable.class, Copy.class, MaxFilename.class})
    public void testMaxFilenameCopyWorks() throws IOException {
        Path loong = this.absTLongFilename();
        Files.copy(this.fileTAB(), loong, new CopyOption[0]);
    }

    @Test(expected=FileSystemException.class)
    @Category(value={Writable.class, Copy.class, MaxFilename.class})
    public void testMaxFilenameCopyTooLongThrows() throws IOException {
        Path loong = this.absTTooLongFilename();
        Files.copy(this.fileTAB(), loong, new CopyOption[0]);
    }

    @Test
    @Category(value={Writable.class, HardLink.class, MaxFilename.class})
    public void testMaxFilenameHardLinkWorks() throws IOException {
        Path loong = this.absTLongFilename();
        Files.createLink(loong, this.fileTAB());
    }

    @Test(expected=FileSystemException.class)
    @Category(value={HardLink.class, Writable.class, MaxFilename.class})
    public void testMaxFilenameHardLinkTooLongThrows() throws IOException {
        Path loong = this.absTTooLongFilename();
        Files.createLink(loong, this.fileTAB());
    }

    @Test
    @Category(value={Move.class, Writable.class, MaxFilename.class})
    public void testMaxFilenameMoveWorks() throws IOException {
        Path loong = this.absTLongFilename();
        Files.move(this.fileTAB(), loong, new CopyOption[0]);
    }

    @Test(expected=FileSystemException.class)
    @Category(value={Writable.class, Move.class, MaxFilename.class})
    public void testMaxFilenameMoveTooLongThrows() throws IOException {
        Path loong = this.absTTooLongFilename();
        Files.move(this.fileTAB(), loong, new CopyOption[0]);
    }

    public Path unnormalize(Path path) {
        return path.getParent().resolve("..").resolve(path.getParent().getFileName()).resolve(path.getFileName());
    }

    public Path absTLongFilename() {
        return this.FS.getPath(this.absTTooLongFilename().toString().substring(0, this.description.getInt(MAX_FILENAME_LENGTH)), new String[0]);
    }

    public Path absTTooLongFilename() {
        return this.absT().resolve(this.tooLongFileName());
    }

    public String tooLongFileName() {
        int maxFilenameLength = this.description.getInt(MAX_FILENAME_LENGTH);
        if (maxFilenameLength < 2) {
            throw new IllegalStateException("set max filename length");
        }
        String name = this.nameA();
        while (name.length() < maxFilenameLength + 2) {
            name = name + name;
        }
        return name;
    }
}

