/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.text.Strings;
import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests04Copy;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;

public abstract class Tests05URI
extends Tests04Copy {
    public Tests05URI(FSDescription capa) {
        super(capa);
    }

    @Test
    public void testFileSystemOfAPathIsTheConstructingOne() {
        Assert.assertEquals((Object)this.FS, (Object)this.FS.getPath("", new String[0]).getFileSystem());
    }

    @Test
    public void testSeparatorIsNotEmpty() {
        Assert.assertThat((Object)this.FS.getSeparator().isEmpty(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testSchemeIsNotEmpty() {
        Assert.assertThat((Object)this.FS.provider().getScheme().isEmpty(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testProviderGetFileSystemWithWrongSchemeFails() {
        this.FS.provider().getFileSystem(URI.create(this.FS.provider().getScheme() + "N:"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrongUriAtProviderNewFails() throws IOException {
        this.FS.provider().newFileSystem(URI.create(this.FS.provider().getScheme() + "N:"), Collections.EMPTY_MAP);
    }

    @Test
    public void testToUriOfRelativePathIsTheUriOfTheAbsolute() throws Exception {
        Assert.assertThat((Object)this.pathDefault().toAbsolutePath().toUri(), (Matcher)Is.is((Object)this.pathDefault().toUri()));
    }

    @Test
    public void testGetExistingFileSystem() throws IOException {
        FileSystem fs = this.FS.provider().getFileSystem(this.toURI(this.FS));
        Assert.assertThat((Object)fs, (Matcher)Is.is((Object)this.FS));
    }

    @Test(expected=FileSystemAlreadyExistsException.class)
    public void testNewFileSystemOfExistingThrows() throws IOException {
        this.FS.provider().newFileSystem(this.toURI(this.FS), this.getEnv());
    }

    @Test
    public void testPathToUriAndBackIsSame() {
        Path path = this.getNonExistingPath();
        URI uri = path.toUri();
        Assert.assertThat((Object)uri, (Matcher)IsNull.notNullValue());
        Path back = Paths.get(uri);
        Assert.assertThat((Object)back, (Matcher)Is.is((Object)path));
    }

    @Test
    public void testPathWithWitespaceToUri() {
        Path path = this.getEmptyDir().resolve("z z");
        URI uri = path.toUri();
        Assert.assertThat((Object)uri, (Matcher)IsNull.notNullValue());
    }

    @Test
    public void testPathWithWitespaceToUriAndBack() {
        Path path = this.getEmptyDir().resolve("z z");
        URI uri = path.toUri();
        Assert.assertThat((Object)uri, (Matcher)IsNull.notNullValue());
        Path back = Paths.get(uri);
        Assert.assertThat((Object)back, (Matcher)Is.is((Object)path));
    }

    public URI toURI(FileSystem fs) {
        Function toURI = (Function)this.description.props.get("fsToUri");
        if (toURI == null) {
            return Tests05URI.toURIWithRoot(fs);
        }
        return (URI)toURI.apply(fs);
    }

    public Map<String, ?> getEnv() {
        Map env = (Map)this.description.props.get("env");
        if (env == null) {
            return Collections.EMPTY_MAP;
        }
        return env;
    }

    public static URI toURIWithRoot(FileSystem fs) {
        URI ret = fs.getPath("", new String[0]).toAbsolutePath().getRoot().toUri();
        return ret;
    }

    public static URI toURIWithoutPath(FileSystem fs) {
        Path root = fs.getPath("", new String[0]).toAbsolutePath().getRoot();
        return URI.create(Strings.withoutSuffix((String)root.toUri().toString(), (String)root.toString()));
    }
}

