/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.collection.Sets;
import de.pfabulist.lindwurm.niotest.matcher.IteratorMatcher;
import de.pfabulist.lindwurm.niotest.matcher.PathExists;
import de.pfabulist.lindwurm.niotest.matcher.PathIsDirectory;
import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests03File;
import de.pfabulist.lindwurm.niotest.tests.topics.Attributes;
import de.pfabulist.lindwurm.niotest.tests.topics.Copy;
import de.pfabulist.lindwurm.niotest.tests.topics.CreationTime;
import de.pfabulist.lindwurm.niotest.tests.topics.Delete;
import de.pfabulist.lindwurm.niotest.tests.topics.Move;
import de.pfabulist.lindwurm.niotest.tests.topics.MoveWhile;
import de.pfabulist.lindwurm.niotest.tests.topics.SlowTest;
import de.pfabulist.lindwurm.niotest.tests.topics.Writable;
import de.pfabulist.unchecked.Filess;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableWithSize;
import org.hamcrest.number.OrderingComparison;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests04Copy
extends Tests03File {
    @Test
    @Category(value={Writable.class, Copy.class})
    public void testCopyDuplicatesTheContent() throws IOException {
        Files.copy(this.srcFile(), this.tgt(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.tgt()), (Matcher)CoreMatchers.is((Object)CONTENT));
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.srcFile()), (Matcher)CoreMatchers.is((Object)CONTENT));
    }

    @Test(expected=FileAlreadyExistsException.class)
    @Category(value={Writable.class, Copy.class})
    public void testCopyAlreadyThereWithoutOptionThrows() throws IOException {
        Files.write(this.tgt(), CONTENT, standardOpen);
        Files.copy(this.srcFile(), this.tgt(), new CopyOption[0]);
    }

    @Test
    @Category(value={Writable.class, Copy.class})
    public void testCopyAlreadyThereOverwrite() throws IOException {
        Files.write(this.tgt(), CONTENT_OTHER, new OpenOption[0]);
        Files.copy(this.srcFile(), this.tgt(), StandardCopyOption.REPLACE_EXISTING);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.tgt()), (Matcher)CoreMatchers.is((Object)CONTENT));
    }

    @Test
    @Category(value={Writable.class, Copy.class})
    public void testCopyViaProvider() throws IOException {
        this.srcFile().getFileSystem().provider().copy(this.srcFile(), this.tgt(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.tgt()), (Matcher)CoreMatchers.is((Object)CONTENT));
    }

    @Test
    @Category(value={Writable.class, Copy.class, SlowTest.class, Attributes.class})
    public void testCopyResultHasCreationTime() throws Exception {
        FileTime before = Files.getLastModifiedTime(this.srcFile(), new LinkOption[0]);
        this.waitForAttribute();
        Files.copy(this.srcFile(), this.tgt(), new CopyOption[0]);
        FileTime created = Files.readAttributes(this.tgt(), BasicFileAttributes.class, new LinkOption[0]).creationTime();
        MatcherAssert.assertThat((Object)created, (Matcher)OrderingComparison.greaterThan((Comparable)before));
    }

    @Test
    @Category(value={Writable.class, Copy.class, SlowTest.class, Attributes.class})
    public void testCopyAttributesCheckModifiedTime() throws Exception {
        BasicFileAttributes srcAttis = Files.readAttributes(this.srcFile(), BasicFileAttributes.class, new LinkOption[0]);
        this.waitForAttribute();
        Files.copy(this.srcFile(), this.tgt(), StandardCopyOption.COPY_ATTRIBUTES);
        BasicFileAttributes tgtAttis = Files.readAttributes(this.tgt(), BasicFileAttributes.class, new LinkOption[0]);
        MatcherAssert.assertThat((Object)tgtAttis.lastModifiedTime(), (Matcher)CoreMatchers.is((Object)srcAttis.lastModifiedTime()));
    }

    @Test
    @Category(value={Writable.class, Copy.class, SlowTest.class, Attributes.class})
    public void testCopyDoesNotModifyOriginal() throws Exception {
        FileTime beforeCopy = Files.getLastModifiedTime(this.srcFile(), new LinkOption[0]);
        this.waitForAttribute();
        Files.copy(this.srcFile(), this.tgt(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)this.srcFile(), PathExists.exists());
        Assert.assertEquals((Object)beforeCopy, (Object)Files.getLastModifiedTime(this.srcFile(), new LinkOption[0]));
    }

    @Test
    @Category(value={Writable.class, Copy.class})
    public void testModifyOriginalAfterCopyDoesNotChangeTarget() throws Exception {
        Files.copy(this.srcFile(), this.tgt(), new CopyOption[0]);
        Files.write(this.srcFile(), CONTENT_OTHER, new OpenOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.tgt()), (Matcher)CoreMatchers.is((Object)CONTENT));
    }

    @Test
    @Category(value={Writable.class, Move.class})
    public void testMoveCreatesNewFileDeletesOriginal() throws IOException {
        Files.move(this.srcFile(), this.tgt(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)this.src(), (Matcher)CoreMatchers.not(PathExists.exists()));
    }

    @Test(expected=FileAlreadyExistsException.class)
    @Category(value={Writable.class, Move.class})
    public void testMoveAlreadyThereThrows() throws IOException {
        Files.write(this.tgt(), CONTENT_OTHER, standardOpen);
        Files.move(this.srcFile(), this.tgt(), new CopyOption[0]);
    }

    @Test
    @Category(value={Writable.class, Move.class})
    public void testFailedMoveLeavesOriginal() throws Exception {
        Files.write(this.tgt(), CONTENT, standardOpen);
        try {
            Files.move(this.srcFile(), this.tgt(), new CopyOption[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)this.src(), PathExists.exists());
    }

    @Test
    @Category(value={Writable.class, Move.class})
    public void testMoveAlreadyThereOverwrite() throws Exception {
        Files.write(this.tgt(), CONTENT_OTHER, standardOpen);
        Files.move(this.srcFile(), this.tgt(), StandardCopyOption.REPLACE_EXISTING);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.tgt()), (Matcher)CoreMatchers.is((Object)CONTENT));
        MatcherAssert.assertThat((Object)this.src(), (Matcher)CoreMatchers.not(PathExists.exists()));
    }

    @Test(expected=FileAlreadyExistsException.class)
    @Category(value={Writable.class, Move.class})
    public void testMoveAlreadyThereDirectory() throws Exception {
        Files.createDirectory(this.tgt(), new FileAttribute[0]);
        Files.move(this.srcFile(), this.tgt(), new CopyOption[0]);
    }

    @Test
    @Category(value={Writable.class, Move.class})
    public void testMoveAlreadyThereDirectoryOverwrite() throws Exception {
        Files.createDirectory(this.tgt(), new FileAttribute[0]);
        Files.move(this.srcFile(), this.tgt(), StandardCopyOption.REPLACE_EXISTING);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.tgt()), (Matcher)CoreMatchers.is((Object)CONTENT));
        MatcherAssert.assertThat((Object)this.src(), (Matcher)CoreMatchers.not(PathExists.exists()));
    }

    @Test(expected=DirectoryNotEmptyException.class)
    @Category(value={Writable.class, Move.class})
    public void testMoveAlreadyThereNonEmptyDirectoryOverwrite() throws Exception {
        Files.createDirectory(this.tgt(), new FileAttribute[0]);
        Files.write(this.tgt().resolve(this.nameB()), CONTENT, new OpenOption[0]);
        Files.move(this.srcFile(), this.tgt(), StandardCopyOption.REPLACE_EXISTING);
    }

    @Test
    @Category(value={Writable.class, Move.class})
    public void testMoveViaProvider() throws IOException {
        this.srcFile().getFileSystem().provider().move(this.src(), this.tgt(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)this.src(), (Matcher)CoreMatchers.not(PathExists.exists()));
    }

    @Test
    @Category(value={Writable.class, Move.class})
    public void testMoveEmptyDir() throws IOException {
        Files.move(this.srcDir(), this.tgt(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)this.tgt(), PathIsDirectory.isDirectory());
    }

    @Test
    @Category(value={Writable.class, Move.class})
    public void testMoveNonEmptyDir() throws IOException {
        Files.write(this.srcDir().resolve(this.nameB()), CONTENT, new OpenOption[0]);
        Files.write(this.src().resolve(this.nameC()), CONTENT, new OpenOption[0]);
        Files.createDirectory(this.src().resolve(this.nameA()), new FileAttribute[0]);
        Files.write(this.src().resolve(this.nameA()).resolve(this.nameA()), CONTENT, new OpenOption[0]);
        Files.move(this.src(), this.tgt(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)this.tgt().resolve(this.nameA()).resolve(this.nameA()), PathExists.exists());
    }

    @Test(expected=IOException.class)
    @Category(value={Writable.class, Move.class})
    public void testMoveIntoItself() throws IOException {
        Files.move(this.srcDir(), this.srcDir().resolve("tgt"), new CopyOption[0]);
    }

    @Test(expected=FileSystemException.class)
    @Category(value={Writable.class, Move.class})
    public void testMoveRoot() throws IOException {
        Files.move(this.defaultRoot(), this.tgt(), new CopyOption[0]);
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Move.class, Attributes.class})
    public void testMoveKeepsLastModifiedTime() throws IOException, InterruptedException {
        FileTime modi = Files.getLastModifiedTime(this.srcFile(), new LinkOption[0]);
        this.waitForAttribute();
        Files.move(this.src(), this.tgt(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.getLastModifiedTime(this.tgt(), new LinkOption[0]), (Matcher)CoreMatchers.is((Object)modi));
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Move.class, Attributes.class})
    public void testMoveChangesModifiedTimeOfParent() throws IOException, InterruptedException {
        FileTime modi = Files.getLastModifiedTime(this.srcFile().getParent(), new LinkOption[0]);
        this.waitForAttribute();
        Files.move(this.src(), this.tgt(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.getLastModifiedTime(this.src().getParent(), new LinkOption[0]), (Matcher)OrderingComparison.greaterThan((Comparable)modi));
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Move.class, Attributes.class})
    public void testMoveChangesModifiedTimeOfTargetsParent() throws IOException, InterruptedException {
        FileTime modi = Files.getLastModifiedTime(this.tgt().getParent(), new LinkOption[0]);
        this.waitForAttribute();
        Files.move(this.srcFile(), this.tgt(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.getLastModifiedTime(this.tgt().getParent(), new LinkOption[0]), (Matcher)OrderingComparison.greaterThan((Comparable)modi));
    }

    @Test
    @Category(value={Writable.class, Copy.class})
    public void testCopyDirCreatesADirWithTheTargetName() throws Exception {
        Files.copy(this.srcDir(), this.tgt(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)this.tgt(), PathExists.exists());
    }

    @Test
    @Category(value={Writable.class, Copy.class})
    public void testCopyNonEmptyDirDoesNotCopyKids() throws Exception {
        Files.write(this.srcDir().resolve(this.nameB()), CONTENT, new OpenOption[0]);
        Files.copy(this.src(), this.tgt(), new CopyOption[0]);
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(this.tgt());){
            MatcherAssert.assertThat(kids, (Matcher)IsIterableWithSize.iterableWithSize((int)0));
        }
    }

    @Test
    @Category(value={Writable.class, Copy.class})
    public void testCopyDirReplaceExistingOverwritesFile() throws Exception {
        Files.write(this.tgt(), CONTENT, standardOpen);
        Files.copy(this.srcDir(), this.tgt(), StandardCopyOption.REPLACE_EXISTING);
        MatcherAssert.assertThat((Object)this.tgt(), PathIsDirectory.isDirectory());
    }

    @Test(expected=DirectoryNotEmptyException.class)
    @Category(value={Writable.class, Copy.class})
    public void testCopyFileReplaceExistingDoesNotOverwriteExistingNonEmptyDir() throws Exception {
        Path targetKid = this.tgt().resolve("targetKid");
        Files.createDirectories(this.tgt(), new FileAttribute[0]);
        Files.write(targetKid, CONTENT, new OpenOption[0]);
        Files.copy(this.srcFile(), this.tgt(), StandardCopyOption.REPLACE_EXISTING);
    }

    @Test
    @Category(value={Writable.class, Copy.class})
    public void testCopyFileReplaceExistingOverwritesExistingDir() throws Exception {
        Files.createDirectories(this.tgt(), new FileAttribute[0]);
        Files.copy(this.srcFile(), this.tgt(), StandardCopyOption.REPLACE_EXISTING);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.tgt()), (Matcher)CoreMatchers.is((Object)CONTENT));
    }

    @Test
    @Category(value={Writable.class, Copy.class})
    public void testCopyIntoItself() throws IOException {
        Path tgt = this.srcDir().resolve("tgt");
        Files.copy(tgt.getParent(), tgt, new CopyOption[0]);
        MatcherAssert.assertThat((Object)tgt, PathExists.exists());
    }

    @Test
    @Category(value={Writable.class, Delete.class})
    public void testDeleteDeletes() throws Exception {
        Files.delete(this.fileTA());
        MatcherAssert.assertThat((Object)this.absTA(), (Matcher)CoreMatchers.not(PathExists.exists()));
    }

    @Test
    @Category(value={Writable.class, Delete.class})
    public void testDeleteDirRemovesItFromParentsKids() throws IOException, InterruptedException {
        Path dir = this.dirTB();
        Files.delete(dir);
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(dir.getParent());){
            MatcherAssert.assertThat((Object)dir, (Matcher)CoreMatchers.not(IteratorMatcher.isIn(kids)));
        }
    }

    @Test
    @Category(value={Writable.class, Delete.class})
    public void testDeleteFileRemovesItFromParentsKids() throws IOException, InterruptedException {
        Path file = this.fileTAB();
        Files.write(file, CONTENT, standardOpen);
        Files.delete(file);
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(file.getParent());){
            MatcherAssert.assertThat((Object)file, (Matcher)CoreMatchers.not(IteratorMatcher.isIn(kids)));
        }
    }

    @Test(expected=DirectoryNotEmptyException.class)
    @Category(value={Writable.class, Delete.class})
    public void testDeleteNonEmptyDirectoryThrows() throws IOException {
        Files.delete(this.fileTAB().getParent());
    }

    @Test
    @Category(value={Writable.class, Delete.class})
    public void testDeleteEmptyDir() throws IOException {
        Files.delete(this.dirTA());
        MatcherAssert.assertThat((Object)this.absTA(), (Matcher)CoreMatchers.not(PathExists.exists()));
    }

    @Test
    @Category(value={Writable.class, Delete.class})
    public void testDeleteEmptiedDir() throws IOException {
        Path file = this.fileTAB();
        Files.delete(file);
        Files.delete(file.getParent());
        MatcherAssert.assertThat((Object)file.getParent(), (Matcher)CoreMatchers.not(PathExists.exists()));
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Delete.class, Attributes.class})
    public void testDeleteFileChangesParentsModificationTime() throws IOException, InterruptedException {
        FileTime modified = Files.getLastModifiedTime(this.fileTAB().getParent(), new LinkOption[0]);
        this.waitForAttribute();
        Files.delete(this.fileTAB());
        MatcherAssert.assertThat((Object)Files.getLastModifiedTime(this.absTA(), new LinkOption[0]), (Matcher)OrderingComparison.greaterThan((Comparable)modified));
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Delete.class, Attributes.class, CreationTime.class})
    public void testDeleteFileDoesNotChangeParentCreationTime() throws IOException, InterruptedException {
        Path file = this.fileTAB();
        Path parent = file.getParent();
        FileTime created = Files.readAttributes(parent, BasicFileAttributes.class, new LinkOption[0]).creationTime();
        this.waitForAttribute();
        Files.delete(file);
        MatcherAssert.assertThat((Object)Files.readAttributes(parent, BasicFileAttributes.class, new LinkOption[0]).creationTime(), (Matcher)CoreMatchers.is((Object)created));
    }

    @Test
    @Category(value={SlowTest.class, Writable.class, Delete.class, Attributes.class})
    public void testDeleteDirChangesParentsModificationTime() throws IOException, InterruptedException {
        FileTime modified = Files.getLastModifiedTime(this.dirTAB().getParent(), new LinkOption[0]);
        this.waitForAttribute();
        Files.delete(this.absTAB());
        MatcherAssert.assertThat((Object)Files.getLastModifiedTime(this.absTA(), new LinkOption[0]), (Matcher)OrderingComparison.greaterThan((Comparable)modified));
    }

    @Test(expected=NoSuchFileException.class)
    @Category(value={Writable.class, Delete.class})
    public void testDeleteNonExistingFileThrows() throws IOException {
        Files.delete(this.absTA());
    }

    @Test(expected=Exception.class)
    @Category(value={Writable.class, Delete.class})
    public void testDeleteRootThrowa() throws IOException {
        Files.delete(this.defaultRoot());
    }

    @Test
    @Category(value={Writable.class, Delete.class})
    public void testDeleteRecreate() throws IOException {
        Files.delete(this.fileTAB());
        Files.write(this.absTAB(), CONTENT, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.absTAB()), (Matcher)CoreMatchers.is((Object)CONTENT));
    }

    @Test
    @Category(value={Writable.class, Delete.class})
    public void testDeleteIfExistsRecreate() throws IOException {
        Files.deleteIfExists(this.fileTAB());
        Files.write(this.absTAB(), CONTENT, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.absTAB()), (Matcher)CoreMatchers.is((Object)CONTENT));
    }

    @Test
    @Category(value={Writable.class, Move.class})
    public void testRenameSourceIsNoLongerKid() throws IOException {
        Files.move(this.srcFile(), this.src().getParent().resolve("tgt"), new CopyOption[0]);
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(this.src().getParent());){
            MatcherAssert.assertThat((Object)this.src(), (Matcher)CoreMatchers.not(IteratorMatcher.isIn(kids)));
        }
    }

    @Test
    @Category(value={Writable.class, Move.class})
    public void testRenameTargetIsKid() throws IOException {
        Path tgt = this.src().getParent().resolve("tgt");
        Files.move(this.srcFile(), tgt, new CopyOption[0]);
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(this.src().getParent());){
            MatcherAssert.assertThat((Object)tgt, IteratorMatcher.isIn(kids));
        }
    }

    @Test(expected=NoSuchFileException.class)
    @Category(value={Writable.class, Move.class})
    public void testMoveToFileWithNonExistingParentThrows() throws IOException {
        Files.move(this.srcFile(), this.absTAB(), new CopyOption[0]);
    }

    @Test
    @Category(value={Writable.class, Delete.class, MoveWhile.class})
    public void testDeleteWhileReading() throws IOException {
        Path file = this.fileTA();
        try (SeekableByteChannel ch = Files.newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);){
            Files.delete(file);
            MatcherAssert.assertThat((Object)file, (Matcher)Matchers.not(PathExists.exists()));
            int i = ch.read(ByteBuffer.allocate(2));
            MatcherAssert.assertThat((Object)i, (Matcher)CoreMatchers.is((Object)2));
        }
        MatcherAssert.assertThat((Object)file, (Matcher)Matchers.not(PathExists.exists()));
    }

    @Test
    @Category(value={Writable.class, Delete.class, MoveWhile.class})
    public void testDeleteWhileWriting() throws IOException {
        Path file = this.fileTA();
        try (SeekableByteChannel ch = Files.newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE}), new FileAttribute[0]);){
            Files.delete(file);
            MatcherAssert.assertThat((Object)file, (Matcher)Matchers.not(PathExists.exists()));
            int n = ch.write(ByteBuffer.wrap(CONTENT_OTHER));
        }
        MatcherAssert.assertThat((Object)file, (Matcher)Matchers.not(PathExists.exists()));
    }

    @Test
    @Category(value={Writable.class, Delete.class, MoveWhile.class})
    public void testMoveWhileWriting() throws IOException {
        Path file = this.fileTA();
        try (SeekableByteChannel ch = Files.newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE}), new FileAttribute[0]);){
            Files.move(file, this.absTB(), new CopyOption[0]);
            MatcherAssert.assertThat((Object)file, (Matcher)Matchers.not(PathExists.exists()));
            ByteBuffer bb = ByteBuffer.wrap(CONTENT_OTHER);
            ch.write(bb);
        }
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.absTB()), (Matcher)CoreMatchers.is((Object)CONTENT_OTHER));
    }

    public Tests04Copy(FSDescription capa) {
        super(capa);
    }

    protected Path src() {
        return this.absT().resolve("src");
    }

    protected Path srcFile() {
        if (Files.exists(this.src(), new LinkOption[0])) {
            return this.src();
        }
        Filess.write((Path)this.src(), (byte[])CONTENT, (OpenOption[])new OpenOption[0]);
        return this.src();
    }

    protected Path srcDir() {
        Path ret = this.src();
        if (Files.exists(ret, new LinkOption[0])) {
            return ret;
        }
        Filess.createDirectory((Path)ret, (FileAttribute[])new FileAttribute[0]);
        return ret;
    }

    protected Path tgt() {
        Path ret = this.absT().resolve("tgt");
        return ret;
    }
}

