/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.matcher;

import java.nio.file.attribute.FileTime;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class FileTimeMatcher
extends TypeSafeMatcher<FileTime> {
    private final FileTime base;

    public FileTimeMatcher(FileTime base) {
        this.base = base;
    }

    public boolean matchesSafely(FileTime ft) {
        return FileTime.fromMillis(this.base.toMillis() - 1000L).compareTo(ft) <= 0 && ft.compareTo(FileTime.fromMillis(this.base.toMillis() + 1000L)) <= 0;
    }

    public void describeTo(Description description) {
        description.appendText("filetime is not in [" + this.base + " -1s, " + this.base + " + 1s] ");
    }

    @Factory
    public static Matcher<FileTime> isCloseTo(FileTime other) {
        return new FileTimeMatcher(other);
    }
}

