/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests.descriptionbuilders;

import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.AttributeBuilder;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.ClosablePlayground;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.FSCreation;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.FileChannelBuilder;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.FileStoreBuilder;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.HardLinksBuilder;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.OtherProviderPlayground;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.PathConstraints;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.Playground;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.ReadonlyPlayground;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.SymlinkBuilder;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.TimeBuilder;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.UnixBuilder;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.WatchBuilder;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.WindowsBuilder;

public class CombinedBuilder {
    private final FSDescription descr;

    public CombinedBuilder(FSDescription descr) {
        this.descr = descr;
    }

    public static CombinedBuilder build() {
        return new CombinedBuilder(new FSDescription());
    }

    public FSDescription done() {
        return this.descr;
    }

    public CombinedBuilder bug(String name, boolean actually) {
        if (actually) {
            this.descr.addBug(name);
        }
        return this;
    }

    public CombinedBuilder bug(String name) {
        return this.bug(name, true);
    }

    public CombinedBuilder nitpick(String name, String comment) {
        return this.bug(name, true);
    }

    public CombinedBuilder nitpickScheme(String scheme, String comment) {
        return this.bugScheme(scheme, true);
    }

    public CombinedBuilder bugScheme(String scheme, boolean val) {
        if (val) {
            this.descr.addBugScheme(scheme);
        }
        return this;
    }

    public ClosablePlayground<CombinedBuilder> closable() {
        return new ClosablePlayground<CombinedBuilder>(this.descr, this);
    }

    public Playground<CombinedBuilder> playground() {
        return new Playground<CombinedBuilder>(this.descr, this);
    }

    public ReadonlyPlayground<CombinedBuilder> readonlyPlayground() {
        return new ReadonlyPlayground<CombinedBuilder>(this.descr, this);
    }

    public OtherProviderPlayground<CombinedBuilder> otherProviderplayground() {
        return new OtherProviderPlayground<CombinedBuilder>(this.descr, this);
    }

    public WatchBuilder<CombinedBuilder> watchable() {
        return new WatchBuilder<CombinedBuilder>(this.descr, this);
    }

    public TimeBuilder<CombinedBuilder> time() {
        return new TimeBuilder<CombinedBuilder>(this.descr, this);
    }

    public PathConstraints<CombinedBuilder> pathConstraints() {
        return new PathConstraints<CombinedBuilder>(this.descr, this);
    }

    public UnixBuilder<CombinedBuilder> unix() {
        return new UnixBuilder<CombinedBuilder>(this.descr, this);
    }

    public WindowsBuilder<CombinedBuilder> windows() {
        return new WindowsBuilder<CombinedBuilder>(this.descr, this);
    }

    public SymlinkBuilder<CombinedBuilder> symlinks() {
        return new SymlinkBuilder<CombinedBuilder>(this.descr, this);
    }

    public HardLinksBuilder<CombinedBuilder> hardlinks() {
        return new HardLinksBuilder<CombinedBuilder>(this.descr, this);
    }

    public FSCreation<CombinedBuilder> fsCreation() {
        return new FSCreation<CombinedBuilder>(this.descr, this);
    }

    public FileStoreBuilder<CombinedBuilder> fileStores() {
        return new FileStoreBuilder<CombinedBuilder>(this.descr, this);
    }

    public FileChannelBuilder<CombinedBuilder> fileChannel() {
        return new FileChannelBuilder<CombinedBuilder>(this.descr, this);
    }

    public AttributeBuilder<CombinedBuilder> attributes() {
        return new AttributeBuilder<CombinedBuilder>(this.descr, this);
    }
}

