/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests.attributes;

import de.pfabulist.lindwurm.niotest.tests.topics.Topic;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class AttributeDescription {
    private final String name;
    private final Class<? extends BasicFileAttributeView> viewType;
    private final Class<? extends BasicFileAttributes> readType;
    Map<String, Function<BasicFileAttributes, Object>> read = new HashMap<String, Function<BasicFileAttributes, Object>>();
    Map<String, BiConsumer<BasicFileAttributeView, Object>> view = new HashMap<String, BiConsumer<BasicFileAttributeView, Object>>();
    private final Class<? extends Topic> topic;

    public AttributeDescription(Class<? extends Topic> topic, String name, Class<? extends BasicFileAttributeView> bfav, Class<? extends BasicFileAttributes> bfas) {
        this.topic = topic;
        this.name = name;
        this.viewType = bfav;
        this.readType = bfas;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getAttributeNames() {
        return this.read.keySet();
    }

    public Class<? extends BasicFileAttributeView> getViewType() {
        return this.viewType;
    }

    public Class<? extends BasicFileAttributes> getReadType() {
        return this.readType;
    }

    public <R extends BasicFileAttributes> Object get(R bfas, String attiName) {
        if (!this.read.containsKey(attiName)) {
            throw new IllegalArgumentException("no such atti " + attiName);
        }
        return this.read.get(attiName).apply(bfas);
    }

    public Class<? extends Topic> getTopic() {
        return this.topic;
    }

    void addReader(String name, Function<BasicFileAttributes, Object> getter) {
        this.read.put(name, getter);
    }
}

