/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests12DifferentFS;
import de.pfabulist.lindwurm.niotest.tests.topics.FileStores;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyIterable;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests13FileStore
extends Tests12DifferentFS {
    public Tests13FileStore(FSDescription capa) {
        super(capa);
    }

    @Test
    @Category(value={FileStores.class})
    public void testFileStoreIterable() {
        MatcherAssert.assertThat(this.FS.getFileStores(), (Matcher)Matchers.not((Matcher)IsEmptyIterable.emptyIterable()));
    }

    @Test(expected=NoSuchFileException.class)
    @Category(value={FileStores.class})
    public void testGetFileStoreOfNonExistent() throws IOException {
        Files.getFileStore(this.absTA());
    }

    @Test
    @Category(value={FileStores.class})
    public void testFileStoresHaveAName() {
        for (FileStore store : this.FS.getFileStores()) {
            MatcherAssert.assertThat((Object)store.name(), (Matcher)Matchers.notNullValue());
        }
    }

    @Test
    @Category(value={FileStores.class})
    public void testFileStoresHaveAType() {
        for (FileStore store : this.FS.getFileStores()) {
            MatcherAssert.assertThat((Object)store.type(), (Matcher)Matchers.notNullValue());
        }
    }

    @Test
    @Category(value={FileStores.class})
    public void testFileStoreTotalSpaceIsNonNegative() throws IOException {
        for (FileStore store : this.FS.getFileStores()) {
            MatcherAssert.assertThat((Object)store.getTotalSpace(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
        }
    }

    @Test
    @Category(value={FileStores.class})
    public void testFileStoreUsableSpaceIsSmallerThanTotal() throws IOException {
        for (FileStore store : this.FS.getFileStores()) {
            MatcherAssert.assertThat((Object)store.getTotalSpace(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(store.getUsableSpace())));
        }
    }

    @Test
    @Category(value={FileStores.class})
    public void testFileStoreUnallocatedSpaceIsSmallerUsableSpace() throws IOException {
        for (FileStore store : this.FS.getFileStores()) {
            MatcherAssert.assertThat((Object)store.getUnallocatedSpace(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(store.getUsableSpace())));
        }
    }
}

