/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.collection.Ref;
import de.pfabulist.kleinod.collection.Sets;
import de.pfabulist.lindwurm.niotest.matcher.WatchEventMatcher;
import de.pfabulist.lindwurm.niotest.matcher.WatchKeyMatcher;
import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests10PathWithContent;
import de.pfabulist.lindwurm.niotest.tests.topics.Closable;
import de.pfabulist.lindwurm.niotest.tests.topics.SlowTest;
import de.pfabulist.lindwurm.niotest.tests.topics.Watchable;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests11Watcher
extends Tests10PathWithContent {
    public static final String WATCH_DELAY = "watchDelay";
    private WatchService watchService;

    public Tests11Watcher(FSDescription capa) {
        super(capa);
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class})
    public void testWatchADelete() throws Exception {
        Path toBeDeleted = this.watchedFileA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_DELETE);
        Files.delete(toBeDeleted);
        Thread.sleep(4000L);
        MatcherAssert.assertThat((Object)this.watchServicePoll(), WatchKeyMatcher.correctKey(toBeDeleted, StandardWatchEventKinds.ENTRY_DELETE));
    }

    @Test(timeout=20000L)
    @Category(value={SlowTest.class, Watchable.class})
    public void testWatchADeleteTake() throws Exception {
        Path toBeDeleted = this.watchedFileA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_DELETE);
        Files.delete(toBeDeleted);
        MatcherAssert.assertThat((Object)this.getWatchService().take(), WatchKeyMatcher.correctKey(toBeDeleted, StandardWatchEventKinds.ENTRY_DELETE));
    }

    @Test(timeout=30000L)
    @Category(value={SlowTest.class, Watchable.class})
    public void testWatchADeletePollWithTimeOut() throws Exception {
        Path toBeDeleted = this.watchedFileA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_DELETE);
        Files.delete(toBeDeleted);
        MatcherAssert.assertThat((Object)this.waitForWatchService().poll(1000L, TimeUnit.MILLISECONDS), WatchKeyMatcher.correctKey(toBeDeleted, StandardWatchEventKinds.ENTRY_DELETE));
    }

    @Test(timeout=30000L)
    @Category(value={SlowTest.class, Watchable.class})
    public void testWatchPollWithTimeoutTimesOut() throws Exception {
        this.watcherSetup(StandardWatchEventKinds.ENTRY_DELETE);
        this.getWatchService().poll(1000L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=ClosedWatchServiceException.class)
    @Category(value={Watchable.class})
    public void testRegisterOnClosedWatchService() throws IOException {
        WatchService watcher = this.FS.newWatchService();
        watcher.close();
        this.dirTAB().register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
    }

    @Test(expected=ClosedWatchServiceException.class)
    @Category(value={Watchable.class, Closable.class})
    public void testRegisterWatchServiceOfClosedFS() throws Exception {
        this.getClosedDirB().register(this.getClosedFSWatchService(), StandardWatchEventKinds.ENTRY_DELETE);
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class})
    public void testWatchADeleteFromAMove() throws Exception {
        Path toBeMoved = this.watchedFileA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_DELETE);
        Files.move(toBeMoved, this.absTA(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)this.watchServicePoll(), WatchKeyMatcher.correctKey(toBeMoved, StandardWatchEventKinds.ENTRY_DELETE));
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class})
    public void testWatchAModify() throws Exception {
        Path toBeModified = this.watchedFileA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_MODIFY);
        Files.write(toBeModified, CONTENT_OTHER, new OpenOption[0]);
        MatcherAssert.assertThat((Object)this.watchServicePoll(), WatchKeyMatcher.correctKey(toBeModified, StandardWatchEventKinds.ENTRY_MODIFY));
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class})
    public void testWatchReadIsNotModify() throws Exception {
        Path toBeModified = this.watchedFileA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_MODIFY);
        Files.readAllBytes(toBeModified);
        MatcherAssert.assertThat((Object)this.watchServicePoll(), (Matcher)Matchers.nullValue());
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class})
    public void testWatchForOtherEventCatchesNothing() throws Exception {
        Path toBeModified = this.watchedFileA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        Files.write(toBeModified, CONTENT_OTHER, new OpenOption[0]);
        MatcherAssert.assertThat((Object)this.watchServicePoll(), (Matcher)Matchers.nullValue());
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class})
    public void testWatchInOtherDirCatchesNothing() throws Exception {
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        this.fileTAB();
        MatcherAssert.assertThat((Object)this.watchServicePoll(), (Matcher)Matchers.nullValue());
    }

    @Test(timeout=30000L)
    @Category(value={SlowTest.class, Watchable.class})
    public void testNotResetWatchKeyDoesNotQue() throws Exception {
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        this.watchedFileA();
        WatchKey key = this.waitForWatchService().take();
        key.pollEvents();
        Files.write(this.watchedAbsB(), CONTENT, new OpenOption[0]);
        MatcherAssert.assertThat((Object)this.watchServicePoll(), (Matcher)Matchers.nullValue());
    }

    @Test(timeout=30000L)
    @Category(value={SlowTest.class, Watchable.class})
    public void testResetWatchKeyDoesQue() throws Exception {
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        this.watchedFileA();
        WatchKey key = this.waitForWatchService().take();
        key.pollEvents();
        key.reset();
        Path file = Files.write(this.watchedAbsB(), CONTENT, new OpenOption[0]);
        MatcherAssert.assertThat((Object)this.getWatchService().take(), WatchKeyMatcher.correctKey(file, StandardWatchEventKinds.ENTRY_CREATE));
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class})
    public void testWatchSeveralEventsInOneDir() throws Exception {
        Path toBeModified = this.watchedFileA();
        Path toBeCreated = this.watchedAbsB();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
        Files.write(toBeModified, CONTENT_OTHER, new OpenOption[0]);
        Files.write(toBeCreated, CONTENT_OTHER, new OpenOption[0]);
        WatchKey key = this.watchServicePoll();
        MatcherAssert.assertThat((Object)key, (Matcher)CoreMatchers.notNullValue());
        List<WatchEvent<?>> watchEvents = key.pollEvents();
        MatcherAssert.assertThat(watchEvents, (Matcher)IsCollectionContaining.hasItems((Matcher[])new Matcher[]{WatchEventMatcher.isEvent(toBeModified, StandardWatchEventKinds.ENTRY_MODIFY), WatchEventMatcher.isEvent(toBeCreated, StandardWatchEventKinds.ENTRY_CREATE)}));
    }

    @Test(timeout=20000L)
    @Category(value={SlowTest.class, Watchable.class})
    public void testWatchACreateBy2WatchServies() throws Exception {
        Path toBeCreated = this.watchedAbsA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        WatchService watchService2 = this.FS.newWatchService();
        this.watchedDir().register(watchService2, StandardWatchEventKinds.ENTRY_CREATE);
        Files.write(toBeCreated, CONTENT, new OpenOption[0]);
        MatcherAssert.assertThat((Object)this.getWatchService().take(), WatchKeyMatcher.correctKey(toBeCreated, StandardWatchEventKinds.ENTRY_CREATE));
        MatcherAssert.assertThat((Object)watchService2.take(), WatchKeyMatcher.correctKey(toBeCreated, StandardWatchEventKinds.ENTRY_CREATE));
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class})
    public void testWatchACreate() throws Exception {
        Path toBeCreated = this.watchedAbsA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        Files.write(toBeCreated, CONTENT, new OpenOption[0]);
        MatcherAssert.assertThat((Object)this.watchServicePoll(), WatchKeyMatcher.correctKey(toBeCreated, StandardWatchEventKinds.ENTRY_CREATE));
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class})
    public void testWatchACreateDir() throws Exception {
        Path toBeCreated = this.watchedAbsA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        Files.createDirectory(toBeCreated, new FileAttribute[0]);
        MatcherAssert.assertThat((Object)this.watchServicePoll(), WatchKeyMatcher.correctKey(toBeCreated, StandardWatchEventKinds.ENTRY_CREATE));
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class})
    public void testWatchACreateFromCopy() throws Exception {
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        Files.copy(this.fileTB(), this.watchedAbsA(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)this.watchServicePoll(), WatchKeyMatcher.correctKey(this.watchedAbsA(), StandardWatchEventKinds.ENTRY_CREATE));
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class})
    public void testWatchACreateFromMove() throws Exception {
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        Files.move(this.fileTAB(), this.watchedAbsA(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)this.watchServicePoll(), WatchKeyMatcher.correctKey(this.watchedAbsA(), StandardWatchEventKinds.ENTRY_CREATE));
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class})
    public void testCanceledWatchKeyDoesNotWatch() throws Exception {
        WatchKey key = this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        key.cancel();
        this.watchedFileA();
        MatcherAssert.assertThat((Object)this.watchServicePoll(), (Matcher)Matchers.nullValue());
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class})
    public void testWatchATruncate() throws Exception {
        Path file = this.watchedFileA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_MODIFY);
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE}), new FileAttribute[0]);){
            channel.truncate(2L);
        }
        MatcherAssert.assertThat((Object)this.watchServicePoll(), WatchKeyMatcher.correctKey(file, StandardWatchEventKinds.ENTRY_MODIFY));
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class})
    public void testWatchServiceTakeBlocks() throws Exception {
        Path dir = this.dirTA();
        WatchService watcher = dir.getFileSystem().newWatchService();
        dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        Ref interrupted = Ref.valueOf((Object)false);
        new Thread(() -> {
            try {
                watcher.take();
            }
            catch (Exception exception) {
            }
            finally {
                interrupted.set((Object)true);
            }
        }).start();
        Thread.sleep(1000L);
        MatcherAssert.assertThat((Object)interrupted.get(), (Matcher)Is.is((Object)false));
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class})
    public void testCloseAWatchServiceReleasesBlockedTreads() throws Exception {
        Path dir = this.dirTB();
        WatchService watcher = dir.getFileSystem().newWatchService();
        dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        Ref interrupted = Ref.valueOf((Object)false);
        new Thread(() -> {
            try {
                watcher.take();
            }
            catch (InterruptedException e) {
            }
            catch (ClosedWatchServiceException e) {
                interrupted.set((Object)true);
            }
        }).start();
        Thread.sleep(1000L);
        watcher.close();
        Thread.sleep(100L);
        MatcherAssert.assertThat((Object)interrupted.get(), (Matcher)Is.is((Object)true));
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class})
    public void testCloseAWatchServiceCancelsKeys() throws Exception {
        Path dir = this.dirTA();
        WatchService watcher = dir.getFileSystem().newWatchService();
        WatchKey key = dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        watcher.close();
        this.waitForWatchService();
        MatcherAssert.assertThat((Object)key.isValid(), (Matcher)Is.is((Object)false));
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class})
    public void testPollAnEmptyWatchServiceReturnsNull() throws Exception {
        Path dir = this.dirTA();
        WatchService watcher = dir.getFileSystem().newWatchService();
        dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        MatcherAssert.assertThat((Object)watcher.poll(), (Matcher)Matchers.nullValue());
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class})
    public void testWatchKeyPollEventsEmptiesQue() throws Exception {
        Path dir = this.dirTA();
        Path toBeDeleted = this.dirTAB();
        WatchService watcher = dir.getFileSystem().newWatchService();
        dir.register(watcher, StandardWatchEventKinds.ENTRY_DELETE);
        Thread.sleep(1000L);
        Files.delete(toBeDeleted);
        this.waitForWatchService();
        WatchKey watchKey = watcher.poll();
        watchKey.pollEvents();
        MatcherAssert.assertThat(watchKey.pollEvents(), (Matcher)Matchers.empty());
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class})
    public void testDeleteWatchedDirCancelsKeys() throws Exception {
        WatchKey key = this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        Files.delete(this.watchedDir());
        this.watchServicePoll();
        MatcherAssert.assertThat((Object)key.isValid(), (Matcher)Is.is((Object)false));
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class})
    public void testMovedWatchedDirCancelsKeys() throws Exception {
        Path dir = this.dirTA();
        WatchService watcher = this.FS.newWatchService();
        WatchKey key = dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        Files.move(dir, this.absTB(), new CopyOption[0]);
        this.waitForWatchService();
        MatcherAssert.assertThat((Object)key.isValid(), (Matcher)Is.is((Object)false));
    }

    @Test
    @Category(value={SlowTest.class, Watchable.class})
    public void testWatchTwoModifiesOneKey() throws Exception {
        Path toBeModified = this.watchedFileA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_MODIFY);
        Files.write(toBeModified, CONTENT_OTHER, new OpenOption[0]);
        Files.write(toBeModified, CONTENT, new OpenOption[0]);
        WatchKey key = this.watchServicePoll();
        MatcherAssert.assertThat((Object)key, (Matcher)CoreMatchers.notNullValue());
        List<WatchEvent<?>> watchEvents = key.pollEvents();
        MatcherAssert.assertThat(watchEvents, (Matcher)IsCollectionContaining.hasItems((Matcher[])new Matcher[]{WatchEventMatcher.isEvent(toBeModified, StandardWatchEventKinds.ENTRY_MODIFY)}));
    }

    public Path watchedFileA() throws IOException {
        Path ret = this.watchedAbsA();
        Files.write(ret, CONTENT, standardOpen);
        return ret;
    }

    public Path watchedAbsA() throws IOException {
        return this.watchedDir().resolve(this.nameA());
    }

    public Path watchedAbsB() throws IOException {
        return this.watchedDir().resolve(this.nameB());
    }

    public Path watchedDir() throws IOException {
        Path ret = this.absT().resolve("watched");
        Files.createDirectories(ret, new FileAttribute[0]);
        return ret;
    }

    public WatchService getWatchService() {
        return this.watchService;
    }

    public WatchService waitForWatchService() throws InterruptedException {
        Thread.sleep(this.getDelay());
        return this.watchService;
    }

    private int getDelay() {
        int delay = this.description.getInt(WATCH_DELAY);
        if (delay < 10) {
            return 2000;
        }
        return delay;
    }

    public WatchKey watchServicePoll() throws InterruptedException {
        return this.watchService.poll(this.getDelay(), TimeUnit.MILLISECONDS);
    }

    WatchKey watcherSetup(WatchEvent.Kind<Path> ... kinds) throws IOException {
        this.watchService = this.FS.newWatchService();
        return this.watchedDir().register(this.watchService, kinds);
    }
}

