/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.collection.Sets;
import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.Tests06Attributes;
import de.pfabulist.lindwurm.niotest.tests.topics.Closable;
import de.pfabulist.lindwurm.niotest.tests.topics.FileChannel;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests07Closed
extends Tests06Attributes {
    public static final String CLOSEABLE_PLAYGROUND = "closeablePlayground";

    public Tests07Closed(FSDescription description) {
        super(description);
    }

    @Test
    @Category(value={Closable.class})
    public void testClosedFSisClosed() throws Exception {
        Assert.assertThat((Object)this.getClosedFS().isOpen(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=ClosedFileSystemException.class)
    @Category(value={Closable.class})
    public void testClosedFSCantRead() throws Exception {
        Files.readAllBytes(this.getClosedFileA());
    }

    @Test(expected=ClosedFileSystemException.class)
    @Category(value={Closable.class})
    public void testClosedFSCantReadDir() throws Exception {
        Files.newDirectoryStream(this.getClosedDirB());
    }

    @Test(expected=ClosedChannelException.class)
    @Category(value={Closable.class})
    public void testClosedFSCantUseReadChannelPosition() throws Exception {
        this.getClosedReadChannel().position();
    }

    @Test(expected=ClosedChannelException.class)
    @Category(value={Closable.class})
    public void testClosedFSCantUseReadChannelRead() throws Exception {
        this.getClosedReadChannel().read(ByteBuffer.allocate(2));
    }

    @Test(expected=ClosedChannelException.class)
    @Category(value={Closable.class})
    public void testClosedFSCantUseReadChannelSize() throws Exception {
        this.getClosedReadChannel().size();
    }

    @Test(expected=FileSystemNotFoundException.class)
    @Category(value={Closable.class})
    public void testCantGetClosedFSViaURI() throws Exception {
        this.getClosedFSProvider().getFileSystem(this.getClosedURI());
    }

    @Test(expected=ClosedFileSystemException.class)
    @Category(value={Closable.class})
    public void testClosedFSnewByteChannel() throws Exception {
        this.getClosedFS();
        this.FS.provider().newByteChannel(this.getClosedFileA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    @Category(value={Closable.class})
    public void testClosedFSGetBasicFileAttributeViewProvider() throws IOException {
        this.getClosedFS();
        this.FS.provider().getFileAttributeView(this.getClosedFileA(), BasicFileAttributeView.class, new LinkOption[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    @Category(value={Closable.class})
    public void testClosedFSCreateDirectoryOtherProvider() throws IOException {
        this.getClosedFSProvider().createDirectory(this.getClosedFileA(), new FileAttribute[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    @Category(value={Closable.class, FileChannel.class})
    public void testClosedFSNewFileChannel() throws IOException {
        this.getClosedFSProvider().newFileChannel(this.getClosedFileA(), Collections.emptySet(), new FileAttribute[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    @Category(value={Closable.class})
    public void testClosedFSCheckAccess() throws IOException {
        this.getClosedFS();
        this.FS.provider().checkAccess(this.getClosedFileA(), new AccessMode[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    @Category(value={Closable.class})
    public void testCopyFromClosedFS() throws IOException {
        this.getClosedFSProvider().copy(this.getClosedFileA(), this.dirTA(), new CopyOption[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    @Category(value={Closable.class})
    public void testCopyToClosedFS() throws IOException {
        this.getClosedFSProvider().copy(this.fileTA(), this.getClosedFileA(), new CopyOption[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    @Category(value={Closable.class})
    public void testMoveToClosedFS() throws IOException {
        this.getClosedFSProvider().move(this.fileTA(), this.getClosedFileA(), new CopyOption[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    @Category(value={Closable.class})
    public void testClosedFSCreateHardLink() throws IOException {
        this.getClosedFSProvider().createLink(this.getClosedFileA(), this.getClosedFileA());
    }

    @Test(expected=ClosedFileSystemException.class)
    @Category(value={Closable.class})
    public void testClosedFSDelete() throws IOException {
        this.getClosedFSProvider().delete(this.getClosedFileA());
    }

    @Test(expected=ClosedFileSystemException.class)
    @Category(value={Closable.class})
    public void testClosedFSGetFileStore() throws IOException {
        this.getClosedFSProvider().getFileStore(this.getClosedFileA());
    }

    @Test(expected=ClosedFileSystemException.class)
    @Category(value={Closable.class})
    public void testClosedFSIsHidden() throws IOException {
        this.getClosedFSProvider().isHidden(this.getClosedFileA());
    }

    @Test(expected=ClosedFileSystemException.class)
    @Category(value={Closable.class})
    public void testClosedFSNewInputStream() throws IOException {
        this.getClosedFSProvider().newOutputStream(this.getClosedFileA(), new OpenOption[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    @Category(value={Closable.class})
    public void testClosedFSNewOutputStream() throws IOException {
        this.getClosedFSProvider().newOutputStream(this.getClosedFileA(), new OpenOption[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    @Category(value={Closable.class})
    public void testClosedFSReadAttributes() throws IOException {
        this.getClosedFSProvider().readAttributes(this.getClosedFileA(), BasicFileAttributes.class, new LinkOption[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    @Category(value={Closable.class})
    public void testClosedFSReadAttributesString() throws IOException {
        this.getClosedFSProvider().readAttributes(this.getClosedFileA(), "*", new LinkOption[0]);
    }

    public FileSystem getClosedFS() throws IOException {
        if (this.description.closedFSVars == null) {
            this.description.closedFSVars = new FSDescription.ClosedFSVars(this.description.get(Path.class, CLOSEABLE_PLAYGROUND));
        }
        if (this.description.closedFSVars.fs == null) {
            this.description.closedFSVars.fs = this.description.closedFSVars.play.getFileSystem();
        }
        if (!this.description.closedFSVars.fs.isOpen()) {
            return this.description.closedFSVars.fs;
        }
        this.description.closedFSVars.provider = this.description.closedFSVars.fs.provider();
        this.description.closedFSVars.dirB = this.description.closedFSVars.play.resolve(this.nameB());
        Files.createDirectories(this.description.closedFSVars.dirB, new FileAttribute[0]);
        this.description.closedFSVars.fileA = this.description.closedFSVars.play.resolve(this.nameA());
        Files.write(this.description.closedFSVars.fileA, CONTENT, standardOpen);
        Path closedCf = this.description.closedFSVars.play.resolve(this.nameC());
        Files.write(closedCf, CONTENT, standardOpen);
        this.description.closedFSVars.readChannel = Files.newByteChannel(closedCf, StandardOpenOption.READ);
        this.description.closedFSVars.uri = this.description.closedFSVars.play.getRoot().toUri();
        this.description.closedFSVars.dirStream = Files.newDirectoryStream(this.description.closedFSVars.play);
        try {
            this.description.closedFSVars.watchService = this.description.closedFSVars.fs.newWatchService();
        }
        catch (IOException | UnsupportedOperationException exception) {
            // empty catch block
        }
        this.description.closedFSVars.fs.close();
        return this.description.closedFSVars.fs;
    }

    public FileSystemProvider getClosedFSProvider() throws IOException {
        this.getClosedFS();
        return this.FS.provider();
    }

    public Path getClosedFileA() throws IOException {
        this.getClosedFS();
        return this.description.closedFSVars.fileA;
    }

    public Path getClosedDirB() throws IOException {
        this.getClosedFS();
        return this.description.closedFSVars.dirB;
    }

    public URI getClosedURI() throws IOException {
        this.getClosedFS();
        return this.description.closedFSVars.uri;
    }

    public SeekableByteChannel getClosedReadChannel() throws IOException {
        this.getClosedFileA();
        return this.description.closedFSVars.readChannel;
    }

    public WatchService getClosedFSWatchService() throws IOException {
        this.getClosedFS();
        return this.description.closedFSVars.watchService;
    }
}

