/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.matcher;

import java.nio.file.Path;
import java.nio.file.WatchEvent;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class WatchEventMatcher
extends TypeSafeMatcher<WatchEvent> {
    private final Path file;
    private final WatchEvent.Kind<Path> kind;

    public WatchEventMatcher(Path file, WatchEvent.Kind<Path> kind) {
        this.file = file.getFileName();
        this.kind = kind;
    }

    protected boolean matchesSafely(WatchEvent event) {
        if (!this.file.equals(event.context())) {
            return false;
        }
        return event.kind().equals(this.kind);
    }

    public void describeTo(Description description) {
        description.appendText("watch file event");
    }

    @Factory
    public static Matcher<WatchEvent> isEvent(Path file, WatchEvent.Kind<Path> kind) {
        return new WatchEventMatcher(file, kind);
    }

    public String toString() {
        return "WatchEventMatcher{file=" + this.file + ", kind=" + this.kind + '}';
    }
}

