/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.matcher;

import java.nio.file.Path;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class PathAbsolute
extends TypeSafeMatcher<Path> {
    private final boolean positive;

    public PathAbsolute(boolean positive) {
        this.positive = positive;
    }

    public boolean matchesSafely(Path path) {
        return this.positive == path.isAbsolute();
    }

    public void describeTo(Description description) {
        description.appendText("path is absolute");
    }

    @Factory
    public static Matcher<Path> absolute() {
        return new PathAbsolute(true);
    }

    @Factory
    public static Matcher<Path> relative() {
        return new PathAbsolute(false);
    }
}

