/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.testsn.setup;

import de.pfabulist.lindwurm.niotest.testsn.setup.AllCapabilitiesBuilder;
import de.pfabulist.lindwurm.niotest.testsn.setup.Capa;
import de.pfabulist.lindwurm.niotest.testsn.setup.DetailBuilder;
import java.nio.file.Path;

public class CapBuilder00 {
    public final Capa capa = new Capa();

    public static TypeBuilder typ(FSType type) {
        return new TypeBuilder(type);
    }

    public AllCapabilitiesBuilder playground(Path path) {
        this.capa.attributes.put("playground", path);
        return (AllCapabilitiesBuilder)this;
    }

    public AllCapabilitiesBuilder bug(String testMethodName, boolean cond) {
        if (cond) {
            this.capa.bugs.add(testMethodName);
        }
        return (AllCapabilitiesBuilder)this;
    }

    public AllCapabilitiesBuilder bug(String testMethodName) {
        return this.bug(testMethodName, true);
    }

    public AllCapabilitiesBuilder bugScheme(String substr) {
        this.capa.addBugSchemes(substr);
        return (AllCapabilitiesBuilder)this;
    }

    public AllCapabilitiesBuilder nitpick(String testMethod, String reason) {
        return this.bug(testMethod);
    }

    public Capa build() {
        return this.capa;
    }

    public static class TypeBuilder
    extends DetailBuilder {
        public TypeBuilder(FSType type) {
            super(new AllCapabilitiesBuilder());
            switch (type) {
                case NEUTRAL: {
                    break;
                }
                case NTFS: {
                    this.capa.attributes.put("maxFilenameLength", 255);
                    this.capa.attributes.put("maxPathLength", 32000);
                    this.capa.addFeature("Unix", false);
                    this.capa.addFeature("Posix", false);
                    this.capa.addFeature("Windows", true);
                    this.capa.addFeature("CaseIgnorant", true);
                    this.capa.addFeature("CaseRemembering", true);
                    this.capa.addFeature("UNC", true);
                    break;
                }
                case HFSplus: {
                    break;
                }
                case WINDOWS_STYLE: {
                    this.capa.attributes.put("maxFilenameLength", 255);
                    this.capa.attributes.put("maxPathLength", 32000);
                    this.capa.addFeature("Unix", false);
                    this.capa.addFeature("Posix", false);
                    this.capa.addFeature("Windows", false);
                    this.capa.addFeature("CaseIgnorant", true);
                    this.capa.addFeature("CaseRemembering", true);
                    this.capa.addFeature("UNC", false);
                    this.capa.addFeature("RootComponent", false);
                    break;
                }
                case UNIX_STYLE: {
                    this.capa.attributes.put("maxFilenameLength", 255);
                    this.capa.addFeature("Unix", true);
                    this.capa.addFeature("Windows", false);
                    this.capa.addFeature("Posix", false);
                    this.capa.addFeature("CaseIgnorant", false);
                    this.capa.addFeature("CaseRemembering", false);
                    this.capa.addFeature("UNC", false);
                    this.capa.addFeature("RootComponent", false);
                    this.capa.addFeature("ReadChannelOfDir", false);
                    break;
                }
                case EXT2: {
                    this.capa.attributes.put("maxFilenameLength", 255);
                    this.capa.addFeature("Unix", true);
                    this.capa.addFeature("Windows", false);
                    this.capa.addFeature("Posix", true);
                    this.capa.addFeature("CaseIgnorant", false);
                    this.capa.addFeature("CaseRemembering", false);
                    this.capa.addFeature("UNC", false);
                    this.capa.addFeature("RootComponent", false);
                    this.capa.addFeature("ReadChannelOfDir", false);
                }
            }
        }

        public TypeBuilder unc(boolean cond) {
            this.capa.addFeature("UNC", cond);
            return this;
        }

        public TypeBuilder rootComponent(boolean cnd) {
            this.capa.addFeature("RootComponent", cnd);
            return this;
        }

        @Override
        public AllCapabilitiesBuilder onOff(boolean val) {
            return this.builder;
        }
    }

    public static enum FSType {
        NEUTRAL,
        NTFS,
        HFSplus,
        WINDOWS_STYLE,
        UNIX_STYLE,
        EXT2;

    }

    public static enum SimOS {
        NEUTRAL,
        WINDOWS,
        UNIX,
        OSX;

    }
}

