/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.testsn;

import de.pfabulist.kleinod.errors.Unchecked;
import de.pfabulist.kleinod.paths.Filess;
import de.pfabulist.lindwurm.niotest.matcher.PathExists;
import de.pfabulist.lindwurm.niotest.matcher.PathIsDirectory;
import de.pfabulist.lindwurm.niotest.testsn.Tests19HardLinks;
import de.pfabulist.lindwurm.niotest.testsn.setup.AllCapabilitiesBuilder;
import de.pfabulist.lindwurm.niotest.testsn.setup.Capa;
import de.pfabulist.lindwurm.niotest.testsn.setup.DetailBuilder;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotLinkException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Test;

public abstract class Tests20SymLinks
extends Tests19HardLinks {
    public Tests20SymLinks(Capa capa) {
        super(capa);
    }

    @Test
    public void testCreateSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)this.symLink(), PathExists.exists());
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testCreateSymLinkWhereLinkExistsThrows() throws IOException {
        Files.write(this.symLink(), CONTENT, new OpenOption[0]);
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
    }

    @Test
    public void testCreateSymLinkToNonExisting() throws IOException {
        Files.createSymbolicLink(this.link(), this.absTA(), new FileAttribute[0]);
    }

    @Test
    public void testSymLinkAttributeNonLink() throws IOException {
        MatcherAssert.assertThat((Object)Files.isSymbolicLink(this.targetFile()), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testSymLinkAttributeLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.isSymbolicLink(this.symLink()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testRealPathofAnUnnormalizedDeepSymLink() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetDir(), new FileAttribute[0]);
        Files.write(this.link().getParent().resolve(this.nameB()), CONTENT, new OpenOption[0]);
        Files.write(this.targetDir().getParent().resolve(this.nameB()), CONTENT_OTHER, new OpenOption[0]);
        Path unnorm = this.link().resolve("..").resolve(this.nameB());
        System.out.println(this.link());
        System.out.println(this.targetDir());
        System.out.println(unnorm.toRealPath(new LinkOption[0]));
        System.out.println(unnorm.toRealPath(LinkOption.NOFOLLOW_LINKS));
        System.out.println(this.link().getParent().resolve(this.nameB()).toRealPath(new LinkOption[0]));
    }

    @Test
    public void testReadFromSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.symLink()), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testReadFromSymLinkToSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.createSymbolicLink(this.symLink2(), this.symLink(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.symLink2()), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testWriteToSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.write(this.symLink(), CONTENT_OTHER, new OpenOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.targetFile()), (Matcher)Is.is((Object)CONTENT_OTHER));
    }

    @Test
    public void testDirSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.isDirectory(this.symLink(), new LinkOption[0]), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testStreamFromDirSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.symLink());){
            for (Path kid : stream) {
                System.out.println(kid);
                MatcherAssert.assertThat((Object)kid.getParent(), (Matcher)Is.is((Object)this.symLink()));
                MatcherAssert.assertThat((Object)Files.isSameFile(kid, this.targetDirKid()), (Matcher)Is.is((Object)true));
            }
        }
    }

    @Test
    public void testCreateFileInDirSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.write(this.linkKid(), CONTENT, new OpenOption[0]);
        MatcherAssert.assertThat((Object)this.linkKid(), PathExists.exists());
    }

    @Test
    public void testFileInDirSymLinkIsNotSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.write(this.linkKid(), CONTENT, new OpenOption[0]);
        MatcherAssert.assertThat((Object)Files.isSymbolicLink(this.linkKid()), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testCreateDirInDirSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.createDirectory(this.linkKid(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)this.linkKid(), PathIsDirectory.isDirectory());
    }

    @Test
    public void testDeleteSymLinkDoesNotDeleteTarget() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.delete(this.symLink());
        MatcherAssert.assertThat((Object)this.targetFile(), PathExists.exists());
        MatcherAssert.assertThat((Object)this.symLink(), (Matcher)IsNot.not(PathExists.exists()));
    }

    @Test
    public void testDeleteSymLinkDoesNotDeleteTargetNonEmptyDirCase() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.write(this.symLink().resolve("kid"), CONTENT, new OpenOption[0]);
        Files.delete(this.symLink());
        MatcherAssert.assertThat((Object)this.symLink(), (Matcher)IsNot.not(PathExists.exists()));
    }

    @Test
    public void testCopyFromSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.copy(this.symLink(), this.tgt(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.tgt()), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testCopyFromDeeperSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.write(this.linkKid(), CONTENT, new OpenOption[0]);
        Files.copy(this.linkKid(), this.tgt(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.tgt()), (Matcher)Is.is((Object)CONTENT));
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testCopyToBrokenSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.absTA(), new FileAttribute[0]);
        Files.copy(this.fileTAB(), this.symLink(), new CopyOption[0]);
    }

    @Test
    public void testCopyBrokenSymLinkToItself() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.absTA(), new FileAttribute[0]);
        Files.copy(this.symLink(), this.symLink(), new CopyOption[0]);
    }

    @Test
    public void testCopySymLinkToItself() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.copy(this.symLink(), this.symLink(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.symLink()), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testCopyToSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.copy(this.fileTAB(), this.symLink(), StandardCopyOption.REPLACE_EXISTING);
        MatcherAssert.assertThat((Object)Files.isSymbolicLink(this.symLink()), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testCopyToDeepSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.copy(this.fileTAB(), this.linkKid(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.linkKid()), (Matcher)Is.is((Object)CONTENT));
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.linkKid().toRealPath(new LinkOption[0])), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testHardLinkToSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.createLink(this.hardLink(), this.symLink());
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.hardLink()), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testHardLinkToSymLinkDeleteSymLeavesHardLinkUntouched() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.createLink(this.hardLink(), this.symLink());
        Files.delete(this.symLink());
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.hardLink()), (Matcher)Is.is((Object)CONTENT));
    }

    @Test(expected=NoSuchFileException.class)
    public void testBrokenSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.delete(this.targetFile());
        Files.readAllBytes(this.symLink());
    }

    @Test
    public void testBrokenSymLinkNotExists() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.absTA(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)this.symLink(), (Matcher)IsNot.not(PathExists.exists()));
    }

    @Test
    public void testBrokenSymLinkNoFollowLinkExists() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.absTA(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.exists(this.symLink(), LinkOption.NOFOLLOW_LINKS), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testBrokenSymLinkThrowsOnIsSymlink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.absTA(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.isSymbolicLink(this.symLink()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testBrokenSymLinkGetAttisNoFollowLinkDoesWorks() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.absTA(), new FileAttribute[0]);
        BasicFileAttributes aa = Files.readAttributes(this.symLink(), BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        MatcherAssert.assertThat((Object)aa.isSymbolicLink(), (Matcher)Is.is((Object)true));
    }

    @Test(expected=NoSuchFileException.class)
    public void testBrokenSymLinkDoesNotTestForSymlinkAttribute() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.absTA(), new FileAttribute[0]);
        Files.readAttributes(this.symLink(), BasicFileAttributes.class, new LinkOption[0]);
    }

    @Test
    public void testDeleteBrokenSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.absTA(), new FileAttribute[0]);
        Files.delete(this.symLink());
    }

    @Test
    public void testGetSymLinkTarget() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.readSymbolicLink(this.symLink()), (Matcher)Is.is((Object)this.targetFile()));
    }

    @Test(expected=NotLinkException.class)
    public void testGetSymLinkOfNonLinkThrows() throws IOException {
        Files.readSymbolicLink(this.targetFile());
    }

    @Test
    public void testReadAttributesFromSymLinkNoFollowLinks() throws IOException, InterruptedException {
        this.targetFile();
        Thread.sleep(2000L);
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        FileTime orig = Files.readAttributes(this.symLink(), BasicFileAttributes.class, new LinkOption[0]).creationTime();
        FileTime linkTime = Files.readAttributes(this.symLink(), BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS).creationTime();
        MatcherAssert.assertThat((Object)linkTime, (Matcher)Matchers.greaterThan((Comparable)orig));
    }

    @Test
    public void testAttributesFromSymLinkWithFollowLinkShowNoLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        BasicFileAttributes bfa = Files.readAttributes(this.symLink(), BasicFileAttributes.class, new LinkOption[0]);
        MatcherAssert.assertThat((Object)bfa.isSymbolicLink(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testAttributesFromSymLinkWithFollowLinkShowNoLink_View() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        BasicFileAttributeView bfav = Files.getFileAttributeView(this.symLink(), BasicFileAttributeView.class, new LinkOption[0]);
        MatcherAssert.assertThat((Object)bfav.readAttributes().isSymbolicLink(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testMoveSymLinkFileTestContent() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.move(this.symLink(), this.absTA(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.absTA()), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testMoveSymLinkMovesLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.move(this.symLink(), this.absTC(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)this.symLink(), (Matcher)IsNot.not(PathExists.exists()));
    }

    @Test
    public void testMoveSymLinkLeavesTarget() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.move(this.symLink(), this.absTC(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)this.targetFile(), PathExists.exists());
    }

    @Test
    public void testMoveSymLinkFileKeepsSymLinkStatus() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.move(this.symLink(), this.tgt(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.isSymbolicLink(this.tgt()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testFileStoreOfSymLinkIsTargets() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.getFileStore(this.symLink()), (Matcher)Is.is((Object)Files.getFileStore(this.targetFile())));
    }

    @Test
    public void testSymLinkAndTargetAreSameFile() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.isSameFile(this.symLink(), this.targetFile()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testDeepSymLinkIsSameFile() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.write(this.linkKid(), CONTENT, new OpenOption[0]);
        MatcherAssert.assertThat((Object)Files.isSameFile(this.linkKid(), this.targetDir().resolve(this.linkKid().getFileName())), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testDoubleSymLinkExists() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.createSymbolicLink(this.linkKid(), this.fileTAB(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)this.linkKid(), PathExists.exists());
    }

    @Test
    public void testDoubleSymLinkSameFile() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.createSymbolicLink(this.linkKid(), this.fileTAB(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.isSameFile(this.linkKid(), this.fileTAB()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testDoubleSymLinkReadAttributes() throws IOException, InterruptedException {
        this.fileTAB();
        Thread.sleep(1100L);
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.createSymbolicLink(this.linkKid(), this.fileTAB(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.readAttributes(this.linkKid(), "basic:lastModifiedTime", new LinkOption[0]).get("lastModifiedTime"), (Matcher)Is.is((Object)Files.readAttributes(this.fileTAB(), "basic:lastModifiedTime", new LinkOption[0]).get("lastModifiedTime")));
    }

    @Test
    public void testDeepSymLinkMove() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.write(this.linkKid(), CONTENT, new OpenOption[0]);
        Files.move(this.linkKid(), this.tgt(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.tgt()), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testMoveToDeepSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.move(this.fileTAB(), this.linkKid(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.linkKid()), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testDoubleSymLinkReadAttributesNoFollowLink() throws IOException, InterruptedException {
        this.fileTAB();
        Thread.sleep(1100L);
        Files.createSymbolicLink(this.symLink(), this.targetDir(), new FileAttribute[0]);
        Files.createSymbolicLink(this.linkKid(), this.fileTAB(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)((FileTime)Files.readAttributes(this.linkKid(), "basic:lastModifiedTime", LinkOption.NOFOLLOW_LINKS).get("lastModifiedTime")), (Matcher)Matchers.greaterThan((Comparable)((FileTime)Files.readAttributes(this.fileTAB(), "basic:lastModifiedTime", new LinkOption[0]).get("lastModifiedTime"))));
    }

    @Test
    public void testSymLinkChanges() throws IOException {
        Path target = this.targetFile();
        Files.createSymbolicLink(this.symLink(), target, new FileAttribute[0]);
        Files.delete(target);
        Files.createDirectory(target, new FileAttribute[0]);
        MatcherAssert.assertThat((Object)this.symLink(), PathIsDirectory.isDirectory());
    }

    @Test
    public void testRelSymLinkIsRelativeToLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.FS.getPath("..", new String[0]).resolve(this.nameA()), new FileAttribute[0]);
        Files.write(this.symLink().getParent().getParent().resolve(this.nameA()), CONTENT_OTHER, new OpenOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.symLink()), (Matcher)Is.is((Object)CONTENT_OTHER));
    }

    @Test
    public void testMoveARelSymLink2() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.FS.getPath("..", new String[0]).resolve(this.nameA()), new FileAttribute[0]);
        Path to = this.dirTB().resolve(this.nameB());
        Files.move(this.symLink(), to, new CopyOption[0]);
        Files.write(to, CONTENT, new OpenOption[0]);
        MatcherAssert.assertThat((Object)Files.isSameFile(to, this.absTA()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testMoveSymLinkDoesNotChangeLastModifiedTime() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.fileTA(), new FileAttribute[0]);
        FileTime before = Files.getLastModifiedTime(this.symLink(), LinkOption.NOFOLLOW_LINKS);
        this.waitForAttribute();
        Files.move(this.symLink(), this.absTB(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.getLastModifiedTime(this.absTB(), LinkOption.NOFOLLOW_LINKS), (Matcher)Is.is((Object)before));
    }

    @Test
    public void testMoveARelSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.relA(), new FileAttribute[0]);
        Files.move(this.symLink(), this.absTB(), new CopyOption[0]);
        Files.write(this.absTB(), CONTENT, new OpenOption[0]);
        MatcherAssert.assertThat((Object)Files.isSameFile(this.absTB(), this.absTA()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testMoveReplaceExistingToSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        Files.move(this.fileTA(), this.symLink(), StandardCopyOption.REPLACE_EXISTING);
        MatcherAssert.assertThat((Object)Files.isSymbolicLink(this.symLink()), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testUnnormalizedDeepSymLinkFollowsLinkBeforeNormalization() throws IOException {
        Path sym = this.dirTA().resolve("link");
        Files.createSymbolicLink(sym, this.dirTBB(), new FileAttribute[0]);
        Files.write(this.dirTA().resolve(this.nameC()), CONTENT, new OpenOption[0]);
        Files.write(this.dirTB().resolve(this.nameC()), CONTENT_OTHER, new OpenOption[0]);
        MatcherAssert.assertThat((Object)Files.isSameFile(sym.resolve("..").resolve(this.nameC()), this.dirTB().resolve(this.nameC())), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testSymLinkToUnnormalizedRelPath() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.FS.getPath(this.nameA(), new String[0]).resolve(".."), new FileAttribute[0]);
        Files.createSymbolicLink(this.symLink().getParent().resolve(this.nameA()), this.targetFile(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.isSameFile(this.symLink(), this.targetFile().getParent()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testGetFileStoreOfSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.targetFile(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.getFileStore(this.symLink()), (Matcher)Is.is((Object)Files.getFileStore(this.targetFile())));
    }

    @Test(expected=NoSuchFileException.class)
    public void testGetFileStoreOfBrokenSymLink() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.absTA(), new FileAttribute[0]);
        Files.getFileStore(this.symLink());
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testCreateDirAtSymLinkThrows() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.absTA(), new FileAttribute[0]);
        Files.createDirectory(this.symLink(), new FileAttribute[0]);
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testCreateHardLinkAtSymLinkThrows() throws IOException {
        Files.createSymbolicLink(this.symLink(), this.absTA(), new FileAttribute[0]);
        Files.createLink(this.symLink(), this.targetFile());
    }

    private Path targetFile() {
        Path target = this.absT().resolve("targetSpace").resolve("target");
        if (Files.exists(target, new LinkOption[0])) {
            return target;
        }
        Filess.createDirectories((Path)target.getParent());
        Filess.write((Path)target, (byte[])CONTENT, (OpenOption[])new OpenOption[0]);
        return target;
    }

    protected Path otherProviderTargetFile() {
        try {
            Path target = this.otherProviderAbsA().resolve(this.nameB());
            if (!Files.exists(target, new LinkOption[0])) {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                Files.write(target, CONTENT, new OpenOption[0]);
            }
            return target;
        }
        catch (IOException e) {
            throw Unchecked.runtime((Exception)e);
        }
    }

    protected Path otherProviderTargetDir() {
        try {
            Path target = this.otherProviderAbsA().resolve("target");
            if (!Files.exists(target, new LinkOption[0])) {
                Files.createDirectories(target, new FileAttribute[0]);
                Files.write(this.otherProviderTargetDirKid(), CONTENT, new OpenOption[0]);
            }
            return target;
        }
        catch (IOException e) {
            throw Unchecked.runtime((Exception)e);
        }
    }

    protected Path otherProviderTargetDirKid() {
        return this.otherProviderAbsA().resolve("target").resolve("kid");
    }

    private Path targetDir() {
        try {
            Path target = this.targetDirKid().getParent();
            if (!Files.exists(target, new LinkOption[0])) {
                Files.createDirectories(target, new FileAttribute[0]);
                Files.write(this.targetDirKid(), CONTENT, new OpenOption[0]);
            }
            return target;
        }
        catch (IOException e) {
            throw Unchecked.runtime((Exception)e);
        }
    }

    private Path targetDirKid() {
        return this.absT().resolve("targetSpace").resolve("targetDir").resolve("targetKid");
    }

    protected Path symLinkSpace() {
        Path ret = this.absT().resolve("forsyml");
        Filess.createDirectories((Path)ret);
        return ret;
    }

    protected Path symLink() {
        return this.symLinkSpace().resolve("link");
    }

    protected Path symLink2() {
        return this.symLinkSpace().resolve("link2");
    }

    protected Path hardLink() {
        return this.symLinkSpace().resolve("hardLink");
    }

    private Path linkKid() {
        return this.symLink().resolve("linkKid");
    }

    public static class SymlinkBuilder
    extends DetailBuilder {
        public SymlinkBuilder(AllCapabilitiesBuilder builder) {
            super(builder);
        }

        public SymlinkBuilder toOtherProviders(boolean cond) {
            this.capa.addFeature("SymLinkToOtherProvider", cond);
            return this;
        }

        public SymlinkBuilder toDirs(boolean cond) {
            this.capa.addFeature("DirSymLink", cond);
            this.capa.addFeature("DeepSymLink", cond);
            this.capa.addFeature("DoubleSymLink", cond);
            return this;
        }

        public SymlinkBuilder relativeTargets(boolean cond) {
            this.capa.addFeature("RelSymLink", cond);
            return this;
        }

        @Override
        public AllCapabilitiesBuilder onOff(boolean val) {
            this.capa.addFeature("SymLink", val);
            return this.builder;
        }
    }

    public static class CapaBuilder20
    extends Tests19HardLinks.CapaBuilder19 {
        public SymlinkBuilder symlinks() {
            return new SymlinkBuilder((AllCapabilitiesBuilder)this);
        }
    }
}

