/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.testsn;

import de.pfabulist.lindwurm.niotest.matcher.PathAbsolute;
import de.pfabulist.lindwurm.niotest.matcher.PathExists;
import de.pfabulist.lindwurm.niotest.testsn.Tests09WrongProvider;
import de.pfabulist.lindwurm.niotest.testsn.setup.AllCapabilitiesBuilder;
import de.pfabulist.lindwurm.niotest.testsn.setup.Capa;
import de.pfabulist.lindwurm.niotest.testsn.setup.DetailBuilder;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public abstract class Tests10PathWithContent
extends Tests09WrongProvider {
    public static final String MAX_FILENAME_LENGTH = "maxFilenameLength";
    public static final String MAX_PATH_LENGTH = "maxPathLength";

    public Tests10PathWithContent(Capa capa) {
        super(capa);
    }

    @Test
    public void testIsSameFileOnEqualPath() throws IOException {
        Assert.assertThat((Object)Files.isSameFile(this.absTA(), this.absTA()), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsSameFileOnEqualPathElementsOtherProvider() throws IOException {
        Assert.assertThat((Object)Files.isSameFile(this.absTA(), this.otherProviderAbsA()), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testIsSameFileWithUnnormalizedPath() throws IOException {
        Assert.assertThat((Object)this.FS.provider().isSameFile(this.fileTAB(), this.unnormalize(this.fileTAB())), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsSameFileWithSpecialUnnormalizedPath() throws IOException {
        Assert.assertThat((Object)this.FS.provider().isSameFile(this.fileTAB(), this.fileTAB().resolve("..").resolve(this.nameB())), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsSameFileWithRelativePath() throws IOException {
        Assert.assertThat((Object)this.FS.provider().isSameFile(this.fileTAB(), this.relativize(this.fileTAB())), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsSameFileOfSameContentDifferentPathIsNot() throws IOException {
        Assert.assertThat((Object)this.FS.provider().isSameFile(this.fileTA(), this.fileTB()), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testIsSameFileOfDifferentPathNonExistingFileIsNot() throws IOException {
        Assert.assertThat((Object)this.FS.provider().isSameFile(this.fileTAB(), this.absTB()), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testIsSameFileOfDifferentPathNonExistingFile2IsNot() throws IOException {
        Assert.assertThat((Object)this.FS.provider().isSameFile(this.fileTA(), this.absTB()), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testWriteUnnormalized() throws IOException {
        Files.write(this.unnormalize(this.absTA()), CONTENT, standardOpen);
        Assert.assertThat((Object)Files.readAllBytes(this.absTA()), (Matcher)CoreMatchers.is((Object)CONTENT));
    }

    @Test
    public void testReadAttributesFromUnnormalizedPath() throws IOException {
        this.fileTA();
        Assert.assertThat((Object)Files.size(this.unnormalize(this.fileTA())), (Matcher)CoreMatchers.is((Object)CONTENT.length));
    }

    @Test
    public void testCheckAccessUnnormalizedPath() throws IOException {
        this.FS.provider().checkAccess(this.unnormalize(this.fileTA()), new AccessMode[0]);
    }

    @Test
    public void testCheckAccessRelativePath() throws IOException {
        this.FS.provider().checkAccess(this.relativize(this.fileTA()), new AccessMode[0]);
    }

    @Test
    public void testCheckAccessSupportesRead() throws IOException {
        try {
            this.FS.provider().checkAccess(this.fileTAB(), AccessMode.READ);
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    @Test
    public void testCheckAccessSupportesWrite() throws IOException {
        try {
            this.FS.provider().checkAccess(this.fileTAB(), AccessMode.WRITE);
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    @Test
    public void testCheckAccessSupportesExecute() throws IOException {
        try {
            this.FS.provider().checkAccess(this.fileTAB(), AccessMode.EXECUTE);
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    @Test(expected=NoSuchFileException.class)
    public void testCheckAccessNonExistingFile() throws IOException {
        this.FS.provider().checkAccess(this.absTAB(), new AccessMode[0]);
    }

    @Test
    public void testCopyUnnormalizedPath() throws IOException {
        this.FS.provider().copy(this.unnormalize(this.srcFile()), this.tgt(), new CopyOption[0]);
        Assert.assertThat((Object)Files.readAllBytes(this.tgt()), (Matcher)CoreMatchers.is((Object)CONTENT));
    }

    @Test
    public void testMoveUnnormalizedPath() throws IOException {
        this.FS.provider().move(this.unnormalize(this.srcFile()), this.tgt(), new CopyOption[0]);
        Assert.assertThat((Object)Files.readAllBytes(this.tgt()), (Matcher)CoreMatchers.is((Object)CONTENT));
    }

    @Test
    public void testCopyToUnnormalizedPath() throws IOException {
        this.FS.provider().copy(this.srcFile(), this.unnormalize(this.tgt()), new CopyOption[0]);
        Assert.assertThat((Object)Files.readAllBytes(this.tgt()), (Matcher)CoreMatchers.is((Object)CONTENT));
    }

    @Test
    public void testMoveToUnnormalizedPath() throws IOException {
        this.FS.provider().move(this.srcFile(), this.unnormalize(this.tgt()), new CopyOption[0]);
        Assert.assertThat((Object)Files.readAllBytes(this.tgt()), (Matcher)CoreMatchers.is((Object)CONTENT));
    }

    @Test
    public void testCreateDirectoryUnnormalizedPath() throws IOException {
        this.FS.provider().createDirectory(this.unnormalize(this.absTA()), new FileAttribute[0]);
        Assert.assertThat((Object)this.absTA(), PathExists.exists());
    }

    @Test
    public void testCreateDirectoryWithRelativePath() throws IOException {
        Files.createDirectory(this.relTA(), new FileAttribute[0]);
        Assert.assertThat((Object)this.relTA(), PathExists.exists());
    }

    @Test
    public void testDeleteUnnormalizedPath() throws IOException {
        this.FS.provider().delete(this.unnormalize(this.fileTAC()));
        Assert.assertThat((Object)this.absTAC(), (Matcher)CoreMatchers.not(PathExists.exists()));
    }

    @Test
    public void testDeleteIfExistsUnnormalizedPath() throws IOException {
        this.FS.provider().deleteIfExists(this.unnormalize(this.fileTAC()));
        Assert.assertThat((Object)this.absTAC(), (Matcher)CoreMatchers.not(PathExists.exists()));
    }

    @Test
    public void testGetFileStoreUnnormalizedPath() throws IOException {
        this.FS.provider().getFileStore(this.unnormalize(this.fileTA()));
    }

    @Test
    public void testIsHiddenUnnormalizedPath() throws IOException {
        this.FS.provider().isHidden(this.unnormalize(this.fileTA()));
    }

    @Test
    public void testToRealpathResturnsAnAbsolutePath() throws Exception {
        Assert.assertThat((Object)this.relativize(this.fileTAB()).toRealPath(new LinkOption[0]), PathAbsolute.absolute());
    }

    @Test
    public void testToRealPathOfUnnormalizedResturnsAnNormalizedPath() throws Exception {
        Path real = this.unnormalize(this.fileTAB()).toRealPath(new LinkOption[0]);
        Assert.assertThat((Object)real.normalize(), (Matcher)CoreMatchers.is((Object)real));
    }

    @Test
    public void testToRealPathOfUnnormalizedIsSamePath() throws Exception {
        Assert.assertThat((Object)this.FS.provider().isSameFile(this.unnormalize(this.fileTAB()).toRealPath(new LinkOption[0]), this.fileTAB()), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test(expected=NoSuchFileException.class)
    public void testToRealPathOfNonExistingFileThrows() throws Exception {
        this.absTAB().toRealPath(new LinkOption[0]);
    }

    @Test
    public void testMaxFilenameHasNoEffectOfPathConstruction() throws IOException {
        this.absTTooLongFilename();
    }

    @Test
    public void testMaxFilenameWorks() throws IOException {
        Path loong = this.absTLongFilename();
        Files.createDirectories(loong.getParent(), new FileAttribute[0]);
        Files.write(loong, CONTENT, new OpenOption[0]);
    }

    @Test(expected=FileSystemException.class)
    public void testMaxFilenameWriteTooLongThrows() throws IOException {
        Path loong = this.absTTooLongFilename();
        Files.createDirectories(loong.getParent(), new FileAttribute[0]);
        Files.write(loong, CONTENT, new OpenOption[0]);
    }

    @Test
    public void testMaxFilenameDirOfLongWorks() throws IOException {
        Path loong = this.absTLongFilename();
        Files.createDirectories(loong, new FileAttribute[0]);
    }

    @Test(expected=FileSystemException.class)
    public void testMaxFilenameDirTooLongThrows() throws IOException {
        Path loong = this.absTTooLongFilename();
        Files.createDirectories(loong, new FileAttribute[0]);
    }

    @Test
    public void testMaxFilenameCopyWorks() throws IOException {
        Path loong = this.absTLongFilename();
        Files.copy(this.fileTAB(), loong, new CopyOption[0]);
    }

    @Test(expected=FileSystemException.class)
    public void testMaxFilenameCopyTooLongThrows() throws IOException {
        Path loong = this.absTTooLongFilename();
        Files.copy(this.fileTAB(), loong, new CopyOption[0]);
    }

    @Test
    public void testMaxFilenameHardLinkWorks() throws IOException {
        Path loong = this.absTLongFilename();
        Files.createLink(loong, this.fileTAB());
    }

    @Test(expected=FileSystemException.class)
    public void testMaxFilenameHardLinkTooLongThrows() throws IOException {
        Path loong = this.absTTooLongFilename();
        Files.createLink(loong, this.fileTAB());
    }

    @Test
    public void testMaxFilenameMoveWorks() throws IOException {
        Path loong = this.absTLongFilename();
        Files.move(this.fileTAB(), loong, new CopyOption[0]);
    }

    @Test(expected=FileSystemException.class)
    public void testMaxFilenameMoveTooLongThrows() throws IOException {
        Path loong = this.absTTooLongFilename();
        Files.move(this.fileTAB(), loong, new CopyOption[0]);
    }

    public Path unnormalize(Path path) {
        return path.getParent().resolve("..").resolve(path.getParent().getFileName()).resolve(path.getFileName());
    }

    public Path absTLongFilename() {
        return this.FS.getPath(this.absTTooLongFilename().toString().substring(0, this.capa.get(Integer.class, MAX_FILENAME_LENGTH)), new String[0]);
    }

    public Path absTTooLongFilename() {
        int maxFilenameLength = this.capa.getInt(MAX_FILENAME_LENGTH);
        if (maxFilenameLength < 2) {
            throw new IllegalStateException("set max filename length");
        }
        String name = this.nameA();
        while (name.length() < maxFilenameLength + 2) {
            name = name + name;
        }
        return this.absT().resolve(name);
    }

    public static class CapaBuilder10
    extends Tests09WrongProvider.CapBuilder09 {
        public PathConstraintsBuilder pathConstraints() {
            return new PathConstraintsBuilder((AllCapabilitiesBuilder)this);
        }

        public class PathConstraintsBuilder
        extends DetailBuilder {
            public PathConstraintsBuilder(AllCapabilitiesBuilder descr) {
                super(descr);
            }

            @Override
            public AllCapabilitiesBuilder onOff(boolean val) {
                this.capa.addFeature("MaxFilename", val && this.capa.getInt(Tests10PathWithContent.MAX_FILENAME_LENGTH) >= 0);
                this.capa.addFeature("MaxPath", val && this.capa.getInt(Tests10PathWithContent.MAX_PATH_LENGTH) >= 0);
                return this.builder;
            }

            public PathConstraintsBuilder maxFilenameLength(int len) {
                this.capa.attributes.put(Tests10PathWithContent.MAX_FILENAME_LENGTH, len);
                return this;
            }

            public PathConstraintsBuilder noMaxFilenameLength() {
                this.capa.attributes.put(Tests10PathWithContent.MAX_FILENAME_LENGTH, -1);
                return this;
            }

            public PathConstraintsBuilder maxPathLength(int len) {
                this.capa.attributes.put(Tests10PathWithContent.MAX_PATH_LENGTH, len);
                return this;
            }

            public PathConstraintsBuilder noMaxPathLength() {
                this.capa.attributes.put(Tests10PathWithContent.MAX_PATH_LENGTH, -1);
                return this;
            }
        }
    }
}

