/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.testsn;

import de.pfabulist.kleinod.collection.Sets;
import de.pfabulist.lindwurm.niotest.tests.ClosedFSVars;
import de.pfabulist.lindwurm.niotest.testsn.Tests06Attributes;
import de.pfabulist.lindwurm.niotest.testsn.setup.AllCapabilitiesBuilder;
import de.pfabulist.lindwurm.niotest.testsn.setup.CapBuilder03;
import de.pfabulist.lindwurm.niotest.testsn.setup.Capa;
import de.pfabulist.lindwurm.niotest.testsn.setup.DetailBuilder;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public abstract class Tests07Closed
extends Tests06Attributes {
    public static final String CLOSEABLE_PLAYGROUND = "closeablePlayground";

    public Tests07Closed(Capa capa) {
        super(capa);
    }

    @Test
    public void testClosedFSisClosed() throws Exception {
        Assert.assertThat((Object)this.getClosedFS().isOpen(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSCantRead() throws Exception {
        Files.readAllBytes(this.getClosedFileA());
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSCantReadDir() throws Exception {
        Files.newDirectoryStream(this.getClosedDirB());
    }

    @Test(expected=ClosedChannelException.class)
    public void testClosedFSCantUseReadChannelPosition() throws Exception {
        this.getClosedReadChannel().position();
    }

    @Test(expected=ClosedChannelException.class)
    public void testClosedFSCantUseReadChannelRead() throws Exception {
        this.getClosedReadChannel().read(ByteBuffer.allocate(2));
    }

    @Test(expected=ClosedChannelException.class)
    public void testClosedFSCantUseReadChannelSize() throws Exception {
        this.getClosedReadChannel().size();
    }

    @Test(expected=FileSystemNotFoundException.class)
    public void testCantGetClosedFSViaURI() throws Exception {
        this.getClosedFSProvider().getFileSystem(this.getClosedURI());
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSnewByteChannel() throws Exception {
        this.getClosedFS();
        this.FS.provider().newByteChannel(this.getClosedFileA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSGetBasicFileAttributeViewProvider() throws IOException {
        this.getClosedFS();
        this.FS.provider().getFileAttributeView(this.getClosedFileA(), BasicFileAttributeView.class, new LinkOption[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSCreateDirectoryOtherProvider() throws IOException {
        this.getClosedFSProvider().createDirectory(this.getClosedFileA(), new FileAttribute[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSNewFileChannel() throws IOException {
        this.getClosedFSProvider().newFileChannel(this.getClosedFileA(), Collections.emptySet(), new FileAttribute[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSCheckAccess() throws IOException {
        this.getClosedFS();
        this.FS.provider().checkAccess(this.getClosedFileA(), new AccessMode[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testCopyFromClosedFS() throws IOException {
        this.getClosedFSProvider().copy(this.getClosedFileA(), this.dirTA(), new CopyOption[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testCopyToClosedFS() throws IOException {
        this.getClosedFSProvider().copy(this.fileTA(), this.getClosedFileA(), new CopyOption[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testMoveToClosedFS() throws IOException {
        this.getClosedFSProvider().move(this.fileTA(), this.getClosedFileA(), new CopyOption[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSCreateHardLink() throws IOException {
        this.getClosedFSProvider().createLink(this.getClosedFileA(), this.getClosedFileA());
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSDelete() throws IOException {
        this.getClosedFSProvider().delete(this.getClosedFileA());
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSGetFileStore() throws IOException {
        this.getClosedFSProvider().getFileStore(this.getClosedFileA());
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSIsHidden() throws IOException {
        this.getClosedFSProvider().isHidden(this.getClosedFileA());
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSNewInputStream() throws IOException {
        this.getClosedFSProvider().newOutputStream(this.getClosedFileA(), new OpenOption[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSNewOutputStream() throws IOException {
        this.getClosedFSProvider().newOutputStream(this.getClosedFileA(), new OpenOption[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSReadAttributes() throws IOException {
        this.getClosedFSProvider().readAttributes(this.getClosedFileA(), BasicFileAttributes.class, new LinkOption[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSReadAttributesString() throws IOException {
        this.getClosedFSProvider().readAttributes(this.getClosedFileA(), "*", new LinkOption[0]);
    }

    public FileSystem getClosedFS() throws IOException {
        if (this.capa.closedFSVars == null) {
            this.capa.closedFSVars = new ClosedFSVars(this.capa.get(Path.class, CLOSEABLE_PLAYGROUND));
        }
        if (this.capa.closedFSVars.fs == null) {
            this.capa.closedFSVars.fs = this.capa.closedFSVars.play.getFileSystem();
        }
        if (!this.capa.closedFSVars.fs.isOpen()) {
            return this.capa.closedFSVars.fs;
        }
        this.capa.closedFSVars.provider = this.capa.closedFSVars.fs.provider();
        this.capa.closedFSVars.dirB = this.capa.closedFSVars.play.resolve(this.nameB());
        Files.createDirectories(this.capa.closedFSVars.dirB, new FileAttribute[0]);
        this.capa.closedFSVars.fileA = this.capa.closedFSVars.play.resolve(this.nameA());
        Files.write(this.capa.closedFSVars.fileA, CONTENT, standardOpen);
        Path closedCf = this.capa.closedFSVars.play.resolve(this.nameC());
        Files.write(closedCf, CONTENT, standardOpen);
        this.capa.closedFSVars.readChannel = Files.newByteChannel(closedCf, StandardOpenOption.READ);
        this.capa.closedFSVars.uri = this.capa.closedFSVars.play.getRoot().toUri();
        this.capa.closedFSVars.dirStream = Files.newDirectoryStream(this.capa.closedFSVars.play);
        try {
            this.capa.closedFSVars.watchService = this.capa.closedFSVars.fs.newWatchService();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.capa.closedFSVars.fs.close();
        return this.capa.closedFSVars.fs;
    }

    public FileSystemProvider getClosedFSProvider() throws IOException {
        this.getClosedFS();
        return this.FS.provider();
    }

    public Path getClosedFileA() throws IOException {
        this.getClosedFS();
        return this.capa.closedFSVars.fileA;
    }

    public Path getClosedDirB() throws IOException {
        this.getClosedFS();
        return this.capa.closedFSVars.dirB;
    }

    public URI getClosedURI() throws IOException {
        this.getClosedFS();
        return this.capa.closedFSVars.uri;
    }

    public SeekableByteChannel getClosedReadChannel() throws IOException {
        this.getClosedFileA();
        return this.capa.closedFSVars.readChannel;
    }

    public WatchService getClosedFSWatchService() throws IOException {
        this.getClosedFS();
        return this.capa.closedFSVars.watchService;
    }

    public static class CapBuilder07
    extends CapBuilder03 {
        public CloseableBuilder closeable() {
            return new CloseableBuilder((AllCapabilitiesBuilder)this);
        }

        public static class CloseableBuilder
        extends DetailBuilder {
            public CloseableBuilder(AllCapabilitiesBuilder descr) {
                super(descr);
            }

            @Override
            public AllCapabilitiesBuilder onOff(boolean val) {
                this.capa.addFeature("ClosedFS", val);
                return this.builder;
            }

            public CloseableBuilder playground(Path path) {
                this.capa.attributes.put(Tests07Closed.CLOSEABLE_PLAYGROUND, path);
                return this;
            }
        }
    }
}

