/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.testsn;

import de.pfabulist.lindwurm.niotest.matcher.FileTimeMatcher;
import de.pfabulist.lindwurm.niotest.testsn.SlowTest;
import de.pfabulist.lindwurm.niotest.testsn.Tests05URI;
import de.pfabulist.lindwurm.niotest.testsn.setup.Capa;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests06Attributes
extends Tests05URI {
    public Tests06Attributes(Capa capa) {
        super(capa);
    }

    @Test
    public void testGetLastModifiedTime() throws IOException {
        Files.readAttributes(this.pathDefault(), BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime();
    }

    @Test
    public void testGetCreationTimeIsRecent() throws IOException {
        FileTime created = Files.readAttributes(this.fileTA(), BasicFileAttributes.class, new LinkOption[0]).creationTime();
        Assert.assertThat((Object)created, FileTimeMatcher.isCloseTo(FileTime.fromMillis(System.currentTimeMillis())));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testReadAttributesAskingForUnknownAttributesThrows() throws Exception {
        Files.readAttributes(this.pathDefault(), SomeFileAttributes.class, new LinkOption[0]);
    }

    @Test
    public void testSizeOfDirDoesNotThrow() throws IOException {
        Files.size(this.pathDefault());
    }

    @Test
    public void testRootIsNotASymbolicLink() {
        Assert.assertThat((String)"root is a symbolic link", (Object)Files.isSymbolicLink(this.defaultRoot()), (Matcher)CoreMatchers.not((Object)true));
    }

    @Test
    public void testBasicIsASupportedFileAttributeView() {
        Assert.assertThat(this.FS.supportedFileAttributeViews(), (Matcher)CoreMatchers.hasItem((Object)"basic"));
    }

    @Test
    public void testGetLastModifiedAllMethodsDeliverSame() throws IOException {
        Path path = this.fileTA();
        FileTime last0 = Files.getLastModifiedTime(path, new LinkOption[0]);
        FileTime last1 = this.FS.provider().readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime();
        FileTime last2 = (FileTime)this.FS.provider().readAttributes(path, "basic:lastModifiedTime", new LinkOption[0]).get("lastModifiedTime");
        FileTime last3 = this.FS.provider().getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]).readAttributes().lastModifiedTime();
        Assert.assertThat((Object)last0, (Matcher)CoreMatchers.is((Object)last1));
        Assert.assertThat((Object)last1, (Matcher)CoreMatchers.is((Object)last2));
        Assert.assertThat((Object)last2, (Matcher)CoreMatchers.is((Object)last3));
        Assert.assertThat((Object)last3, (Matcher)CoreMatchers.is((Object)last0));
    }

    @Test
    public void testGetLastModifiedViaStringOfRelativePath() throws IOException {
        Path path = this.fileTA();
        Assert.assertThat((Object)this.FS.provider().readAttributes(this.pathDefault().toAbsolutePath().relativize(path), "basic:lastModifiedTime", new LinkOption[0]).get("lastModifiedTime"), (Matcher)CoreMatchers.is((Object)this.FS.provider().readAttributes(path, "basic:lastModifiedTime", new LinkOption[0]).get("lastModifiedTime")));
    }

    @Test
    public void testGetAllBasicAttributes() throws IOException {
        Map<String, Object> attis = this.FS.provider().readAttributes(this.fileTA(), "basic:*", new LinkOption[0]);
        Assert.assertThat(attis.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"size", "creationTime", "lastAccessTime", "lastModifiedTime", "fileKey", "isDirectory", "isRegularFile", "isSymbolicLink", "isOther"}));
    }

    @Test
    public void testUnsupportedAttributeViewReturnsNull() {
        Assert.assertThat((Object)this.FS.provider().getFileAttributeView(this.pathDefault(), UnsiView.class, new LinkOption[0]), (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUnsupportedAttributesThrows() throws IOException {
        this.FS.provider().readAttributes(this.pathDefault(), UnsiAttris.class, new LinkOption[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testReadUnsupportedAttributeThrows() throws IOException {
        this.FS.provider().readAttributes(this.pathDefault(), "thisissuchasillyattributesname:duda", new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadAttributesUnknownAttributeThrows() throws IOException {
        this.FS.provider().readAttributes(this.pathDefault(), "basic:duda", new LinkOption[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetUnsupportedAttributeThrows() throws IOException {
        this.FS.provider().setAttribute(this.fileTA(), "whoaa:freeze", true, new LinkOption[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetUnsupportedAttributeThrows() throws IOException {
        Files.getAttribute(this.fileTA(), "whoaa:freeze", new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetUnsupportedAttributeThrows2() throws IOException {
        Files.getAttribute(this.fileTA(), "basic:freeze", new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadAttributesOneUnknownAttributeThrows() throws IOException {
        this.FS.provider().readAttributes(this.pathDefault(), "basic:lastModifiedTime,duda", new LinkOption[0]);
    }

    @Test
    public void testSetLastModifiedTimeViaString() throws IOException {
        FileTime past = FileTime.fromMillis(System.currentTimeMillis() - 100000L);
        Path file = this.fileTA();
        this.FS.provider().setAttribute(file, "basic:lastModifiedTime", past, new LinkOption[0]);
        Assert.assertThat((Object)Files.getLastModifiedTime(file, new LinkOption[0]), FileTimeMatcher.isCloseTo(past));
    }

    @Test
    public void testSetLastModifiedTimeViaFiles() throws IOException {
        FileTime past = FileTime.fromMillis(System.currentTimeMillis() - 100000L);
        Path file = this.fileTA();
        Files.setLastModifiedTime(file, past);
        Assert.assertThat((Object)Files.getLastModifiedTime(file, new LinkOption[0]), FileTimeMatcher.isCloseTo(past));
    }

    @Test
    public void testSetLastModifiedTimeViaView() throws IOException {
        FileTime past = FileTime.fromMillis(System.currentTimeMillis() - 100000L);
        Path file = this.fileTA();
        this.FS.provider().getFileAttributeView(file, BasicFileAttributeView.class, new LinkOption[0]).setTimes(past, null, null);
        Assert.assertThat((Object)Files.getLastModifiedTime(file, new LinkOption[0]), FileTimeMatcher.isCloseTo(past));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetSizeThrows() throws IOException {
        this.FS.provider().setAttribute(this.fileTA(), "basic:size", 7, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetIsLinkThrows() throws IOException {
        this.FS.provider().setAttribute(this.fileTA(), "basic:isSymbolicLink", true, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetIsDirectoryThrows() throws IOException {
        this.FS.provider().setAttribute(this.fileTA(), "basic:isDirectory", true, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetIsRegularFileThrows() throws IOException {
        this.FS.provider().setAttribute(this.fileTA(), "basic:isRegularFile", true, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetFileKeyThrows() throws IOException {
        this.FS.provider().setAttribute(this.fileTA(), "basic:fileKey", true, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetIsOtherThrows() throws IOException {
        this.FS.provider().setAttribute(this.fileTA(), "basic:isOther", true, new LinkOption[0]);
    }

    @Test
    public void testSetCreationTimeViaString() throws IOException {
        FileTime past = FileTime.fromMillis(System.currentTimeMillis() - 100000L);
        Path file = this.fileTA();
        this.FS.provider().setAttribute(file, "basic:creationTime", past, new LinkOption[0]);
        Assert.assertThat((Object)Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).creationTime(), FileTimeMatcher.isCloseTo(past));
    }

    @Test
    @Category(value={SlowTest.class})
    public void testSetCreationTimeDoesNotChangeLastAccessTime() throws IOException, InterruptedException {
        Path file = this.fileTA();
        FileTime before = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        this.waitForAttribute();
        this.FS.provider().setAttribute(file, "basic:creationTime", FileTime.fromMillis(System.currentTimeMillis() - 100000L), new LinkOption[0]);
        Assert.assertThat((Object)Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), (Matcher)CoreMatchers.is((Object)before));
    }

    @Test
    public void testSetCreationTimeViaView() throws IOException {
        FileTime past = FileTime.fromMillis(System.currentTimeMillis() - 100000L);
        Path file = this.fileTA();
        this.FS.provider().getFileAttributeView(file, BasicFileAttributeView.class, new LinkOption[0]).setTimes(null, null, past);
        Assert.assertThat((Object)Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).creationTime(), FileTimeMatcher.isCloseTo(past));
    }

    @Test
    public void testSetLastAccessTimeViaString() throws IOException {
        FileTime past = FileTime.fromMillis(System.currentTimeMillis() - 100000L);
        Path file = this.fileTA();
        this.FS.provider().setAttribute(file, "basic:lastAccessTime", past, new LinkOption[0]);
        Assert.assertThat((Object)Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), FileTimeMatcher.isCloseTo(past));
    }

    @Test
    public void testSetLastAccessTimeViaView() throws IOException {
        FileTime past = FileTime.fromMillis(System.currentTimeMillis() - 100000L);
        Path file = this.fileTA();
        this.FS.provider().getFileAttributeView(file, BasicFileAttributeView.class, new LinkOption[0]).setTimes(null, past, null);
        Assert.assertThat((Object)Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), FileTimeMatcher.isCloseTo(past));
    }

    @Test(expected=NoSuchFileException.class)
    public void testGetAttributeFromNonExistingFile() throws IOException {
        Files.getLastModifiedTime(this.absTA(), new LinkOption[0]);
    }

    @Test(expected=NoSuchFileException.class)
    public void testReadAttributesByStringFromNonExistingFile() throws IOException {
        Files.readAttributes(this.absTA(), "basic:size", new LinkOption[0]);
    }

    @Test
    public void testReadAttributesViewFromNonExistingFile() throws IOException {
        Assert.assertThat((Object)this.FS.provider().getFileAttributeView(this.absTA(), BasicFileAttributeView.class, new LinkOption[0]), (Matcher)CoreMatchers.notNullValue());
    }

    @Test(expected=NoSuchFileException.class)
    public void testReadAttributesViewAndReadFromNonExistingFile() throws IOException {
        BasicFileAttributeView view = this.FS.provider().getFileAttributeView(this.absTA(), BasicFileAttributeView.class, new LinkOption[0]);
        view.readAttributes();
    }

    @Test
    public void testReadAttributesViewFutureExistingFile() throws IOException {
        BasicFileAttributeView view = this.FS.provider().getFileAttributeView(this.absTA(), BasicFileAttributeView.class, new LinkOption[0]);
        this.fileTA();
        view.readAttributes();
    }

    @Test(expected=NoSuchFileException.class)
    public void testReadAttributesFromNonExistingFile() throws IOException {
        Files.readAttributes(this.absTA(), BasicFileAttributes.class, new LinkOption[0]);
    }

    @Test
    public void testFileKeyIsId() throws IOException {
        Assume.assumeThat((Object)Files.readAttributes(this.fileTAB(), BasicFileAttributes.class, new LinkOption[0]).fileKey(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat(Files.readAttributes(this.fileTAB(), "basic:fileKey", new LinkOption[0]), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not(Files.readAttributes(this.fileTAC(), "basic:fileKey", new LinkOption[0]))));
    }

    public static interface UnsiAttris
    extends BasicFileAttributes {
    }

    public static interface UnsiView
    extends BasicFileAttributeView {
    }

    public static class SomeFileAttributes
    implements BasicFileAttributes {
        @Override
        public FileTime lastModifiedTime() {
            return null;
        }

        @Override
        public FileTime lastAccessTime() {
            return null;
        }

        @Override
        public FileTime creationTime() {
            return null;
        }

        @Override
        public boolean isRegularFile() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public boolean isSymbolicLink() {
            return false;
        }

        @Override
        public boolean isOther() {
            return false;
        }

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public Object fileKey() {
            return null;
        }
    }
}

