/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.testsn;

import de.pfabulist.kleinod.paths.Filess;
import de.pfabulist.kleinod.text.Strings;
import de.pfabulist.lindwurm.niotest.Utils;
import de.pfabulist.lindwurm.niotest.matcher.ExceptionMatcher;
import de.pfabulist.lindwurm.niotest.matcher.IteratorMatcher;
import de.pfabulist.lindwurm.niotest.matcher.PathAbsolute;
import de.pfabulist.lindwurm.niotest.matcher.PathExists;
import de.pfabulist.lindwurm.niotest.matcher.PathIsDirectory;
import de.pfabulist.lindwurm.niotest.testsn.SlowTest;
import de.pfabulist.lindwurm.niotest.testsn.Tests01NoContent;
import de.pfabulist.lindwurm.niotest.testsn.setup.Capa;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.number.OrderingComparison;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests02Dir
extends Tests01NoContent {
    protected static byte[] CONTENT;
    protected static byte[] CONTENT_OTHER;
    protected static byte[] CONTENT20k;
    protected static byte[] CONTENT50;

    public Tests02Dir(Capa capa) {
        super(capa);
    }

    @Test
    public void testDefaultIsDir() throws Exception {
        Assert.assertThat((Object)this.pathDefault(), PathIsDirectory.isDirectory());
    }

    @Test
    public void testContentOfNonEmptyDir() throws IOException {
        this.fileTAB();
        this.fileTAC();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.dirTA());){
            Assert.assertThat((Object)Utils.getSize(stream), (Matcher)Is.is((Object)2));
        }
    }

    @Test
    public void testIteratorCanOnlyBeCalledOnceOnDirStream() throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.dirTA());){
            stream.iterator();
            Assert.assertThat(stream::iterator, ExceptionMatcher.throwsException(IllegalStateException.class));
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testDirStreamIteratorHasNoRemove() throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.dirTA());){
            stream.iterator().remove();
        }
    }

    @Test
    public void testContentOfNonEmptyDirFiltered() throws IOException {
        Path path = this.fileTAB().getParent();
        this.fileTAC();
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){
            boolean first = true;

            @Override
            public boolean accept(Path entry) throws IOException {
                if (this.first) {
                    this.first = false;
                    return false;
                }
                return true;
            }
        };
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, (DirectoryStream.Filter<? super Path>)filter);){
            Assert.assertThat((Object)Utils.getSize(stream), (Matcher)Is.is((Object)1));
        }
    }

    @Test
    public void testNewDirIsInParentsDirStream() throws IOException {
        Path dir = this.dirTA().resolve(this.nameB());
        Files.createDirectory(dir, new FileAttribute[0]);
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(dir.getParent());){
            Assert.assertThat((Object)dir, IteratorMatcher.isIn(kids));
        }
    }

    @Test
    public void testNewDirectoryExists() throws IOException {
        Files.createDirectory(this.absTA(), new FileAttribute[0]);
        Assert.assertThat((Object)this.absTA(), PathExists.exists());
    }

    @Test
    public void testNewRelDirectoryExists() throws IOException {
        Files.createDirectory(this.relTA(), new FileAttribute[0]);
        Assert.assertThat((Object)this.relTA(), PathExists.exists());
    }

    @Test
    public void testCreateDirectoryTwiceThrows() throws IOException {
        Path newDir = this.absTA();
        Files.createDirectory(newDir, new FileAttribute[0]);
        Assert.assertThat(() -> Files.createDirectory(newDir, new FileAttribute[0]), ExceptionMatcher.throwsException(FileAlreadyExistsException.class));
    }

    @Test(expected=NoSuchFileException.class)
    public void testCreateDirectoryWithoutExistingParentFails() throws IOException {
        Files.createDirectory(this.absTAB(), new FileAttribute[0]);
    }

    @Test(expected=FileSystemException.class)
    public void testCreateDirectoryWithInFileFails() throws IOException {
        Files.createDirectory(this.fileTA().resolve(this.nameC()), new FileAttribute[0]);
    }

    @Test
    public void testRootisADir() throws IOException {
        Assert.assertThat((Object)this.defaultRoot(), PathIsDirectory.isDirectory());
    }

    @Test
    public void testDefaultExists() throws Exception {
        Assert.assertThat((Object)this.pathDefault(), PathExists.exists());
    }

    @Test
    public void testNonExistingAbsolutePathIsNotADirectory() throws IOException {
        Assert.assertThat((Object)this.absTA(), (Matcher)Matchers.not(PathIsDirectory.isDirectory()));
    }

    @Test
    public void testNonExistingAbsolutePathIsNotADirectoryEvenIfParent() throws IOException {
        Assert.assertThat((Object)this.absTAB().getParent(), (Matcher)Matchers.not(PathIsDirectory.isDirectory()));
    }

    @Test
    public void testNonExistingRelativePathIsNotADirectory() throws IOException {
        Assert.assertThat((Object)this.relA(), (Matcher)Matchers.not(PathIsDirectory.isDirectory()));
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testCreateDirWithSamePathAsExistingFileFails() throws Exception {
        Files.createDirectory(this.fileTA(), new FileAttribute[0]);
    }

    @Test
    @Category(value={SlowTest.class})
    public void testCreateDirSetsModifiedTimeOfParent() throws IOException, InterruptedException {
        Path dir = this.dirTA();
        FileTime created = Files.getLastModifiedTime(dir, new LinkOption[0]);
        this.waitForAttribute();
        Files.createDirectory(dir.resolve(this.nameB()), new FileAttribute[0]);
        Assert.assertThat((Object)Files.getLastModifiedTime(dir, new LinkOption[0]), (Matcher)Matchers.greaterThan((Comparable)created));
    }

    @Test
    @Category(value={SlowTest.class})
    public void testCreateDirSetsLastAccessTimeOfParent() throws IOException, InterruptedException {
        Path dir = this.dirTA();
        FileTime before = Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        this.waitForAttribute();
        Files.createDirectory(dir.resolve(this.nameB()), new FileAttribute[0]);
        Assert.assertThat((Object)Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), (Matcher)OrderingComparison.greaterThan((Comparable)before));
    }

    @Test
    @Category(value={SlowTest.class})
    public void testCreateDirSetsCreationTime() throws IOException, InterruptedException {
        Path dir = this.absTA();
        FileTime before = Files.getLastModifiedTime(dir.getParent(), new LinkOption[0]);
        this.waitForAttribute();
        Files.createDirectory(dir, new FileAttribute[0]);
        BasicFileAttributes atti = Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]);
        Assert.assertThat((Object)atti.creationTime(), (Matcher)OrderingComparison.greaterThan((Comparable)before));
    }

    @Test
    public void testKidsOfAbsoluteDirAreAbsolute() throws Exception {
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(this.fileTAB().getParent());){
            for (Path kid : kids) {
                Assert.assertThat((Object)kid, PathAbsolute.absolute());
            }
        }
    }

    @Test
    public void testKidsOfRelativeDirAreRelative() throws Exception {
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(this.relativize(this.fileTAB()).getParent());){
            for (Path kid : kids) {
                Assert.assertThat((Object)kid, PathAbsolute.relative());
            }
        }
    }

    @Test
    public void testKidsOfRelDirAreLikeTheResultOfResolve() throws Exception {
        Path dir = this.relativize(this.fileTAB()).getParent();
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(dir);){
            for (Path kid : kids) {
                Assert.assertThat((Object)kid, (Matcher)Is.is((Object)dir.resolve(kid.getFileName())));
            }
        }
    }

    @Test
    @Category(value={SlowTest.class})
    public void testReadDirStreamSetsLastAccessTime() throws Exception {
        Path dir = this.fileTAB().getParent();
        FileTime before = Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        this.waitForAttribute();
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(dir);){
            for (Path kid : kids) {
            }
        }
        Assert.assertThat((Object)Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), (Matcher)OrderingComparison.greaterThan((Comparable)before));
    }

    @Test
    @Category(value={SlowTest.class})
    public void testReadEmptyDirStreamSetsLastAccessTime() throws Exception {
        Path dir = this.dirTA();
        FileTime before = Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        this.waitForAttribute();
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(dir);){
            for (Path kid : kids) {
            }
        }
        Assert.assertThat((Object)Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), (Matcher)OrderingComparison.greaterThan((Comparable)before));
    }

    @Test
    public void testReadDirStreamDoesNotSetParentsLastAccessTime() throws Exception {
        Path dir = this.dirTA();
        FileTime before = Files.readAttributes(dir.getParent(), BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        this.waitForAttribute();
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(dir);){
            for (Path kid : kids) {
            }
        }
        Assert.assertThat((Object)Files.readAttributes(dir.getParent(), BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), (Matcher)Is.is((Object)before));
    }

    @Test
    public void testCloseDirStreamInTheMiddleOfIteration() throws Exception {
        Path file = this.fileTAB();
        this.fileTAC();
        this.fileTAD();
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(file.getParent());){
            int count = 0;
            for (Path kid : kids) {
                if (++count != 1) continue;
                kids.close();
            }
            Assert.assertThat((Object)count, (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(3)));
        }
    }

    @Test(expected=Exception.class)
    public void testReadBytesFromDirectoryThrows() throws IOException {
        Files.readAllBytes(this.dirTA());
    }

    @Test(expected=NoSuchFileException.class)
    public void testNewDirectoryStreamFromNonExistingDirThrows() throws IOException {
        DirectoryStream<Path> kids = Files.newDirectoryStream(this.absTA());
        Throwable throwable = null;
        if (kids != null) {
            if (throwable != null) {
                try {
                    kids.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                kids.close();
            }
        }
    }

    @BeforeClass
    public static void beforeDir() {
        int i;
        CONTENT = Strings.getBytes((String)"hi there");
        CONTENT_OTHER = Strings.getBytes((String)"what's up, huh, huh");
        CONTENT20k = new byte[20000];
        for (i = 0; i < 20000; ++i) {
            Tests02Dir.CONTENT20k[i] = (byte)i;
        }
        CONTENT50 = new byte[50];
        for (i = 0; i < 50; ++i) {
            Tests02Dir.CONTENT50[i] = (byte)i;
        }
    }

    public Path absT() {
        Path ret = this.capa.get(Path.class, "playground").resolve(this.testMethodName.getMethodName());
        Filess.createDirectories((Path)ret);
        return ret;
    }

    public Path absTA() {
        return this.absT().resolve(this.nameA());
    }

    public Path absTB() {
        return this.absT().resolve(this.nameB());
    }

    public Path absTC() {
        return this.absT().resolve(this.nameC());
    }

    public Path relTA() {
        Path abs = this.absTA();
        return this.pathDefault().toAbsolutePath().relativize(abs);
    }

    public Path absTAB() {
        return this.absTA().resolve(this.nameB());
    }

    public Path absTAC() {
        return this.absTA().resolve(this.nameC());
    }

    public Path dirTA() {
        Path ret = this.absTA();
        Filess.createDirectories((Path)ret);
        return ret;
    }

    public Path dirTAB() {
        Path ret = this.absTAB();
        Filess.createDirectories((Path)ret);
        return ret;
    }

    public Path dirTBB() {
        Path ret = this.absTB().resolve(this.nameB());
        Filess.createDirectories((Path)ret);
        return ret;
    }

    public Path dirTB() {
        Path ret = this.absTB();
        Filess.createDirectories((Path)ret);
        return ret;
    }

    public Path fileTA() {
        Path ret = this.absTA();
        if (!Files.exists(ret, new LinkOption[0])) {
            Filess.write((Path)ret, (byte[])CONTENT, (OpenOption[])new OpenOption[0]);
        }
        return ret;
    }

    public Path fileTB() {
        Path ret = this.absTB();
        if (!Files.exists(ret, new LinkOption[0])) {
            Filess.write((Path)ret, (byte[])CONTENT, (OpenOption[])new OpenOption[0]);
        }
        return ret;
    }

    public Path fileTAB() {
        Path ret = this.dirTA().resolve(this.nameB());
        if (!Files.exists(ret, new LinkOption[0])) {
            Filess.write((Path)ret, (byte[])CONTENT, (OpenOption[])new OpenOption[0]);
        }
        return ret;
    }

    public Path relativize(Path path) {
        return this.pathDefault().toAbsolutePath().relativize(path);
    }

    public Path fileTAC() {
        Path ret = this.dirTA().resolve(this.nameC());
        if (!Files.exists(ret, new LinkOption[0])) {
            Filess.write((Path)ret, (byte[])CONTENT, (OpenOption[])new OpenOption[0]);
        }
        return ret;
    }

    public Path fileTAD() {
        Path ret = this.dirTA().resolve(this.nameD());
        if (!Files.exists(ret, new LinkOption[0])) {
            Filess.write((Path)ret, (byte[])CONTENT, (OpenOption[])new OpenOption[0]);
        }
        return ret;
    }

    public void waitForAttribute() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

