/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import java.util.Arrays;
import java.util.List;

public class SymLinkDescriptionBuilder {
    private final FSDescription descr;
    private boolean foreignLinks = true;
    private boolean dirLinks = true;

    public SymLinkDescriptionBuilder(FSDescription descr) {
        this.descr = descr;
    }

    public FSDescription no() {
        this.descr.hasSymbolicLinks = false;
        return this.descr;
    }

    public FSDescription yes() {
        this.descr.hasSymbolicLinks = true;
        return this.descr;
    }

    public SymLinkDescriptionBuilder with(SymLinkOption ... symLinkOptions) {
        List<SymLinkOption> options = Arrays.asList(symLinkOptions);
        if (options.contains((Object)SymLinkOption.DELAYED_LOOP_CHEFCKING)) {
            this.descr.delayedSymLinkLoopChecking = true;
            this.descr.immediateSymLinkLoopChecking = false;
        }
        if (options.contains((Object)SymLinkOption.IMMEDIATE_LOOP_CHECKING)) {
            this.descr.delayedSymLinkLoopChecking = false;
            this.descr.immediateSymLinkLoopChecking = true;
        }
        if (options.contains((Object)SymLinkOption.TO_DIRECTORIES)) {
            this.descr.hasDirSymLinks = true;
        }
        if (options.contains((Object)SymLinkOption.TO_OTHER_FILESYSTEM)) {
            this.descr.supportsForeignSymLinks = true;
        }
        return this;
    }

    public SymLinkDescriptionBuilder withOut(SymLinkOption ... symLinkOptions) {
        List<SymLinkOption> options = Arrays.asList(symLinkOptions);
        if (options.contains((Object)SymLinkOption.DELAYED_LOOP_CHEFCKING)) {
            this.descr.delayedSymLinkLoopChecking = false;
        }
        if (options.contains((Object)SymLinkOption.IMMEDIATE_LOOP_CHECKING)) {
            this.descr.immediateSymLinkLoopChecking = false;
        }
        if (options.contains((Object)SymLinkOption.TO_DIRECTORIES)) {
            this.descr.hasDirSymLinks = false;
        }
        if (options.contains((Object)SymLinkOption.TO_OTHER_FILESYSTEM)) {
            this.descr.supportsForeignSymLinks = false;
        }
        return this;
    }

    public static enum SymLinkOption {
        TO_OTHER_FILESYSTEM,
        TO_DIRECTORIES,
        IMMEDIATE_LOOP_CHECKING,
        DELAYED_LOOP_CHEFCKING;

    }
}

