/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.matcher.PathAbsolute;
import de.pfabulist.lindwurm.niotest.matcher.PathEndsWith;
import de.pfabulist.lindwurm.niotest.matcher.PathStartsWith;
import de.pfabulist.lindwurm.niotest.tests.Setup;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public abstract class PathTest1NoContentIT
extends Setup {
    @Test
    public void testGetNameSimple() {
        Path path = this.getPathAB();
        Assert.assertEquals((Object)this.getPathA(), (Object)path.getName(0));
        Assert.assertEquals((Object)this.getPathB(), (Object)path.getName(1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRootHasNoName() {
        this.getRoot().getName(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetNameWithNegativeIndex() {
        this.getPathAB().getName(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetNameWithTooLargeIndex() {
        this.getPathAB().getName(5);
    }

    @Test
    public void testGetNameOfDefaultPathIsItself() {
        Assert.assertEquals((Object)this.getDefaultPath(), (Object)this.getDefaultPath().getName(0));
    }

    @Test
    public void testResultOfGetNameIsRelative() {
        Assert.assertThat((Object)this.getPathAB().getName(0), PathAbsolute.relative());
    }

    @Test
    public void testNameDoesNotIncludeSeparator() throws Exception {
        Assert.assertThat((Object)this.getPathAB().getName(1).toString().contains(this.getSeparator()), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testNameCountOfNameIs1() throws Exception {
        Assert.assertThat((Object)this.getPathABC().getName(2).getNameCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testGetNameCountSimple() {
        Assert.assertEquals((long)2L, (long)this.getPathAB().getNameCount());
    }

    @Test
    public void testGetNameIsIdempontent() {
        Assert.assertEquals((Object)this.getName(0), (Object)this.getName(0).getName(0));
    }

    @Test
    public void testRootNameCountIs0() {
        Assert.assertEquals((long)0L, (long)this.getRoot().getNameCount());
    }

    @Test
    public void testDefaultHasNameCount1() {
        Assert.assertEquals((long)1L, (long)this.getDefaultPath().getNameCount());
    }

    @Test
    public void testEndsWithSimple() {
        Path abc = this.getPathABC();
        Path bc = this.getPathBC();
        Path ab = this.getPathAB();
        Assert.assertThat((Object)abc, PathEndsWith.endsWith(bc));
        Assert.assertThat((Object)abc, (Matcher)CoreMatchers.not(PathEndsWith.endsWith(ab)));
    }

    @Test
    public void testEndsWithStringSimple() {
        Path abc = this.getPathABC();
        String bcStr = this.getPathBC().toString();
        String abStr = this.getPathAB().toString();
        Assert.assertThat((Object)abc, PathEndsWith.endsWith(bcStr));
        Assert.assertThat((Object)abc, (Matcher)CoreMatchers.not(PathEndsWith.endsWith(abStr)));
    }

    @Test
    public void testStartsWithSimple() {
        Path abc = this.getPathABC();
        Path bc = this.getPathBC();
        Path ab = this.getPathAB();
        Assert.assertThat((Object)abc, (Matcher)CoreMatchers.not(PathStartsWith.startsWith(bc)));
        Assert.assertThat((Object)abc, PathStartsWith.startsWith(ab));
    }

    @Test
    public void testAbsolutePathDoesNotStartsWithARelativePath() {
        Path abcAbso = this.getPathRABC();
        Path abRel = this.getPathAB();
        Assert.assertThat((Object)abcAbso, (Matcher)CoreMatchers.not(PathStartsWith.startsWith(abRel)));
    }

    @Test
    public void testAbsolutePathDoesStartsWithAnAbsolutePath() {
        Path abcAbso = this.getPathRABC();
        Path abAbso = this.getPathRAB();
        Assert.assertThat((Object)abcAbso.startsWith(abAbso), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testAbsolutePathDoesStartsWithRoot() {
        Assert.assertThat((Object)this.getPathRABC(), PathStartsWith.startsWith(this.getRoot()));
    }

    @Test
    public void testNoNonEmptyPathStartsWithDefault() {
        Assert.assertThat((Object)this.getPathABC(), (Matcher)CoreMatchers.not(PathStartsWith.startsWith(this.getDefaultPath())));
    }

    @Test
    public void testStartsWithStringSimple() {
        Path abc = this.getPathABC();
        String bcStr = this.getPathBC().toString();
        String abStr = this.getPathAB().toString();
        Assert.assertThat((Object)abc, (Matcher)CoreMatchers.not(PathStartsWith.startsWith(bcStr)));
        Assert.assertThat((Object)abc.startsWith(abStr), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testSubPathSimple() throws Exception {
        Assert.assertEquals((Object)this.getPathBC(), (Object)this.getPathABC().subpath(1, 3));
    }

    @Test
    public void testSubPathIsRelative() throws Exception {
        Assert.assertThat((Object)this.getPathABC().subpath(1, 3), PathAbsolute.relative());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubPathNegativeStart() throws Exception {
        this.getPathABC().subpath(-1, 2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubPathStartTooLarge() throws Exception {
        this.getPathAB().subpath(7, 9);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubPathEndBeforeStart() throws Exception {
        this.getPathABC().subpath(1, 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubPathEndTooLarge() throws Exception {
        this.getPathABC().subpath(1, 12);
    }

    @Test
    public void testFileNameHasNameCountOf1() {
        Assert.assertThat((Object)this.getPathRAB().getFileName().getNameCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testGetFileNameIsIdempotent() throws Exception {
        Path fileName = this.getPathAB().getFileName();
        Assert.assertEquals((Object)fileName, (Object)fileName.getFileName());
    }

    @Test
    public void testFileNameIsRelative() throws Exception {
        Assert.assertThat((Object)this.getPathRAB().getFileName(), PathAbsolute.relative());
    }

    @Test
    public void testRootHasNoFileName() throws Exception {
        Assert.assertThat((Object)this.getRoot().getFileName(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testFileNameStringIsPathPartString() {
        Assert.assertEquals((Object)this.nameStr[0], (Object)this.getPathA().getFileName().toString());
    }

    @Test
    public void testFileNameIsLastName() throws Exception {
        Assert.assertEquals((Object)this.getPathABC().getName(2), (Object)this.getPathABC().getFileName());
    }

    @Test
    public void testDefaultHasANameAndItsItself() throws Exception {
        Assert.assertEquals((Object)this.getDefaultPath(), (Object)this.getDefaultPath().getFileName());
    }

    @Test
    public void testResolveOfNameStrEndsWithThatName() {
        Path rel = this.getDefaultPath();
        Path res = rel.resolve(this.nameStr[0]);
        Assert.assertThat((Object)res, PathEndsWith.endsWith(this.nameStr[0]));
    }

    @Test
    public void testResolveOfARelativePathIsRelative() throws Exception {
        Assert.assertThat((Object)this.getDefaultPath().resolve(this.nameStr[0]), PathAbsolute.relative());
    }

    @Test
    public void testResolveOfAbsoluteIsAbsolute() throws Exception {
        Assert.assertThat((Object)this.getPathRAB().resolve(this.nameStr[0]), PathAbsolute.absolute());
    }

    @Test
    public void testResolveWithDefaultIsNop() {
        Assert.assertEquals((Object)this.getPathABC(), (Object)this.getPathABC().resolve(this.getDefaultPath()));
    }

    @Test
    public void testResolveWithNameIsSameAsStr() throws Exception {
        Assert.assertEquals((Object)this.getPathAB().resolve(this.nameStr[3]), (Object)this.getPathAB().resolve(this.getName(3)));
    }

    @Test
    public void testResolveWorksLikeGetPathOnStringsWithSeparator() throws Exception {
        String str = this.nameStr[0] + this.getSeparator() + this.nameStr[1];
        Assert.assertEquals((Object)this.getDefaultPath().resolve(str), (Object)this.FS.getPath(str, new String[0]));
    }

    @Test
    public void testResolveWithStringWithSeparatorsSameAsWithPath() throws Exception {
        String str = this.nameStr[0] + this.getSeparator() + this.nameStr[1];
        Path asPath = this.FS.getPath(this.nameStr[0] + this.getSeparator() + this.nameStr[1], new String[0]);
        Assert.assertEquals((Object)this.getDefaultPath().resolve(str), (Object)this.getDefaultPath().resolve(asPath));
    }

    @Test
    public void testResolveIterative() throws Exception {
        Path two = this.getName(0).resolve(this.getName(1));
        Assert.assertEquals((Object)this.getPathA().resolve(two), (Object)this.getPathA().resolve(this.getName(0).resolve(this.getName(1))));
    }

    @Test
    public void testResolveWithAbsoluteArgReturnArg() throws Exception {
        Assert.assertEquals((Object)this.getPathRAB(), (Object)this.getPathA().resolve(this.getPathRAB()));
    }

    @Test
    public void testResolveSiblingIsGetParentResolve() throws Exception {
        Assert.assertEquals((Object)this.getPathAB().resolve(this.getName(0)), (Object)this.getPathABC().resolveSibling(this.getName(0)));
    }

    @Test
    public void testResolveSiblingWithAbsoluteArgIsThatArg() throws Exception {
        Assert.assertEquals((Object)this.getPathRAB(), (Object)this.getPathA().resolveSibling(this.getPathRAB()));
    }

    @Test
    public void testResolveSiblingOnRootReturnsArg() throws Exception {
        Assert.assertEquals((Object)this.getPathAB(), (Object)this.getRoot().resolveSibling(this.getPathAB()));
    }

    @Test
    public void testResolveSiblingOnDefaultReturnsArg() throws Exception {
        Assert.assertEquals((Object)this.getPathAB(), (Object)this.getDefaultPath().resolveSibling(this.getPathAB()));
    }

    @Test
    public void testResolveSiblingOnNameReturnsArg() throws Exception {
        Assert.assertEquals((Object)this.getPathAB(), (Object)this.getPathA().resolveSibling(this.getPathAB()));
    }

    @Test
    public void testResolveSiblingWorksWithStringAndPath() throws Exception {
        Assert.assertEquals((Object)this.getPathAB().resolveSibling(this.getName(1)), (Object)this.getPathAB().resolveSibling(this.nameStr[1]));
    }

    @Test
    public void testGetPathIgnoresEmptyStringAsFirstParameter() throws Exception {
        Assert.assertEquals((Object)this.FS.getPath(this.nameStr[0], new String[0]), (Object)this.FS.getPath("", this.nameStr[0]));
    }

    @Test
    public void testGetPathIgnoresEmptyStringInAnyParameter() throws Exception {
        Assert.assertEquals((Object)this.FS.getPath(this.nameStr[0], new String[0]), (Object)this.FS.getPath("", "", this.nameStr[0], "", ""));
    }

    @Test
    public void testGetPathWithSeveralNamesIsSameAsWithOneStringWithSeparators() throws Exception {
        Assert.assertEquals((Object)this.FS.getPath(this.nameStr[0], this.nameStr[1], this.nameStr[2]), (Object)this.FS.getPath(this.nameStr[0] + this.getSeparator() + this.nameStr[1] + this.getSeparator() + this.nameStr[2], new String[0]));
    }

    @Test
    public void testGetPathAllowsMixedArguments() throws Exception {
        Assert.assertEquals((Object)this.FS.getPath(this.nameStr[0] + this.getSeparator() + this.nameStr[1], this.nameStr[2]), (Object)this.FS.getPath(this.nameStr[0], this.nameStr[1] + this.getSeparator() + this.nameStr[2]));
    }

    @Test
    public void testGetPathAndToStringAreOpposites() throws Exception {
        Assert.assertThat((Object)this.FS.getPath(this.getPathABC().toString(), new String[0]), (Matcher)Is.is((Object)this.getPathABC()));
        String str = this.nameStr[2] + this.getSeparator() + this.nameStr[3];
        Assert.assertEquals((Object)str, (Object)this.FS.getPath(str, new String[0]).toString());
    }

    @Test
    public void testGetPathNotStartingWithRootStringIsRelative() throws Exception {
        Assert.assertThat((Object)this.FS.getPath(this.nameStr[2], new String[0]), PathAbsolute.relative());
    }

    @Test
    public void testRelativize() {
        Path shrt = this.FS.getPath(this.nameStr[0], new String[0]);
        Path lng = this.FS.getPath(this.nameStr[0], this.nameStr[1], this.nameStr[2]);
        Assert.assertEquals((Object)lng, (Object)shrt.resolve(shrt.relativize(lng)));
    }

    @Test
    public void testRelativizeAbsolute() {
        Path root = this.getRoot();
        Path lng = root.resolve(this.nameStr[0]).resolve(this.nameStr[1]).resolve(this.nameStr[2]);
        Path lngRel = this.FS.getPath(this.nameStr[0], this.nameStr[1], this.nameStr[2]);
        Assert.assertEquals((Object)lngRel, (Object)root.relativize(lng));
    }

    @Test
    public void testRelativizeFromDefaultIsInverseOfToAbsolute() {
        Path abs = this.getPathRABC();
        Path rel = this.getDefaultPath().toAbsolutePath().relativize(abs);
        Assert.assertThat((Object)rel.toAbsolutePath(), (Matcher)Is.is((Object)abs));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRelativizeAbsToRel() {
        Path shrt = this.FS.getPath(this.nameStr[0], new String[0]);
        Path lng = this.FS.getPath(this.nameStr[0], this.nameStr[1], this.nameStr[2]).toAbsolutePath();
        shrt.relativize(lng);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRelativizeRelToAbs() {
        Path shrt = this.FS.getPath(this.nameStr[0], new String[0]).toAbsolutePath();
        Path lng = this.FS.getPath(this.nameStr[0], this.nameStr[1], this.nameStr[2]);
        shrt.relativize(lng);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRelativizePathWithOtherRootFails() {
        Assume.assumeThat((Object)this.capabilities.hasOtherRoot(), (Matcher)Is.is((Object)true));
        Path one = this.getRoot().resolve(this.nameStr[0]);
        Path two = this.capabilities.getOtherRoot().resolve(this.nameStr[1]);
        one.relativize(two);
    }

    @Test
    public void testGetParent() {
        Path rel = this.FS.getPath(this.nameStr[0], new String[0]);
        Assert.assertThat((Object)rel.getParent(), (Matcher)CoreMatchers.nullValue());
        Path abs = this.FS.getPath(this.nameStr[0], this.nameStr[2]).toAbsolutePath();
        Assert.assertEquals((Object)abs, (Object)abs.resolve(this.nameStr[0]).getParent());
    }

    @Test
    public void testGetParentOfRootIsNull() throws Exception {
        Assert.assertThat((Object)this.getRoot().getParent(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testGetParentOfNameIsNull() throws Exception {
        Assert.assertThat((Object)this.getName(0).getParent(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testGetParentOfDefaultIsNull() throws Exception {
        Assert.assertThat((Object)this.getDefaultPath().getParent(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testGetParentOfLongerRelativeNameIsNotNull() throws Exception {
        Assert.assertThat((Object)this.getPathAB().getParent(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetParentIsInverseOfResolve() throws Exception {
        Assert.assertEquals((Object)this.getPathA(), (Object)this.getPathA().resolve(this.getName(1)).getParent());
        Assert.assertEquals((Object)this.getPathAB(), (Object)this.getPathAB().getParent().resolve(this.getName(1)));
    }

    @Test
    public void testGetParentOfRelativeIsRelative() throws Exception {
        Assert.assertThat((Object)this.getPathAB().getParent(), PathAbsolute.relative());
    }

    @Test
    public void testgetParentOfAbsoluteIsAbsolute() throws Exception {
        Assert.assertThat((Object)this.getPathRAB().getParent(), PathAbsolute.absolute());
    }

    @Test
    public void testNormalizeWildPaths() {
        Path abs = this.FS.getPath(this.nameStr[0], new String[0]).toAbsolutePath();
        Assert.assertEquals((Object)abs.getParent(), (Object)abs.resolve("../aa/../.").normalize());
        Path rel = this.FS.getPath(this.nameStr[0], new String[0]);
        Assert.assertEquals((Object)"", (Object)rel.resolve("..").normalize().toString());
    }

    @Test
    public void testNormalize1Dot() {
        Path path1 = this.getPathAB();
        Path path2 = path1.resolve(".");
        Assert.assertThat((Object)path1, (Matcher)CoreMatchers.not((Matcher)Is.is((Object)path2)));
        Assert.assertThat((Object)path1, (Matcher)Is.is((Object)path2.normalize()));
    }

    @Test
    public void testNormalize2Dots() {
        Path path1 = this.getPathAB();
        Path path2 = path1.resolve(this.nameStr[3]).resolve("..");
        Assert.assertThat((Object)path1, (Matcher)CoreMatchers.not((Matcher)Is.is((Object)path2)));
        Assert.assertThat((Object)path1, (Matcher)Is.is((Object)path2.normalize()));
    }

    @Test
    public void testNormalizeIsIdempotent() throws Exception {
        Path path = this.getPathABC().resolve("..").resolve(this.nameStr[2]);
        Assert.assertEquals((Object)path.normalize(), (Object)path.normalize().normalize());
    }

    @Test
    public void testPathIterator() {
        Path pathABC = this.getPathABC();
        int i = 0;
        for (Path kid : pathABC) {
            Assert.assertEquals((Object)this.FS.getPath(this.nameStr[i], new String[0]), (Object)kid);
            ++i;
        }
        Assert.assertEquals((long)3L, (long)i);
    }

    @Test
    public void testRootOfRelativeIsNull() {
        Assert.assertThat((Object)this.getPathABC().getRoot(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testRootIsOneOfTheRoots() {
        Path root = this.getRoot();
        boolean found = false;
        for (Path aroot : this.FS.getRootDirectories()) {
            Assert.assertThat((Object)aroot.getNameCount(), (Matcher)Is.is((Object)0));
            found |= aroot.equals(root);
        }
        Assert.assertTrue((String)"root of default path is not one of the roots", (boolean)found);
    }

    @Test
    public void testRootOfAbsolutePathIsAbsolute() throws Exception {
        Assert.assertThat((Object)this.getPathRAB().getRoot(), PathAbsolute.absolute());
    }

    @Test
    public void testGetRootIsIdempotent() throws Exception {
        Assert.assertEquals((Object)this.getRoot(), (Object)this.getRoot().getRoot());
    }

    @Test
    public void testGetRootIsaRootDirectory() throws Exception {
        Path root = this.getRoot();
        boolean found = false;
        for (Path aroot : this.FS.getRootDirectories()) {
            found |= aroot.equals(root);
        }
        Assert.assertTrue((String)"root of default path is not one of the roots", (boolean)found);
    }

    @Test
    public void testToAbsoluteProducesAnAbsolutePath() throws Exception {
        Assert.assertThat((Object)this.getPathABC().toAbsolutePath(), PathAbsolute.absolute());
    }

    @Test
    public void testToAbsoluteIsIdempotent() throws Exception {
        Assert.assertThat((Object)this.getPathRAB(), (Matcher)Is.is((Object)this.getPathRAB().toAbsolutePath()));
    }

    @Test
    public void testDefaultIsRelative() throws Exception {
        Assert.assertThat((Object)this.getDefaultPath(), PathAbsolute.relative());
    }

    @Test
    public void testRelativePathToStringDoesNotStartWithSeparator() throws Exception {
        Assert.assertThat((Object)this.getPathAB().toString().startsWith(this.getSeparator()), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testPathWith2NamesHasSeparatorInToString() throws Exception {
        Assert.assertThat((Object)this.getPathAB().toString().contains(this.getSeparator()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testPathsWithSamePathElementsButDifferentProviderAreDifferent() throws Exception {
        Assume.assumeThat((Object)this.FS, (Matcher)CoreMatchers.not((Matcher)Is.is((Object)FileSystems.getDefault())));
        Path myABC = this.FS.getPath(this.nameStr[0], this.nameStr[1], this.nameStr[2]);
        Path otherABC = FileSystems.getDefault().getPath(this.nameStr[0], this.nameStr[1], this.nameStr[2]);
        Assert.assertThat((Object)myABC, (Matcher)CoreMatchers.not((Matcher)Is.is((Object)otherABC)));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testToFileOnNonDefaultFSThrows() throws Exception {
        Assume.assumeTrue((String)"default FileSystem does not throw", (!this.FS.equals(FileSystems.getDefault()) ? 1 : 0) != 0);
        this.getPathRAB().toFile();
    }

    @Test
    public void testPathMatcherKnowsGlob() {
        this.FS.getPathMatcher("glob:*");
    }

    @Test
    public void testPathMatcherKnowsRegex() {
        this.FS.getPathMatcher("regex:.*");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPathMatcherThrowsOnUnknownSyntax() {
        this.FS.getPathMatcher("thisisarellysillysyntax:.*");
    }

    @Test
    public void testPathMatherRegex() throws Exception {
        PathMatcher pm = this.FS.getPathMatcher("regex:.*" + this.nameStr[2] + ".*");
        Assert.assertThat((Object)pm.matches(this.FS.getPath(this.nameStr[2], new String[0]).toAbsolutePath()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)pm.matches(this.FS.getPath(this.nameStr[2], new String[0])), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)pm.matches(this.FS.getPath(this.nameStr[2], "da")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)pm.matches(this.FS.getPath("du", this.nameStr[2], "da")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)pm.matches(this.FS.getPath("du", this.nameStr[2] + this.nameStr[0], "da")), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testPathMatherGlob() throws Exception {
        PathMatcher pm = this.FS.getPathMatcher("glob:*.{" + this.nameStr[2] + "," + this.nameStr[3] + "}");
        Assert.assertThat((Object)pm.matches(this.FS.getPath(this.nameStr[4] + "." + this.nameStr[3], new String[0])), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)pm.matches(this.FS.getPath(this.nameStr[4] + "." + this.nameStr[2], new String[0])), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)pm.matches(this.FS.getPath(this.nameStr[4] + this.nameStr[2], new String[0])), (Matcher)Is.is((Object)false));
    }

    @Test(expected=ClassCastException.class)
    public void testCompareToDifferentProviderThrows() throws Exception {
        Assume.assumeThat((Object)this.FS, (Matcher)CoreMatchers.not((Matcher)Is.is((Object)FileSystems.getDefault())));
        this.getPathABC().compareTo(FileSystems.getDefault().getPath(this.nameStr[0], new String[0]));
    }

    @Test
    public void testCompareToOfEqualPathsIs0() throws Exception {
        Assert.assertEquals((long)0L, (long)this.getPathABC().compareTo(this.getPathABC()));
    }

    @Test
    public void testCompareToShortPathIsPositive() throws Exception {
        Assert.assertTrue((this.getPathABC().compareTo(this.getPathAB()) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToLongetPathIsNegative() throws Exception {
        Assert.assertTrue((this.getPathAB().compareTo(this.getPathABC()) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPathIsImmutabeToAbsolute() throws Exception {
        Path rel = this.getPathAB();
        rel.toAbsolutePath();
        Assert.assertThat((Object)rel, PathAbsolute.relative());
    }

    @Test
    public void testPathIsImmutableToNormalize() throws Exception {
        Path unnom = this.getPathAB().resolve("..");
        Assert.assertTrue((boolean)unnom.toString().contains(".."));
    }

    @Test
    public void testNonExistingAbsolutePathIsNotAFile() throws IOException {
        Assert.assertThat((Object)Files.isRegularFile(this.getPathPA(), new LinkOption[0]), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testNonExistingRelativePathIsNotAFile() throws IOException {
        Assert.assertThat((Object)Files.isRegularFile(this.getPathA(), new LinkOption[0]), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testIllegalCharsInPathThrows() {
        for (Character ill : this.capabilities.getPathIllegalCharacters()) {
            try {
                this.FS.getPath("" + ill, new String[0]);
                Assert.assertThat((Object)("illegal character allowed: <" + ill + ">"), (Matcher)Is.is((Object)""));
            }
            catch (InvalidPathException invalidPathException) {}
        }
    }

    @Test
    public void testSeparatorIsNoFileName() {
        Path path = this.FS.getPath(this.nameStr[3] + this.FS.getSeparator() + this.nameStr[0], new String[0]);
        for (Path elem : path) {
            Assert.assertThat((Object)elem.toString(), (Matcher)CoreMatchers.not((Matcher)Matchers.containsString((String)this.FS.getSeparator())));
        }
    }

    @Test(expected=NullPointerException.class)
    public void testResolveNull() throws IOException {
        this.getPathPA().resolve((String)null);
    }

    @Test(expected=NullPointerException.class)
    public void testNullPath() {
        this.FS.getPath(null, new String[0]);
    }
}

