/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.testsn.setup;

import de.pfabulist.kleinod.paths.Pathss;
import de.pfabulist.lindwurm.niotest.testsn.setup.Capa;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class Setup {
    protected final Capa capa;
    protected String[] name = new String[]{"aaa", "bbbb", "cccc", "ddddd", "eeeeee"};
    protected final FileSystem FS;
    protected Path otherProvidorPlayground;
    @Rule
    public TestName testMethodName = new TestName();

    protected Setup(Capa capa) {
        this.capa = capa;
        this.FS = capa.get(Path.class, "playground").getFileSystem();
    }

    @Before
    public void filter() {
        Assume.assumeThat((String)this.message(), (Object)this.capa.isPossible(this.testMethodName), (Matcher)CoreMatchers.is((Object)true));
    }

    protected String message() {
        if (this.capa.isBug(this.testMethodName)) {
            return "known bugs " + this.testMethodName.getMethodName();
        }
        return "";
    }

    protected Path getOtherProviderPlayground() {
        if (this.otherProvidorPlayground == null) {
            Path other = this.capa.get(Path.class, "otherProviderPlayground");
            if (other != null) {
                this.otherProvidorPlayground = other;
            } else {
                if (this.FS.equals(FileSystems.getDefault())) {
                    throw new IllegalStateException();
                }
                this.otherProvidorPlayground = Pathss.getTmpDir((String)"other");
            }
        }
        return this.otherProvidorPlayground;
    }
}

