/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.testsn.setup;

import de.pfabulist.lindwurm.niotest.tests.ClosedFSVars;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.rules.TestName;

public class Capa {
    public final Map<String, Object> attributes = new HashMap<String, Object>();
    public final Set<String> bugs = new HashSet<String>();
    public final Set<String> bugSchemes = new HashSet<String>();
    public final Set<String> antiSchemes = new HashSet<String>();
    public ClosedFSVars closedFSVars;

    public <T> T get(Class<T> clazz, String key) {
        return (T)this.attributes.get(key);
    }

    public int getInt(String key) {
        Object ret = this.attributes.get(key);
        if (ret == null) {
            return 0;
        }
        return (Integer)ret;
    }

    public boolean has(String key) {
        Object val = this.attributes.get(key);
        return val == null || (Boolean)val != false;
    }

    public boolean isBug(TestName testName) {
        String name = testName.getMethodName();
        if (this.bugs.contains(name)) {
            return true;
        }
        return this.bugSchemes.stream().filter(s -> s.contains(name)).findFirst().isPresent();
    }

    public boolean isPossible(TestName testName) {
        String name = testName.getMethodName();
        if (this.bugs.contains(name)) {
            return false;
        }
        return !this.antiSchemes.stream().filter(s -> name.contains((CharSequence)s)).findFirst().isPresent();
    }

    public void addFeature(String feature, boolean cond) {
        if (cond) {
            this.antiSchemes.remove(feature);
        } else {
            this.antiSchemes.add(feature);
        }
    }

    public void addBugSchemes(String substr) {
        this.antiSchemes.add(substr);
        this.bugSchemes.add(substr);
    }
}

