/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.testsn;

import de.pfabulist.kleinod.paths.Filess;
import de.pfabulist.lindwurm.niotest.matcher.PathExists;
import de.pfabulist.lindwurm.niotest.testsn.SlowTest;
import de.pfabulist.lindwurm.niotest.testsn.Tests18FileChannels;
import de.pfabulist.lindwurm.niotest.testsn.setup.AllCapabilitiesBuilder;
import de.pfabulist.lindwurm.niotest.testsn.setup.Capa;
import de.pfabulist.lindwurm.niotest.testsn.setup.DetailBuilder;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class Tests19HardLinks
extends Tests18FileChannels {
    public Tests19HardLinks(Capa capa) {
        super(capa);
    }

    @Test
    public void testHardLinkCreate() throws IOException {
        Files.createLink(this.link(), this.orig());
        MatcherAssert.assertThat((Object)this.link(), PathExists.exists());
    }

    @Test
    public void testHardLinkChangeOneChangesTheOther() throws IOException {
        Files.createLink(this.link(), this.orig());
        Files.write(this.link(), CONTENT_OTHER, new OpenOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.orig()), (Matcher)Is.is((Object)CONTENT_OTHER));
    }

    @Test
    public void testHardLinkDeleteOrigDoesNotAffectTheOther() throws IOException {
        Files.createLink(this.link(), this.orig());
        Files.delete(this.orig());
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.link()), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testHardLinkDeleteLinkDoesNotAffectTheOther() throws IOException {
        Files.createLink(this.link(), this.orig());
        Files.delete(this.link());
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.orig()), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    @Category(value={SlowTest.class})
    public void testHardLinkModifyOneModifiedDateOfOtherChanged() throws IOException, InterruptedException {
        Files.createLink(this.link(), this.orig());
        FileTime before = Files.getLastModifiedTime(this.orig(), new LinkOption[0]);
        this.waitForAttribute();
        Files.write(this.link(), CONTENT_OTHER, new OpenOption[0]);
        MatcherAssert.assertThat((Object)Files.getLastModifiedTime(this.orig(), new LinkOption[0]), (Matcher)Matchers.greaterThan((Comparable)before));
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testHardLinkToExistingFileThrows() throws IOException, InterruptedException {
        Files.createLink(this.fileTB(), this.orig());
    }

    @Test(expected=ProviderMismatchException.class)
    public void testHardLinkToOtherProviderThrows() throws IOException {
        Files.createLink(this.link(), this.otherProviderFileA());
    }

    @Test
    public void testHardLinkToDirThrows() throws IOException {
        Files.createLink(this.link(), this.orig());
        MatcherAssert.assertThat((Object)this.link(), PathExists.exists());
    }

    @Test
    public void testHardLinkToHardLink() throws IOException {
        Files.createLink(this.link(), this.orig());
        Files.createLink(this.link2(), this.link());
        MatcherAssert.assertThat((Object)this.link2(), PathExists.exists());
    }

    @Test
    public void test2ndHardLink() throws IOException {
        Files.createLink(this.link(), this.fileTA());
        Files.createLink(this.link2(), this.fileTA());
        MatcherAssert.assertThat((Object)this.link2(), PathExists.exists());
    }

    @Test
    public void testIsSameFileWithHardLink() throws IOException {
        Files.createLink(this.link(), this.orig());
        MatcherAssert.assertThat((Object)Files.isSameFile(this.link(), this.orig()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testHardLinkHasSameFileKey() throws IOException {
        Files.createLink(this.link(), this.orig());
        Object fk1 = Files.readAttributes(this.orig(), BasicFileAttributes.class, new LinkOption[0]).fileKey();
        Object fk2 = Files.readAttributes(this.link(), BasicFileAttributes.class, new LinkOption[0]).fileKey();
        MatcherAssert.assertThat((Object)fk1, (Matcher)Is.is((Object)fk2));
    }

    @Test
    public void testHardLinkToRelative() throws IOException {
        Files.createLink(this.link(), this.relativize(this.orig()));
        MatcherAssert.assertThat((Object)Files.isSameFile(this.link(), this.orig()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testMoveHardLinkToReldoesNotMoveTarget() throws IOException {
        Files.createLink(this.link(), this.relativize(this.orig()));
        Files.move(this.link(), this.dirTB().resolve(this.nameC()), new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.isSameFile(this.dirTB().resolve(this.nameC()), this.orig()), (Matcher)Is.is((Object)true));
    }

    protected Path orig() {
        Path ret = this.dirTA().resolve("orig");
        if (!Files.exists(ret, new LinkOption[0])) {
            Filess.write((Path)ret, (byte[])CONTENT, (OpenOption[])new OpenOption[0]);
        }
        return ret;
    }

    protected Path link() {
        return this.dirTB().resolve("link");
    }

    protected Path link2() {
        return this.dirTB().resolve("link2");
    }

    public static class CapaBuilder19
    extends Tests18FileChannels.CapaBuilder18 {
        public HardLinkBuilder hardlinks() {
            return new HardLinkBuilder((AllCapabilitiesBuilder)this);
        }

        public static class HardLinkBuilder
        extends DetailBuilder {
            public HardLinkBuilder(AllCapabilitiesBuilder builder) {
                super(builder);
            }

            public HardLinkBuilder toDirs(boolean cond) {
                this.capa.addFeature("HardLinkToDir", cond);
                return this;
            }

            @Override
            public AllCapabilitiesBuilder onOff(boolean val) {
                this.capa.addFeature("HardLink", val);
                return this.builder;
            }
        }
    }
}

