/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.testsn;

import de.pfabulist.lindwurm.niotest.testsn.Tests11Watcher;
import de.pfabulist.lindwurm.niotest.testsn.Tests12DifferentFS;
import de.pfabulist.lindwurm.niotest.testsn.setup.AllCapabilitiesBuilder;
import de.pfabulist.lindwurm.niotest.testsn.setup.Capa;
import de.pfabulist.lindwurm.niotest.testsn.setup.DetailBuilder;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyIterable;
import org.junit.Test;

public abstract class Tests13FileStore
extends Tests12DifferentFS {
    public Tests13FileStore(Capa capa) {
        super(capa);
    }

    @Test
    public void testFileStoreIterable() {
        MatcherAssert.assertThat(this.FS.getFileStores(), (Matcher)Matchers.not((Matcher)IsEmptyIterable.emptyIterable()));
    }

    @Test(expected=NoSuchFileException.class)
    public void testGetFileStoreOfNonExistent() throws IOException {
        Files.getFileStore(this.absTA());
    }

    @Test
    public void testFileStoresHaveAName() {
        for (FileStore store : this.FS.getFileStores()) {
            MatcherAssert.assertThat((Object)store.name(), (Matcher)Matchers.notNullValue());
        }
    }

    @Test
    public void testFileStoresHaveAType() {
        for (FileStore store : this.FS.getFileStores()) {
            MatcherAssert.assertThat((Object)store.type(), (Matcher)Matchers.notNullValue());
        }
    }

    @Test
    public void testFileStoreTotalSpaceIsNonNegative() throws IOException {
        for (FileStore store : this.FS.getFileStores()) {
            MatcherAssert.assertThat((Object)store.getTotalSpace(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
        }
    }

    @Test
    public void testFileStoreUsableSpaceIsSmallerThanTotal() throws IOException {
        for (FileStore store : this.FS.getFileStores()) {
            MatcherAssert.assertThat((Object)store.getTotalSpace(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(store.getUsableSpace())));
        }
    }

    @Test
    public void testFileStoreUnallocatedSpaceIsSmallerUsableSpace() throws IOException {
        for (FileStore store : this.FS.getFileStores()) {
            MatcherAssert.assertThat((Object)store.getUnallocatedSpace(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(store.getUsableSpace())));
        }
    }

    public static class CapaBuilder13
    extends Tests11Watcher.CapaBuilder11 {
        public FileStoreBuilder fileStores() {
            return new FileStoreBuilder((AllCapabilitiesBuilder)this);
        }

        public static class FileStoreBuilder
        extends DetailBuilder {
            public FileStoreBuilder(AllCapabilitiesBuilder builder) {
                super(builder);
            }

            @Override
            public AllCapabilitiesBuilder onOff(boolean val) {
                this.capa.addFeature("FileStore", val);
                return this.builder;
            }
        }
    }
}

